/*
 * Decompiled with CFR 0.152.
 */
package org.openide.nodes;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.List;
import org.openide.nodes.Node;

public final class Sheet {
    public static final String PROPERTIES = "properties";
    public static final String EXPERT = "expert";
    private ArrayList<Set> sets;
    private Node.PropertySet[] array;
    private PropertyChangeSupport supp = new PropertyChangeSupport(this);
    private PropertyChangeListener propL = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            Sheet.this.supp.firePropertyChange(null, null, null);
        }
    };

    public Sheet() {
        this(new ArrayList<Set>(2));
    }

    Sheet(ArrayList<Set> arrayList) {
        this.sets = arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public final Node.PropertySet[] toArray() {
        while (true) {
            Node.PropertySet[] propertySetArray = this;
            // MONITORENTER : this
            if (this.array != null) {
                // MONITOREXIT : propertySetArray
                return this.array;
            }
            // MONITOREXIT : propertySetArray
            propertySetArray = new Node.PropertySet[this.sets.size()];
            this.sets.toArray(propertySetArray);
            Node.PropertySet[] propertySetArray2 = this;
            // MONITORENTER : this
            if (this.array == null) {
                this.array = propertySetArray;
            }
            // MONITOREXIT : propertySetArray2
        }
    }

    public synchronized Sheet cloneSheet() {
        int n = this.sets.size();
        ArrayList<Set> arrayList = new ArrayList<Set>(n);
        for (int i = 0; i < n; ++i) {
            arrayList.add(this.sets.get(i).cloneSet());
        }
        return new Sheet(arrayList);
    }

    public synchronized Set get(String string) {
        int n = this.findIndex(string);
        return n == -1 ? null : this.sets.get(n);
    }

    public synchronized Set put(Set set) {
        int n = this.findIndex(set.getName());
        Set set2 = null;
        if (n == -1) {
            this.sets.add(set);
        } else {
            set2 = this.sets.set(n, set);
            set2.removePropertyChangeListener(this.propL);
        }
        set.addPropertyChangeListener(this.propL);
        this.refresh();
        return set2;
    }

    public synchronized Set remove(String string) {
        int n = this.findIndex(string);
        if (n != -1) {
            Set set = this.sets.remove(n);
            set.removePropertyChangeListener(this.propL);
            this.refresh();
            return set;
        }
        return null;
    }

    public static Sheet createDefault() {
        Sheet sheet = new Sheet();
        sheet.put(Sheet.createPropertiesSet());
        return sheet;
    }

    public static Set createPropertiesSet() {
        Set set = new Set();
        set.setName(PROPERTIES);
        set.setDisplayName(Node.getString("Properties"));
        set.setShortDescription(Node.getString("HINT_Properties"));
        return set;
    }

    public static Set createExpertSet() {
        Set set = new Set();
        set.setExpert(true);
        set.setName(EXPERT);
        set.setDisplayName(Node.getString("Expert"));
        set.setShortDescription(Node.getString("HINT_Expert"));
        return set;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.supp.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.supp.removePropertyChangeListener(propertyChangeListener);
    }

    private int findIndex(String string) {
        int n = this.sets.size();
        for (int i = 0; i < n; ++i) {
            Node.PropertySet propertySet = this.sets.get(i);
            if (!propertySet.getName().equals(string)) continue;
            return i;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refresh() {
        Sheet sheet = this;
        synchronized (sheet) {
            this.array = null;
        }
        this.supp.firePropertyChange(null, null, null);
    }

    public static final class Set
    extends Node.PropertySet {
        private List<Node.Property<?>> props;
        private Node.Property<?>[] array;
        private PropertyChangeSupport supp = new PropertyChangeSupport(this);

        public Set() {
            this(new ArrayList());
        }

        private Set(List<Node.Property<?>> list) {
            this.props = list;
        }

        public synchronized Set cloneSet() {
            return new Set(new ArrayList(this.props));
        }

        public Node.Property<?> get(String string) {
            int n = this.findIndex(string);
            return n == -1 ? null : this.props.get(n);
        }

        @Override
        public synchronized Node.Property<?>[] getProperties() {
            if (this.array == null) {
                this.array = new Node.Property[this.props.size()];
                this.props.toArray(this.array);
            }
            return this.array;
        }

        public synchronized Node.Property<?> put(Node.Property<?> property) {
            Node.Property<?> property2;
            int n = this.findIndex(property.getName());
            if (n != -1) {
                property2 = this.props.set(n, property);
            } else {
                this.props.add(property);
                property2 = null;
            }
            this.refresh();
            return property2;
        }

        public synchronized void put(Node.Property<?>[] propertyArray) {
            for (int i = 0; i < propertyArray.length; ++i) {
                Node.Property<?> property = propertyArray[i];
                property = propertyArray[i];
                int n = this.findIndex(property.getName());
                if (n != -1) {
                    this.props.set(n, property);
                    continue;
                }
                this.props.add(property);
            }
            this.refresh();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized Node.Property<?> remove(String string) {
            int n = this.findIndex(string);
            if (n != -1) {
                try {
                    Node.Property<?> property = this.props.remove(n);
                    return property;
                }
                finally {
                    this.refresh();
                }
            }
            return null;
        }

        public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.supp.addPropertyChangeListener(propertyChangeListener);
        }

        public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.supp.removePropertyChangeListener(propertyChangeListener);
        }

        private int findIndex(String string) {
            int n = this.props.size();
            for (int i = 0; i < n; ++i) {
                Node.Property<?> property = this.props.get(i);
                if (!property.getName().equals(string)) continue;
                return i;
            }
            return -1;
        }

        private void refresh() {
            this.array = null;
            this.supp.firePropertyChange(null, null, null);
        }
    }
}

