/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rjmx.triggers.internal;

import com.jrockit.mc.common.unit.ContentType;
import com.jrockit.mc.common.unit.IQuantity;
import com.jrockit.mc.common.unit.KindOfQuantity;
import com.jrockit.mc.common.unit.QuantityConversionException;
import com.jrockit.mc.common.unit.UnitLookup;
import com.jrockit.mc.common.xml.XmlToolkit;
import com.jrockit.mc.rjmx.triggers.IValueEvaluator;
import com.jrockit.mc.rjmx.triggers.internal.Messages;
import com.jrockit.mc.rjmx.triggers.internal.ValueEvaluationException;
import java.util.logging.Logger;
import org.eclipse.osgi.util.NLS;
import org.w3c.dom.Element;

public final class ValueEvaluatorNumberMax
implements IValueEvaluator {
    private static final Logger LOGGER = Logger.getLogger("com.jrockit.mc.rjmx");
    private static final String XML_ELEMENT_MAXVALUE = "maxvalue";
    private static final String XML_ELEMENT_CONTENTTYPE = "contenttype";
    private IQuantity m_max;

    public ValueEvaluatorNumberMax() {
    }

    public ValueEvaluatorNumberMax(IQuantity max) {
        this.m_max = max;
    }

    @Override
    public boolean triggerOn(Object val) throws Exception {
        if (!(val instanceof IQuantity)) {
            String logMessage = "ValueEvaluatorNumberMax: " + val + " does not have a content type set";
            LOGGER.info(logMessage);
            throw new ValueEvaluationException(logMessage, NLS.bind((String)Messages.ValueEvaluatorNumber_VALUE_NOT_A_QUANTITY, (Object)val));
        }
        return this.triggerOn((IQuantity)val);
    }

    private boolean triggerOn(IQuantity val) throws Exception {
        if (!val.getUnit().getContentType().equals(this.m_max.getUnit().getContentType())) {
            String logMessage = "ValueEvaluatorNumberMax: " + val.persistableString() + " is not of the same content type as limit " + this.m_max.persistableString();
            LOGGER.info(logMessage);
            throw new ValueEvaluationException(logMessage, NLS.bind((String)Messages.ValueEvaluatorNumber_VALUE_NOT_OF_THE_SAME_TYPE, (Object)val.displayUsing("exact"), (Object)this.m_max.displayUsing("exact")));
        }
        boolean result = val.compareTo((Object)this.m_max) > 0;
        LOGGER.info("ValueEvaluatorNumberMax: " + val.persistableString() + " > " + this.m_max.persistableString() + " = " + result);
        return result;
    }

    public String toString() {
        return "value > " + this.m_max.persistableString();
    }

    public IQuantity getMax() {
        return this.m_max;
    }

    public void setMax(IQuantity maxValue) {
        this.m_max = maxValue;
    }

    @Override
    public void initializeEvaluatorFromXml(Element node) {
        ContentType contentType = UnitLookup.getContentType((String)XmlToolkit.getSetting((Element)node, (String)XML_ELEMENT_CONTENTTYPE, (String)""));
        if (contentType instanceof KindOfQuantity) {
            String persistedQuantity = XmlToolkit.getSetting((Element)node, (String)XML_ELEMENT_MAXVALUE, (String)"0");
            try {
                this.setMax(((KindOfQuantity)contentType).parsePersisted(persistedQuantity));
            }
            catch (QuantityConversionException e) {
                LOGGER.warning(e.getMessage());
                this.setMax(((KindOfQuantity)contentType).getDefaultUnit().quantity(0L));
            }
        }
    }

    @Override
    public void exportEvaluatorToXml(Element node) {
        XmlToolkit.setSetting((Element)node, (String)XML_ELEMENT_CONTENTTYPE, (String)this.getMax().getUnit().getContentType().getIdentifier());
        XmlToolkit.setSetting((Element)node, (String)XML_ELEMENT_MAXVALUE, (String)this.getMax().persistableString());
    }

    @Override
    public String getOperatorString() {
        return ">";
    }

    @Override
    public String getEvaluationConditionString() {
        return "> " + this.m_max.displayUsing("exact");
    }
}

