/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rjmx.subscription.internal;

import com.jrockit.mc.rjmx.IConnectionHandle;
import com.jrockit.mc.rjmx.subscription.IMRIValueListener;
import com.jrockit.mc.rjmx.subscription.ISubscriptionService;
import com.jrockit.mc.rjmx.subscription.MRI;
import com.jrockit.mc.rjmx.subscription.MRIValueEvent;
import com.jrockit.mc.rjmx.subscription.PolicyFactory;
import com.jrockit.mc.rjmx.subscription.internal.AbstractAttributeSubscription;
import com.jrockit.mc.rjmx.subscription.internal.AttributeToolkit;
import com.jrockit.mc.rjmx.subscription.internal.UnavailableSubscriptionsRepository;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.management.openmbean.CompositeData;

class UnavailableChildSubscriptions {
    private final ISubscriptionService m_subscriptionService;
    private final MRI m_parentMRI;
    private final IMRIValueListener m_parentValueListener;
    private final UnavailableSubscriptionsRepository m_repository;
    private final Set<AbstractAttributeSubscription> m_unavailableChildSubscriptions = new HashSet<AbstractAttributeSubscription>();

    public UnavailableChildSubscriptions(IConnectionHandle connectionHandle, MRI parentMRI, UnavailableSubscriptionsRepository repository) {
        this.m_subscriptionService = connectionHandle.getServiceOrNull(ISubscriptionService.class);
        this.m_parentMRI = parentMRI;
        this.m_repository = repository;
        this.m_parentValueListener = this.createValueListener();
        this.m_subscriptionService.addMRIValueListener(this.m_parentMRI, this.m_parentValueListener);
    }

    public MRI getParentMRI() {
        return this.m_parentMRI;
    }

    public void dispose() {
        this.m_subscriptionService.removeMRIValueListener(this.m_parentValueListener);
    }

    public boolean addChildSubscription(AbstractAttributeSubscription subscription) {
        if (!subscription.getMRIMetaData().getMRI().toString().startsWith(this.m_parentMRI.toString())) {
            throw new IllegalArgumentException("Child " + subscription.getMRIMetaData().getMRI() + " is not child of " + this.m_parentMRI);
        }
        boolean result = this.m_unavailableChildSubscriptions.add(subscription);
        this.adjustUpdatePolicy(subscription);
        return result;
    }

    private void adjustUpdatePolicy(AbstractAttributeSubscription subscription) {
        int subscriptionUpdateTime = subscription.getMRIMetaData().getUpdateTime();
        if (subscriptionUpdateTime > 0 && subscriptionUpdateTime < this.getParentSubscriptionUpdateTime()) {
            this.setParentSubscriptionUpdateTime(subscriptionUpdateTime);
        }
    }

    private int getParentSubscriptionUpdateTime() {
        return this.m_subscriptionService.getMRISubscription(this.m_parentMRI).getMRIMetaData().getUpdateTime();
    }

    private void setParentSubscriptionUpdateTime(int subscriptionUpdateTime) {
        this.m_subscriptionService.getMRISubscription(this.m_parentMRI).setUpdatePolicy(PolicyFactory.createSimpleUpdatePolicy(subscriptionUpdateTime));
    }

    public Collection<AbstractAttributeSubscription> getChildSubscriptions() {
        return this.m_unavailableChildSubscriptions;
    }

    private IMRIValueListener createValueListener() {
        return new IMRIValueListener(){

            @Override
            public void valueChanged(MRIValueEvent event) {
                if (event.getValue() instanceof CompositeData) {
                    UnavailableChildSubscriptions.this.dispose();
                    UnavailableChildSubscriptions.this.m_repository.movePossibleChildSubscriptions(UnavailableChildSubscriptions.this);
                }
            }
        };
    }

    public static boolean isCompositeChildSubscription(AbstractAttributeSubscription subscription) {
        String[] compositeParts = AttributeToolkit.getDataPathParts(subscription.getMRIMetaData().getMRI());
        return compositeParts.length > 1;
    }

    public static MRI getParentMRI(AbstractAttributeSubscription subscription) {
        MRI mri = subscription.getMRIMetaData().getMRI();
        return new MRI(mri.getType(), mri.getObjectName(), AttributeToolkit.getDataPathParts(mri)[0]);
    }
}

