/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rjmx.subscription.internal;

import com.jrockit.mc.rjmx.subscription.MRI;
import com.jrockit.mc.rjmx.subscription.internal.AbstractSyntheticAttribute;
import com.jrockit.mc.rjmx.subscription.internal.AttributeValueToolkit;
import com.jrockit.mc.rjmx.subscription.internal.SyntheticAttributeToolkit;
import java.util.Set;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanException;
import javax.management.MBeanServerConnection;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.openmbean.CompositeData;

public class HotSpotLastGcAttribute
extends AbstractSyntheticAttribute {
    private static final String COM_SUN_MANAGEMENT_GC_NOTIFICATION = "com.sun.management.gc.notification";
    private MBeanServerConnection m_connection = null;
    private MRI[] m_notificationDescriptors = null;
    private final NotificationListener m_listener = this.createListener();
    private CompositeData m_lastGcInfo = null;

    @Override
    public Object getValue(MBeanServerConnection connection) throws MBeanException, ReflectionException {
        return this.m_lastGcInfo;
    }

    @Override
    public void setValue(MBeanServerConnection connection, Object value) throws InvalidAttributeValueException, MBeanException, ReflectionException {
    }

    @Override
    public void init(MBeanServerConnection connection) {
        super.init(connection);
        this.m_connection = connection;
        Set<ObjectName> garbageCollectorMxBeans = SyntheticAttributeToolkit.lookupMxBeans(this.m_connection, "java.lang", "GarbageCollector");
        this.m_lastGcInfo = this.findLatestGcInfo(garbageCollectorMxBeans);
        this.m_notificationDescriptors = SyntheticAttributeToolkit.createNotificationDescriptors(this.m_connection, garbageCollectorMxBeans, COM_SUN_MANAGEMENT_GC_NOTIFICATION);
        SyntheticAttributeToolkit.subscribeToNotifications(this.m_connection, this.m_listener, this.m_notificationDescriptors);
    }

    @Override
    public void stop() {
        SyntheticAttributeToolkit.unsubscribeFromNotifications(this.m_connection, this.m_listener, this.m_notificationDescriptors);
    }

    private NotificationListener createListener() {
        return new NotificationListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void handleNotification(Notification notification, Object handback) {
                HotSpotLastGcAttribute hotSpotLastGcAttribute = HotSpotLastGcAttribute.this;
                synchronized (hotSpotLastGcAttribute) {
                    HotSpotLastGcAttribute.this.m_lastGcInfo = (CompositeData)((CompositeData)notification.getUserData()).get("gcInfo");
                }
            }
        };
    }

    private CompositeData findLatestGcInfo(Set<ObjectName> garbageCollectorMxBeans) {
        long lastTimestamp = 0L;
        CompositeData lastLastGc = null;
        for (ObjectName objectName : garbageCollectorMxBeans) {
            try {
                long endTime;
                CompositeData lastGcInfo = (CompositeData)AttributeValueToolkit.getAttribute(this.m_connection, objectName, "LastGcInfo");
                if (lastGcInfo == null || (endTime = ((Long)lastGcInfo.get("endTime")).longValue()) <= lastTimestamp) continue;
                lastTimestamp = endTime;
                lastLastGc = lastGcInfo;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return lastLastGc;
    }
}

