/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rjmx.subscription.internal;

import com.jrockit.mc.rjmx.IConnectionHandle;
import com.jrockit.mc.rjmx.RJMXPlugin;
import com.jrockit.mc.rjmx.internal.IDisposableService;
import com.jrockit.mc.rjmx.services.ServiceException;
import com.jrockit.mc.rjmx.subscription.IMBeanHelperService;
import com.jrockit.mc.rjmx.subscription.IMBeanServerChangeListener;
import com.jrockit.mc.rjmx.subscription.IMRIMetaData;
import com.jrockit.mc.rjmx.subscription.IMRIMetaDataProviderService;
import com.jrockit.mc.rjmx.subscription.IMRIMetaDataService;
import com.jrockit.mc.rjmx.subscription.MRI;
import com.jrockit.mc.rjmx.subscription.internal.MRIMetaDataWrapper;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import javax.management.ObjectName;

public final class DefaultMRIMetaDataService
extends Observable
implements IMRIMetaDataService,
IDisposableService {
    private final Observer metaDataObserver;
    private final IMBeanHelperService mbeanService;
    private final IMBeanServerChangeListener mbeanListener = new IMBeanServerChangeListener(){

        @Override
        public void mbeanUnregistered(ObjectName mbean) {
            DefaultMRIMetaDataService.this.metaDataObserver.update(null, mbean);
        }

        @Override
        public void mbeanRegistered(ObjectName mbean) {
            DefaultMRIMetaDataService.this.metaDataObserver.update(null, mbean);
        }
    };
    private final IMRIMetaDataService providerMetaDataService = this.createProviderMetaDataService();

    private IMRIMetaDataService createProviderMetaDataService() {
        return new IMRIMetaDataService(){

            @Override
            public void setMetaData(MRI mri, String dataKey, Object data) {
                DefaultMRIMetaDataService.this.setMetaData(mri, dataKey, data);
            }

            @Override
            public Object getMetaData(MRI mri, String dataKey) {
                Object md = DefaultMRIMetaDataService.getGlobalService().getMetaData(mri, dataKey);
                if (md != null) {
                    return md;
                }
                Map<String, Object> mriMetaData = DefaultMRIMetaDataService.this.mbeanService.getMBeanMetaData(mri.getObjectName()).get(mri);
                return mriMetaData != null ? mriMetaData.get(dataKey) : null;
            }

            @Override
            public IMRIMetaData getMetaData(MRI descriptor) {
                return new MRIMetaDataWrapper(descriptor, this);
            }

            @Override
            public void deleteObserver(Observer o) {
                DefaultMRIMetaDataService.this.deleteObserver(o);
            }

            @Override
            public void addObserver(Observer o) {
                DefaultMRIMetaDataService.this.addObserver(o);
            }
        };
    }

    public DefaultMRIMetaDataService(IConnectionHandle handle) throws ServiceException {
        this.metaDataObserver = this.createMetaDataObserver();
        DefaultMRIMetaDataService.getGlobalService().addObserver(this.metaDataObserver);
        this.mbeanService = handle.getServiceOrThrow(IMBeanHelperService.class);
        this.mbeanService.addMBeanServerChangeListener(this.mbeanListener);
    }

    @Override
    public IMRIMetaData getMetaData(MRI mri) {
        return new MRIMetaDataWrapper(mri, this);
    }

    @Override
    public Object getMetaData(MRI mri, String dataKey) {
        Object md = DefaultMRIMetaDataService.getGlobalService().getMetaData(mri, dataKey);
        if (md != null) {
            return md;
        }
        md = DefaultMRIMetaDataService.getMetaDataProviderService().getMetaData(this.providerMetaDataService, mri, dataKey);
        if (md != null) {
            return md;
        }
        Map<String, Object> mriMetaData = this.mbeanService.getMBeanMetaData(mri.getObjectName()).get(mri);
        return mriMetaData != null ? mriMetaData.get(dataKey) : null;
    }

    @Override
    public void setMetaData(MRI mri, String dataKey, Object data) {
        DefaultMRIMetaDataService.getGlobalService().setMetaData(mri, dataKey, data);
    }

    @Override
    public void dispose() {
        this.mbeanService.removeMBeanServerChangeListener(this.mbeanListener);
        DefaultMRIMetaDataService.getGlobalService().deleteObserver(this.metaDataObserver);
    }

    private static IMRIMetaDataService getGlobalService() {
        return RJMXPlugin.getDefault().getService(IMRIMetaDataService.class);
    }

    private static IMRIMetaDataProviderService getMetaDataProviderService() {
        return RJMXPlugin.getDefault().getService(IMRIMetaDataProviderService.class);
    }

    private Observer createMetaDataObserver() {
        return new Observer(){

            @Override
            public void update(Observable o, Object arg) {
                DefaultMRIMetaDataService.this.setChanged();
                DefaultMRIMetaDataService.this.notifyObservers(arg);
            }
        };
    }
}

