/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rjmx.subscription;

import com.jrockit.mc.common.xml.IXMLCodec;
import com.jrockit.mc.common.xml.XmlToolkit;
import com.jrockit.mc.rjmx.subscription.internal.AttributeDescriptorCodec;
import java.io.Serializable;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public final class MRI
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String MRI_DELIMITER = "://";
    private ObjectName m_objectName;
    private Type m_type;
    private String m_dataPath;
    private String m_qualifiedName;

    static {
        XmlToolkit.addCodec((IXMLCodec)new AttributeDescriptorCodec());
    }

    private MRI(String qualifiedName) {
        this.initializeFromQualifiedName(qualifiedName);
    }

    public MRI(Type type, String beanName, String attributeName) {
        this.initialize(type, beanName, attributeName);
    }

    public MRI(Type type, ObjectName objectName, String dataPath) {
        this.initialize(type, objectName, dataPath);
    }

    public MRI(MRI mri, String child) {
        this.initialize(mri.getType(), mri.getObjectName(), String.valueOf(mri.getDataPath()) + "/" + child);
    }

    public String getQualifiedName() {
        return this.m_qualifiedName;
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof MRI) {
            return this.m_qualifiedName.equals(((MRI)obj).getQualifiedName());
        }
        return false;
    }

    public int hashCode() {
        return this.m_qualifiedName.hashCode();
    }

    public ObjectName getObjectName() {
        return this.m_objectName;
    }

    public String getDataPath() {
        return this.m_dataPath;
    }

    public Type getType() {
        return this.m_type;
    }

    public String toString() {
        return this.m_qualifiedName;
    }

    private void initializeFromQualifiedName(String qualifiedName) {
        int index = qualifiedName.indexOf(MRI_DELIMITER);
        if (index < 0) {
            throw new IllegalArgumentException(String.format("Malformed FQN. Could not find :// in %s", qualifiedName));
        }
        Type type = Type.fromString(qualifiedName.substring(0, index));
        if (type == null) {
            throw new IllegalArgumentException(String.format("%s is not a recognized type.", qualifiedName.substring(0, index)));
        }
        int mbeanStart = index + MRI_DELIMITER.length();
        if ((index = qualifiedName.indexOf(47, mbeanStart)) >= 0) {
            String beanName = qualifiedName.substring(mbeanStart, index);
            String attributeName = qualifiedName.substring(index + 1);
            this.initialize(type, beanName, attributeName);
        } else {
            this.m_dataPath = qualifiedName;
            this.m_qualifiedName = qualifiedName.intern();
        }
    }

    private void initialize(Type type, String beanName, String attributeName) {
        try {
            this.initialize(type, new ObjectName(beanName), attributeName);
        }
        catch (MalformedObjectNameException e) {
            IllegalArgumentException iae = new IllegalArgumentException("Malformed descriptor.");
            iae.initCause(e);
            throw iae;
        }
    }

    private void initialize(Type type, ObjectName objectName, String valuePath) {
        if (objectName == null) {
            throw new NullPointerException("objectName may not be null!");
        }
        if (valuePath == null) {
            throw new NullPointerException("valuePath may not be null!");
        }
        this.m_type = type;
        this.m_objectName = objectName;
        this.m_dataPath = valuePath;
        this.m_qualifiedName = this.generateQualifiedName(type, objectName, valuePath).intern();
    }

    private String generateQualifiedName(Type type, ObjectName objectName, String valuePath) {
        return String.valueOf(type.getTypeName()) + MRI_DELIMITER + objectName.getCanonicalName() + '/' + valuePath;
    }

    public boolean isCompositeChild() {
        if (this.getDataPath() == null) {
            return false;
        }
        return this.getDataPath().indexOf(47) >= 0;
    }

    public static MRI createFromQualifiedName(String qualName) {
        return new MRI(qualName);
    }

    public static enum Type {
        ATTRIBUTE("attribute"),
        NOTIFICATION("notification");

        private String typeName;

        private Type(String typeName) {
            this.typeName = typeName;
        }

        public String getTypeName() {
            return this.typeName;
        }

        public static Type fromString(String typeName) {
            Type[] typeArray = Type.values();
            int n = typeArray.length;
            int n2 = 0;
            while (n2 < n) {
                Type type = typeArray[n2];
                if (typeName.equals(type.getTypeName())) {
                    return type;
                }
                ++n2;
            }
            return null;
        }
    }
}

