/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rjmx.internal;

import com.jrockit.mc.rjmx.ISyntheticNotification;
import com.jrockit.mc.rjmx.RJMXPlugin;
import com.jrockit.mc.rjmx.internal.SyntheticNotificationEntry;
import com.jrockit.mc.rjmx.internal.SyntheticNotificationMBean;
import com.jrockit.mc.rjmx.subscription.MRI;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanInfo;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import javax.management.MBeanServerFactory;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.QueryExp;
import javax.management.ReflectionException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;

public class SyntheticNotificationRepository {
    private final Map<ObjectName, Set<SyntheticNotificationEntry>> mbeans = new HashMap<ObjectName, Set<SyntheticNotificationEntry>>();
    private final MBeanServer server = MBeanServerFactory.newMBeanServer();
    private final MBeanServerConnection compoundServer;

    public SyntheticNotificationRepository(MBeanServerConnection compoundServer) {
        this.compoundServer = compoundServer;
    }

    public String[] getDomains() {
        return this.server.getDomains();
    }

    public ObjectInstance getObjectInstance(ObjectName name) throws InstanceNotFoundException {
        return this.server.getObjectInstance(name);
    }

    public Set<ObjectInstance> queryMBeans(ObjectName name, QueryExp query) {
        return this.server.queryMBeans(name, query);
    }

    public Set<ObjectName> queryNames(ObjectName name, QueryExp query) {
        return this.server.queryNames(name, query);
    }

    public boolean isRegistered(ObjectName name) {
        return this.server.isRegistered(name);
    }

    public Integer getMBeanCount() {
        return this.server.getMBeanCount();
    }

    public boolean hasNotification(ObjectName name) {
        Set<SyntheticNotificationEntry> entries = this.mbeans.get(name);
        return entries != null;
    }

    public MBeanInfo getMBeanInfo(ObjectName name) throws IntrospectionException, InstanceNotFoundException, ReflectionException {
        return this.server.getMBeanInfo(name);
    }

    public void addNotificationListener(ObjectName name, ObjectName listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, IOException {
        this.server.addNotificationListener(name, listener, filter, handback);
    }

    public void addNotificationListener(ObjectName name, NotificationListener listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException {
        this.server.addNotificationListener(name, listener, filter, handback);
    }

    public void removeNotificationListener(ObjectName name, ObjectName listener) throws InstanceNotFoundException, ListenerNotFoundException {
        this.server.removeNotificationListener(name, listener);
    }

    public void removeNotificationListener(ObjectName name, ObjectName listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, ListenerNotFoundException {
        this.server.removeNotificationListener(name, listener, filter, handback);
    }

    public void removeNotificationListener(ObjectName name, NotificationListener listener) throws InstanceNotFoundException, ListenerNotFoundException {
        this.server.removeNotificationListener(name, listener);
    }

    public void removeNotificationListener(ObjectName name, NotificationListener listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, ListenerNotFoundException {
        this.server.removeNotificationListener(name, listener, filter, handback);
    }

    void initializeFromExtensions() {
        IExtension[] extensions;
        IExtensionRegistry er = Platform.getExtensionRegistry();
        IExtensionPoint ep = er.getExtensionPoint("com.jrockit.mc.rjmx.syntheticnotification");
        IExtension[] iExtensionArray = extensions = ep.getExtensions();
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement[] configs;
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = configs = extension.getConfigurationElements();
            int n3 = configs.length;
            int n4 = 0;
            while (n4 < n3) {
                SyntheticNotificationEntry entry;
                IConfigurationElement config = iConfigurationElementArray[n4];
                if (config.getName().equals("syntheticNotification") && (entry = this.createEntry(config)) != null) {
                    this.registerEntry(entry);
                }
                ++n4;
            }
            ++n2;
        }
        this.registerMBeans();
    }

    private void registerMBeans() {
        for (ObjectName objectName : this.mbeans.keySet()) {
            try {
                SyntheticNotificationMBean mbean = this.createMBean(objectName);
                for (SyntheticNotificationEntry entry : this.mbeans.get(objectName)) {
                    entry.getNotification().init(mbean);
                    entry.getNotification().init(this.compoundServer, entry.getNotificationDescriptor().getDataPath(), entry.getMessage());
                }
            }
            catch (Exception e) {
                RJMXPlugin.getDefault().getLogger().log(Level.SEVERE, "Failed to register synthetic notification mbean " + objectName.toString(), e);
            }
        }
    }

    private SyntheticNotificationMBean createMBean(ObjectName name) throws Exception {
        Set<SyntheticNotificationEntry> entries = this.mbeans.get(name);
        SyntheticNotificationMBean mbean = new SyntheticNotificationMBean(entries.toArray(new SyntheticNotificationEntry[entries.size()]));
        this.server.registerMBean(mbean, name);
        return mbean;
    }

    private void registerEntry(SyntheticNotificationEntry entry) {
        Set<SyntheticNotificationEntry> notificationEntries = this.mbeans.get(entry.getNotificationDescriptor().getObjectName());
        if (notificationEntries == null) {
            notificationEntries = new HashSet<SyntheticNotificationEntry>();
            this.mbeans.put(entry.getNotificationDescriptor().getObjectName(), notificationEntries);
        }
        notificationEntries.add(entry);
    }

    private SyntheticNotificationEntry createEntry(IConfigurationElement config) {
        String notificationName = config.getAttribute("notificationName");
        try {
            ISyntheticNotification notification = (ISyntheticNotification)config.createExecutableExtension("class");
            String description = config.getAttribute("description");
            String type = config.getAttribute("type");
            String message = config.getAttribute("message");
            MRI descriptor = MRI.createFromQualifiedName(notificationName);
            return new SyntheticNotificationEntry(notification, descriptor, description, type, message);
        }
        catch (CoreException e) {
            RJMXPlugin.getDefault().getLogger().log(Level.SEVERE, "Could not create synthetic notification for " + notificationName, e);
            return null;
        }
    }

    public boolean isInstanceOf(ObjectName name, String className) throws InstanceNotFoundException {
        return this.server.isInstanceOf(name, className);
    }

    public void dispose() {
        for (Set<SyntheticNotificationEntry> notificationEntrySet : this.mbeans.values()) {
            for (SyntheticNotificationEntry entry : notificationEntrySet) {
                try {
                    entry.getNotification().stop();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
    }
}

