/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.image.BufferedImage;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.InvalidObjectException;
import java.io.Serializable;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.BreakIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.Vector;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.SourceVersion;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.openide.util.AsyncGUIJob;
import org.openide.util.AsyncInitSupport;
import org.openide.util.ContextAwareAction;
import org.openide.util.ContextGlobalProvider;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.RE13;
import org.openide.util.TopologicalSortException;
import org.openide.util.UtilitiesCompositeActionMap;
import org.openide.util.actions.ActionPresenterProvider;
import org.openide.util.actions.Presenter;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.implspi.ActiveQueue;

public final class Utilities {
    private static final Logger LOG = Logger.getLogger(Utilities.class.getName());
    public static final int OS_WINNT = 1;
    public static final int OS_WIN95 = 2;
    public static final int OS_WIN98 = 4;
    public static final int OS_SOLARIS = 8;
    public static final int OS_LINUX = 16;
    public static final int OS_HP = 32;
    public static final int OS_AIX = 64;
    public static final int OS_IRIX = 128;
    public static final int OS_SUNOS = 256;
    public static final int OS_TRU64 = 512;
    @Deprecated
    public static final int OS_DEC = 1024;
    public static final int OS_OS2 = 2048;
    public static final int OS_MAC = 4096;
    public static final int OS_WIN2000 = 8192;
    public static final int OS_VMS = 16384;
    public static final int OS_WIN_OTHER = 32768;
    public static final int OS_OTHER = 65536;
    public static final int OS_FREEBSD = 131072;
    public static final int OS_WINVISTA = 262144;
    public static final int OS_UNIX_OTHER = 524288;
    public static final int OS_OPENBSD = 0x100000;
    @Deprecated
    public static final int OS_WINDOWS_MASK = 303111;
    @Deprecated
    public static final int OS_UNIX_MASK = 1709048;
    public static final int TYPICAL_WINDOWS_TASKBAR_HEIGHT = 27;
    private static final int TYPICAL_MACOSX_MENU_HEIGHT = 24;
    private static int operatingSystem = -1;
    private static Timer clearIntrospector;
    private static ActionListener doClear;
    private static final int CTRL_WILDCARD_MASK = 32768;
    private static final int ALT_WILDCARD_MASK = 65536;
    private static final Object TRANS_LOCK;
    private static Object transLoader;
    private static RE transExp;
    private static final Map<GraphicsConfiguration, Map<Rectangle, Long>> screenBoundsCache;
    private static Lookup global;
    private static Reference<NamesAndValues> namesAndValues;
    private static Method fileToPath;
    private static Method pathToUri;
    private static Method pathsGet;
    private static Method pathToFile;

    private Utilities() {
    }

    public static ReferenceQueue<Object> activeReferenceQueue() {
        return ActiveQueue.queue();
    }

    public static int getOperatingSystem() {
        if (operatingSystem == -1) {
            String string = System.getProperty("os.name");
            operatingSystem = "Windows NT".equals(string) ? 1 : ("Windows 95".equals(string) ? 2 : ("Windows 98".equals(string) ? 4 : ("Windows 2000".equals(string) ? 8192 : ("Windows Vista".equals(string) ? 262144 : (string.startsWith("Windows ") ? 32768 : ("Solaris".equals(string) ? 8 : (string.startsWith("SunOS") ? 8 : (string.endsWith("Linux") ? 16 : ("HP-UX".equals(string) ? 32 : ("AIX".equals(string) ? 64 : ("Irix".equals(string) ? 128 : ("SunOS".equals(string) ? 256 : ("Digital UNIX".equals(string) ? 512 : ("OS/2".equals(string) ? 2048 : ("OpenVMS".equals(string) ? 16384 : (string.equals("Mac OS X") ? 4096 : (string.startsWith("Darwin") ? 4096 : (string.toLowerCase(Locale.US).startsWith("freebsd") ? 131072 : ("OpenBSD".equals(string) ? 0x100000 : (File.pathSeparatorChar == ':' ? 524288 : 65536))))))))))))))))))));
        }
        return operatingSystem;
    }

    public static boolean isWindows() {
        return (Utilities.getOperatingSystem() & 0x4A007) != 0;
    }

    public static boolean isMac() {
        return (Utilities.getOperatingSystem() & 0x1000) != 0;
    }

    public static boolean isUnix() {
        return (Utilities.getOperatingSystem() & 0x1A13F8) != 0;
    }

    static void resetOperatingSystem() {
        operatingSystem = -1;
    }

    public static boolean isJavaIdentifier(String string) {
        if (string == null) {
            return false;
        }
        return SourceVersion.isIdentifier(string) && !SourceVersion.isKeyword(string);
    }

    public static BeanInfo getBeanInfo(Class<?> clazz) throws IntrospectionException {
        BeanInfo beanInfo;
        try {
            beanInfo = Introspector.getBeanInfo(clazz);
        }
        catch (IntrospectionException introspectionException) {
            Exceptions.attachMessage(introspectionException, "Encountered while introspecting " + clazz.getName());
            throw introspectionException;
        }
        catch (Error error) {
            Exceptions.attachMessage(error, "Encountered while introspecting " + clazz.getName());
            throw error;
        }
        if (Component.class.isAssignableFrom(clazz)) {
            PropertyDescriptor[] propertyDescriptorArray = beanInfo.getPropertyDescriptors();
            for (int i = 0; i < propertyDescriptorArray.length; ++i) {
                if (!propertyDescriptorArray[i].getName().equals("cursor")) continue;
                try {
                    Method method = Component.class.getDeclaredMethod("getCursor", new Class[0]);
                    Method method2 = Component.class.getDeclaredMethod("setCursor", Cursor.class);
                    propertyDescriptorArray[i] = new PropertyDescriptor("cursor", method, method2);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    noSuchMethodException.printStackTrace();
                }
                break;
            }
        }
        if (beanInfo != null) {
            if (clearIntrospector == null) {
                doClear = new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        Introspector.flushCaches();
                    }
                };
                clearIntrospector = new Timer(15000, doClear);
                clearIntrospector.setRepeats(false);
            }
            clearIntrospector.restart();
        }
        return beanInfo;
    }

    public static BeanInfo getBeanInfo(Class<?> clazz, Class<?> clazz2) throws IntrospectionException {
        return Introspector.getBeanInfo(clazz, clazz2);
    }

    @Deprecated
    public static String[] wrapStringToArray(String string, int n, boolean bl, boolean bl2) {
        BreakIterator breakIterator = bl ? BreakIterator.getWordInstance() : BreakIterator.getCharacterInstance();
        return Utilities.wrapStringToArray(string, n, breakIterator, bl2);
    }

    public static String[] wrapStringToArray(String string, int n, BreakIterator breakIterator, boolean bl) {
        int n2;
        int n3;
        String[] stringArray;
        block14: {
            if (string.length() == 0) {
                return new String[]{string};
            }
            if (bl) {
                string = Utilities.trimString(string);
                string = string.replace('\n', ' ');
                stringArray = new String[]{string};
            } else {
                StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
                n3 = stringTokenizer.countTokens();
                stringArray = new String[n3];
                for (n2 = 0; n2 < n3; ++n2) {
                    stringArray[n2] = stringTokenizer.nextToken();
                }
            }
            if (n < 1) {
                n = 1;
            }
            if (string.length() <= n) {
                return stringArray;
            }
            boolean bl2 = true;
            for (n3 = 0; n3 < stringArray.length; ++n3) {
                boolean bl3 = bl2 = bl2 && stringArray[n3].length() < n;
                if (bl2) {
                    continue;
                }
                break block14;
            }
            return stringArray;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        n3 = 0;
        for (n2 = 0; n2 < stringArray.length; ++n2) {
            if (stringArray[n2].length() < n) {
                arrayList.add(stringArray[n2]);
                continue;
            }
            breakIterator.setText(stringArray[n2]);
            int n4 = breakIterator.next();
            int n5 = 0;
            while (true) {
                if (n4 - n3 < n && n4 != -1) {
                    n5 = n4;
                    n4 = breakIterator.next();
                    continue;
                }
                if (n4 == -1) {
                    n4 = n5 = stringArray[n2].length();
                }
                if (n5 == 0) {
                    n5 = n4;
                }
                arrayList.add(stringArray[n2].substring(n3, n5));
                n3 = n5;
                n5 = 0;
                if (n3 >= stringArray[n2].length()) break;
            }
            n3 = 0;
        }
        String[] stringArray2 = new String[arrayList.size()];
        return arrayList.toArray(stringArray2);
    }

    private static String trimString(String string) {
        char c;
        int n = 0;
        int n2 = string.length();
        if (n2 == 0) {
            return string;
        }
        while (((c = string.charAt(n++)) == '\n' || c == '\r') && n < n2) {
        }
        --n;
        if ((n = (string = string.substring(n)).length() - 1) < 0) {
            return string;
        }
        while (((c = string.charAt(n--)) == '\n' || c == '\r') && n >= 0) {
        }
        return string.substring(0, n + 2);
    }

    public static String wrapString(String string, int n, BreakIterator breakIterator, boolean bl) {
        String[] stringArray = Utilities.wrapStringToArray(string, n, breakIterator, bl);
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuilder.append(stringArray[i]);
            stringBuilder.append('\n');
        }
        return stringBuilder.toString();
    }

    @Deprecated
    public static String wrapString(String string, int n, boolean bl, boolean bl2) {
        if (bl2) {
            while (string.startsWith("\n")) {
                string = string.substring(1);
            }
            while (string.endsWith("\n")) {
                string = string.substring(0, string.length() - 1);
            }
            string = string.replace('\n', ' ');
        }
        if (n < 1) {
            n = 1;
        }
        if (string.length() <= n) {
            return string;
        }
        Vector<String> vector = new Vector<String>();
        int n2 = 0;
        int n3 = -1;
        for (int i = 0; i < string.length() && n2 < string.length() - 1; ++i) {
            if (string.charAt(i) == '\n') {
                vector.addElement(string.substring(n2, i));
                n2 = i + 1;
                n3 = -1;
                continue;
            }
            if (Character.isSpaceChar(string.charAt(i))) {
                n3 = i;
            }
            if (i == string.length() - 1) {
                vector.addElement(string.substring(n2));
                break;
            }
            if (i - n2 != n) continue;
            if (bl && n3 != -1) {
                vector.addElement(string.substring(n2, n3));
                n2 = n3 + 1;
                n3 = -1;
                continue;
            }
            vector.addElement(string.substring(n2, i));
            n2 = i;
            n3 = -1;
        }
        StringBuilder stringBuilder = new StringBuilder();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            stringBuilder.append((String)enumeration.nextElement());
            stringBuilder.append('\n');
        }
        return stringBuilder.toString();
    }

    @Deprecated
    public static String replaceString(String string, String string2, String string3) {
        int n;
        int n2 = 0;
        if ("".equals(string2)) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder();
        do {
            if ((n = string.indexOf(string2, n2)) == -1) {
                stringBuilder.append(string.substring(n2));
                return stringBuilder.toString();
            }
            stringBuilder.append(string.substring(n2, n));
            stringBuilder.append(string3);
        } while ((n2 = n + string2.length()) != string.length());
        return stringBuilder.toString();
    }

    public static String pureClassName(String string) {
        int n = string.indexOf(36);
        if (n >= 0 && n < string.length()) {
            return string.substring(n + 1, string.length());
        }
        return string;
    }

    @Deprecated
    public static boolean isLargeFrameIcons() {
        return Utilities.getOperatingSystem() == 8 || Utilities.getOperatingSystem() == 32;
    }

    @Deprecated
    public static int arrayHashCode(Object[] objectArray) {
        int n = 0;
        int n2 = objectArray.length;
        for (int i = 0; i < n2; ++i) {
            Object object = objectArray[i];
            int n3 = object == null ? 1 : object.hashCode();
            n += n3 ^ i;
        }
        return n;
    }

    public static boolean compareObjects(Object object, Object object2) {
        return Utilities.compareObjectsImpl(object, object2, 1);
    }

    public static boolean compareObjectsImpl(Object object, Object object2, int n) {
        if (object == null) {
            return object2 == null;
        }
        if (object2 == null) {
            return false;
        }
        if (n > 0) {
            if (object instanceof Object[] && object2 instanceof Object[]) {
                Object[] objectArray = (Object[])object;
                int n2 = objectArray.length;
                Object[] objectArray2 = (Object[])object2;
                int n3 = objectArray2.length;
                if (n2 != n3) {
                    return false;
                }
                for (int i = 0; i < n2; ++i) {
                    if (Utilities.compareObjectsImpl(objectArray[i], objectArray2[i], n - 1)) continue;
                    return false;
                }
                return true;
            }
            if (object instanceof byte[] && object2 instanceof byte[]) {
                byte[] byArray = (byte[])object;
                int n4 = byArray.length;
                byte[] byArray2 = (byte[])object2;
                int n5 = byArray2.length;
                if (n4 != n5) {
                    return false;
                }
                for (int i = 0; i < n4; ++i) {
                    if (byArray[i] == byArray2[i]) continue;
                    return false;
                }
                return true;
            }
            if (object instanceof short[] && object2 instanceof short[]) {
                short[] sArray = (short[])object;
                int n6 = sArray.length;
                short[] sArray2 = (short[])object2;
                int n7 = sArray2.length;
                if (n6 != n7) {
                    return false;
                }
                for (int i = 0; i < n6; ++i) {
                    if (sArray[i] == sArray2[i]) continue;
                    return false;
                }
                return true;
            }
            if (object instanceof int[] && object2 instanceof int[]) {
                int[] nArray = (int[])object;
                int n8 = nArray.length;
                int[] nArray2 = (int[])object2;
                int n9 = nArray2.length;
                if (n8 != n9) {
                    return false;
                }
                for (int i = 0; i < n8; ++i) {
                    if (nArray[i] == nArray2[i]) continue;
                    return false;
                }
                return true;
            }
            if (object instanceof long[] && object2 instanceof long[]) {
                long[] lArray = (long[])object;
                int n10 = lArray.length;
                long[] lArray2 = (long[])object2;
                int n11 = lArray2.length;
                if (n10 != n11) {
                    return false;
                }
                for (int i = 0; i < n10; ++i) {
                    if (lArray[i] == lArray2[i]) continue;
                    return false;
                }
                return true;
            }
            if (object instanceof float[] && object2 instanceof float[]) {
                float[] fArray = (float[])object;
                int n12 = fArray.length;
                float[] fArray2 = (float[])object2;
                int n13 = fArray2.length;
                if (n12 != n13) {
                    return false;
                }
                for (int i = 0; i < n12; ++i) {
                    if (fArray[i] == fArray2[i]) continue;
                    return false;
                }
                return true;
            }
            if (object instanceof double[] && object2 instanceof double[]) {
                double[] dArray = (double[])object;
                int n14 = dArray.length;
                double[] dArray2 = (double[])object2;
                int n15 = dArray2.length;
                if (n14 != n15) {
                    return false;
                }
                for (int i = 0; i < n14; ++i) {
                    if (dArray[i] == dArray2[i]) continue;
                    return false;
                }
                return true;
            }
            if (object instanceof char[] && object2 instanceof char[]) {
                char[] cArray = (char[])object;
                int n16 = cArray.length;
                char[] cArray2 = (char[])object2;
                int n17 = cArray2.length;
                if (n16 != n17) {
                    return false;
                }
                for (int i = 0; i < n16; ++i) {
                    if (cArray[i] == cArray2[i]) continue;
                    return false;
                }
                return true;
            }
            if (object instanceof boolean[] && object2 instanceof boolean[]) {
                boolean[] blArray = (boolean[])object;
                int n18 = blArray.length;
                boolean[] blArray2 = (boolean[])object2;
                int n19 = blArray2.length;
                if (n18 != n19) {
                    return false;
                }
                for (int i = 0; i < n18; ++i) {
                    if (blArray[i] == blArray2[i]) continue;
                    return false;
                }
                return true;
            }
        }
        return object.equals(object2);
    }

    public static String getClassName(Class<?> clazz) {
        if (clazz.isArray()) {
            return Utilities.getClassName(clazz.getComponentType()) + "[]";
        }
        return clazz.getName();
    }

    public static String getShortClassName(Class<?> clazz) {
        if (clazz.isArray()) {
            return Utilities.getShortClassName(clazz.getComponentType()) + "[]";
        }
        String string = clazz.getName().replace('$', '.');
        return string.substring(string.lastIndexOf(46) + 1, string.length());
    }

    public static Object toPrimitiveArray(Object[] objectArray) {
        if (objectArray instanceof Integer[]) {
            int[] nArray = new int[objectArray.length];
            int n = objectArray.length;
            for (int i = 0; i < n; ++i) {
                nArray[i] = (Integer)objectArray[i] == null ? 0 : (Integer)objectArray[i];
            }
            return nArray;
        }
        if (objectArray instanceof Boolean[]) {
            boolean[] blArray = new boolean[objectArray.length];
            int n = objectArray.length;
            for (int i = 0; i < n; ++i) {
                blArray[i] = (Boolean)objectArray[i] == null ? false : (Boolean)objectArray[i];
            }
            return blArray;
        }
        if (objectArray instanceof Byte[]) {
            byte[] byArray = new byte[objectArray.length];
            int n = objectArray.length;
            for (int i = 0; i < n; ++i) {
                byArray[i] = (Byte)objectArray[i] == null ? (byte)0 : (Byte)objectArray[i];
            }
            return byArray;
        }
        if (objectArray instanceof Character[]) {
            char[] cArray = new char[objectArray.length];
            int n = objectArray.length;
            for (int i = 0; i < n; ++i) {
                cArray[i] = (Character)objectArray[i] == null ? (char)'\u0000' : ((Character)objectArray[i]).charValue();
            }
            return cArray;
        }
        if (objectArray instanceof Double[]) {
            double[] dArray = new double[objectArray.length];
            int n = objectArray.length;
            for (int i = 0; i < n; ++i) {
                dArray[i] = (Double)objectArray[i] == null ? 0.0 : (Double)objectArray[i];
            }
            return dArray;
        }
        if (objectArray instanceof Float[]) {
            float[] fArray = new float[objectArray.length];
            int n = objectArray.length;
            for (int i = 0; i < n; ++i) {
                fArray[i] = (Float)objectArray[i] == null ? 0.0f : ((Float)objectArray[i]).floatValue();
            }
            return fArray;
        }
        if (objectArray instanceof Long[]) {
            long[] lArray = new long[objectArray.length];
            int n = objectArray.length;
            for (int i = 0; i < n; ++i) {
                lArray[i] = (Long)objectArray[i] == null ? 0L : (Long)objectArray[i];
            }
            return lArray;
        }
        if (objectArray instanceof Short[]) {
            short[] sArray = new short[objectArray.length];
            int n = objectArray.length;
            for (int i = 0; i < n; ++i) {
                sArray[i] = (Short)objectArray[i] == null ? (short)0 : (Short)objectArray[i];
            }
            return sArray;
        }
        throw new IllegalArgumentException();
    }

    public static Object[] toObjectArray(Object object) {
        if (object instanceof Object[]) {
            return (Object[])object;
        }
        if (object instanceof int[]) {
            int n = ((int[])object).length;
            Object[] objectArray = new Integer[n];
            for (int i = 0; i < n; ++i) {
                objectArray[i] = ((int[])object)[i];
            }
            return objectArray;
        }
        if (object instanceof boolean[]) {
            int n = ((boolean[])object).length;
            Object[] objectArray = new Boolean[n];
            for (int i = 0; i < n; ++i) {
                objectArray[i] = ((boolean[])object)[i];
            }
            return objectArray;
        }
        if (object instanceof byte[]) {
            int n = ((byte[])object).length;
            Object[] objectArray = new Byte[n];
            for (int i = 0; i < n; ++i) {
                objectArray[i] = ((byte[])object)[i];
            }
            return objectArray;
        }
        if (object instanceof char[]) {
            int n = ((char[])object).length;
            Object[] objectArray = new Character[n];
            for (int i = 0; i < n; ++i) {
                objectArray[i] = Character.valueOf(((char[])object)[i]);
            }
            return objectArray;
        }
        if (object instanceof double[]) {
            int n = ((double[])object).length;
            Object[] objectArray = new Double[n];
            for (int i = 0; i < n; ++i) {
                objectArray[i] = ((double[])object)[i];
            }
            return objectArray;
        }
        if (object instanceof float[]) {
            int n = ((float[])object).length;
            Object[] objectArray = new Float[n];
            for (int i = 0; i < n; ++i) {
                objectArray[i] = Float.valueOf(((float[])object)[i]);
            }
            return objectArray;
        }
        if (object instanceof long[]) {
            int n = ((long[])object).length;
            Object[] objectArray = new Long[n];
            for (int i = 0; i < n; ++i) {
                objectArray[i] = ((long[])object)[i];
            }
            return objectArray;
        }
        if (object instanceof short[]) {
            int n = ((short[])object).length;
            Object[] objectArray = new Short[n];
            for (int i = 0; i < n; ++i) {
                objectArray[i] = ((short[])object)[i];
            }
            return objectArray;
        }
        throw new IllegalArgumentException();
    }

    public static Class<?> getObjectType(Class<?> clazz) {
        if (!clazz.isPrimitive()) {
            return clazz;
        }
        if (clazz == Integer.TYPE) {
            return Integer.class;
        }
        if (clazz == Boolean.TYPE) {
            return Boolean.class;
        }
        if (clazz == Byte.TYPE) {
            return Byte.class;
        }
        if (clazz == Character.TYPE) {
            return Character.class;
        }
        if (clazz == Double.TYPE) {
            return Double.class;
        }
        if (clazz == Float.TYPE) {
            return Float.class;
        }
        if (clazz == Long.TYPE) {
            return Long.class;
        }
        if (clazz == Short.TYPE) {
            return Short.class;
        }
        throw new IllegalArgumentException();
    }

    public static Class<?> getPrimitiveType(Class<?> clazz) {
        if (!clazz.isPrimitive()) {
            return clazz;
        }
        if (clazz == Integer.class) {
            return Integer.TYPE;
        }
        if (clazz == Boolean.class) {
            return Boolean.TYPE;
        }
        if (clazz == Byte.class) {
            return Byte.TYPE;
        }
        if (clazz == Character.class) {
            return Character.TYPE;
        }
        if (clazz == Double.class) {
            return Double.TYPE;
        }
        if (clazz == Float.class) {
            return Float.TYPE;
        }
        if (clazz == Long.class) {
            return Long.TYPE;
        }
        if (clazz == Short.class) {
            return Short.TYPE;
        }
        throw new IllegalArgumentException();
    }

    public static Component getFocusTraversableComponent(Component component) {
        if (component.isFocusable()) {
            return component;
        }
        if (!(component instanceof Container)) {
            return null;
        }
        int n = ((Container)component).getComponentCount();
        for (int i = 0; i < n; ++i) {
            Component component2 = ((Container)component).getComponent(i);
            if (component2 == null) continue;
            return component2;
        }
        return null;
    }

    public static String[] parseParameters(String string) {
        int n = 0;
        int n2 = 1;
        int n3 = 2;
        int n4 = 4;
        int n5 = 8;
        Vector<String> vector = new Vector<String>(5, 5);
        int n6 = n;
        StringBuilder stringBuilder = new StringBuilder(20);
        int n7 = string.length();
        for (int i = 0; i < n7; ++i) {
            char c = string.charAt(i);
            if (Character.isWhitespace(c)) {
                if (n6 == n) {
                    if (stringBuilder.length() <= 0) continue;
                    vector.addElement(stringBuilder.toString());
                    stringBuilder.setLength(0);
                    continue;
                }
                if (n6 == n4) {
                    vector.addElement(stringBuilder.toString());
                    stringBuilder.setLength(0);
                    n6 = n;
                    continue;
                }
                if (n6 == n5) {
                    stringBuilder.append('\\');
                    vector.addElement(stringBuilder.toString());
                    stringBuilder.setLength(0);
                    n6 = n;
                    continue;
                }
                if (n6 == n3) {
                    n6 = n2;
                    stringBuilder.append('\\');
                    stringBuilder.append(c);
                    continue;
                }
                stringBuilder.append(c);
                continue;
            }
            if (c == '\\') {
                if (n6 == n) {
                    if (++i < n7) {
                        char c2 = string.charAt(i);
                        if (c2 == '\"' || c2 == '\\') {
                            stringBuilder.append(c2);
                            continue;
                        }
                        if (Character.isWhitespace(c2)) {
                            stringBuilder.append(c);
                            --i;
                            continue;
                        }
                        stringBuilder.append(c);
                        stringBuilder.append(c2);
                        continue;
                    }
                    stringBuilder.append('\\');
                    break;
                }
                if (n6 == n2) {
                    n6 = n3;
                    continue;
                }
                if (n6 == n3) {
                    stringBuilder.append('\\');
                    n6 = n2;
                    continue;
                }
                if (n6 == n4) {
                    n6 = n5;
                    continue;
                }
                if (n6 != n5) continue;
                stringBuilder.append('\\');
                n6 = n4;
                continue;
            }
            if (c == '\"') {
                if (n6 == n) {
                    n6 = n2;
                    continue;
                }
                if (n6 == n2) {
                    n6 = n4;
                    continue;
                }
                if (n6 == n4) {
                    n6 = n2;
                    continue;
                }
                if (n6 == n5) {
                    stringBuilder.append('\"');
                    n6 = n4;
                    continue;
                }
                stringBuilder.append('\"');
                n6 = n2;
                continue;
            }
            if (n6 == n3) {
                stringBuilder.append('\\');
                n6 = n2;
            } else if (n6 == n5) {
                stringBuilder.append('\\');
                n6 = n4;
            }
            stringBuilder.append(c);
        }
        if (n6 == n2) {
            vector.addElement(stringBuilder.toString());
        } else if ((n6 & (n3 | n5)) != 0) {
            stringBuilder.append('\\');
            vector.addElement(stringBuilder.toString());
        } else if (stringBuilder.length() != 0) {
            vector.addElement(stringBuilder.toString());
        }
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public static String escapeParameters(String[] stringArray) {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        for (n = 0; n < stringArray.length; ++n) {
            Utilities.escapeString(stringArray[n], stringBuffer);
            stringBuffer.append(' ');
        }
        n = stringBuffer.length();
        if (n > 0) {
            stringBuffer.setLength(n - 1);
        }
        return stringBuffer.toString().trim();
    }

    private static void escapeString(String string, StringBuffer stringBuffer) {
        if (string.length() == 0) {
            stringBuffer.append("\"\"");
            return;
        }
        boolean bl = false;
        int n = stringBuffer.length();
        int n2 = string.length();
        for (int i = 0; i < n2; ++i) {
            char c = string.charAt(i);
            if (Character.isWhitespace(c)) {
                bl = true;
                stringBuffer.append(c);
                continue;
            }
            if (c == '\\') {
                stringBuffer.append('\\').append('\\');
                continue;
            }
            if (c == '\"') {
                stringBuffer.append('\\').append('\"');
                continue;
            }
            stringBuffer.append(c);
        }
        if (bl) {
            stringBuffer.insert(n, '\"');
            stringBuffer.append('\"');
        }
    }

    private static synchronized NamesAndValues initNameAndValues() {
        Object object;
        if (namesAndValues != null && (object = namesAndValues.get()) != null) {
            return object;
        }
        object = KeyEvent.class.getDeclaredFields();
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>(((Field[])object).length * 4 / 3 + 5, 0.75f);
        HashMap<Integer, String> hashMap2 = new HashMap<Integer, String>(((Field[])object).length * 4 / 3 + 5, 0.75f);
        for (Field field : object) {
            String string;
            if (!Modifier.isStatic(field.getModifiers()) || !(string = field.getName()).startsWith("VK_")) continue;
            string = string.substring(3);
            try {
                int illegalArgumentException = field.getInt(null);
                hashMap.put(string, illegalArgumentException);
                hashMap2.put(illegalArgumentException, string);
            }
            catch (IllegalArgumentException illegalAccessException) {
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        if (hashMap.get("CONTEXT_MENU") == null) {
            hashMap.put("CONTEXT_MENU", 524);
            hashMap2.put(524, "CONTEXT_MENU");
            hashMap.put("WINDOWS", 525);
            hashMap2.put(525, "WINDOWS");
        }
        hashMap.put("MOUSE_WHEEL_UP", 656);
        hashMap.put("MOUSE_WHEEL_DOWN", 657);
        hashMap2.put(656, "MOUSE_WHEEL_UP");
        hashMap2.put(657, "MOUSE_WHEEL_DOWN");
        NamesAndValues namesAndValues = new NamesAndValues(hashMap2, hashMap);
        Utilities.namesAndValues = new SoftReference<NamesAndValues>(namesAndValues);
        return namesAndValues;
    }

    public static String keyToString(KeyStroke keyStroke) {
        StringBuilder stringBuilder = new StringBuilder();
        if (Utilities.addModifiers(stringBuilder, keyStroke.getModifiers())) {
            stringBuilder.append('-');
        }
        Utilities.appendRest(stringBuilder, keyStroke);
        return stringBuilder.toString();
    }

    private static void appendRest(StringBuilder stringBuilder, KeyStroke keyStroke) {
        String string = Utilities.initNameAndValues().keyToString.get(keyStroke.getKeyCode());
        if (string == null) {
            stringBuilder.append(keyStroke.getKeyChar());
        } else {
            stringBuilder.append(string);
        }
    }

    public static String keyToString(KeyStroke keyStroke, boolean bl) {
        if (bl) {
            StringBuilder stringBuilder = new StringBuilder();
            if (Utilities.addModifiersPortable(stringBuilder, keyStroke.getModifiers())) {
                stringBuilder.append('-');
            }
            Utilities.appendRest(stringBuilder, keyStroke);
            return stringBuilder.toString();
        }
        return Utilities.keyToString(keyStroke);
    }

    public static KeyStroke stringToKey(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string.toUpperCase(Locale.ENGLISH), "-", true);
        int n = 0;
        Map<String, Integer> map = Utilities.initNameAndValues().stringToKey;
        int n2 = -1;
        try {
            String string2;
            while (true) {
                if ((string2 = stringTokenizer.nextToken()).equals("-")) {
                    if (n2 == -1) continue;
                    n |= n2;
                    n2 = -1;
                    continue;
                }
                if (!stringTokenizer.hasMoreElements()) break;
                n2 = Utilities.readModifiers(string2);
            }
            Integer n3 = map.get(string2);
            boolean bl = (n & 0x8000) != 0;
            boolean bl2 = ((n &= 0xFFFF7FFF) & 0x10000) != 0;
            n &= 0xFFFEFFFF;
            if (n3 != null) {
                if (bl && Utilities.isMac() && !Utilities.usableKeyOnMac(n3, bl2 ? n | 2 : (n |= Utilities.getMenuShortcutKeyMask()))) {
                    n &= ~Utilities.getMenuShortcutKeyMask();
                    n = bl2 ? (n |= 8) : (n |= 2);
                }
                if (bl2) {
                    n = Utilities.getOperatingSystem() == 4096 ? (n |= 2) : (n |= 8);
                }
                return KeyStroke.getKeyStroke(n3, n);
            }
            return null;
        }
        catch (NoSuchElementException noSuchElementException) {
            return null;
        }
    }

    private static boolean usableKeyOnMac(int n, int n2) {
        boolean bl;
        if (n == 81) {
            return false;
        }
        boolean bl2 = (n2 & 4) != 0 || (n2 & 0x80) != 0;
        boolean bl3 = (n2 & 8) != 0 || (n2 & 0x200) != 0;
        boolean bl4 = bl = bl2 && (n2 & 0xFFFFFEFB) == 0;
        if (bl) {
            return n != 72 && n != 32 && n != 9;
        }
        if (n == 68 && bl2 && bl3) {
            return false;
        }
        return n != 32 || !bl2 || (n2 & 2) == 0;
    }

    private static int getMenuShortcutKeyMask() {
        try {
            if (!GraphicsEnvironment.isHeadless()) {
                return Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return 2;
    }

    public static KeyStroke[] stringToKeys(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string.toUpperCase(Locale.ENGLISH), " ");
        ArrayList<KeyStroke> arrayList = new ArrayList<KeyStroke>();
        while (stringTokenizer.hasMoreElements()) {
            string = stringTokenizer.nextToken();
            KeyStroke keyStroke = Utilities.stringToKey(string);
            if (keyStroke == null) {
                return null;
            }
            arrayList.add(keyStroke);
        }
        return arrayList.toArray(new KeyStroke[arrayList.size()]);
    }

    private static boolean addModifiers(StringBuilder stringBuilder, int n) {
        boolean bl = false;
        if ((n & 2) != 0) {
            stringBuilder.append("C");
            bl = true;
        }
        if ((n & 8) != 0) {
            stringBuilder.append("A");
            bl = true;
        }
        if ((n & 1) != 0) {
            stringBuilder.append("S");
            bl = true;
        }
        if ((n & 4) != 0) {
            stringBuilder.append("M");
            bl = true;
        }
        if ((n & 0x8000) != 0) {
            stringBuilder.append("D");
            bl = true;
        }
        if ((n & 0x10000) != 0) {
            stringBuilder.append("O");
            bl = true;
        }
        return bl;
    }

    private static boolean addModifiersPortable(StringBuilder stringBuilder, int n) {
        boolean bl = false;
        if ((n & 1) != 0) {
            stringBuilder.append('S');
            bl = true;
        }
        if (Utilities.isMac() && (n & 4) != 0 || !Utilities.isMac() && (n & 2) != 0) {
            stringBuilder.append('D');
            bl = true;
        }
        if (Utilities.isMac() && (n & 2) != 0 || !Utilities.isMac() && (n & 8) != 0) {
            stringBuilder.append('O');
            bl = true;
        }
        if (Utilities.isMac() && (n & 8) != 0) {
            stringBuilder.append('A');
            bl = true;
        }
        if (!Utilities.isMac() && (n & 4) != 0) {
            stringBuilder.append('M');
            bl = true;
        }
        return bl;
    }

    private static int readModifiers(String string) throws NoSuchElementException {
        int n = 0;
        block8: for (int i = 0; i < string.length(); ++i) {
            switch (string.charAt(i)) {
                case 'C': {
                    n |= 2;
                    continue block8;
                }
                case 'A': {
                    n |= 8;
                    continue block8;
                }
                case 'M': {
                    n |= 4;
                    continue block8;
                }
                case 'S': {
                    n |= 1;
                    continue block8;
                }
                case 'D': {
                    n |= 0x8000;
                    continue block8;
                }
                case 'O': {
                    n |= 0x10000;
                    continue block8;
                }
                default: {
                    throw new NoSuchElementException(string);
                }
            }
        }
        return n;
    }

    private static GraphicsConfiguration getCurrentGraphicsConfiguration() {
        Component component = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        if (component != null) {
            Window window = SwingUtilities.getWindowAncestor(component);
            if (window != null) {
                return window.getGraphicsConfiguration();
            }
            for (Frame frame : Frame.getFrames()) {
                if (!"NbMainWindow".equals(frame.getName())) continue;
                return frame.getGraphicsConfiguration();
            }
        }
        return GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
    }

    public static Rectangle getUsableScreenBounds() {
        return Utilities.getUsableScreenBounds(Utilities.getCurrentGraphicsConfiguration());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Rectangle getUsableScreenBounds(GraphicsConfiguration graphicsConfiguration) {
        if (graphicsConfiguration == null) {
            graphicsConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        }
        if (screenBoundsCache == null) {
            return Utilities.calculateUsableScreenBounds(graphicsConfiguration);
        }
        Map<GraphicsConfiguration, Map<Rectangle, Long>> map = screenBoundsCache;
        synchronized (map) {
            Map<Rectangle, Long> map2 = screenBoundsCache.get(graphicsConfiguration);
            if (map2 != null) {
                long l = System.currentTimeMillis();
                Map.Entry<Rectangle, Long> entry = map2.entrySet().iterator().next();
                if (entry.getValue() < l + 10000L) {
                    return new Rectangle(entry.getKey());
                }
            }
            Rectangle rectangle = Utilities.calculateUsableScreenBounds(graphicsConfiguration);
            map2 = new HashMap<Rectangle, Long>(1);
            map2.put(rectangle, System.currentTimeMillis());
            if (screenBoundsCache.size() > 20) {
                screenBoundsCache.clear();
            }
            screenBoundsCache.put(graphicsConfiguration, map2);
            return new Rectangle(rectangle);
        }
    }

    private static Rectangle calculateUsableScreenBounds(GraphicsConfiguration graphicsConfiguration) {
        Rectangle rectangle = new Rectangle(graphicsConfiguration.getBounds());
        String string = System.getProperty("netbeans.screen.insets");
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ", ");
            if (stringTokenizer.countTokens() == 4) {
                try {
                    rectangle.y = Integer.parseInt(stringTokenizer.nextToken());
                    rectangle.x = Integer.parseInt(stringTokenizer.nextToken());
                    rectangle.height -= rectangle.y + Integer.parseInt(stringTokenizer.nextToken());
                    rectangle.width -= rectangle.x + Integer.parseInt(stringTokenizer.nextToken());
                }
                catch (NumberFormatException numberFormatException) {
                    LOG.log(Level.WARNING, null, numberFormatException);
                }
            }
            return rectangle;
        }
        string = System.getProperty("netbeans.taskbar.height");
        if (string != null) {
            rectangle.height -= Integer.getInteger(string, 0).intValue();
            return rectangle;
        }
        try {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            Insets insets = toolkit.getScreenInsets(graphicsConfiguration);
            if (insets.left > rectangle.x && rectangle.x > 0) {
                insets.left -= rectangle.x;
            }
            if (insets.top > rectangle.y && rectangle.y > 0) {
                insets.top -= rectangle.y;
            }
            rectangle.y += insets.top;
            rectangle.x += insets.left;
            rectangle.height -= insets.top + insets.bottom;
            rectangle.width -= insets.left + insets.right;
        }
        catch (Exception exception) {
            LOG.log(Level.WARNING, null, exception);
        }
        if (rectangle.width <= 0 || rectangle.height <= 0) {
            rectangle = new Rectangle(graphicsConfiguration.getBounds());
        }
        return rectangle;
    }

    public static Rectangle findCenterBounds(Dimension dimension) {
        return Utilities.findCenterBounds(Utilities.getCurrentGraphicsConfiguration(), dimension);
    }

    private static Rectangle findCenterBounds(GraphicsConfiguration graphicsConfiguration, Dimension dimension) {
        if (graphicsConfiguration == null) {
            graphicsConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        }
        Rectangle rectangle = graphicsConfiguration.getBounds();
        return new Rectangle(rectangle.x + (rectangle.width - dimension.width) / 2, rectangle.y + (rectangle.height - dimension.height) / 2, dimension.width, dimension.height);
    }

    @Deprecated
    public static Dimension getScreenSize() {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        if (Utilities.isWindows() && !Boolean.getBoolean("netbeans.no.taskbar")) {
            dimension.height -= 27;
        } else if (Utilities.isMac()) {
            dimension.height -= 24;
        }
        return dimension;
    }

    @Deprecated
    public static int showJFileChooser(JFileChooser jFileChooser, Component component, String string) {
        if (string != null) {
            jFileChooser.setApproveButtonText(string);
            jFileChooser.setDialogType(2);
        }
        Frame frame = null;
        Dialog dialog = null;
        if (component instanceof Dialog) {
            dialog = (Dialog)component;
        } else {
            frame = component instanceof Frame ? (Frame)component : (Frame)SwingUtilities.getAncestorOfClass(Frame.class, component);
        }
        String string2 = jFileChooser.getDialogTitle();
        if (string2 == null) {
            string2 = jFileChooser.getUI().getDialogTitle(jFileChooser);
        }
        final JDialog jDialog = dialog != null ? new JDialog(dialog, string2, true) : new JDialog(frame, string2, true);
        jDialog.setDefaultCloseOperation(2);
        Container container = jDialog.getContentPane();
        container.setLayout(new BorderLayout());
        container.add((Component)jFileChooser, "Center");
        jDialog.pack();
        jDialog.setBounds(Utilities.findCenterBounds(component.getGraphicsConfiguration(), jDialog.getSize()));
        jFileChooser.rescanCurrentDirectory();
        final int[] nArray = new int[]{1};
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if ("ApproveSelection".equals(actionEvent.getActionCommand())) {
                    nArray[0] = 0;
                }
                jDialog.setVisible(false);
                jDialog.dispose();
            }
        };
        jFileChooser.addActionListener(actionListener);
        jDialog.show();
        return nArray[0];
    }

    @Deprecated
    public static List partialSort(List list, Comparator comparator, boolean bl) throws UnorderableException {
        Set<Iterator<Object>> set;
        Object object;
        Iterator<Object> iterator;
        int n;
        HashMap<Object, HashSet<Iterator<Object>>> hashMap = new HashMap<Object, HashSet<Iterator<Object>>>();
        int n2 = list.size();
        for (int i = 0; i < n2; ++i) {
            for (int j = i + 1; j < n2; ++j) {
                n = comparator.compare(list.get(i), list.get(j));
                if (n == 0) continue;
                iterator = list.get(n < 0 ? i : j);
                object = list.get(n > 0 ? i : j);
                set = (Set)hashMap.get(object);
                if (set == null) {
                    set = new HashSet<Iterator<Object>>();
                    hashMap.put(object, (HashSet<Iterator<Object>>)set);
                }
                set.add(iterator);
            }
        }
        LinkedList linkedList = new LinkedList(list);
        ArrayList<Object> arrayList = new ArrayList<Object>(n2);
        while (linkedList.size() > 0) {
            n = 0;
            iterator = linkedList.iterator();
            while (iterator.hasNext()) {
                object = iterator.next();
                set = (HashSet<Iterator<Object>>)hashMap.get(object);
                if (set != null && !set.isEmpty()) continue;
                iterator.remove();
                n = 1;
                arrayList.add(object);
                for (Object e : linkedList) {
                    Set set2 = (Set)hashMap.get(e);
                    if (set2 == null) continue;
                    set2.remove(object);
                }
                if (!bl) continue;
                break;
            }
            if (n != 0) continue;
            iterator = hashMap.entrySet().iterator();
            while (iterator.hasNext()) {
                object = (Map.Entry)iterator.next();
                if (!linkedList.contains(object.getKey())) {
                    iterator.remove();
                    continue;
                }
                set = (Set)object.getValue();
                Iterator iterator2 = set.iterator();
                while (iterator2.hasNext()) {
                    if (linkedList.contains(iterator2.next())) continue;
                    iterator2.remove();
                }
                if (!set.isEmpty()) continue;
                iterator.remove();
            }
            throw new UnorderableException(linkedList, hashMap);
        }
        return arrayList;
    }

    public static <T> List<T> topologicalSort(Collection<? extends T> collection, Map<? super T, ? extends Collection<? extends T>> map) throws TopologicalSortException {
        HashMap hashMap = new HashMap();
        ArrayList arrayList = new ArrayList(Math.max(collection.size(), 1));
        ArrayList<T> arrayList2 = new ArrayList<T>(collection);
        Collections.reverse(arrayList2);
        Iterator iterator = arrayList2.iterator();
        while (iterator.hasNext()) {
            List<? super T> list = Utilities.visit(iterator.next(), map, hashMap, arrayList);
            if (list == null) continue;
            throw new TopologicalSortException(arrayList2, map);
        }
        Collections.reverse(arrayList);
        if (arrayList.size() != collection.size()) {
            arrayList.retainAll(collection);
        }
        return arrayList;
    }

    static <T> List<T> visit(T t, Map<? super T, ? extends Collection<? extends T>> map, Map<T, Boolean> map2, List<T> list) {
        Boolean bl = map2.get(t);
        if (bl != null) {
            if (bl.booleanValue()) {
                return null;
            }
            ArrayList<T> arrayList = new ArrayList<T>();
            arrayList.add(t);
            map2.put(t, null);
            return arrayList;
        }
        Collection<T> collection = map.get(t);
        if (collection != null) {
            map2.put(t, Boolean.FALSE);
            Iterator<T> iterator = collection.iterator();
            while (iterator.hasNext()) {
                List<T> list2 = Utilities.visit(iterator.next(), map, map2, list);
                if (list2 == null) continue;
                if (list2 instanceof ArrayList) {
                    if (Boolean.FALSE == map2.get(t)) {
                        list2.add(t);
                    } else {
                        Collections.reverse(list2);
                        list2 = Collections.unmodifiableList(list2);
                    }
                }
                map2.put(t, Boolean.TRUE);
                return list2;
            }
        }
        map2.put(t, Boolean.TRUE);
        list.add(t);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String translate(String string) {
        RE rE;
        Utilities.checkMapping();
        Object object = TRANS_LOCK;
        synchronized (object) {
            rE = transExp;
        }
        if (rE == null) {
            return string;
        }
        object = rE;
        synchronized (object) {
            return rE.convert(string);
        }
    }

    private static void checkMapping() {
        if (transLoader == TRANS_LOCK) {
            return;
        }
        ClassLoader classLoader = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
        if (classLoader == null) {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        if (transLoader == classLoader) {
            return;
        }
        Utilities.initForLoader(classLoader, classLoader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void initForLoader(ClassLoader classLoader, Object object) {
        Object object2;
        String[] stringArray;
        Enumeration<URL> enumeration;
        if (object == null) {
            object = TRANS_LOCK;
        }
        try {
            enumeration = classLoader.getResources("META-INF/netbeans/translate.names");
        }
        catch (IOException iOException) {
            LOG.log(Level.WARNING, null, iOException);
            enumeration = null;
        }
        if (enumeration == null || !enumeration.hasMoreElements()) {
            Object object3 = TRANS_LOCK;
            synchronized (object3) {
                transLoader = object;
                transExp = null;
            }
            return;
        }
        RE13 rE13 = null;
        rE13 = new RE13();
        TreeSet<String[]> treeSet = new TreeSet<String[]>(new Comparator<String[]>(){

            @Override
            public int compare(String[] stringArray, String[] stringArray2) {
                int n;
                String string = stringArray[0];
                String string2 = stringArray2[0];
                int n2 = string.length();
                if (n2 != (n = string2.length())) {
                    return n - n2;
                }
                return string2.compareTo(string);
            }
        });
        while (enumeration.hasMoreElements()) {
            stringArray = enumeration.nextElement();
            try {
                object2 = new BufferedReader(new InputStreamReader(stringArray.openStream(), "UTF8"));
                Utilities.loadTranslationFile(rE13, (BufferedReader)object2, treeSet);
                ((BufferedReader)object2).close();
            }
            catch (IOException iOException) {
                LOG.log(Level.WARNING, "Problematic file: {0}", (Object)stringArray);
                LOG.log(Level.WARNING, null, iOException);
            }
        }
        stringArray = new String[treeSet.size()];
        object2 = new String[stringArray.length];
        int n = 0;
        for (String[] stringArray2 : treeSet) {
            stringArray[n] = stringArray2[1].intern();
            object2[n] = stringArray2[0];
            ++n;
        }
        Object object4 = TRANS_LOCK;
        synchronized (object4) {
            if (stringArray.length == 0) {
                transExp = null;
            } else {
                transExp = rE13;
                transExp.init((String[])object2, stringArray);
            }
            transLoader = object;
        }
    }

    private static void loadTranslationFile(RE rE, BufferedReader bufferedReader, Set<String[]> set) throws IOException {
        String string;
        while ((string = bufferedReader.readLine()) != null) {
            if (string.length() == 0 || string.startsWith("#")) continue;
            String[] stringArray = rE.readPair(string);
            if (stringArray == null) {
                throw new InvalidObjectException("Line is invalid: " + string);
            }
            set.add(stringArray);
        }
    }

    @Deprecated
    public static Image mergeImages(Image image, Image image2, int n, int n2) {
        return ImageUtilities.mergeImages(image, image2, n, n2);
    }

    @Deprecated
    public static Image loadImage(String string) {
        return ImageUtilities.loadImage(string);
    }

    @Deprecated
    public static Image icon2Image(Icon icon) {
        return ImageUtilities.icon2Image(icon);
    }

    /*
     * WARNING - void declaration
     */
    public static JPopupMenu actionsToPopup(Action[] actionArray, Lookup lookup) {
        HashSet<Action> hashSet = new HashSet<Action>();
        ArrayList<Component> arrayList = new ArrayList<Component>();
        for (Action action : actionArray) {
            if (action != null && hashSet.add(action)) {
                void var8_11;
                void object;
                if (action instanceof ContextAwareAction) {
                    Action action2 = ((ContextAwareAction)action).createContextAwareInstance(lookup);
                    if (action2 == null) {
                        Logger.getLogger(Utilities.class.getName()).log(Level.WARNING, "ContextAwareAction.createContextAwareInstance(context) returns null. That is illegal! action={0}, context={1}", new Object[]{action, lookup});
                    } else {
                        Action action3 = action2;
                    }
                }
                if (object instanceof Presenter.Popup) {
                    JMenuItem jMenuItem = ((Presenter.Popup)object).getPopupPresenter();
                    if (jMenuItem == null) {
                        Logger.getLogger(Utilities.class.getName()).log(Level.WARNING, "findContextMenuImpl, getPopupPresenter returning null for {0}", object);
                        continue;
                    }
                } else {
                    JMenuItem jMenuItem = ActionPresenterProvider.getDefault().createPopupPresenter((Action)object);
                }
                for (Component component : ActionPresenterProvider.getDefault().convertComponents((Component)var8_11)) {
                    if (component instanceof JSeparator) {
                        arrayList.add(null);
                        continue;
                    }
                    arrayList.add(component);
                }
                continue;
            }
            arrayList.add(null);
        }
        JPopupMenu jPopupMenu = ActionPresenterProvider.getDefault().createEmptyPopup();
        int n = 0;
        int n2 = 0;
        for (Component component : arrayList) {
            try {
                if (component == null) {
                    n2 = n;
                    continue;
                }
                n = 1;
                if (n2 != 0) {
                    n2 = 0;
                    jPopupMenu.addSeparator();
                }
                jPopupMenu.add(component);
            }
            catch (RuntimeException runtimeException) {
                Exceptions.attachMessage(runtimeException, "Current component: " + component);
                Exceptions.attachMessage(runtimeException, "List of components: " + arrayList);
                Exceptions.attachMessage(runtimeException, "List of actions: " + Arrays.asList(actionArray));
                Exceptions.printStackTrace(runtimeException);
            }
        }
        return jPopupMenu;
    }

    public static JPopupMenu actionsToPopup(Action[] actionArray, Component component) {
        Serializable serializable;
        Lookup lookup = null;
        for (serializable = component; !(serializable == null || serializable instanceof Lookup.Provider && (lookup = ((Lookup.Provider)serializable).getLookup()) != null); serializable = serializable.getParent()) {
        }
        if (lookup == null) {
            serializable = new UtilitiesCompositeActionMap(component);
            lookup = Lookups.singleton((Object)serializable);
        }
        return Utilities.actionsToPopup(actionArray, lookup);
    }

    public static List<? extends Action> actionsForPath(String string) {
        ArrayList<Action> arrayList = new ArrayList<Action>();
        for (Lookup.Item item : Lookups.forPath((String)string).lookupResult(Object.class).allItems()) {
            if (Action.class.isAssignableFrom(item.getType())) {
                Object object = item.getInstance();
                if (object == null) continue;
                arrayList.add((Action)object);
                continue;
            }
            if (JSeparator.class.isAssignableFrom(item.getType())) {
                arrayList.add(null);
                continue;
            }
            Logger.getLogger(Utilities.class.getName()).log(Level.WARNING, "Unrecognized object of {0} found in actions path {1}", new Object[]{item.getType(), string});
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Lookup actionsGlobalContext() {
        Object object = ContextGlobalProvider.class;
        synchronized (ContextGlobalProvider.class) {
            if (global != null) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return global;
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            object = (ContextGlobalProvider)Lookup.getDefault().lookup(ContextGlobalProvider.class);
            Lookup lookup = object == null ? Lookup.EMPTY : object.createGlobalContext();
            Class<ContextGlobalProvider> clazz = ContextGlobalProvider.class;
            synchronized (ContextGlobalProvider.class) {
                if (global == null) {
                    global = lookup;
                }
                // ** MonitorExit[var2_3] (shouldn't be in output)
                return global;
            }
        }
    }

    @Deprecated
    public static Image loadImage(String string, boolean bl) {
        return ImageUtilities.loadImage(string, bl);
    }

    public static Cursor createProgressCursor(Component component) {
        if (component == null) {
            throw new NullPointerException("Given component is null");
        }
        Image image = null;
        image = Utilities.isMac() ? ImageUtilities.loadImage("org/openide/util/progress-cursor-mac.gif") : (Utilities.isUnix() ? ImageUtilities.loadImage("org/openide/util/progress-cursor-motif.gif") : ImageUtilities.loadImage("org/openide/util/progress-cursor-win.gif"));
        return Utilities.createCustomCursor(component, image, "PROGRESS_CURSOR");
    }

    public static Cursor createCustomCursor(Component component, Image image, String string) {
        Toolkit toolkit = component.getToolkit();
        Dimension dimension = toolkit.getBestCursorSize(16, 16);
        Image image2 = image;
        if (dimension.width != image.getWidth(null)) {
            if (dimension.width == 0 && dimension.height == 0) {
                return Cursor.getPredefinedCursor(3);
            }
            BufferedImage bufferedImage = ImageUtilities.createBufferedImage(dimension.width, dimension.height);
            image2 = ImageUtilities.mergeImages(image, bufferedImage, 0, 0);
        }
        return toolkit.createCustomCursor(image2, new Point(1, 1), string);
    }

    public static void attachInitJob(Component component, AsyncGUIJob asyncGUIJob) {
        new AsyncInitSupport(component, asyncGUIJob);
    }

    public static URI toURI(File file) {
        String string;
        if (fileToPath != null) {
            try {
                URI uRI = (URI)pathToUri.invoke(fileToPath.invoke((Object)file, new Object[0]), new Object[0]);
                if (uRI.toString().startsWith("file:///")) {
                    uRI = new URI(uRI.getScheme(), uRI.getUserInfo(), uRI.getHost(), uRI.getPort(), uRI.getPath(), uRI.getQuery(), uRI.getFragment());
                }
                return uRI;
            }
            catch (Exception exception) {
                LOG.log(Level.FINE, "could not convert " + file + " to URI", exception);
            }
        }
        if ((string = file.getAbsolutePath()).startsWith("\\\\")) {
            if (!string.endsWith("\\") && file.isDirectory()) {
                string = string + "\\";
            }
            try {
                return new URI("file", null, string.replace('\\', '/'), null);
            }
            catch (URISyntaxException uRISyntaxException) {
                LOG.log(Level.FINE, "could not convert " + file + " to URI", uRISyntaxException);
            }
        }
        return file.toURI();
    }

    public static File toFile(URI uRI) throws IllegalArgumentException {
        String string;
        if (pathsGet != null) {
            try {
                return (File)pathToFile.invoke(pathsGet.invoke(null, uRI), new Object[0]);
            }
            catch (Exception exception) {
                LOG.log(Level.FINE, "could not convert " + uRI + " to File", exception);
            }
        }
        if ((string = uRI.getHost()) != null && !string.isEmpty() && "file".equals(uRI.getScheme())) {
            return new File("\\\\" + string + uRI.getPath().replace('/', '\\'));
        }
        return new File(uRI);
    }

    @Deprecated
    public static URL toURL(File file) throws MalformedURLException {
        if (file == null) {
            throw new NullPointerException();
        }
        if (!file.isAbsolute()) {
            throw new IllegalArgumentException("Relative path: " + file);
        }
        URI uRI = Utilities.toURI(file);
        return uRI.toURL();
    }

    @Deprecated
    public static File toFile(URL uRL) {
        if (uRL == null) {
            throw new NullPointerException();
        }
        try {
            URI uRI = uRL.toURI();
            return Utilities.toFile(uRI);
        }
        catch (URISyntaxException uRISyntaxException) {
            return null;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    static {
        TRANS_LOCK = new Object();
        boolean bl = !GraphicsEnvironment.isHeadless() && Utilities.isUnix() && !Utilities.isMac() && System.getProperty("netbeans.screen.insetsCache", "true").equalsIgnoreCase("true");
        screenBoundsCache = bl ? new WeakHashMap<GraphicsConfiguration, Map<Rectangle, Long>>() : null;
        try {
            fileToPath = File.class.getMethod("toPath", new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        if (fileToPath != null) {
            try {
                Class<?> clazz = Class.forName("java.nio.file.Path");
                pathToUri = clazz.getMethod("toUri", new Class[0]);
                pathsGet = Class.forName("java.nio.file.Paths").getMethod("get", URI.class);
                pathToFile = clazz.getMethod("toFile", new Class[0]);
            }
            catch (Exception exception) {
                throw new ExceptionInInitializerError(exception);
            }
        }
    }

    @Deprecated
    public static class UnorderableException
    extends RuntimeException {
        static final long serialVersionUID = 6749951134051806661L;
        private Collection unorderable;
        private Map deps;

        public UnorderableException(Collection collection, Map map) {
            this.unorderable = collection;
            this.deps = map;
        }

        public UnorderableException(String string, Collection collection, Map map) {
            super(string);
            this.unorderable = collection;
            this.deps = map;
        }

        public Collection getUnorderable() {
            return this.unorderable;
        }

        public Map getDeps() {
            return this.deps;
        }
    }

    static interface RE {
        public void init(String[] var1, String[] var2);

        public String convert(String var1);

        public String[] readPair(String var1);
    }

    private static final class NamesAndValues {
        final Map<Integer, String> keyToString;
        final Map<String, Integer> stringToKey;

        NamesAndValues(Map<Integer, String> map, Map<String, Integer> map2) {
            this.keyToString = map;
            this.stringToKey = map2;
        }
    }
}

