/*
 * Decompiled with CFR 0.152.
 */
package bluej.views;

import bluej.debugger.gentype.GenTypeDeclTpar;
import bluej.debugger.gentype.JavaType;
import bluej.utility.JavaUtils;
import bluej.views.CallableView;
import bluej.views.View;
import java.lang.reflect.Constructor;
import java.util.List;

public final class ConstructorView
extends CallableView {
    protected Constructor<?> cons;

    public ConstructorView(View view, Constructor<?> cons) {
        super(view);
        this.cons = cons;
    }

    @Override
    public String toString() {
        return this.cons.toString();
    }

    @Override
    public int getModifiers() {
        return this.cons.getModifiers();
    }

    @Override
    public boolean hasParameters() {
        return this.cons.getParameterTypes().length > 0;
    }

    @Override
    public boolean isGeneric() {
        return !JavaUtils.getJavaUtils().getTypeParams(this.cons).isEmpty();
    }

    @Override
    public boolean isConstructor() {
        return true;
    }

    @Override
    public String getSignature() {
        return JavaUtils.getSignature(this.cons);
    }

    @Override
    public String getShortDesc() {
        try {
            return JavaUtils.getJavaUtils().getShortDesc(this.cons, this.getParamNames());
        }
        catch (ClassNotFoundException cnfe) {
            return "";
        }
    }

    @Override
    public String getLongDesc() {
        try {
            return JavaUtils.getJavaUtils().getLongDesc(this.cons, this.getParamNames());
        }
        catch (ClassNotFoundException cnfe) {
            return "";
        }
    }

    @Override
    public Class<?>[] getParameters() {
        return this.cons.getParameterTypes();
    }

    @Override
    public String[] getParamTypeStrings() {
        try {
            return JavaUtils.getJavaUtils().getParameterTypes(this.cons);
        }
        catch (ClassNotFoundException cnfe) {
            return new String[0];
        }
    }

    @Override
    public JavaType[] getParamTypes(boolean raw) {
        try {
            return JavaUtils.getJavaUtils().getParamGenTypes(this.cons);
        }
        catch (ClassNotFoundException cnfe) {
            return new JavaType[0];
        }
    }

    @Override
    public GenTypeDeclTpar[] getTypeParams() {
        JavaUtils jutils = JavaUtils.getJavaUtils();
        List<GenTypeDeclTpar> tparams = jutils.getTypeParams(this.cons);
        return tparams.toArray(new GenTypeDeclTpar[tparams.size()]);
    }

    @Override
    public boolean isVarArgs() {
        return JavaUtils.getJavaUtils().isVarArgs(this.cons);
    }
}

