/*
 * Decompiled with CFR 0.152.
 */
package bluej.pkgmgr.target;

import bluej.Config;
import bluej.graph.GraphEditor;
import bluej.pkgmgr.Package;
import bluej.pkgmgr.target.PackageTarget;
import bluej.pkgmgr.target.Target;
import bluej.prefmgr.PrefMgr;
import bluej.utility.JavaNames;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.Properties;
import javax.swing.AbstractAction;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class ParentPackageTarget
extends PackageTarget {
    static final String openStr = Config.getString("pkgmgr.parentpackagetarget.open");
    static final String openUnamedStr = Config.getString("pkgmgr.parentpackagetarget.openunamed");

    public ParentPackageTarget(Package pkg) {
        super(pkg, "<go up>");
    }

    @Override
    public void load(Properties props, String prefix) {
    }

    @Override
    public void save(Properties props, String prefix) {
    }

    @Override
    public void deleteFiles() {
    }

    public boolean copyFiles(String directory) {
        return true;
    }

    @Override
    public boolean isResizable() {
        return false;
    }

    @Override
    public boolean isMoveable() {
        return false;
    }

    @Override
    public boolean isSaveable() {
        return false;
    }

    @Override
    public void doubleClick(MouseEvent evt) {
        this.getPackage().getEditor().raiseOpenPackageEvent(this, JavaNames.getPrefix(this.getPackage().getQualifiedName()));
    }

    @Override
    public void popupMenu(int x, int y, GraphEditor graphEditor) {
        JPopupMenu menu = this.createMenu(null);
        if (menu != null) {
            menu.show(graphEditor, x, y);
        }
    }

    private JPopupMenu createMenu(Class<?> cl) {
        JPopupMenu menu = new JPopupMenu(this.getBaseName());
        String item = JavaNames.getPrefix(this.getPackage().getQualifiedName());
        while (!item.equals("")) {
            this.addMenuItem(menu, openStr + " " + item, item);
            item = JavaNames.getPrefix(item);
        }
        this.addMenuItem(menu, openUnamedStr, "");
        return menu;
    }

    private void addMenuItem(JPopupMenu menu, String itemString, String pkgName) {
        OpenAction openAction = new OpenAction(itemString, this, pkgName);
        JMenuItem item = menu.add(openAction);
        item.setFont(PrefMgr.getPopupMenuFont());
        item.setForeground(envOpColour);
    }

    @Override
    public void remove() {
    }

    private class OpenAction
    extends AbstractAction {
        private Target t;
        private String pkgName;

        public OpenAction(String menu, Target t, String pkgName) {
            super(menu);
            this.t = t;
            this.pkgName = pkgName;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ParentPackageTarget.this.getPackage().getEditor().raiseOpenPackageEvent(this.t, this.pkgName);
        }
    }
}

