/*
 * Decompiled with CFR 0.152.
 */
package bluej.parser.nodes;

import bluej.parser.lexer.LocatableToken;
import bluej.parser.nodes.FieldNode;
import bluej.parser.nodes.IncrementalParsingNode;
import bluej.parser.nodes.JavaParentNode;
import bluej.parser.nodes.MethodNode;
import bluej.parser.nodes.NodeStructureListener;
import bluej.parser.nodes.NodeTree;
import bluej.parser.nodes.ParseParams;
import bluej.parser.nodes.ParsedNode;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class TypeInnerNode
extends IncrementalParsingNode {
    private Map<String, Set<MethodNode>> methods = new HashMap<String, Set<MethodNode>>();

    public TypeInnerNode(JavaParentNode parent) {
        super(parent);
    }

    @Override
    public boolean isInner() {
        return true;
    }

    public void methodAdded(MethodNode method) {
        String name = method.getName();
        Set<MethodNode> methodSet = this.methods.get(name);
        if (methodSet == null) {
            methodSet = new HashSet<MethodNode>();
            this.methods.put(name, methodSet);
        }
        methodSet.add(method);
    }

    @Override
    public void childChangedName(ParsedNode child, String oldName) {
        super.childChangedName(child, oldName);
        if (child.getNodeType() == 2) {
            Set<MethodNode> methodSet = this.methods.get(oldName);
            methodSet.remove(child);
            this.methodAdded((MethodNode)child);
        }
    }

    @Override
    protected void childRemoved(NodeTree.NodeAndPosition<ParsedNode> child, NodeStructureListener listener) {
        super.childRemoved(child, listener);
        if (child.getNode().getNodeType() == 2) {
            Set<MethodNode> methodSet = this.methods.get(child.getNode().getName());
            methodSet.remove(child.getNode());
        }
    }

    public Map<String, FieldNode> getFields() {
        return this.variables;
    }

    public Map<String, Set<MethodNode>> getMethods() {
        return this.methods;
    }

    @Override
    protected int doPartialParse(ParseParams params, int state) {
        this.last = null;
        LocatableToken nextToken = params.tokenStream.nextToken();
        if (nextToken.getType() == 100) {
            this.last = nextToken;
            return 2;
        }
        if (nextToken.getType() == 1) {
            this.last = nextToken;
            return 1;
        }
        if (this.checkBoundary(params, nextToken)) {
            this.last = nextToken;
            return 8;
        }
        params.parser.parseClassElement(nextToken);
        this.complete = false;
        return 0;
    }

    @Override
    protected boolean isDelimitingNode(NodeTree.NodeAndPosition<ParsedNode> nap) {
        return nap.getNode().isContainer();
    }

    @Override
    protected boolean marksOwnEnd() {
        return false;
    }

    @Override
    public boolean growsForward() {
        return true;
    }
}

