/*
 * Decompiled with CFR 0.152.
 */
package bluej.parser.nodes;

import bluej.debugger.gentype.GenTypeClass;
import bluej.debugger.gentype.GenTypeSolid;
import bluej.parser.CodeSuggestions;
import bluej.parser.CompletionParser;
import bluej.parser.DocumentReader;
import bluej.parser.entity.EntityResolver;
import bluej.parser.entity.JavaEntity;
import bluej.parser.nodes.JavaParentNode;
import bluej.parser.nodes.NodeTree;
import bluej.parser.nodes.ParsedNode;
import javax.swing.text.Document;
import javax.swing.text.Element;

public class ExpressionNode
extends JavaParentNode {
    public ExpressionNode(JavaParentNode parent) {
        super(parent);
    }

    @Override
    public int getNodeType() {
        return 6;
    }

    @Override
    protected boolean marksOwnEnd() {
        return false;
    }

    @Override
    protected CodeSuggestions getExpressionType(int pos, int nodePos, JavaEntity defaultType, Document document) {
        this.valueEntityCache.clear();
        this.pocEntityCache.clear();
        NodeTree.NodeAndPosition<ParsedNode> nap = this.findNodeAt(pos, nodePos);
        if (nap != null && nap.getNode().getNodeType() == 1) {
            return nap.getNode().getExpressionType(pos, nap.getPosition(), defaultType, document);
        }
        return ExpressionNode.suggestAsExpression(pos, nodePos, this, defaultType, document);
    }

    public static CodeSuggestions suggestAsExpression(int pos, int nodePos, EntityResolver resolver, JavaEntity defaultType, Document document) {
        GenTypeClass atype;
        DocumentReader r = new DocumentReader(document, nodePos, pos);
        Element map = document.getDefaultRootElement();
        int line = map.getElementIndex(nodePos) + 1;
        int col = nodePos - map.getElement(line - 1).getStartOffset() + 1;
        CompletionParser parser = new CompletionParser(resolver, r, defaultType, line, col, nodePos);
        parser.parseExpression();
        GenTypeSolid stype = parser.getSuggestionType();
        GenTypeClass genTypeClass = atype = defaultType != null ? defaultType.getType().asClass() : null;
        if (stype != null) {
            return new CodeSuggestions(stype, atype, parser.getSuggestionToken(), parser.isSuggestionStatic());
        }
        return null;
    }
}

