/*
 * Decompiled with CFR 0.152.
 */
package bluej.parser.lexer;

import bluej.parser.JavaParser;
import bluej.parser.TokenStream;
import bluej.parser.lexer.LocatableToken;
import java.util.LinkedList;
import java.util.List;

public final class JavaTokenFilter
implements TokenStream {
    private TokenStream sourceStream;
    private LocatableToken lastComment;
    private LocatableToken cachedToken;
    private List<LocatableToken> buffer = new LinkedList<LocatableToken>();
    private JavaParser parser;

    public JavaTokenFilter(TokenStream source) {
        this.sourceStream = source;
        this.lastComment = null;
    }

    public JavaTokenFilter(TokenStream source, JavaParser parser) {
        this(source);
        this.parser = parser;
    }

    @Override
    public LocatableToken nextToken() {
        if (!this.buffer.isEmpty()) {
            if (this.cachedToken == null) {
                this.cachedToken = this.nextToken2();
            }
            return this.buffer.remove(this.buffer.size() - 1);
        }
        LocatableToken rval = this.cachedToken == null ? this.nextToken2() : this.cachedToken;
        this.cachedToken = this.nextToken2();
        return rval;
    }

    public void pushBack(LocatableToken token) {
        this.buffer.add(token);
    }

    public LocatableToken LA(int distance) {
        if (this.cachedToken != null) {
            this.buffer.add(0, this.cachedToken);
            this.cachedToken = null;
        }
        for (int numToAdd = distance - this.buffer.size(); numToAdd > 0; --numToAdd) {
            this.buffer.add(0, this.nextToken2());
        }
        return this.buffer.get(this.buffer.size() - distance);
    }

    private LocatableToken nextToken2() {
        LocatableToken t;
        block2: {
            t = null;
            while (true) {
                int ttype;
                if ((ttype = (t = this.sourceStream.nextToken()).getType()) == 61) {
                    this.lastComment = t;
                    if (this.parser == null) continue;
                    this.parser.gotComment(t);
                    continue;
                }
                if (ttype != 166) break;
                if (this.parser == null) continue;
                this.parser.gotComment(t);
            }
            if (this.lastComment == null) break block2;
            t.setHiddenBefore(this.lastComment);
            this.lastComment = null;
        }
        return t;
    }
}

