/*
 * Decompiled with CFR 0.152.
 */
package bluej.parser;

import bluej.debugger.gentype.GenTypeArrayClass;
import bluej.debugger.gentype.GenTypeClass;
import bluej.debugger.gentype.GenTypeParameter;
import bluej.debugger.gentype.JavaPrimitiveType;
import bluej.debugger.gentype.JavaType;
import bluej.debugger.gentype.MethodReflective;
import bluej.debugger.gentype.Reflective;
import bluej.parser.AssistContent;
import bluej.parser.CodeSuggestions;
import bluej.parser.JavaParser;
import bluej.parser.MethodCompletion;
import bluej.parser.entity.EntityResolver;
import bluej.parser.entity.ImportedEntity;
import bluej.parser.entity.JavaEntity;
import bluej.parser.entity.ParsedArrayReflective;
import bluej.parser.entity.SolidTargEntity;
import bluej.parser.entity.TypeArgumentEntity;
import bluej.parser.entity.TypeEntity;
import bluej.parser.entity.UnboundedWildcardEntity;
import bluej.parser.entity.UnresolvedArray;
import bluej.parser.entity.UnresolvedEntity;
import bluej.parser.entity.WildcardExtendsEntity;
import bluej.parser.entity.WildcardSuperEntity;
import bluej.parser.lexer.LocatableToken;
import bluej.pkgmgr.JavadocResolver;
import bluej.utility.JavaReflective;
import bluej.utility.JavaUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;

public class ParseUtils {
    public static AssistContent[] getPossibleCompletions(CodeSuggestions suggests, JavadocResolver javadocResolver) {
        GenTypeClass exprType = ParseUtils.initGetPossibleCompletions(suggests);
        if (exprType != null) {
            List<AssistContent> completions = ParseUtils.processQueue(exprType, suggests, javadocResolver);
            return completions.toArray(new AssistContent[completions.size()]);
        }
        return null;
    }

    public static GenTypeClass initGetPossibleCompletions(CodeSuggestions suggests) {
        if (suggests != null) {
            GenTypeClass exprType = suggests.getSuggestionType().asClass();
            if (exprType == null) {
                final JavaType arrayComponent = suggests.getSuggestionType().getArrayComponent();
                if (arrayComponent != null && arrayComponent.isPrimitive()) {
                    exprType = new GenTypeArrayClass((Reflective)new ParsedArrayReflective(new JavaReflective(Object.class), "Object"){

                        @Override
                        public String getSimpleName() {
                            return arrayComponent.toString() + "[]";
                        }
                    }, arrayComponent);
                } else {
                    return null;
                }
            }
            return exprType;
        }
        return null;
    }

    protected static List<AssistContent> processQueue(GenTypeClass exprType, CodeSuggestions suggests, JavadocResolver javadocResolver) {
        GenTypeClass accessType = suggests.getAccessType();
        Reflective accessReflective = accessType != null ? accessType.getReflective() : null;
        HashSet<String> contentSigs = new HashSet<String>();
        HashSet<String> typesDone = new HashSet<String>();
        ArrayList<AssistContent> completions = new ArrayList<AssistContent>();
        LinkedList<GenTypeParameter> typeQueue = new LinkedList<GenTypeParameter>();
        typeQueue.add(exprType);
        GenTypeClass origExprType = exprType;
        while (!typeQueue.isEmpty()) {
            exprType = (GenTypeClass)typeQueue.removeFirst();
            if (!typesDone.add(exprType.getReflective().getName())) continue;
            Map<String, Set<MethodReflective>> methods = exprType.getReflective().getDeclaredMethods();
            Map<String, GenTypeParameter> typeArgs = exprType.getMap();
            for (String name : methods.keySet()) {
                Set<MethodReflective> mset = methods.get(name);
                for (MethodReflective method : mset) {
                    if (accessReflective != null && !JavaUtils.checkMemberAccess(method.getDeclaringType(), origExprType, suggests.getAccessType().getReflective(), method.getModifiers(), suggests.isStatic())) continue;
                    ParseUtils.discoverElement(javadocResolver, contentSigs, completions, typeArgs, method);
                    for (GenTypeClass stype : exprType.getReflective().getSuperTypes()) {
                        if (typeArgs != null) {
                            typeQueue.add(stype.mapTparsToTypes(typeArgs));
                            continue;
                        }
                        typeQueue.add(stype.getErasedType());
                    }
                    Reflective outer = exprType.getReflective().getOuterClass();
                    if (outer == null) continue;
                    typeQueue.add(new GenTypeClass(outer));
                }
            }
        }
        return completions;
    }

    public static AssistContent discoverElement(JavadocResolver javadocResolver, Set<String> contentSigs, List<AssistContent> completions, Map<String, GenTypeParameter> typeArgs, MethodReflective method) {
        MethodCompletion result = null;
        MethodCompletion completion = null;
        completion = new MethodCompletion(method, typeArgs, javadocResolver);
        String sig = completion.getDisplayName();
        if (contentSigs.add(sig)) {
            completions.add(completion);
            result = completion;
        }
        return result;
    }

    public static JavaEntity getImportEntity(EntityResolver resolver, Reflective querySource, List<LocatableToken> tokens) {
        if (tokens.isEmpty()) {
            return null;
        }
        Iterator<LocatableToken> i = tokens.iterator();
        LocatableToken tok = i.next();
        if (tok.getType() != 69) {
            return null;
        }
        LinkedList<String> names = new LinkedList<String>();
        names.add(tok.getText());
        while (i.hasNext()) {
            tok = i.next();
            if (tok.getType() != 68 || !i.hasNext()) {
                return null;
            }
            tok = i.next();
            if (tok.getType() != 69) {
                return null;
            }
            names.add(tok.getText());
        }
        return new ImportedEntity(resolver, names, querySource);
    }

    public static JavaEntity getTypeEntity(EntityResolver resolver, Reflective querySource, List<LocatableToken> tokens) {
        DepthRef dr = new DepthRef();
        return ParseUtils.getTypeEntity(resolver, querySource, tokens.listIterator(), dr);
    }

    private static JavaEntity getTypeEntity(EntityResolver resolver, Reflective querySource, ListIterator<LocatableToken> i, DepthRef depthRef) {
        JavaEntity poc;
        LocatableToken token = i.next();
        if (JavaParser.isPrimitiveType(token)) {
            JavaType type = null;
            switch (token.getType()) {
                case 83: {
                    type = JavaPrimitiveType.getInt();
                    break;
                }
                case 82: {
                    type = JavaPrimitiveType.getShort();
                    break;
                }
                case 85: {
                    type = JavaPrimitiveType.getLong();
                    break;
                }
                case 81: {
                    type = JavaPrimitiveType.getChar();
                    break;
                }
                case 80: {
                    type = JavaPrimitiveType.getByte();
                    break;
                }
                case 79: {
                    type = JavaPrimitiveType.getBoolean();
                    break;
                }
                case 86: {
                    type = JavaPrimitiveType.getDouble();
                    break;
                }
                case 84: {
                    type = JavaPrimitiveType.getFloat();
                    break;
                }
                case 78: {
                    type = JavaPrimitiveType.getVoid();
                }
            }
            while (i.hasNext()) {
                token = i.next();
                if (token.getType() == 66) {
                    type = ((JavaType)type).getArray();
                    i.next();
                    continue;
                }
                return null;
            }
            return new TypeEntity(type);
        }
        String text = token.getText();
        for (poc = UnresolvedEntity.getEntity(resolver, text, querySource); poc != null && i.hasNext(); poc = poc.getSubentity(token.getText(), querySource)) {
            token = i.next();
            if (token.getType() == 73) {
                if ((poc = ParseUtils.processTypeArgs(resolver, querySource, poc, i, depthRef)) == null) {
                    return null;
                }
                if (!i.hasNext()) {
                    return poc;
                }
                token = i.next();
            }
            if (token.getType() != 68) {
                while (token.getType() == 66) {
                    poc = new UnresolvedArray(poc);
                    if (i.hasNext()) {
                        token = i.next();
                    }
                    if (!i.hasNext()) {
                        return poc;
                    }
                    token = i.next();
                }
                i.previous();
                return poc;
            }
            token = i.next();
            if (token.getType() != 69) break;
        }
        return poc;
    }

    private static JavaEntity processTypeArgs(EntityResolver resolver, Reflective querySource, JavaEntity base, ListIterator<LocatableToken> i, DepthRef depthRef) {
        int startDepth = depthRef.depth++;
        LinkedList<TypeArgumentEntity> taList = new LinkedList<TypeArgumentEntity>();
        block4: while (i.hasNext() && depthRef.depth > startDepth) {
            LocatableToken token = i.next();
            if (token.getType() == 70) {
                if (!i.hasNext()) {
                    return null;
                }
                token = i.next();
                if (token.getType() == 72) {
                    JavaEntity taEnt = ParseUtils.getTypeEntity(resolver, querySource, i, depthRef);
                    if (taEnt == null) {
                        return null;
                    }
                    taList.add(new WildcardSuperEntity(taEnt));
                } else if (token.getType() == 71) {
                    JavaEntity taEnt = ParseUtils.getTypeEntity(resolver, querySource, i, depthRef);
                    if (taEnt == null) {
                        return null;
                    }
                    taList.add(new WildcardExtendsEntity(taEnt));
                } else {
                    taList.add(new UnboundedWildcardEntity(resolver));
                    i.previous();
                }
            } else {
                i.previous();
                JavaEntity taEnt = ParseUtils.getTypeEntity(resolver, querySource, i, depthRef);
                if (taEnt == null) {
                    return null;
                }
                taList.add(new SolidTargEntity(taEnt));
            }
            if (depthRef.depth <= startDepth) break;
            if (!i.hasNext()) {
                return null;
            }
            token = i.next();
            int ttype = token.getType();
            while (ttype == 75 || ttype == 76 || ttype == 77) {
                switch (ttype) {
                    case 77: {
                        --depthRef.depth;
                    }
                    case 76: {
                        --depthRef.depth;
                    }
                }
                --depthRef.depth;
                if (!i.hasNext()) break block4;
                token = i.next();
                ttype = token.getType();
            }
            if (ttype == 74) continue;
            i.previous();
            break;
        }
        return base.setTypeArgs(taList);
    }

    private static class DepthRef {
        int depth = 0;

        private DepthRef() {
        }
    }
}

