/*
 * Decompiled with CFR 0.152.
 */
package bluej.parser;

import bluej.Config;
import bluej.debugger.gentype.GenTypeClass;
import bluej.debugger.gentype.Reflective;
import bluej.parser.entity.JavaEntity;
import bluej.parser.entity.PackageOrClass;
import bluej.parser.entity.TypeEntity;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ImportsCollection {
    private Map<String, JavaEntity> normalImports = new HashMap<String, JavaEntity>();
    private List<JavaEntity> wildcardImports = new ArrayList<JavaEntity>();
    private List<JavaEntity> staticWildcardImports = new ArrayList<JavaEntity>();
    private Map<String, List<JavaEntity>> staticImports = new HashMap<String, List<JavaEntity>>();

    public void clear() {
        this.normalImports.clear();
        this.wildcardImports.clear();
    }

    public void addNormalImport(String name, JavaEntity importEntity) {
        this.normalImports.put(name, importEntity);
    }

    public void addWildcardImport(JavaEntity importEntity) {
        this.wildcardImports.add(importEntity);
    }

    public void addStaticImport(String name, JavaEntity importEntity) {
        List<JavaEntity> l = this.staticImports.get(name);
        if (l == null) {
            l = new ArrayList<JavaEntity>();
            this.staticImports.put(name, l);
        }
        l.add(importEntity);
    }

    public void addStaticWildcardImport(TypeEntity importEntity) {
        this.staticWildcardImports.add(importEntity);
    }

    public TypeEntity getTypeImport(String name) {
        JavaEntity r = this.normalImports.get(name);
        if (r != null) {
            return r.resolveAsType();
        }
        List<JavaEntity> l = this.staticImports.get(name);
        if (l != null) {
            Iterator<JavaEntity> i = l.iterator();
            while (i.hasNext()) {
                TypeEntity rt = i.next().resolveAsType();
                if (rt == null || (rt = rt.getPackageOrClassMember(name)) == null) continue;
                return rt;
            }
        }
        return null;
    }

    public List<JavaEntity> getStaticImports(String name) {
        List<JavaEntity> l = this.staticImports.get(name);
        if (l == null) {
            l = Collections.emptyList();
        }
        return l;
    }

    public List<JavaEntity> getStaticWildcardImports() {
        return this.staticWildcardImports;
    }

    public TypeEntity getTypeImportWC(String name) {
        PackageOrClass importEntity;
        for (JavaEntity entity : this.wildcardImports) {
            TypeEntity clMember;
            PackageOrClass member;
            importEntity = entity.resolveAsPackageOrClass();
            if (importEntity == null || (member = importEntity.getPackageOrClassMember(name)) == null || (clMember = member.resolveAsType()) == null) continue;
            return clMember;
        }
        Iterator<JavaEntity> j = this.staticWildcardImports.iterator();
        while (j.hasNext()) {
            GenTypeClass clType;
            importEntity = j.next().resolveAsType();
            if (importEntity == null || (clType = ((TypeEntity)importEntity).getClassType()) == null) continue;
            List<Reflective> inners = clType.getReflective().getInners();
            for (Reflective inner : inners) {
                String innerName = inner.getName();
                if (!name.equals(innerName = innerName.substring(innerName.lastIndexOf(36)))) continue;
                return new TypeEntity(new GenTypeClass(inner));
            }
        }
        return null;
    }

    public String toString() {
        String rr = "";
        for (JavaEntity importEntity : this.normalImports.values()) {
            rr = rr + "import ";
            rr = rr + importEntity.getName() + ";" + Config.nl;
        }
        Iterator<JavaEntity> i = this.wildcardImports.iterator();
        while (i.hasNext()) {
            JavaEntity importEntity;
            importEntity = (PackageOrClass)i.next();
            rr = rr + "import ";
            rr = rr + importEntity.getName() + ".*;" + Config.nl;
        }
        for (String importName : this.staticImports.keySet()) {
            List<JavaEntity> l = this.staticImports.get(importName);
            Iterator<JavaEntity> j = l.iterator();
            while (j.hasNext()) {
                TypeEntity importEntity = j.next().resolveAsType();
                if (importEntity == null) continue;
                rr = rr + "import static " + importEntity.getName();
                rr = rr + "." + importName + ";" + Config.nl;
            }
        }
        Iterator<JavaEntity> iii = this.staticWildcardImports.iterator();
        while (i.hasNext()) {
            JavaEntity importEntity = iii.next();
            rr = rr + "import static " + importEntity.getName();
            rr = rr + ".*;" + Config.nl;
        }
        return rr;
    }
}

