/*
 * Decompiled with CFR 0.152.
 */
package bluej.groupwork.cvsnb;

import bluej.groupwork.HistoryInfo;
import bluej.groupwork.LogHistoryListener;
import bluej.groupwork.Revision;
import bluej.groupwork.cvsnb.BasicServerResponse;
import bluej.groupwork.cvsnb.BlueJCvsClient;
import bluej.groupwork.cvsnb.CvsCommand;
import bluej.groupwork.cvsnb.CvsRepository;
import bluej.groupwork.cvsnb.LogServerResponse;
import bluej.utility.FileUtility;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.netbeans.lib.cvsclient.command.CommandAbortedException;
import org.netbeans.lib.cvsclient.command.CommandException;
import org.netbeans.lib.cvsclient.command.log.LogInformation;
import org.netbeans.lib.cvsclient.connection.AuthenticationException;

public class CvsLogCommand
extends CvsCommand {
    private LogHistoryListener listener;

    public CvsLogCommand(CvsRepository repository, LogHistoryListener listener) {
        super(repository);
        this.listener = listener;
    }

    @Override
    protected BasicServerResponse doCommand() throws CommandAbortedException, CommandException, AuthenticationException {
        BlueJCvsClient client = this.getClient();
        LogServerResponse response = this.repository.doGetLogHistory(client);
        if (!response.isError()) {
            HashMap<Revision, ArrayList<String>> commits = new HashMap<Revision, ArrayList<String>>();
            List<LogInformation> infoList = response.getInfoList();
            for (LogInformation logInformation : infoList) {
                List cvsRevisionList = logInformation.getRevisionList();
                for (LogInformation.Revision cvsRev : cvsRevisionList) {
                    Revision rev = new Revision(cvsRev.getAuthor(), cvsRev.getDateString(), cvsRev.getMessage());
                    ArrayList<String> files = (ArrayList<String>)commits.get(rev);
                    if (files == null) {
                        files = new ArrayList<String>();
                    }
                    files.add(FileUtility.makeRelativePath(this.repository.getProjectPath(), logInformation.getFile()));
                    commits.put(rev, files);
                }
            }
            for (Map.Entry entry : commits.entrySet()) {
                Revision rev = (Revision)entry.getKey();
                List filesList = (List)entry.getValue();
                String[] files = filesList.toArray(new String[filesList.size()]);
                HistoryInfo hinfo = new HistoryInfo(files, "", rev.getDateString(), rev.getAuthor(), rev.getMessage());
                this.listener.logInfoAvailable(hinfo);
            }
        }
        return response;
    }
}

