/*
 * Decompiled with CFR 0.152.
 */
package bluej.groupwork.actions;

import bluej.Config;
import bluej.groupwork.Repository;
import bluej.groupwork.TeamSettingsController;
import bluej.groupwork.TeamUtils;
import bluej.groupwork.TeamworkCommand;
import bluej.groupwork.TeamworkCommandResult;
import bluej.groupwork.actions.TeamAction;
import bluej.groupwork.ui.ModuleSelectDialog;
import bluej.groupwork.ui.TeamSettingsDialog;
import bluej.pkgmgr.Import;
import bluej.pkgmgr.Package;
import bluej.pkgmgr.PkgMgrFrame;
import bluej.pkgmgr.Project;
import bluej.utility.Debug;
import bluej.utility.DialogManager;
import bluej.utility.FileUtility;
import bluej.utility.SwingWorker;
import java.awt.Frame;
import java.io.File;

public class CheckoutAction
extends TeamAction {
    private static CheckoutAction instance = null;

    public CheckoutAction() {
        super("team.checkout");
    }

    public static CheckoutAction getInstance() {
        if (instance == null) {
            instance = new CheckoutAction();
        }
        return instance;
    }

    @Override
    public void actionPerformed(PkgMgrFrame oldFrame) {
        TeamSettingsController tsc = new TeamSettingsController(new File(".").getAbsoluteFile());
        TeamSettingsDialog tsd = tsc.getTeamSettingsDialog();
        tsd.setLocationRelativeTo(oldFrame);
        if (tsd.doTeamSettings() == 0) {
            File parentDir;
            ModuleSelectDialog moduleDialog = new ModuleSelectDialog((Frame)oldFrame, tsc.getRepository(true));
            moduleDialog.setLocationRelativeTo(oldFrame);
            moduleDialog.setVisible(true);
            String moduleName = moduleDialog.getModuleName();
            if (moduleName != null && (parentDir = FileUtility.getDirName(oldFrame, Config.getString("team.checkout.filechooser.title"), Config.getString("team.checkout.filechooser.button"), true, true)) != null) {
                PkgMgrFrame newFrame;
                if (Package.isPackage(parentDir)) {
                    Debug.message("Attempted to checkout a project into an existing project: " + parentDir);
                    DialogManager.showError(null, "team-cannot-import-into-existing-project");
                    return;
                }
                File projectDir = new File(parentDir, moduleName);
                if (projectDir.exists()) {
                    DialogManager.showError(null, "directory-exists");
                    return;
                }
                if (oldFrame.isEmptyFrame()) {
                    newFrame = oldFrame;
                } else {
                    newFrame = PkgMgrFrame.createFrame();
                    if (Config.isJava15()) {
                        newFrame.setLocationByPlatform(true);
                    }
                    newFrame.setVisible(true);
                    newFrame.setEnabled(false);
                }
                new CheckoutWorker(newFrame, tsc.getRepository(true), projectDir, tsc).start();
            }
        }
    }

    private class CheckoutWorker
    extends SwingWorker {
        private Repository repository;
        private PkgMgrFrame newFrame;
        private File projDir;
        private TeamSettingsController tsc;
        private TeamworkCommandResult response;
        private boolean failed = true;

        public CheckoutWorker(PkgMgrFrame newFrame, Repository repository, File projDir, TeamSettingsController tsc) {
            this.newFrame = newFrame;
            this.repository = repository;
            this.projDir = projDir;
            this.tsc = tsc;
        }

        @Override
        public Object construct() {
            this.newFrame.setStatus(Config.getString("team.checkingout"));
            this.newFrame.startProgress();
            TeamworkCommand checkoutCmd = this.repository.checkout(this.projDir);
            this.response = checkoutCmd.getResult();
            this.failed = this.response.isError();
            this.newFrame.stopProgress();
            if (!this.failed) {
                this.newFrame.setStatus(Config.getString("team.checkedout"));
            }
            this.newFrame.stopProgress();
            return this.response;
        }

        @Override
        public void finished() {
            if (!this.failed) {
                if (!Project.isProject(this.projDir.toString()) && !Import.convertNonBlueJ(this.newFrame, this.projDir)) {
                    this.cleanup();
                    return;
                }
                Project project = Project.openProject(this.projDir.toString(), this.newFrame);
                project.setTeamSettingsController(this.tsc);
                Package initialPackage = project.getPackage(project.getInitialPackageName());
                this.newFrame.openPackage(initialPackage);
                this.newFrame.setEnabled(true);
            } else {
                TeamUtils.handleServerResponse(this.response, this.newFrame);
                this.cleanup();
            }
        }

        public void cleanup() {
            this.projDir.delete();
            this.newFrame.doClose(true, false);
            this.newFrame.setEnabled(true);
        }
    }
}

