/*
 * Decompiled with CFR 0.152.
 */
package bluej.debugger.jdi;

import bluej.debugger.DebuggerClass;
import bluej.debugger.DebuggerField;
import bluej.debugger.DebuggerObject;
import bluej.debugger.gentype.GenTypeClass;
import bluej.debugger.gentype.JavaType;
import bluej.debugger.jdi.JdiArray;
import bluej.debugger.jdi.JdiClass;
import bluej.debugger.jdi.JdiField;
import bluej.debugger.jdi.JdiReflective;
import bluej.debugger.jdi.JdiUtils;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.Field;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import java.util.ArrayList;
import java.util.List;

public class JdiObject
extends DebuggerObject {
    ObjectReference obj;
    GenTypeClass genType = null;
    List<Field> fields;

    public static JdiObject getDebuggerObject(ObjectReference obj) {
        if (obj instanceof ArrayReference) {
            return new JdiArray((ArrayReference)obj);
        }
        return new JdiObject(obj);
    }

    public static JdiObject getDebuggerObject(ObjectReference obj, JavaType expectedType) {
        if (obj instanceof ArrayReference) {
            return new JdiArray((ArrayReference)obj, expectedType);
        }
        if (expectedType instanceof GenTypeClass) {
            return new JdiObject(obj, (GenTypeClass)expectedType);
        }
        return new JdiObject(obj);
    }

    public static JdiObject getDebuggerObject(ObjectReference obj, Field field, JdiObject parent) {
        JavaType expectedType = JdiReflective.fromField(field, parent);
        if (obj instanceof ArrayReference) {
            return new JdiArray((ArrayReference)obj, expectedType);
        }
        if (expectedType.asClass() != null) {
            return new JdiObject(obj, expectedType.asClass());
        }
        return new JdiObject(obj);
    }

    protected JdiObject() {
    }

    private JdiObject(ObjectReference obj) {
        this.obj = obj;
        if (obj != null) {
            obj.disableCollection();
            this.getRemoteFields();
        }
    }

    private JdiObject(ObjectReference obj, GenTypeClass expectedType) {
        this.obj = obj;
        if (obj != null) {
            obj.disableCollection();
            this.getRemoteFields();
            JdiReflective reflective = new JdiReflective(obj.referenceType());
            if (expectedType.isGeneric()) {
                this.genType = expectedType.mapToDerived(reflective);
            }
        }
    }

    protected void finalize() {
        if (this.obj != null) {
            this.obj.enableCollection();
        }
    }

    public String toString() {
        return JdiUtils.getJdiUtils().getValueString(this.obj);
    }

    @Override
    public String getClassName() {
        if (this.obj == null) {
            return "";
        }
        return this.obj.referenceType().name();
    }

    @Override
    public DebuggerClass getClassRef() {
        if (this.obj == null) {
            return null;
        }
        return new JdiClass(this.obj.referenceType());
    }

    @Override
    public GenTypeClass getGenType() {
        if (this.genType != null) {
            return this.genType;
        }
        if (this.obj != null) {
            JdiReflective r = new JdiReflective(this.obj.referenceType());
            return new GenTypeClass(r);
        }
        return null;
    }

    @Override
    public boolean isArray() {
        return false;
    }

    @Override
    public boolean isNullObject() {
        return this.obj == null;
    }

    @Override
    public int getElementCount() {
        return -1;
    }

    @Override
    public JavaType getElementType() {
        return null;
    }

    @Override
    public DebuggerObject getElementObject(int index) {
        return null;
    }

    @Override
    public String getElementValueString(int index) {
        return null;
    }

    @Override
    public ObjectReference getObjectReference() {
        return this.obj;
    }

    @Override
    public List<DebuggerField> getFields() {
        List<Field> visibleFields = this.obj.referenceType().visibleFields();
        ArrayList<DebuggerField> rlist = new ArrayList<DebuggerField>(this.fields.size());
        for (Field field : this.fields) {
            if (this.checkIgnoreField(field)) continue;
            boolean visible = visibleFields.remove(field);
            rlist.add(new JdiField(field, this, !visible));
        }
        return rlist;
    }

    private boolean checkIgnoreField(Field f) {
        return f.name().indexOf(36) >= 0;
    }

    protected void getRemoteFields() {
        ReferenceType cls;
        if (this.obj != null && (cls = this.obj.referenceType()) != null) {
            this.fields = cls.allFields();
            return;
        }
        this.fields = new ArrayList<Field>();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        JdiObject test = (JdiObject)o;
        return ((Object)this.obj).equals(test.obj);
    }

    public int hashCode() {
        return ((Object)this.obj).hashCode();
    }
}

