/*
 * Decompiled with CFR 0.152.
 */
package bluej.debugger.jdi;

import bluej.Config;
import bluej.classmgr.BPClassLoader;
import bluej.debugger.Debugger;
import bluej.debugger.DebuggerClass;
import bluej.debugger.DebuggerEvent;
import bluej.debugger.DebuggerListener;
import bluej.debugger.DebuggerObject;
import bluej.debugger.DebuggerResult;
import bluej.debugger.DebuggerTerminal;
import bluej.debugger.DebuggerTestResult;
import bluej.debugger.DebuggerThreadTreeModel;
import bluej.debugger.ExceptionDescription;
import bluej.debugger.SourceLocation;
import bluej.debugger.jdi.JdiClass;
import bluej.debugger.jdi.JdiObject;
import bluej.debugger.jdi.JdiTestResult;
import bluej.debugger.jdi.JdiTestResultError;
import bluej.debugger.jdi.JdiTestResultFailure;
import bluej.debugger.jdi.JdiThread;
import bluej.debugger.jdi.JdiThreadNode;
import bluej.debugger.jdi.JdiThreadSet;
import bluej.debugger.jdi.JdiThreadTreeModel;
import bluej.debugger.jdi.JdiUtils;
import bluej.debugger.jdi.JdiVmCreationException;
import bluej.debugger.jdi.VMReference;
import bluej.utility.Debug;
import bluej.utility.JavaNames;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.Field;
import com.sun.jdi.InvocationException;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.StringReference;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.VMOutOfMemoryException;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class JdiDebugger
extends Debugger {
    private static final int loaderPriority = 3;
    private boolean autoRestart = true;
    private boolean selfRestart = false;
    private VMReference vmRef;
    private MachineLoaderThread machineLoader;
    private Object serverThreadLock = new Object();
    private JdiThreadSet allThreads;
    private JdiThreadTreeModel treeModel;
    private List<DebuggerListener> listenerList = new ArrayList<DebuggerListener>();
    private File startingDirectory;
    private DebuggerTerminal terminal;
    private Set<String> usedNames;
    private boolean hideSystemThreads;
    private int machineState = 1;
    private BPClassLoader lastProjectClassLoader;
    private ExceptionDescription lastException;
    private URL[] libraries = new URL[0];

    public JdiDebugger(File startingDirectory, DebuggerTerminal terminal) {
        this.startingDirectory = startingDirectory;
        this.terminal = terminal;
        this.allThreads = new JdiThreadSet();
        this.treeModel = new JdiThreadTreeModel(new JdiThreadNode());
        this.usedNames = new TreeSet<String>();
        this.hideSystemThreads = true;
    }

    @Override
    public void setUserLibraries(URL[] libraries) {
        this.libraries = libraries;
    }

    @Override
    public synchronized void launch() {
        if (this.vmRef != null) {
            throw new IllegalStateException("JdiDebugger.launch() was called but the debugger was already loaded");
        }
        if (this.machineLoader != null && !this.selfRestart) {
            return;
        }
        this.autoRestart = true;
        if (!this.selfRestart) {
            this.machineLoader = new MachineLoaderThread();
        }
        this.selfRestart = false;
        this.machineLoader.setPriority(3);
        this.machineLoader.start();
    }

    @Override
    public synchronized void close(boolean restart) {
        if (this.vmRef != null) {
            this.autoRestart = restart;
            this.selfRestart = restart;
            if (this.selfRestart) {
                this.machineLoader = new MachineLoaderThread();
            }
            this.vmRef.close();
        } else if (!restart) {
            this.autoRestart = false;
            this.selfRestart = false;
            this.machineLoader = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int addDebuggerListener(DebuggerListener l) {
        List<DebuggerListener> list = this.listenerList;
        synchronized (list) {
            this.listenerList.add(l);
            return this.machineState;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeDebuggerListener(DebuggerListener l) {
        List<DebuggerListener> list = this.listenerList;
        synchronized (list) {
            this.listenerList.remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DebuggerListener[] getListeners() {
        List<DebuggerListener> list = this.listenerList;
        synchronized (list) {
            return this.listenerList.toArray(new DebuggerListener[this.listenerList.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String guessNewName(String className) {
        String baseName = JavaNames.getBase(className = className.replace('[', ' ').replace(']', ' ').trim());
        int stringEndIndex = baseName.length() > 8 ? 8 : baseName.length();
        String newName = Character.toLowerCase(baseName.charAt(0)) + baseName.substring(1, stringEndIndex);
        int num = 1;
        JdiDebugger jdiDebugger = this;
        synchronized (jdiDebugger) {
            while (this.usedNames.contains(newName + num)) {
                ++num;
            }
        }
        return newName + num;
    }

    @Override
    public String guessNewName(DebuggerObject obj) {
        String name = null;
        DebuggerClass cls = obj.getClassRef();
        if (cls.isEnum()) {
            ObjectReference val = obj.getObjectReference();
            name = JdiUtils.getJdiUtils().getValueString(val);
        }
        if (name == null) {
            name = cls.getName();
        }
        return this.guessNewName(name);
    }

    @Override
    public synchronized void newClassLoader(BPClassLoader bpClassLoader) {
        if (bpClassLoader == null) {
            return;
        }
        this.lastProjectClassLoader = bpClassLoader;
        VMReference vmr = this.getVMNoWait();
        if (vmr != null) {
            this.usedNames.clear();
            try {
                vmr.clearAllBreakpoints();
                vmr.newClassLoader(bpClassLoader.getURLs());
            }
            catch (VMDisconnectedException vMDisconnectedException) {
                // empty catch block
            }
        }
    }

    @Override
    public void removeBreakpointsForClass(String className) {
        VMReference vmr = this.getVMNoWait();
        if (vmr != null) {
            vmr.clearBreakpointsForClass(className);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addObject(String scopeId, String newInstanceName, DebuggerObject dob) {
        VMReference vmr = this.getVMNoWait();
        if (vmr != null) {
            vmr.addObject(scopeId, newInstanceName, ((JdiObject)dob).getObjectReference());
            JdiDebugger jdiDebugger = this;
            synchronized (jdiDebugger) {
                this.usedNames.add(newInstanceName);
            }
        }
        return true;
    }

    @Override
    public void removeObject(String scopeId, String instanceName) {
        VMReference vmr = this.getVMNoWait();
        if (vmr != null) {
            vmr.removeObject(scopeId, instanceName);
        }
    }

    @Override
    public Map<String, DebuggerObject> getObjects() {
        throw new IllegalStateException("not implemented");
    }

    @Override
    public int getStatus() {
        return this.machineState;
    }

    @Override
    public DebuggerObject getMirror(String value) {
        VMReference vmr = this.getVM();
        if (vmr != null) {
            try {
                return JdiObject.getDebuggerObject(vmr.getMirror(value));
            }
            catch (VMDisconnectedException vde) {
            }
            catch (VMOutOfMemoryException vMOutOfMemoryException) {
                // empty catch block
            }
        }
        return null;
    }

    public ExceptionDescription getException() {
        return this.lastException;
    }

    @Override
    public DebuggerThreadTreeModel getThreadTreeModel() {
        return this.treeModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, DebuggerObject> runTestSetUp(String className) {
        ArrayReference arrayRef = null;
        HashMap<String, DebuggerObject> returnMap = new HashMap<String, DebuggerObject>();
        VMReference vmr = this.getVM();
        try {
            Object object = this.serverThreadLock;
            synchronized (object) {
                if (vmr != null) {
                    arrayRef = (ArrayReference)vmr.invokeTestSetup(className);
                }
                if (arrayRef != null) {
                    ObjectReference testObject = (ObjectReference)arrayRef.getValue(arrayRef.length() - 1);
                    JdiObject jdiTestObject = JdiObject.getDebuggerObject(testObject);
                    for (int i = 0; i < arrayRef.length() - 1; i += 2) {
                        String fieldName = ((StringReference)arrayRef.getValue(i)).value();
                        Field testField = testObject.referenceType().fieldByName(fieldName);
                        returnMap.put(fieldName, JdiObject.getDebuggerObject((ObjectReference)arrayRef.getValue(i + 1), testField, jdiTestObject));
                    }
                }
            }
        }
        catch (InvocationException e) {
            return null;
        }
        catch (VMDisconnectedException e) {
            return null;
        }
        return returnMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DebuggerTestResult runTestMethod(String className, String methodName) {
        ArrayReference arrayRef = null;
        try {
            VMReference vmr = this.getVM();
            Object object = this.serverThreadLock;
            synchronized (object) {
                if (vmr != null) {
                    arrayRef = (ArrayReference)vmr.invokeRunTest(className, methodName);
                }
                if (arrayRef == null || arrayRef.length() == 0) {
                    return new JdiTestResultError(className, methodName, "VM returned unknown result", "", null, 0);
                }
                int runTimeMs = Integer.parseInt(((StringReference)arrayRef.getValue(0)).value());
                if (arrayRef != null && arrayRef.length() > 5) {
                    String failureType = ((StringReference)arrayRef.getValue(7)).value();
                    String exMsg = ((StringReference)arrayRef.getValue(1)).value();
                    String traceMsg = ((StringReference)arrayRef.getValue(2)).value();
                    String failureClass = ((StringReference)arrayRef.getValue(3)).value();
                    String failureSource = ((StringReference)arrayRef.getValue(4)).value();
                    String failureMethod = ((StringReference)arrayRef.getValue(5)).value();
                    int lineNo = Integer.parseInt(((StringReference)arrayRef.getValue(6)).value());
                    SourceLocation failPoint = new SourceLocation(failureClass, failureSource, failureMethod, lineNo);
                    if (failureType.equals("failure")) {
                        return new JdiTestResultFailure(className, methodName, exMsg, traceMsg, failPoint, runTimeMs);
                    }
                    return new JdiTestResultError(className, methodName, exMsg, traceMsg, failPoint, runTimeMs);
                }
                if (arrayRef != null && arrayRef.length() == 1) {
                    return new JdiTestResult(className, methodName, runTimeMs);
                }
            }
        }
        catch (InvocationException ie) {
            return new JdiTestResultError(className, methodName, "Internal invocation error", "", null, 0);
        }
        catch (VMDisconnectedException vmde) {
            return new JdiTestResultError(className, methodName, "VM restarted", "", null, 0);
        }
        return new JdiTestResultError(className, methodName, "VM returned unknown result", "", null, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disposeWindows() {
        VMReference vmr = this.getVMNoWait();
        try {
            Object object = this.serverThreadLock;
            synchronized (object) {
                if (vmr != null) {
                    vmr.disposeWindows();
                }
            }
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DebuggerResult runClassMain(String className) throws ClassNotFoundException {
        VMReference vmr = this.getVM();
        Object object = this.serverThreadLock;
        synchronized (object) {
            if (vmr != null) {
                return vmr.runShellClass(className);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DebuggerResult instantiateClass(String className) {
        VMReference vmr = this.getVM();
        if (vmr != null) {
            Object object = this.serverThreadLock;
            synchronized (object) {
                return vmr.instantiateClass(className);
            }
        }
        return new DebuggerResult(3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DebuggerResult instantiateClass(String className, String[] paramTypes, DebuggerObject[] args) {
        if (paramTypes == null || args == null || paramTypes.length == 0 || args.length == 0) {
            return this.instantiateClass(className);
        }
        VMReference vmr = this.getVM();
        if (vmr != null) {
            ObjectReference[] orArgs = new ObjectReference[args.length];
            for (int i = 0; i < args.length; ++i) {
                JdiObject jdiObject = (JdiObject)args[i];
                orArgs[i] = jdiObject.getObjectReference();
            }
            Object object = this.serverThreadLock;
            synchronized (object) {
                return vmr.instantiateClass(className, paramTypes, orArgs);
            }
        }
        return new DebuggerResult(3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DebuggerClass getClass(String className, boolean initialize) throws ClassNotFoundException {
        ReferenceType classMirror;
        VMReference vmr = this.getVM();
        if (vmr == null) {
            throw new ClassNotFoundException("Virtual machine terminated.");
        }
        Object object = this.serverThreadLock;
        synchronized (object) {
            classMirror = initialize && this.machineState != 3 ? vmr.loadInitClass(className) : vmr.loadClass(className);
        }
        return new JdiClass(classMirror);
    }

    private void fireTargetEvent(DebuggerEvent ce, boolean skipUpdate) {
        DebuggerListener[] listeners = this.getListeners();
        for (int i = listeners.length - 1; i >= 0; --i) {
            listeners[i].processDebuggerEvent(ce, skipUpdate);
        }
    }

    void raiseStateChangeEvent(int newState) {
        if (newState != this.machineState) {
            if (this.machineState == 4 && newState != 3) {
                this.doStateChange(4, 3);
            }
            if (this.machineState == 3 && newState == 1) {
                this.doStateChange(3, 2);
            }
            this.doStateChange(this.machineState, newState);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doStateChange(int oldState, int newState) {
        DebuggerListener[] ll;
        List<DebuggerListener> list = this.listenerList;
        synchronized (list) {
            ll = this.listenerList.toArray(new DebuggerListener[this.listenerList.size()]);
            this.machineState = newState;
        }
        for (DebuggerListener l : ll) {
            l.processDebuggerEvent(new DebuggerEvent((Object)this, 1, oldState, newState), false);
        }
    }

    @Override
    public String toggleBreakpoint(String className, int line, boolean set, Map<String, String> properties) {
        VMReference vmr = this.getVM();
        try {
            if (vmr != null) {
                if (set) {
                    return vmr.setBreakpoint(className, line, properties);
                }
                return vmr.clearBreakpoint(className, line);
            }
            return "VM terminated.";
        }
        catch (Exception e) {
            Debug.reportError("breakpoint error: " + e);
            e.printStackTrace(System.out);
            return Config.getString("debugger.jdiDebugger.internalErrorMsg");
        }
    }

    @Override
    public String toggleBreakpoint(String className, String method, boolean set, Map<String, String> properties) {
        VMReference vmr = this.getVM();
        try {
            if (vmr != null) {
                if (set) {
                    return vmr.setBreakpoint(className, method, properties);
                }
                return vmr.clearBreakpoint(className, method);
            }
            return "VM terminated.";
        }
        catch (Exception e) {
            Debug.reportError("breakpoint error: " + e);
            e.printStackTrace(System.out);
            return Config.getString("debugger.jdiDebugger.internalErrorMsg");
        }
    }

    @Override
    public String toggleBreakpoint(DebuggerClass debuggerClass, String method, boolean set, Map<String, String> properties) {
        VMReference vmr = this.getVM();
        try {
            if (vmr != null) {
                JdiClass jdiClass = (JdiClass)debuggerClass;
                if (set) {
                    return vmr.setBreakpoint(jdiClass.remoteClass, method, properties);
                }
                return vmr.clearBreakpoint(jdiClass.remoteClass, method);
            }
            return "VM terminated.";
        }
        catch (Exception e) {
            Debug.reportError("breakpoint error: " + e);
            e.printStackTrace(System.out);
            return Config.getString("debugger.jdiDebugger.internalErrorMsg");
        }
    }

    public void breakpoint(final ThreadReference tr, int debuggerEventType, boolean skipUpdate, DebuggerEvent.BreakpointProperties props) {
        final JdiThread breakThread = this.allThreads.find(tr);
        if (!skipUpdate) {
            this.treeModel.syncExec(new Runnable(){

                @Override
                public void run() {
                    JdiThreadNode jtn = JdiDebugger.this.treeModel.findThreadNode(tr);
                    if (jtn == null) {
                        JdiThreadNode root = JdiDebugger.this.treeModel.getThreadRoot();
                        JdiDebugger.this.treeModel.insertNodeInto(new JdiThreadNode(breakThread), root, 0);
                    } else {
                        JdiDebugger.this.treeModel.nodeChanged(jtn);
                    }
                }
            });
        }
        this.fireTargetEvent(new DebuggerEvent(this, debuggerEventType, breakThread, props), skipUpdate);
    }

    public boolean screenBreakpoint(ThreadReference thread, int debuggerEventType, DebuggerEvent.BreakpointProperties props) {
        JdiThread breakThread = this.allThreads.find(thread);
        breakThread.stopped();
        DebuggerEvent event = new DebuggerEvent(this, debuggerEventType, breakThread, props);
        boolean done = false;
        DebuggerListener[] listeners = this.getListeners();
        for (int i = listeners.length - 1; i >= 0; --i) {
            done = done || listeners[i].examineDebuggerEvent(event);
        }
        return done;
    }

    synchronized void vmDisconnect() {
        if (this.autoRestart) {
            this.allThreads.clear();
            if (this.vmRef != null) {
                if (!this.selfRestart) {
                    this.machineLoader = new MachineLoaderThread();
                }
                this.selfRestart = true;
                this.vmRef.closeIO();
                this.vmRef = null;
                this.raiseStateChangeEvent(1);
                this.launch();
                this.usedNames.clear();
                this.treeModel.syncExec(new Runnable(){

                    @Override
                    public void run() {
                        JdiDebugger.this.treeModel.setRoot(new JdiThreadNode());
                        JdiDebugger.this.treeModel.reload();
                    }
                });
            }
        }
    }

    void threadStart(ThreadReference tr) {
        final JdiThread newThread = new JdiThread(this, tr);
        this.allThreads.add(newThread);
        this.treeModel.syncExec(new Runnable(){

            @Override
            public void run() {
                JdiDebugger.this.displayThread(newThread);
            }
        });
    }

    void threadDeath(final ThreadReference tr) {
        this.allThreads.removeThread(tr);
        this.treeModel.syncExec(new Runnable(){

            @Override
            public void run() {
                JdiThreadNode jtn = JdiDebugger.this.treeModel.findThreadNode(tr);
                if (jtn != null) {
                    JdiDebugger.this.treeModel.removeNodeFromParent(jtn);
                }
            }
        });
    }

    @Override
    public void hideSystemThreads(boolean hide) {
        if (this.hideSystemThreads == hide) {
            return;
        }
        this.hideSystemThreads = hide;
        this.updateThreadDisplay();
    }

    private void updateThreadDisplay() {
        this.treeModel.setRoot(new JdiThreadNode());
        for (JdiThread currentThread : this.allThreads) {
            this.displayThread(currentThread);
        }
        this.treeModel.reload();
    }

    private void displayThread(JdiThread newThread) {
        if (!this.hideSystemThreads || !newThread.isKnownSystemThread()) {
            JdiThreadNode root = this.treeModel.getThreadRoot();
            this.treeModel.insertNodeInto(new JdiThreadNode(newThread), root, 0);
        }
    }

    private VMReference getVM() {
        MachineLoaderThread mlt = this.machineLoader;
        if (mlt == null) {
            return null;
        }
        return mlt.getVM();
    }

    private VMReference getVMNoWait() {
        MachineLoaderThread mlt = this.machineLoader;
        if (mlt == null) {
            return null;
        }
        return mlt.getVMNoWait();
    }

    void emitThreadHaltEvent(JdiThread thread) {
        this.vmRef.emitThreadEvent(thread, true);
    }

    void emitThreadResumedEvent(JdiThread thread) {
        this.vmRef.emitThreadEvent(thread, false);
    }

    void threadHalted(final JdiThread thread) {
        DebuggerEvent event = new DebuggerEvent(this, 2, thread, null);
        boolean skipUpdate = false;
        DebuggerListener[] listeners = this.getListeners();
        for (int i = listeners.length - 1; i >= 0; --i) {
            skipUpdate |= listeners[i].examineDebuggerEvent(event);
        }
        if (!skipUpdate) {
            this.treeModel.syncExec(new Runnable(){

                @Override
                public void run() {
                    JdiThreadNode threadNode = JdiDebugger.this.treeModel.findThreadNode(thread.getRemoteThread());
                    if (threadNode != null) {
                        JdiDebugger.this.treeModel.nodeChanged(threadNode);
                    }
                }
            });
        }
        this.fireTargetEvent(event, skipUpdate);
    }

    void threadResumed(final JdiThread thread) {
        DebuggerEvent event = new DebuggerEvent(this, 6, thread, null);
        boolean skipUpdate = false;
        DebuggerListener[] listeners = this.getListeners();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            skipUpdate |= listeners[i].examineDebuggerEvent(event);
        }
        if (!skipUpdate) {
            this.treeModel.syncExec(new Runnable(){

                @Override
                public void run() {
                    JdiThreadNode threadNode = JdiDebugger.this.treeModel.findThreadNode(thread.getRemoteThread());
                    if (threadNode != null) {
                        JdiDebugger.this.treeModel.nodeChanged(threadNode);
                    }
                }
            });
        }
        this.fireTargetEvent(event, skipUpdate);
    }

    public void serverThreadResumed(ThreadReference serverThread) {
        this.allThreads.find(serverThread).notifyResumed();
    }

    class MachineLoaderThread
    extends Thread {
        MachineLoaderThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                BPClassLoader lastLoader;
                VMReference newVM = new VMReference(JdiDebugger.this, JdiDebugger.this.terminal, JdiDebugger.this.startingDirectory, JdiDebugger.this.libraries);
                JdiDebugger jdiDebugger = JdiDebugger.this;
                synchronized (jdiDebugger) {
                    if (!JdiDebugger.this.autoRestart) {
                        newVM.close();
                        JdiDebugger.this.notifyAll();
                        return;
                    }
                    lastLoader = JdiDebugger.this.lastProjectClassLoader;
                }
                newVM.newClassLoader(lastLoader.getURLs());
                jdiDebugger = JdiDebugger.this;
                synchronized (jdiDebugger) {
                    JdiDebugger.this.vmRef = newVM;
                }
            }
            catch (JdiVmCreationException e) {
                JdiDebugger.this.raiseStateChangeEvent(5);
            }
            JdiDebugger jdiDebugger = JdiDebugger.this;
            synchronized (jdiDebugger) {
                JdiDebugger.this.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private VMReference getVM() {
            JdiDebugger jdiDebugger = JdiDebugger.this;
            synchronized (jdiDebugger) {
                while (JdiDebugger.this.vmRef == null && JdiDebugger.this.autoRestart) {
                    try {
                        JdiDebugger.this.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                return JdiDebugger.this.vmRef;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private VMReference getVMNoWait() {
            JdiDebugger jdiDebugger = JdiDebugger.this;
            synchronized (jdiDebugger) {
                return JdiDebugger.this.vmRef;
            }
        }
    }
}

