/*
 * Decompiled with CFR 0.152.
 */
package bluej.debugger.gentype;

import bluej.debugger.gentype.GenTypeArray;
import bluej.debugger.gentype.GenTypeParameter;
import bluej.debugger.gentype.GenTypeSolid;
import bluej.debugger.gentype.JavaType;
import bluej.debugger.gentype.NameTransform;
import java.util.Map;

public class JavaPrimitiveType
extends JavaType {
    private static JavaPrimitiveType[] primitiveTypes = new JavaPrimitiveType[JavaType.JT_MAX + 1];
    private static String[] typeNames = new String[]{"void", "null", "boolean", "char", "byte", "short", "int", "long", "float", "double"};
    private static int[][] assignableFrom = new int[JT_MAX + 1][];
    private int myIndex;

    protected JavaPrimitiveType(int index) {
        JavaPrimitiveType.assignableFrom[JavaPrimitiveType.JT_VOID] = new int[0];
        JavaPrimitiveType.assignableFrom[JavaPrimitiveType.JT_NULL] = new int[0];
        JavaPrimitiveType.assignableFrom[JavaPrimitiveType.JT_BOOLEAN] = new int[]{JT_BOOLEAN};
        JavaPrimitiveType.assignableFrom[JavaPrimitiveType.JT_CHAR] = new int[]{JT_CHAR};
        JavaPrimitiveType.assignableFrom[JavaPrimitiveType.JT_BYTE] = new int[]{JT_BYTE};
        JavaPrimitiveType.assignableFrom[JavaPrimitiveType.JT_SHORT] = new int[]{JT_SHORT, JT_BYTE};
        JavaPrimitiveType.assignableFrom[JavaPrimitiveType.JT_INT] = new int[]{JT_INT, JT_BYTE, JT_SHORT, JT_CHAR};
        JavaPrimitiveType.assignableFrom[JavaPrimitiveType.JT_LONG] = new int[]{JT_LONG, JT_BYTE, JT_SHORT, JT_CHAR, JT_INT};
        JavaPrimitiveType.assignableFrom[JavaPrimitiveType.JT_FLOAT] = new int[]{JT_FLOAT, JT_LONG, JT_BYTE, JT_SHORT, JT_CHAR, JT_INT, JT_LONG};
        JavaPrimitiveType.assignableFrom[JavaPrimitiveType.JT_DOUBLE] = new int[]{JT_DOUBLE, JT_LONG, JT_BYTE, JT_SHORT, JT_CHAR, JT_INT, JT_LONG, JT_FLOAT};
        this.myIndex = index;
    }

    private static JavaPrimitiveType getType(int v) {
        if (primitiveTypes[v] == null) {
            JavaPrimitiveType.primitiveTypes[v] = new JavaPrimitiveType(v);
        }
        return primitiveTypes[v];
    }

    public static JavaPrimitiveType getVoid() {
        return JavaPrimitiveType.getType(JT_VOID);
    }

    public static JavaPrimitiveType getNull() {
        return JavaPrimitiveType.getType(JT_NULL);
    }

    public static JavaPrimitiveType getBoolean() {
        return JavaPrimitiveType.getType(JT_BOOLEAN);
    }

    public static JavaPrimitiveType getByte() {
        return JavaPrimitiveType.getType(JT_BYTE);
    }

    public static JavaPrimitiveType getChar() {
        return JavaPrimitiveType.getType(JT_CHAR);
    }

    public static JavaPrimitiveType getShort() {
        return JavaPrimitiveType.getType(JT_SHORT);
    }

    public static JavaPrimitiveType getInt() {
        return JavaPrimitiveType.getType(JT_INT);
    }

    public static JavaPrimitiveType getLong() {
        return JavaPrimitiveType.getType(JT_LONG);
    }

    public static JavaPrimitiveType getFloat() {
        return JavaPrimitiveType.getType(JT_FLOAT);
    }

    public static JavaPrimitiveType getDouble() {
        return JavaPrimitiveType.getType(JT_DOUBLE);
    }

    @Override
    public String toString() {
        return typeNames[this.myIndex];
    }

    @Override
    public String arrayComponentName() {
        return "!!ZCBSIJFD".substring(this.myIndex, this.myIndex + 1);
    }

    @Override
    public boolean isAssignableFrom(JavaType o) {
        int[] assignables = assignableFrom[this.myIndex];
        for (int i = 0; i < assignables.length; ++i) {
            if (!o.typeIs(assignables[i])) continue;
            return true;
        }
        return false;
    }

    @Override
    public JavaType getErasedType() {
        return this;
    }

    @Override
    public boolean isAssignableFromRaw(JavaType t) {
        return this.isAssignableFrom(t);
    }

    @Override
    public boolean isPrimitive() {
        return true;
    }

    @Override
    public boolean isNumeric() {
        return this.myIndex >= JT_LOWEST_NUMERIC;
    }

    @Override
    public boolean isIntegralType() {
        return this.myIndex >= JT_CHAR && this.myIndex <= JT_LONG;
    }

    @Override
    public boolean typeIs(int v) {
        return this.myIndex == v;
    }

    @Override
    public JavaType mapTparsToTypes(Map<String, ? extends GenTypeParameter> tparams) {
        return this;
    }

    @Override
    public GenTypeArray getArray() {
        return new GenTypeArray(this);
    }

    @Override
    public JavaType getCapture() {
        return this;
    }

    @Override
    public void getParamsFromTemplate(Map<String, GenTypeParameter> map, GenTypeParameter template) {
    }

    @Override
    public GenTypeSolid getLowerBound() {
        return null;
    }

    @Override
    public JavaPrimitiveType getUpperBound() {
        return this;
    }

    @Override
    public GenTypeSolid[] getUpperBounds() {
        return null;
    }

    @Override
    public String toTypeArgString(NameTransform nt) {
        return this.toString();
    }

    @Override
    public boolean equals(JavaType other) {
        if (other == null) {
            return false;
        }
        return other.typeIs(this.myIndex);
    }

    @Override
    public boolean isWildcard() {
        return false;
    }
}

