/*
 * Decompiled with CFR 0.152.
 */
package bluej.compiler;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;

public class WriterOutputStream
extends OutputStream {
    private Charset cs = Charset.forName(System.getProperty("file.encoding"));
    private CharsetDecoder decoder = this.cs.newDecoder();
    ByteBuffer inBuffer;
    CharBuffer outBuffer;
    private Writer writer;

    public WriterOutputStream(Writer writer) {
        this.writer = writer;
        this.decoder.reset();
        this.decoder.onMalformedInput(CodingErrorAction.REPLACE);
        this.decoder.onUnmappableCharacter(CodingErrorAction.REPLACE);
        this.inBuffer = ByteBuffer.allocate(4096);
        this.inBuffer.clear();
        this.outBuffer = CharBuffer.allocate(4096);
        this.outBuffer.clear();
    }

    @Override
    public void write(int b) throws IOException {
        this.write(new byte[]{(byte)b}, 0, 1);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        int remaining = this.inBuffer.remaining();
        while (len > 0) {
            int toWrite = remaining;
            if (toWrite > len) {
                toWrite = len;
            }
            this.inBuffer.put(b, off, toWrite);
            off += toWrite;
            len -= toWrite;
            if ((remaining -= toWrite) != 0) continue;
            this.flush();
            remaining = this.inBuffer.remaining();
        }
    }

    private void flushInBuffer(boolean endOfInput) throws IOException {
        this.inBuffer.flip();
        CoderResult result = this.decoder.decode(this.inBuffer, this.outBuffer, endOfInput);
        while (result.isOverflow()) {
            this.flushOutBuffer();
            result = this.decoder.decode(this.inBuffer, this.outBuffer, endOfInput);
        }
        this.inBuffer.compact();
    }

    private void flushOutBuffer() throws IOException {
        this.outBuffer.flip();
        this.writer.write(this.outBuffer.toString());
        this.outBuffer.clear();
    }

    private void flush(boolean endOfInput) throws IOException {
        this.flushInBuffer(endOfInput);
        this.flushOutBuffer();
        this.writer.flush();
    }

    @Override
    public void flush() throws IOException {
        this.flush(false);
    }

    @Override
    public void close() throws IOException {
        if (this.writer != null) {
            this.flush(true);
            this.writer = null;
        }
    }
}

