/*
 * Decompiled with CFR 0.152.
 */
package bluej.compiler;

import bluej.Config;
import bluej.classmgr.BPClassLoader;
import bluej.compiler.CompileObserver;
import bluej.compiler.Compiler;
import java.io.File;
import java.nio.charset.Charset;
import java.util.List;

class Job {
    Compiler compiler;
    CompileObserver observer;
    File destDir;
    BPClassLoader bpClassLoader;
    File[] sources;
    boolean internal;
    private List<String> userCompileOptions;
    private Charset fileCharset;

    public Job(File[] sourceFiles, Compiler compiler, CompileObserver observer, BPClassLoader bpClassLoader, File destDir, boolean internal, List<String> userCompileOptions, Charset fileCharset) {
        this.sources = sourceFiles;
        this.compiler = compiler;
        this.observer = observer;
        this.bpClassLoader = bpClassLoader;
        this.destDir = destDir;
        this.internal = internal;
        this.userCompileOptions = userCompileOptions;
        this.fileCharset = fileCharset;
    }

    public void compile() {
        block7: {
            try {
                if (this.observer != null) {
                    this.observer.startCompile(this.sources);
                }
                if (this.destDir != null) {
                    this.compiler.setDestDir(this.destDir);
                }
                this.compiler.setClasspath(this.bpClassLoader.getClassPathAsFiles());
                if (this.bpClassLoader.loadsForJavaMEproject()) {
                    this.compiler.setBootClassPath(this.bpClassLoader.getJavaMElibsAsFiles());
                } else {
                    this.compiler.setBootClassPath(null);
                    String majorVersion = System.getProperty("java.specification.version");
                    this.userCompileOptions.add(0, "-source");
                    this.userCompileOptions.add(1, majorVersion);
                }
                boolean successful = this.compiler.compile(this.sources, this.observer, this.internal, this.userCompileOptions, this.fileCharset);
                if (this.observer != null) {
                    this.observer.endCompile(this.sources, successful);
                }
            }
            catch (Exception e) {
                System.err.println(Config.getString("compileException") + ": " + e);
                e.printStackTrace();
                if (this.observer == null) break block7;
                this.observer.endCompile(this.sources, false);
            }
        }
    }
}

