/*
 * Decompiled with CFR 0.152.
 */
package bluej.collect;

import bluej.collect.Event;
import bluej.collect.FileKey;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.mime.MultipartEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.util.EntityUtils;

class DataSubmitter {
    private static final String submitUrl = "http://blackbox.bluej.org/master_events";
    private static volatile boolean givenUp = false;
    private static boolean isRunning = false;
    private static List<Event> queue = new LinkedList<Event>();
    private static int sequenceNum;
    private static Map<FileKey, List<String>> fileVersions;

    DataSubmitter() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void submitEvent(Event evt) {
        if (givenUp) {
            return;
        }
        List<Event> list = queue;
        synchronized (list) {
            queue.add(evt);
            if (!isRunning) {
                new Thread(){

                    @Override
                    public void run() {
                        DataSubmitter.processQueue();
                    }
                }.start();
                isRunning = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void processQueue() {
        while (true) {
            Event evt;
            List<Event> list = queue;
            synchronized (list) {
                if (queue.isEmpty()) {
                    isRunning = false;
                    queue.notifyAll();
                    return;
                }
                evt = queue.remove(0);
            }
            if (givenUp) continue;
            givenUp = !DataSubmitter.postData(evt);
        }
    }

    private static boolean postData(Event evt) {
        BasicHttpParams params = new BasicHttpParams();
        HttpConnectionParams.setConnectionTimeout((HttpParams)params, (int)10000);
        HttpConnectionParams.setSoTimeout((HttpParams)params, (int)10000);
        DefaultHttpClient client = new DefaultHttpClient((HttpParams)params);
        try {
            HttpPost post = new HttpPost(submitUrl);
            MultipartEntity mpe = evt.makeData(sequenceNum, fileVersions);
            if (mpe == null) {
                return true;
            }
            ++sequenceNum;
            post.setEntity((HttpEntity)mpe);
            HttpResponse response = client.execute((HttpUriRequest)post);
            for (Header h : response.getAllHeaders()) {
                if (!"X-Status".equals(h.getName()) || "Created".equals(h.getValue())) continue;
                System.err.println("Problem response: " + mpe.toString() + " " + response.toString());
                return false;
            }
            if (response.getStatusLine().getStatusCode() != 200) {
                System.err.println("Problem code: " + response.getStatusLine().getStatusCode());
                return false;
            }
            evt.success(fileVersions);
            EntityUtils.consume((HttpEntity)response.getEntity());
        }
        catch (ClientProtocolException cpe) {
            return false;
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void waitForQueueFlush(int maxMillis) {
        long endTime = System.currentTimeMillis() + (long)maxMillis;
        try {
            List<Event> list = queue;
            synchronized (list) {
                long waitTime;
                while ((!queue.isEmpty() || isRunning) && (waitTime = endTime - System.currentTimeMillis()) > 0L) {
                    queue.wait(waitTime);
                }
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static void initSequence() {
        sequenceNum = 1;
    }

    static {
        fileVersions = new HashMap<FileKey, List<String>>();
    }
}

