/*
 * Decompiled with CFR 0.152.
 */
package bluej.collect;

import bluej.Config;
import bluej.utility.Debug;
import bluej.utility.Utility;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.UIManager;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.html.HTMLDocument;

class DataCollectionDialog
extends JDialog {
    private boolean optedIn = false;

    public DataCollectionDialog() {
        this.setModal(true);
        this.setDefaultCloseOperation(0);
        this.setTitle("BlueJ - " + Config.getString("collect.dialog.title"));
        JPanel body = new JPanel();
        body.setLayout(new BorderLayout());
        body.setBorder(BorderFactory.createEmptyBorder(10, 20, 10, 20));
        body.setAlignmentX(0.0f);
        JPanel topHalf = new JPanel();
        topHalf.setLayout(new BoxLayout(topHalf, 1));
        JPanel headerPanel = this.makeHeaderPanel();
        topHalf.add(headerPanel);
        topHalf.add(Box.createVerticalStrut(10));
        topHalf.add(this.makeButtonPanel());
        topHalf.add(Box.createVerticalStrut(5));
        topHalf.add(new JSeparator(0));
        body.add((Component)topHalf, "North");
        body.add((Component)this.makeExplanationText(headerPanel.getPreferredSize().width), "Center");
        this.getContentPane().add(body);
        this.pack();
    }

    private JEditorPane makeExplanationText(int width) {
        JEditorPane text = new JEditorPane();
        text.setContentType("text/html");
        String content = "<html><body><p>" + Config.getString("collect.dialog.ethics1") + "  <a href='http://www.bluej.org/blackbox.html'>" + Config.getString("collect.dialog.ethics.seemore") + "</a>.</p>" + "<p>" + Config.getString("collect.dialog.ethics2") + "</p></body></html>";
        text.setText(content);
        text.setEditable(false);
        text.setAlignmentX(0.0f);
        text.setOpaque(false);
        text.setBackground(new Color(0, 0, 0, 0));
        Font labelFont = UIManager.getFont("Label.font");
        String styleRule = "a { color: black; } body { font-family: " + labelFont.getFamily() + "; " + "font-size: " + (labelFont.getSize() - 2) + "pt; } ";
        ((HTMLDocument)text.getDocument()).getStyleSheet().addRule(styleRule);
        this.setEditorPaneSize(width, text);
        this.addLinkListener(text);
        return text;
    }

    private void addLinkListener(JEditorPane text) {
        text.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent hev) {
                if (hev.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    Utility.openWebBrowser(hev.getURL());
                }
            }
        });
    }

    private void setEditorPaneSize(int width, JEditorPane text) {
        text.setSize(new Dimension(width, 300));
        Rectangle r = null;
        try {
            r = text.modelToView(text.getDocument().getLength());
        }
        catch (BadLocationException e) {
            Debug.reportError(e);
        }
        Dimension d = new Dimension(text.getMinimumSize().width, r.y + r.height + 5);
        text.setPreferredSize(d);
        text.setSize(d);
    }

    private JPanel makeHeaderPanel() {
        JPanel headerPanel = new JPanel();
        headerPanel.setLayout(new BoxLayout(headerPanel, 0));
        headerPanel.setAlignmentX(0.0f);
        headerPanel.add(new JLabel(Config.getFixedImageAsIcon("bluej-icon-48.png")));
        headerPanel.add(Box.createHorizontalStrut(20));
        JLabel headerLabel = new JLabel();
        headerLabel.setText("<html><body><b><p>" + Config.getString("collect.dialog.header1") + "<br>" + Config.getString("collect.dialog.header2") + "</p><br>" + "<p>" + Config.getString("collect.dialog.header3") + "</p></b></body></html>");
        headerLabel.setAlignmentX(0.0f);
        headerPanel.add(headerLabel);
        return headerPanel;
    }

    private JPanel makeButtonPanel() {
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new BorderLayout());
        buttonPanel.setAlignmentX(0.0f);
        JButton buttonNo = new JButton();
        buttonNo.setText(Config.getString("collect.dialog.no"));
        buttonNo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataCollectionDialog.this.optedIn = false;
                DataCollectionDialog.this.setVisible(false);
            }
        });
        buttonPanel.add((Component)buttonNo, "West");
        JButton buttonYes = new JButton();
        buttonYes.setText(Config.getString("collect.dialog.yes"));
        buttonYes.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataCollectionDialog.this.optedIn = true;
                DataCollectionDialog.this.setVisible(false);
            }
        });
        buttonPanel.add((Component)buttonYes, "East");
        this.getRootPane().setDefaultButton(buttonYes);
        buttonYes.requestFocusInWindow();
        return buttonPanel;
    }

    public boolean optedIn() {
        return this.optedIn;
    }
}

