/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.services;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.Module;
import org.netbeans.api.autoupdate.UpdateElement;
import org.netbeans.api.autoupdate.UpdateManager;
import org.netbeans.api.autoupdate.UpdateUnit;
import org.netbeans.api.autoupdate.UpdateUnitProvider;
import org.netbeans.modules.autoupdate.services.DependencyChecker;
import org.netbeans.modules.autoupdate.services.ModuleUpdateElementImpl;
import org.netbeans.modules.autoupdate.services.Trampoline;
import org.netbeans.modules.autoupdate.services.UpdateElementImpl;
import org.netbeans.modules.autoupdate.services.UpdateUnitFactory;
import org.netbeans.modules.autoupdate.services.Utilities;
import org.netbeans.modules.autoupdate.updateprovider.ArtificialFeaturesProvider;
import org.netbeans.modules.autoupdate.updateprovider.FeatureItem;
import org.netbeans.modules.autoupdate.updateprovider.InstallInfo;
import org.openide.modules.Dependency;
import org.openide.modules.ModuleInfo;
import org.openide.modules.SpecificationVersion;
import org.openide.util.NbBundle;

public class FeatureUpdateElementImpl
extends UpdateElementImpl {
    private String codeName;
    private String displayName;
    private SpecificationVersion specVersion;
    private String description;
    private String homepage;
    private String category;
    private InstallInfo installInfo;
    private static final Logger LOG = Logger.getLogger(FeatureUpdateElementImpl.class.getName());
    private Set<ModuleUpdateElementImpl> moduleElementsImpl;
    private Set<FeatureUpdateElementImpl> featureElementsImpl;
    private UpdateManager.TYPE type;

    public FeatureUpdateElementImpl(FeatureItem featureItem, String string, Set<ModuleUpdateElementImpl> set, Set<FeatureUpdateElementImpl> set2, UpdateManager.TYPE tYPE) {
        super(featureItem, string);
        this.type = tYPE;
        this.moduleElementsImpl = set;
        this.featureElementsImpl = set2;
        this.codeName = featureItem.getCodeName();
        String string2 = featureItem.getSpecificationVersion();
        if (string2 == null) {
            LOG.log(Level.INFO, this.codeName + " has no specificationVersion.");
        } else {
            this.specVersion = new SpecificationVersion(string2);
        }
        this.installInfo = new InstallInfo(featureItem);
        this.displayName = featureItem.getDisplayName();
        this.description = featureItem.getDescription();
        this.category = featureItem.getCategory();
        if (this.category == null) {
            this.category = NbBundle.getMessage(UpdateElementImpl.class, (String)"UpdateElementImpl_Feature_CategoryName");
        }
    }

    @Override
    public String getCodeName() {
        return this.codeName;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public SpecificationVersion getSpecificationVersion() {
        if (this.specVersion == null) {
            this.specVersion = new SpecificationVersion(ArtificialFeaturesProvider.createVersion(this.getModuleInfos()));
        }
        return this.specVersion;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getNotification() {
        return null;
    }

    @Override
    public String getAuthor() {
        String string = "";
        HashSet<String> hashSet = new HashSet<String>();
        for (ModuleUpdateElementImpl moduleUpdateElementImpl : this.getContainedModuleElements()) {
            if (moduleUpdateElementImpl.getAuthor() == null || !hashSet.add(moduleUpdateElementImpl.getAuthor())) continue;
            string = string + (string.length() == 0 ? moduleUpdateElementImpl.getAuthor() : ", " + moduleUpdateElementImpl.getAuthor());
        }
        return string;
    }

    @Override
    public String getHomepage() {
        return this.homepage;
    }

    @Override
    public int getDownloadSize() {
        int n = 0;
        for (ModuleUpdateElementImpl moduleUpdateElementImpl : this.getContainedModuleElements()) {
            if (moduleUpdateElementImpl.getUpdateUnit().getAvailableUpdates().isEmpty()) continue;
            n += moduleUpdateElementImpl.getUpdateUnit().getAvailableUpdates().get(0).getDownloadSize();
        }
        return n;
    }

    @Override
    public String getSource() {
        String string = "";
        HashSet<String> hashSet = new HashSet<String>();
        for (ModuleUpdateElementImpl moduleUpdateElementImpl : this.getContainedModuleElements()) {
            if (!hashSet.add(moduleUpdateElementImpl.getSource())) continue;
            string = string + (string.length() == 0 ? moduleUpdateElementImpl.getSource() : ", " + moduleUpdateElementImpl.getSource());
        }
        return string;
    }

    @Override
    public String getCategory() {
        if (this.isAutoload() || this.isFixed()) {
            this.category = UpdateUnitFactory.LIBRARIES_CATEGORY;
        } else if (this.isEager()) {
            this.category = UpdateUnitFactory.BRIDGES_CATEGORY;
        } else if (this.category == null || this.category.length() == 0) {
            this.category = UpdateUnitFactory.UNSORTED_CATEGORY;
        }
        return this.category;
    }

    @Override
    public String getDate() {
        String string = null;
        Date date = null;
        for (ModuleUpdateElementImpl moduleUpdateElementImpl : this.getContainedModuleElements()) {
            String string2 = moduleUpdateElementImpl.getDate();
            if (string2 == null) continue;
            try {
                Date date2 = Utilities.parseDate(string2);
                date = date == null ? date2 : new Date(Math.max(date.getTime(), date2.getTime()));
            }
            catch (ParseException parseException) {
                assert (false) : parseException + " cannot happened.";
            }
        }
        if (date != null) {
            string = Utilities.formatDate(date);
        }
        return string;
    }

    @Override
    public String getLicenseId() {
        String string = "";
        HashSet<String> hashSet = new HashSet<String>();
        for (ModuleUpdateElementImpl moduleUpdateElementImpl : this.getContainedModuleElements()) {
            String string2;
            if (moduleUpdateElementImpl.getUpdateUnit().getAvailableUpdates().isEmpty() || !hashSet.add(string2 = moduleUpdateElementImpl.getUpdateUnit().getAvailableUpdates().get(0).getLicenseId())) continue;
            string = string + (string.length() == 0 ? string2 : "," + string2);
        }
        return string;
    }

    @Override
    public String getLicence() {
        String string = "";
        HashSet<String> hashSet = new HashSet<String>();
        for (ModuleUpdateElementImpl moduleUpdateElementImpl : this.getContainedModuleElements()) {
            String string2;
            if (moduleUpdateElementImpl.getUpdateUnit().getAvailableUpdates().isEmpty() || !hashSet.add(string2 = moduleUpdateElementImpl.getUpdateUnit().getAvailableUpdates().get(0).getLicence())) continue;
            string = string + (string.length() == 0 ? string2 : "<br>" + string2);
        }
        return string;
    }

    @Override
    public InstallInfo getInstallInfo() {
        return this.installInfo;
    }

    @Override
    public List<ModuleInfo> getModuleInfos() {
        return this.getModuleInfos(false);
    }

    @Override
    public List<ModuleInfo> getModuleInfos(boolean bl) {
        ArrayList<ModuleInfo> arrayList = new ArrayList<ModuleInfo>();
        for (ModuleUpdateElementImpl updateElementImpl : this.getContainedModuleElements()) {
            if (arrayList.contains(updateElementImpl.getModuleInfo())) continue;
            arrayList.add(updateElementImpl.getModuleInfo());
        }
        if (bl) {
            for (FeatureUpdateElementImpl featureUpdateElementImpl : this.getDependingFeatures()) {
                for (ModuleUpdateElementImpl moduleUpdateElementImpl : featureUpdateElementImpl.getContainedModuleElements()) {
                    if (arrayList.contains(moduleUpdateElementImpl.getModuleInfo())) continue;
                    arrayList.add(moduleUpdateElementImpl.getModuleInfo());
                }
            }
        }
        return arrayList;
    }

    public Set<ModuleUpdateElementImpl> getContainedModuleElements() {
        assert (this.moduleElementsImpl != null) : "FeatureUpdateElementImpl contains modules " + this.moduleElementsImpl;
        return this.moduleElementsImpl;
    }

    public Set<FeatureUpdateElementImpl> getDependingFeatures() {
        assert (this.featureElementsImpl != null) : "FeatureUpdateElementImpl contains features " + this.featureElementsImpl;
        return this.featureElementsImpl;
    }

    @Override
    public UpdateManager.TYPE getType() {
        return this.type;
    }

    @Override
    public boolean isEnabled() {
        boolean bl = true;
        for (ModuleUpdateElementImpl updateElementImpl : this.getContainedModuleElements()) {
            bl &= updateElementImpl.isEnabled();
        }
        for (FeatureUpdateElementImpl featureUpdateElementImpl : this.getDependingFeatures()) {
            bl &= featureUpdateElementImpl.isEnabled();
        }
        return bl;
    }

    @Override
    public boolean isAutoload() {
        boolean bl = true;
        for (ModuleUpdateElementImpl updateElementImpl : this.getContainedModuleElements()) {
            bl &= updateElementImpl.isAutoload();
        }
        for (FeatureUpdateElementImpl featureUpdateElementImpl : this.getDependingFeatures()) {
            bl &= featureUpdateElementImpl.isAutoload();
        }
        return bl;
    }

    @Override
    public boolean isEager() {
        boolean bl = true;
        for (ModuleUpdateElementImpl updateElementImpl : this.getContainedModuleElements()) {
            bl &= updateElementImpl.isEager();
        }
        for (FeatureUpdateElementImpl featureUpdateElementImpl : this.getDependingFeatures()) {
            bl &= featureUpdateElementImpl.isEager();
        }
        return bl;
    }

    @Override
    public boolean isFixed() {
        boolean bl = true;
        for (ModuleUpdateElementImpl updateElementImpl : this.getContainedModuleElements()) {
            bl &= updateElementImpl.isFixed();
        }
        for (FeatureUpdateElementImpl featureUpdateElementImpl : this.getDependingFeatures()) {
            bl &= featureUpdateElementImpl.isFixed();
        }
        return bl;
    }

    @Override
    public boolean isPreferredUpdate() {
        boolean bl = true;
        for (ModuleUpdateElementImpl updateElementImpl : this.getContainedModuleElements()) {
            bl &= updateElementImpl.isPreferredUpdate();
        }
        for (FeatureUpdateElementImpl featureUpdateElementImpl : this.getDependingFeatures()) {
            bl &= featureUpdateElementImpl.isPreferredUpdate();
        }
        return bl;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        FeatureUpdateElementImpl featureUpdateElementImpl = (FeatureUpdateElementImpl)object;
        if (!(this.specVersion == featureUpdateElementImpl.specVersion || this.specVersion != null && this.specVersion.equals((Object)featureUpdateElementImpl.specVersion))) {
            return false;
        }
        return this.codeName == featureUpdateElementImpl.codeName || this.codeName != null && this.codeName.equals(featureUpdateElementImpl.codeName);
    }

    public int hashCode() {
        int n = 5;
        n = 61 * n + (this.codeName != null ? this.codeName.hashCode() : 0);
        n = 61 * n + (this.specVersion != null ? this.specVersion.hashCode() : 0);
        return n;
    }

    public String toString() {
        return "FeatureUpdateElementImpl[" + this.codeName + "/" + this.specVersion + "]";
    }

    public static class Agent
    extends FeatureUpdateElementImpl {
        private Set<ModuleUpdateElementImpl> moduleElementsImpl;
        private Set<FeatureUpdateElementImpl> featureElementsImpl;
        private FeatureItem featureItem;

        public Agent(FeatureItem featureItem, String string, UpdateManager.TYPE tYPE) {
            super(featureItem, string, null, null, tYPE);
            this.featureItem = featureItem;
        }

        @Override
        public Set<ModuleUpdateElementImpl> getContainedModuleElements() {
            this.initializeAgent();
            assert (this.moduleElementsImpl != null) : "FeatureUpdateElementImpl contains modules " + this.moduleElementsImpl;
            return this.moduleElementsImpl;
        }

        @Override
        public Set<FeatureUpdateElementImpl> getDependingFeatures() {
            this.initializeAgent();
            assert (this.featureElementsImpl != null) : "FeatureUpdateElementImpl depends on features " + this.featureElementsImpl;
            return this.featureElementsImpl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void initializeAgent() {
            Agent agent = this;
            synchronized (agent) {
                if (this.featureElementsImpl == null || this.moduleElementsImpl == null) {
                    HashSet<FeatureUpdateElementImpl> hashSet = new HashSet<FeatureUpdateElementImpl>();
                    this.moduleElementsImpl = this.processContainedModules(this.featureItem.getModuleCodeNames(), null, hashSet);
                    this.featureElementsImpl = hashSet;
                }
            }
        }

        private Set<ModuleUpdateElementImpl> processContainedModules(Set<String> set, UpdateUnitProvider updateUnitProvider, Set<FeatureUpdateElementImpl> set2) {
            Object object;
            String string;
            Object object22;
            HashSet<ModuleUpdateElementImpl> hashSet = new HashSet<ModuleUpdateElementImpl>();
            assert (set != null) : "Invalid Feature " + this + " with null modules.";
            set = set == null ? new HashSet<String>() : new HashSet<String>(set);
            HashSet hashSet2 = new HashSet();
            for (String object42 : set) {
                hashSet2.addAll(Dependency.create((int)1, (String)object42));
            }
            List<UpdateUnit> list = updateUnitProvider == null ? UpdateManager.getDefault().getUpdateUnits(UpdateManager.TYPE.MODULE) : updateUnitProvider.getUpdateUnits(UpdateManager.TYPE.MODULE);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                UpdateUnit updateUnit = (UpdateUnit)iterator.next();
                Object object3 = hashSet2.iterator();
                while (object3.hasNext()) {
                    object22 = (Dependency)object3.next();
                    assert (1 == object22.getType()) : "Only Dependency.TYPE_MODULE supported, but " + object22;
                    string = object22.getName();
                    if (string.indexOf(47) != -1) {
                        int n = string.indexOf(47);
                        string = string.substring(0, n);
                    }
                    if (!updateUnit.getCodeName().equals(string)) continue;
                    UpdateElement updateElement = Agent.getMatchedUpdateElement(updateUnit, (Dependency)object22);
                    if (updateElement != null) {
                        assert (Trampoline.API.impl(updateElement) instanceof ModuleUpdateElementImpl) : "Impl of " + updateElement + " is instanceof ModuleUpdateElementImpl.";
                        object = (ModuleUpdateElementImpl)Trampoline.API.impl(updateElement);
                        hashSet.add((ModuleUpdateElementImpl)object);
                        set.remove(string);
                        object3.remove();
                        continue;
                    }
                    LOG.log(Level.INFO, this.getUpdateUnit() + " requires a module " + string + " what is not present.");
                }
            }
            if (!set.isEmpty()) {
                List<UpdateUnit> list2 = updateUnitProvider == null ? UpdateManager.getDefault().getUpdateUnits(UpdateManager.TYPE.FEATURE) : updateUnitProvider.getUpdateUnits(UpdateManager.TYPE.FEATURE);
                for (Object object3 : list2) {
                    object22 = hashSet2.iterator();
                    while (object22.hasNext()) {
                        string = (Dependency)object22.next();
                        String string2 = string.getName();
                        if (!string2.equals(((UpdateUnit)object3).getCodeName())) continue;
                        object = Agent.getMatchedUpdateElement((UpdateUnit)object3, (Dependency)string);
                        if (object != null) {
                            assert (Trampoline.API.impl((UpdateElement)object) instanceof FeatureUpdateElementImpl) : "Impl of " + object + " is instanceof FeatureUpdateElementImpl.";
                            FeatureUpdateElementImpl featureUpdateElementImpl = (FeatureUpdateElementImpl)Trampoline.API.impl((UpdateElement)object);
                            if (set2.add(featureUpdateElementImpl)) {
                                // empty if block
                            }
                            set.remove(string2);
                            object22.remove();
                            continue;
                        }
                        LOG.log(Level.INFO, this.getUpdateUnit() + " requires a feature " + string2 + " what is not present.");
                    }
                }
            }
            for (String string3 : set) {
                for (Object object22 : Dependency.create((int)1, (String)string3)) {
                    Module module;
                    string = object22.getName();
                    if (string.indexOf(47) != -1) {
                        int n = string.indexOf(47);
                        string = string.substring(0, n);
                    }
                    if ((module = Utilities.toModule(string, null)) == null || module.getProblems().isEmpty()) continue;
                    set.remove(string3);
                }
            }
            if (!set.isEmpty()) {
                throw new IllegalStateException(this.featureItem + " depends on non-existing " + set);
            }
            return hashSet;
        }

        private static UpdateElement getMatchedUpdateElement(UpdateUnit updateUnit, Dependency dependency) {
            if (Agent.match(updateUnit.getInstalled(), dependency)) {
                return updateUnit.getInstalled();
            }
            if (!updateUnit.getAvailableUpdates().isEmpty() && Agent.match(updateUnit.getAvailableUpdates().get(0), dependency)) {
                return updateUnit.getAvailableUpdates().get(0);
            }
            return null;
        }

        private static boolean match(UpdateElement updateElement, Dependency dependency) {
            if (updateElement == null) {
                return false;
            }
            UpdateElementImpl updateElementImpl = Trampoline.API.impl(updateElement);
            if (updateElementImpl instanceof FeatureUpdateElementImpl) {
                if (dependency.getVersion() == null) {
                    return true;
                }
                SpecificationVersion specificationVersion = new SpecificationVersion(dependency.getVersion());
                return specificationVersion.compareTo((Object)updateElementImpl.getSpecificationVersion()) >= 0;
            }
            return DependencyChecker.checkDependencyModuleAllowEqual(dependency, Utilities.takeModuleInfo(updateElement));
        }
    }
}

