/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rcp.application.p2;

import com.jrockit.mc.common.io.IOToolkit;
import com.jrockit.mc.rcp.application.ApplicationPlugin;
import java.io.Closeable;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import org.eclipse.osgi.util.NLS;

public class UpdateSiteURLToolkit {
    private static final Properties UPDATE_PROPERTIES;
    private static final String KEY_UPDATE_SITE_EXPERIMENTAL = "updateSiteExperimental";
    private static final String KEY_UPDATE_SITE_EXPERIMENTAL_ORACLE = "updateSiteExperimentalOracle";
    private static final String KEY_UPDATE_SITE_INTERNAL = "updateSiteInternal";
    private static final String DEFAULT_UPDATE_SITE_EXPERIMENTAL = "http://download.oracle.com/technology/products/missioncontrol/updatesites/experimental/{0}/rcp/";
    private static final String DEFAULT_UPDATE_SITE_EXPERIMENTAL_ORACLE = "http://jrpgftp.se.oracle.com/jmc/updatesites/experimental/{0}/rcp/";
    private static final String DEFAULT_UPDATE_SITE_INTERNAL = "http://jrpgftp.se.oracle.com/jmc/updatesites/internal/{0}/rcp/";
    private static final String KEY_IS_ON_ORACLE_NETWORK = "com.jrockit.mc.updatesite.isonoraclenetwork";

    static {
        block5: {
            UPDATE_PROPERTIES = new Properties();
            InputStream is = null;
            try {
                try {
                    is = UpdateSiteURLToolkit.class.getClassLoader().getResourceAsStream("updates.properties");
                    UPDATE_PROPERTIES.load(is);
                }
                catch (Exception e) {
                    UpdateSiteURLToolkit.fillOutDefaults(UPDATE_PROPERTIES);
                    IOToolkit.closeSilently((Closeable)is);
                    break block5;
                }
            }
            catch (Throwable throwable) {
                IOToolkit.closeSilently(is);
                throw throwable;
            }
            IOToolkit.closeSilently((Closeable)is);
        }
    }

    private UpdateSiteURLToolkit() {
        throw new AssertionError((Object)"Not to be instantiated!");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isOnOracleNetwork() {
        if (System.getProperty(KEY_IS_ON_ORACLE_NETWORK) != null) {
            return Boolean.getBoolean(KEY_IS_ON_ORACLE_NETWORK);
        }
        try {
            for (InetAddress address : UpdateSiteURLToolkit.getAvailableAddresses()) {
                String hostName = address.getHostName();
                if (hostName == null || !hostName.endsWith(".oracle.com") && !hostName.endsWith(".bea.com")) continue;
                ApplicationPlugin.getLogger().info("Found interface bound to oracle internal network (" + hostName + ")! Internal update site activated!");
                return true;
            }
        }
        catch (SocketException e) {
            ApplicationPlugin.getLogger().log(Level.WARNING, "Could not determine local addresses.", e);
            return false;
        }
        ApplicationPlugin.getLogger().info("Could not find interface on Oracle internal network. Oracle internal update site disabled.");
        return false;
    }

    public static String getInternalUpdateSite() {
        return NLS.bind((String)UPDATE_PROPERTIES.getProperty(KEY_UPDATE_SITE_INTERNAL), (Object)ApplicationPlugin.FULL_VERSION);
    }

    public static String getExperimentalUpdateSite() {
        if (UpdateSiteURLToolkit.isOnOracleNetwork()) {
            return NLS.bind((String)UPDATE_PROPERTIES.getProperty(KEY_UPDATE_SITE_EXPERIMENTAL_ORACLE), (Object)ApplicationPlugin.FULL_VERSION);
        }
        return NLS.bind((String)UPDATE_PROPERTIES.getProperty(KEY_UPDATE_SITE_EXPERIMENTAL), (Object)ApplicationPlugin.FULL_VERSION);
    }

    private static List<InetAddress> getAvailableAddresses() throws SocketException {
        ArrayList<InetAddress> addresses = new ArrayList<InetAddress>();
        Enumeration<NetworkInterface> nics = NetworkInterface.getNetworkInterfaces();
        while (nics.hasMoreElements()) {
            NetworkInterface nic = nics.nextElement();
            UpdateSiteURLToolkit.add(nic.getInetAddresses(), addresses);
        }
        return addresses;
    }

    private static void add(Enumeration<InetAddress> inetAddresses, List<InetAddress> addresses) {
        while (inetAddresses.hasMoreElements()) {
            addresses.add(inetAddresses.nextElement());
        }
    }

    private static void fillOutDefaults(Properties updateProperties) {
        updateProperties.put(KEY_UPDATE_SITE_EXPERIMENTAL, DEFAULT_UPDATE_SITE_EXPERIMENTAL);
        updateProperties.put(KEY_UPDATE_SITE_EXPERIMENTAL_ORACLE, DEFAULT_UPDATE_SITE_EXPERIMENTAL_ORACLE);
        updateProperties.put(KEY_UPDATE_SITE_INTERNAL, DEFAULT_UPDATE_SITE_INTERNAL);
    }
}

