/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rcp.application;

import com.jrockit.mc.common.IUserAction;
import com.jrockit.mc.core.AdapterUtil;
import com.jrockit.mc.core.UserActionJob;
import com.jrockit.mc.rcp.application.actions.Messages;
import com.jrockit.mc.ui.UIPlugin;
import com.jrockit.mc.ui.idesupport.OpenHandler;
import java.io.File;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;

public class MissionControlEditorDropAdapter
extends DropTargetAdapter {
    private final IWorkbenchWindow window;

    public MissionControlEditorDropAdapter(IWorkbenchWindow window) {
        this.window = window;
    }

    public void dragEnter(DropTargetEvent event) {
        event.detail = 1;
    }

    public void dragOver(DropTargetEvent event) {
        event.detail = 1;
    }

    public void dragOperationChanged(DropTargetEvent event) {
        event.detail = 1;
    }

    public void drop(DropTargetEvent event) {
        IUserAction action;
        OpenHandler oh;
        Object dropped = event.data;
        if (dropped instanceof IStructuredSelection) {
            dropped = ((IStructuredSelection)dropped).getFirstElement();
        }
        if ((oh = (OpenHandler)AdapterUtil.getAdapter((Object)dropped, OpenHandler.class)) != null) {
            oh.open(this.window, dropped);
        }
        if ((action = (IUserAction)AdapterUtil.getAdapter((Object)dropped, IUserAction.class)) != null) {
            new UserActionJob(action).schedule();
        }
        if (dropped instanceof String[]) {
            final String[] data = (String[])dropped;
            IWorkbenchWindow win = this.window;
            win.getWorkbench().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    String[] stringArray = data;
                    int n = data.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String element = stringArray[n2];
                        MissionControlEditorDropAdapter.this.openFilename(element);
                        ++n2;
                    }
                }
            });
        }
    }

    private void openFilename(String fileName) {
        File file = new File(fileName);
        OpenHandler command = UIPlugin.getDefault().getFiletypeManager().getFileOpener(file.getName());
        if (command != null) {
            command.open(this.window, (Object)file);
        } else {
            String msg = NLS.bind((String)Messages.OpenFileAction_FILEFORMAT_NOT_SUPPORTED_TEXT, (Object)file.getName());
            MessageDialog.openError((Shell)this.window.getShell(), (String)Messages.OpenFileAction_ERROR_WHEN_OPENING_FILE_TEXT_TITLE, (String)msg);
        }
    }
}

