/*
 * Decompiled with CFR 0.152.
 */
package bluej.extensions;

import bluej.debugger.DebuggerObject;
import bluej.debugmgr.objectbench.ObjectWrapper;
import bluej.extensions.BField;
import bluej.extensions.BObject;
import bluej.extensions.DirectInvoker;
import bluej.extensions.Identifier;
import bluej.extensions.InvocationArgumentException;
import bluej.extensions.InvocationErrorException;
import bluej.extensions.PackageNotFoundException;
import bluej.extensions.ProjectNotOpenException;
import bluej.pkgmgr.PkgMgrFrame;
import bluej.views.MethodView;
import bluej.views.View;
import com.sun.jdi.Field;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import java.lang.reflect.Modifier;

public class BMethod {
    private Identifier parentId;
    private MethodView bluej_view;

    BMethod(Identifier aParentId, MethodView i_bluej_view) {
        this.parentId = aParentId;
        this.bluej_view = i_bluej_view;
    }

    public boolean matches(String methodName, Class<?>[] parameter) {
        if (methodName == null) {
            return false;
        }
        if (!methodName.equals(this.bluej_view.getName())) {
            return false;
        }
        Class[] thisArgs = this.bluej_view.getParameters();
        if (thisArgs != null && thisArgs.length <= 0) {
            thisArgs = null;
        }
        if (parameter != null && parameter.length <= 0) {
            parameter = null;
        }
        if (thisArgs == null && parameter == null) {
            return true;
        }
        if (thisArgs == null || parameter == null) {
            return false;
        }
        if (thisArgs.length != parameter.length) {
            return false;
        }
        for (int index = 0; index < thisArgs.length; ++index) {
            if (thisArgs[index].isAssignableFrom(parameter[index])) continue;
            return false;
        }
        return true;
    }

    public String getDeclaringClass() {
        return this.bluej_view.getClassName();
    }

    public Class<?>[] getParameterTypes() {
        return this.bluej_view.getParameters();
    }

    public String getName() {
        return this.bluej_view.getName();
    }

    public Class<?> getReturnType() {
        View aView = this.bluej_view.getReturnType();
        return aView.getViewClass();
    }

    public int getModifiers() {
        return this.bluej_view.getModifiers();
    }

    public Object invoke(BObject onThis, Object[] params) throws ProjectNotOpenException, PackageNotFoundException, InvocationArgumentException, InvocationErrorException {
        PkgMgrFrame pkgFrame;
        DirectInvoker invoker;
        DebuggerObject result;
        ObjectWrapper instanceWrapper = null;
        if (onThis != null) {
            instanceWrapper = onThis.getObjectWrapper();
        }
        if ((result = (invoker = new DirectInvoker(pkgFrame = this.parentId.getPackageFrame())).invokeMethod(instanceWrapper, this.bluej_view, params)) == null || result.isNullObject()) {
            return null;
        }
        String resultName = invoker.getResultName();
        ObjectReference objRef = result.getObjectReference();
        ReferenceType type = objRef.referenceType();
        Field thisField = type.fieldByName("result");
        if (thisField == null) {
            return null;
        }
        return BField.doGetVal(pkgFrame, resultName, objRef.getValue(thisField));
    }

    public String toString() {
        Class<?>[] signature = this.getParameterTypes();
        String sig = "";
        for (int i = 0; i < signature.length; ++i) {
            sig = sig + signature[i].getName() + (i == signature.length - 1 ? "" : ", ");
        }
        String mod = Modifier.toString(this.getModifiers());
        if (mod.length() > 0) {
            mod = mod + " ";
        }
        return mod + this.getReturnType() + " " + this.getName() + "(" + sig + ")";
    }
}

