/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.startup.preferences;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.SyncFailedException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.core.startup.preferences.NbPreferences;
import org.netbeans.core.startup.preferences.Statistics;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.util.EditableProperties;
import org.openide.util.Exceptions;

class PropertiesStorage
implements NbPreferences.FileStorage {
    private static final String USERROOT_PREFIX = "/Preferences";
    private static final String SYSTEMROOT_PREFIX = "/SystemPreferences";
    private static final FileObject SFS_ROOT = FileUtil.getConfigRoot();
    private final String folderPath;
    private String filePath;
    private boolean isModified;
    private FileChangeAdapter fileChangeAdapter;
    private static final Logger LOGGER = Logger.getLogger(PropertiesStorage.class.getName());

    static NbPreferences.FileStorage instance(String string) {
        return new PropertiesStorage(string, true);
    }

    FileObject preferencesRoot() throws IOException {
        return FileUtil.createFolder((FileObject)SFS_ROOT, (String)USERROOT_PREFIX);
    }

    static NbPreferences.FileStorage instanceReadOnly(String string) {
        return new PropertiesStorage(string, false){

            @Override
            public boolean isReadOnly() {
                return true;
            }

            @Override
            public final String[] childrenNames() {
                return new String[0];
            }

            @Override
            public final EditableProperties load() throws IOException {
                return new EditableProperties(true);
            }

            @Override
            protected FileObject toPropertiesFile(boolean bl) throws IOException {
                if (bl) {
                    throw new IOException();
                }
                return null;
            }

            @Override
            protected FileObject toFolder(boolean bl) throws IOException {
                if (bl) {
                    throw new IOException();
                }
                return null;
            }

            @Override
            protected FileObject toPropertiesFile() {
                return null;
            }

            @Override
            protected FileObject toFolder() {
                return null;
            }

            @Override
            FileObject preferencesRoot() throws IOException {
                return FileUtil.createFolder((FileObject)SFS_ROOT, (String)PropertiesStorage.SYSTEMROOT_PREFIX);
            }
        };
    }

    private PropertiesStorage(String string, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = bl ? USERROOT_PREFIX : SYSTEMROOT_PREFIX;
        stringBuilder.append(string2).append(string);
        this.folderPath = stringBuilder.toString();
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public void markModified() {
        this.isModified = true;
    }

    @Override
    public final boolean existsNode() {
        return this.toPropertiesFile() != null || this.toFolder() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] childrenNames() {
        Statistics.StopWatch stopWatch = Statistics.getStopWatch(Statistics.CHILDREN_NAMES, true);
        try {
            FileObject fileObject = this.toFolder();
            ArrayList<String> arrayList = new ArrayList<String>();
            if (fileObject != null) {
                block3: for (FileObject fileObject2 : Collections.list(fileObject.getFolders(false))) {
                    Enumeration enumeration = fileObject2.getChildren(true);
                    while (enumeration.hasMoreElements()) {
                        FileObject fileObject3 = (FileObject)enumeration.nextElement();
                        if (!fileObject3.hasExt("properties")) continue;
                        arrayList.add(fileObject2.getNameExt());
                        continue block3;
                    }
                }
                for (FileObject fileObject2 : Collections.list(fileObject.getData(false))) {
                    if (!fileObject2.hasExt("properties")) continue;
                    arrayList.add(fileObject2.getName());
                }
            }
            String[] stringArray = arrayList.toArray(new String[arrayList.size()]);
            return stringArray;
        }
        finally {
            stopWatch.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void removeNode() throws IOException {
        Statistics.StopWatch stopWatch = Statistics.getStopWatch(Statistics.REMOVE_NODE, true);
        try {
            FileObject fileObject = this.toPropertiesFile();
            if (fileObject != null && fileObject.isValid()) {
                fileObject.delete();
                for (FileObject fileObject2 = fileObject.getParent(); fileObject2 != null && fileObject2 != this.preferencesRoot() && fileObject2.getChildren().length == 0; fileObject2 = fileObject2.getParent()) {
                    fileObject2.delete();
                }
            }
        }
        finally {
            stopWatch.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EditableProperties load() throws IOException {
        Statistics.StopWatch stopWatch = Statistics.getStopWatch(Statistics.LOAD, true);
        try {
            Object object;
            EditableProperties editableProperties = new EditableProperties(true);
            FileObject fileObject = this.toPropertiesFile(false);
            if (fileObject != null) {
                try {
                    object = fileObject.getInputStream();
                    try {
                        editableProperties.load((InputStream)object);
                    }
                    finally {
                        ((InputStream)object).close();
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    Logger.getLogger(PropertiesStorage.class.getName()).log(Level.INFO, "While loading " + fileObject, illegalArgumentException);
                    fileObject.delete();
                }
            }
            object = editableProperties;
            return object;
        }
        finally {
            stopWatch.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void save(EditableProperties editableProperties) throws IOException {
        if (!this.isModified) return;
        Statistics.StopWatch stopWatch = Statistics.getStopWatch(Statistics.FLUSH, true);
        try {
            this.isModified = false;
            if (!editableProperties.isEmpty()) {
                OutputStream outputStream = null;
                try {
                    outputStream = this.outputStream();
                    editableProperties.store(outputStream);
                    if (outputStream == null) return;
                }
                catch (Throwable throwable) {
                    if (outputStream == null) throw throwable;
                    LOGGER.log(Level.FINE, "Closing output-stream for file {0} in {1}.", new Object[]{this.filePath, this.folderPath});
                    outputStream.close();
                    throw throwable;
                }
                LOGGER.log(Level.FINE, "Closing output-stream for file {0} in {1}.", new Object[]{this.filePath, this.folderPath});
                outputStream.close();
                return;
            }
            FileObject fileObject = this.toPropertiesFile();
            if (fileObject != null) {
                fileObject.delete();
            }
            for (FileObject fileObject2 = this.toFolder(); fileObject2 != null && fileObject2 != this.preferencesRoot() && fileObject2.getChildren().length == 0; fileObject2 = fileObject2.getParent()) {
                fileObject2.delete();
            }
            return;
        }
        finally {
            stopWatch.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OutputStream outputStream() throws IOException {
        FileObject fileObject = this.toPropertiesFile(true);
        final FileLock fileLock = fileObject.lock();
        OutputStream outputStream = null;
        try {
            outputStream = fileObject.getOutputStream(fileLock);
        }
        finally {
            if (outputStream == null && fileLock != null) {
                fileLock.releaseLock();
            }
        }
        return new FilterOutputStream(outputStream){

            @Override
            public void close() throws IOException {
                super.close();
                fileLock.releaseLock();
            }
        };
    }

    private String folderPath() {
        return this.folderPath;
    }

    private String filePath() {
        if (this.filePath == null) {
            String[] stringArray = this.folderPath().split("/");
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < stringArray.length - 1; ++i) {
                stringBuilder.append(stringArray[i]).append("/");
            }
            if (stringArray.length > 0) {
                stringBuilder.append(stringArray[stringArray.length - 1]).append(".properties");
            } else {
                stringBuilder.append("root.properties");
            }
            this.filePath = stringBuilder.toString();
        }
        return this.filePath;
    }

    protected FileObject toFolder() {
        return SFS_ROOT.getFileObject(this.folderPath());
    }

    protected FileObject toPropertiesFile() {
        return SFS_ROOT.getFileObject(this.filePath());
    }

    protected FileObject toFolder(boolean bl) throws IOException {
        FileObject fileObject = this.toFolder();
        if (fileObject == null && bl) {
            fileObject = FileUtil.createFolder((FileObject)SFS_ROOT, (String)this.folderPath);
        }
        assert (fileObject == null && !bl || fileObject != null && fileObject.isFolder());
        return fileObject;
    }

    protected FileObject toPropertiesFile(boolean bl) throws IOException {
        FileObject fileObject = this.toPropertiesFile();
        if (fileObject == null && bl) {
            SFS_ROOT.refresh();
            fileObject = this.toPropertiesFile();
            if (fileObject == null) {
                try {
                    fileObject = FileUtil.createData((FileObject)SFS_ROOT, (String)this.filePath());
                }
                catch (SyncFailedException syncFailedException) {
                    fileObject = this.toPropertiesFile();
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
                    LOGGER.log(Level.WARNING, "File {0} seems to already exist.\nCurrent date/time: {1}\nLast modified: {2}\nContents: {3}", new Object[]{FileUtil.toFile((FileObject)fileObject).getAbsolutePath(), simpleDateFormat.format(Calendar.getInstance()), simpleDateFormat.format(fileObject.lastModified()), fileObject.asText()});
                }
            }
        }
        assert (fileObject == null && !bl || fileObject != null && fileObject.isData());
        return fileObject;
    }

    @Override
    public void runAtomic(final Runnable runnable) {
        try {
            SFS_ROOT.getFileSystem().runAtomicAction(new FileSystem.AtomicAction(){

                public void run() throws IOException {
                    runnable.run();
                }
            });
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
    }

    @Override
    public void attachChangeListener(final ChangeListener changeListener) {
        try {
            this.fileChangeAdapter = new FileChangeAdapter(){

                public void fileDataCreated(FileEvent fileEvent) {
                    if (fileEvent.getFile().equals(PropertiesStorage.this.toPropertiesFile())) {
                        changeListener.stateChanged(new ChangeEvent(PropertiesStorage.this));
                    }
                }

                public void fileFolderCreated(FileEvent fileEvent) {
                    if (fileEvent.getFile().equals(PropertiesStorage.this.toPropertiesFile())) {
                        changeListener.stateChanged(new ChangeEvent(PropertiesStorage.this));
                    }
                }

                public void fileChanged(FileEvent fileEvent) {
                    if (fileEvent.getFile().equals(PropertiesStorage.this.toPropertiesFile())) {
                        changeListener.stateChanged(new ChangeEvent(PropertiesStorage.this));
                    }
                }

                public void fileDeleted(FileEvent fileEvent) {
                    if (fileEvent.getFile().equals(PropertiesStorage.this.toPropertiesFile())) {
                        changeListener.stateChanged(new ChangeEvent(PropertiesStorage.this));
                    }
                }

                public void fileRenamed(FileRenameEvent fileRenameEvent) {
                    if (fileRenameEvent.getFile().equals(PropertiesStorage.this.toPropertiesFile())) {
                        changeListener.stateChanged(new ChangeEvent(PropertiesStorage.this));
                    }
                }
            };
            SFS_ROOT.getFileSystem().addFileChangeListener(FileUtil.weakFileChangeListener((FileChangeListener)this.fileChangeAdapter, (Object)SFS_ROOT.getFileSystem()));
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            Exceptions.printStackTrace((Throwable)fileStateInvalidException);
        }
    }
}

