/*
 * Decompiled with CFR 0.152.
 */
package org.openide.awt;

import java.awt.Component;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.lang.ref.WeakReference;
import javax.activation.DataContentHandler;
import javax.activation.DataContentHandlerFactory;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.openide.util.ImageUtilities;
import org.openide.util.RequestProcessor;

public class QuickSearch {
    private static final String ICON_FIND = "org/openide/awt/resources/quicksearch/find.png";
    private static final String ICON_FIND_WITH_MENU = "org/openide/awt/resources/quicksearch/findMenu.png";
    private static final Object CLIENT_PROPERTY_KEY = new Object();
    private final JComponent component;
    private final Object constraints;
    private final Callback callback;
    private final JMenu popupMenu;
    private final boolean asynchronous;
    private boolean enabled = true;
    private SearchTextField searchTextField;
    private KeyAdapter quickSearchKeyAdapter;
    private SearchFieldListener searchFieldListener;
    private JPanel searchPanel;
    private final RequestProcessor rp;
    private AnimationTimer animationTimer;
    private boolean alwaysShown = false;

    private QuickSearch(JComponent jComponent, Object object, Callback callback, boolean bl, JMenu jMenu) {
        this.component = jComponent;
        this.constraints = object;
        this.callback = callback;
        this.asynchronous = bl;
        this.popupMenu = jMenu;
        this.rp = bl ? new RequestProcessor(QuickSearch.class) : null;
        this.setUpSearch();
    }

    public static QuickSearch attach(JComponent jComponent, Object object, Callback callback) {
        return QuickSearch.attach(jComponent, object, callback, false, null);
    }

    public static QuickSearch attach(JComponent jComponent, Object object, Callback callback, boolean bl) {
        return QuickSearch.attach(jComponent, object, callback, bl, null);
    }

    public static QuickSearch attach(JComponent jComponent, Object object, Callback callback, JMenu jMenu) {
        return QuickSearch.attach(jComponent, object, callback, false, jMenu);
    }

    public static QuickSearch attach(JComponent jComponent, Object object, Callback callback, boolean bl, JMenu jMenu) {
        Object object2 = jComponent.getClientProperty(CLIENT_PROPERTY_KEY);
        if (object2 instanceof QuickSearch) {
            throw new IllegalStateException("A quick search is attached to this component already, detach it first.");
        }
        QuickSearch quickSearch = new QuickSearch(jComponent, object, callback, bl, jMenu);
        jComponent.putClientProperty(CLIENT_PROPERTY_KEY, quickSearch);
        return quickSearch;
    }

    public void detach() {
        this.setEnabled(false);
        this.component.putClientProperty(CLIENT_PROPERTY_KEY, null);
    }

    public boolean isAlwaysShown() {
        return this.alwaysShown;
    }

    public void setAlwaysShown(boolean bl) {
        this.alwaysShown = bl;
        if (bl) {
            this.displaySearchField();
        } else {
            this.removeSearchField();
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean bl) {
        if (this.enabled == bl) {
            return;
        }
        this.enabled = bl;
        if (bl) {
            this.component.addKeyListener(this.quickSearchKeyAdapter);
        } else {
            this.removeSearchField();
            this.component.removeKeyListener(this.quickSearchKeyAdapter);
        }
    }

    public void processKeyEvent(KeyEvent keyEvent) {
        if (!this.isEnabled()) {
            return;
        }
        if (this.searchPanel != null) {
            this.searchTextField.setCaretPosition(this.searchTextField.getText().length());
            this.searchTextField.processKeyEvent(keyEvent);
        } else {
            switch (keyEvent.getID()) {
                case 401: {
                    this.quickSearchKeyAdapter.keyPressed(keyEvent);
                    break;
                }
                case 402: {
                    this.quickSearchKeyAdapter.keyReleased(keyEvent);
                    break;
                }
                case 400: {
                    this.quickSearchKeyAdapter.keyTyped(keyEvent);
                }
            }
        }
    }

    private void fireQuickSearchUpdate(String string) {
        if (this.asynchronous) {
            this.rp.post((Runnable)new LazyFire(QS_FIRE.UPDATE, string));
        } else {
            this.callback.quickSearchUpdate(string);
        }
    }

    private void fireShowNextSelection(boolean bl) {
        if (this.asynchronous) {
            this.rp.post((Runnable)new LazyFire(QS_FIRE.NEXT, bl));
        } else {
            this.callback.showNextSelection(bl);
        }
    }

    private void findMaxPrefix(String string, DataContentHandlerFactory dataContentHandlerFactory) {
        if (this.asynchronous) {
            this.rp.post((Runnable)new LazyFire(QS_FIRE.MAX, string, dataContentHandlerFactory));
        } else {
            string = this.callback.findMaxPrefix(string);
            dataContentHandlerFactory.createDataContentHandler(string);
        }
    }

    private void setUpSearch() {
        this.searchTextField = new SearchTextField();
        this.quickSearchKeyAdapter = new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
                int n = keyEvent.getModifiers();
                int n2 = keyEvent.getKeyCode();
                char c = keyEvent.getKeyChar();
                if (c == '+' || c == '-' || c == ' ') {
                    return;
                }
                if (n > 0 && n != 1 || keyEvent.isActionKey()) {
                    return;
                }
                if (Character.isISOControl(c) || n2 == 16 || n2 == 27) {
                    return;
                }
                QuickSearch.this.displaySearchField();
                KeyStroke keyStroke = KeyStroke.getKeyStrokeForEvent(keyEvent);
                QuickSearch.this.searchTextField.setText(String.valueOf(keyStroke.getKeyChar()));
                keyEvent.consume();
            }
        };
        if (this.isEnabled()) {
            this.component.addKeyListener(this.quickSearchKeyAdapter);
        }
        this.searchFieldListener = new SearchFieldListener();
        this.searchTextField.addKeyListener(this.searchFieldListener);
        this.searchTextField.addFocusListener(this.searchFieldListener);
        this.searchTextField.getDocument().addDocumentListener(this.searchFieldListener);
        if (this.isAlwaysShown()) {
            this.displaySearchField();
        }
    }

    private void displaySearchField() {
        JLabel jLabel;
        if (this.searchPanel != null || !this.isEnabled()) {
            return;
        }
        this.searchTextField.setOriginalFocusOwner();
        this.searchTextField.setFont(this.component.getFont());
        this.searchPanel = new SearchPanel(this.component, this.isAlwaysShown());
        if (this.popupMenu != null) {
            jLabel = new JLabel(ImageUtilities.loadImageIcon((String)ICON_FIND_WITH_MENU, (boolean)false));
            jLabel.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent mouseEvent) {
                    QuickSearch.this.maybeShowPopup(mouseEvent, jLabel);
                }
            });
        } else {
            jLabel = new JLabel(ImageUtilities.loadImageIcon((String)ICON_FIND, (boolean)false));
        }
        this.animationTimer = this.asynchronous ? new AnimationTimer(jLabel, jLabel.getIcon()) : null;
        this.searchPanel.setLayout(new BoxLayout(this.searchPanel, 0));
        if ("Aqua".equals(UIManager.getLookAndFeel().getID())) {
            if (this.popupMenu != null) {
                final JPopupMenu jPopupMenu = new JPopupMenu();
                jPopupMenu.addPopupMenuListener(new PopupMenuListener(){

                    @Override
                    public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                jPopupMenu.setVisible(false);
                            }
                        });
                    }

                    @Override
                    public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
                    }

                    @Override
                    public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
                    }
                });
                this.searchTextField.putClientProperty("JTextField.Search.FindPopup", jPopupMenu);
                this.searchTextField.putClientProperty("JTextField.Search.FindAction", new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        QuickSearch.this.maybeShowPopup(null, QuickSearch.this.searchTextField);
                    }
                });
            }
        } else {
            this.searchPanel.add(jLabel);
        }
        this.searchPanel.add(this.searchTextField);
        this.searchPanel.setBackground(this.component.getBackground());
        jLabel.setLabelFor(this.searchTextField);
        this.searchTextField.setColumns(10);
        this.searchTextField.setMaximumSize(this.searchTextField.getPreferredSize());
        this.searchTextField.putClientProperty("JTextField.variant", "search");
        jLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 5));
        if (this.constraints == null) {
            this.component.add(this.searchPanel);
        } else {
            this.component.add((Component)this.searchPanel, this.constraints);
        }
        this.component.invalidate();
        this.component.revalidate();
        this.component.repaint();
        this.searchTextField.requestFocus();
    }

    protected void maybeShowPopup(MouseEvent mouseEvent, Component component) {
        if (mouseEvent != null && !SwingUtilities.isLeftMouseButton(mouseEvent)) {
            return;
        }
        JPopupMenu jPopupMenu = this.popupMenu.getPopupMenu();
        jPopupMenu.show(component, 0, component.getHeight() - 1);
        this.searchTextField.setText("");
        this.searchTextField.requestOriginalFocusOwner();
    }

    private void removeSearchField() {
        if (this.isAlwaysShown()) {
            return;
        }
        if (this.searchPanel == null) {
            return;
        }
        if (this.animationTimer != null) {
            this.animationTimer.stopProgressAnimation();
        }
        JPanel jPanel = this.searchPanel;
        this.searchPanel = null;
        this.component.remove(jPanel);
        this.component.invalidate();
        this.component.revalidate();
        this.component.repaint();
    }

    JTextField getSearchField() {
        return this.searchTextField;
    }

    public static String findMaxPrefix(String string, String string2, boolean bl) {
        int n;
        int n2 = string.length();
        int n3 = string2.length();
        if (bl) {
            char c;
            char c2;
            for (n = 0; n < n2 && n < n3 && (c2 = Character.toUpperCase(string.charAt(n))) == (c = Character.toUpperCase(string2.charAt(n))); ++n) {
            }
        } else {
            char c;
            char c3;
            while (n < n2 && n < n3 && (c3 = string.charAt(n)) == (c = string2.charAt(n))) {
                ++n;
            }
        }
        return string.substring(0, n);
    }

    public static interface Callback {
        public void quickSearchUpdate(String var1);

        public void showNextSelection(boolean var1);

        public String findMaxPrefix(String var1);

        public void quickSearchConfirmed();

        public void quickSearchCanceled();
    }

    private class SearchFieldListener
    extends KeyAdapter
    implements DocumentListener,
    FocusListener {
        private boolean ignoreEvents;

        SearchFieldListener() {
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            if (this.ignoreEvents) {
                return;
            }
            this.searchForNode();
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            if (this.ignoreEvents) {
                return;
            }
            this.searchForNode();
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            if (this.ignoreEvents) {
                return;
            }
            this.searchForNode();
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            int n = keyEvent.getKeyCode();
            if (n == 27) {
                QuickSearch.this.removeSearchField();
                QuickSearch.this.searchTextField.requestOriginalFocusOwner();
                QuickSearch.this.callback.quickSearchCanceled();
                keyEvent.consume();
            } else if (n == 38 || n == 114 && keyEvent.isShiftDown()) {
                QuickSearch.this.fireShowNextSelection(false);
                keyEvent.consume();
            } else if (n == 40 || n == 114) {
                QuickSearch.this.fireShowNextSelection(true);
                keyEvent.consume();
            } else if (n == 9) {
                QuickSearch.this.findMaxPrefix(QuickSearch.this.searchTextField.getText(), new DataContentHandlerFactory(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public DataContentHandler createDataContentHandler(final String string) {
                        if (!SwingUtilities.isEventDispatchThread()) {
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    this.createDataContentHandler(string);
                                }
                            });
                            return null;
                        }
                        SearchFieldListener.this.ignoreEvents = true;
                        try {
                            QuickSearch.this.searchTextField.setText(string);
                        }
                        finally {
                            SearchFieldListener.this.ignoreEvents = false;
                        }
                        return null;
                    }
                });
                keyEvent.consume();
            } else if (n == 10) {
                QuickSearch.this.removeSearchField();
                QuickSearch.this.callback.quickSearchConfirmed();
                QuickSearch.this.component.requestFocusInWindow();
                keyEvent.consume();
            }
        }

        private void searchForNode() {
            String string = QuickSearch.this.searchTextField.getText();
            QuickSearch.this.fireQuickSearchUpdate(string);
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
            if (focusEvent.getSource() == QuickSearch.this.searchTextField) {
                int n = QuickSearch.this.searchTextField.getText().length();
                QuickSearch.this.searchTextField.select(n, n);
            }
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            if (focusEvent.isTemporary() || QuickSearch.this.isAlwaysShown()) {
                return;
            }
            Component component = focusEvent.getOppositeComponent();
            if (focusEvent.getSource() != QuickSearch.this.searchTextField) {
                ((Component)focusEvent.getSource()).removeFocusListener(this);
            }
            if (component instanceof JMenuItem || component instanceof JPopupMenu) {
                component.addFocusListener(this);
                return;
            }
            if (component == QuickSearch.this.searchTextField) {
                return;
            }
            if (QuickSearch.this.searchPanel != null) {
                QuickSearch.this.removeSearchField();
                QuickSearch.this.callback.quickSearchCanceled();
            }
        }
    }

    private class SearchTextField
    extends JTextField {
        private WeakReference<Component> originalFocusOwner = new WeakReference<Object>(null);

        void setOriginalFocusOwner() {
            Component component = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
            this.originalFocusOwner = component != null && QuickSearch.this.component.isAncestorOf(component) ? new WeakReference<Component>(component) : new WeakReference<JComponent>(QuickSearch.this.component);
        }

        void requestOriginalFocusOwner() {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Component component = (Component)SearchTextField.this.originalFocusOwner.get();
                    if (component != null) {
                        component.requestFocusInWindow();
                    }
                }
            });
        }

        @Override
        public boolean isManagingFocus() {
            return true;
        }

        @Override
        public void processKeyEvent(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 27) {
                QuickSearch.this.removeSearchField();
                keyEvent.consume();
                this.requestOriginalFocusOwner();
                QuickSearch.this.callback.quickSearchCanceled();
            } else {
                super.processKeyEvent(keyEvent);
            }
        }
    }

    private static class SearchPanel
    extends JPanel {
        public static final boolean isAquaLaF = "Aqua".equals(UIManager.getLookAndFeel().getID());
        private JComponent component;
        private boolean alwaysShown = false;

        public SearchPanel(JComponent jComponent, boolean bl) {
            this.component = jComponent;
            this.alwaysShown = bl;
            if (isAquaLaF) {
                this.setBorder(BorderFactory.createEmptyBorder(9, 6, 8, 2));
            } else {
                this.setBorder(BorderFactory.createEmptyBorder(2, 6, 2, 2));
            }
            this.setOpaque(true);
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            if (isAquaLaF && graphics instanceof Graphics2D) {
                Graphics2D graphics2D = (Graphics2D)graphics;
                if (this.alwaysShown) {
                    graphics2D.setColor(this.component.getBackground());
                    graphics2D.fillRect(0, 0, this.getWidth(), this.getHeight());
                } else {
                    graphics2D.setPaint(new GradientPaint(0.0f, 0.0f, UIManager.getColor("NbExplorerView.quicksearch.background.top"), 0.0f, this.getHeight(), UIManager.getColor("NbExplorerView.quicksearch.background.bottom")));
                    graphics2D.fillRect(0, 0, this.getWidth(), this.getHeight());
                    graphics2D.setColor(UIManager.getColor("NbExplorerView.quicksearch.border"));
                    graphics2D.drawLine(0, 0, this.getWidth(), 0);
                }
            } else {
                super.paintComponent(graphics);
            }
        }
    }

    private class LazyFire
    implements Runnable {
        private final QS_FIRE fire;
        private final String searchText;
        private final boolean forward;
        private final DataContentHandlerFactory newPrefixSetter;

        LazyFire(QS_FIRE qS_FIRE, String string) {
            this(qS_FIRE, string, true, null);
        }

        LazyFire(QS_FIRE qS_FIRE, boolean bl) {
            this(qS_FIRE, null, bl);
        }

        LazyFire(QS_FIRE qS_FIRE, String string, boolean bl) {
            this(qS_FIRE, string, bl, null);
        }

        LazyFire(QS_FIRE qS_FIRE, String string, DataContentHandlerFactory dataContentHandlerFactory) {
            this(qS_FIRE, string, true, dataContentHandlerFactory);
        }

        LazyFire(QS_FIRE qS_FIRE, String string, boolean bl, DataContentHandlerFactory dataContentHandlerFactory) {
            this.fire = qS_FIRE;
            this.searchText = string;
            this.forward = bl;
            this.newPrefixSetter = dataContentHandlerFactory;
            QuickSearch.this.animationTimer.startProgressAnimation();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            try {
                switch (this.fire) {
                    case UPDATE: {
                        QuickSearch.this.callback.quickSearchUpdate(this.searchText);
                        return;
                    }
                    case NEXT: {
                        QuickSearch.this.callback.showNextSelection(this.forward);
                        return;
                    }
                    case MAX: {
                        String string = QuickSearch.this.callback.findMaxPrefix(this.searchText);
                        this.newPrefixSetter.createDataContentHandler(string);
                        return;
                    }
                }
                return;
            }
            finally {
                QuickSearch.this.animationTimer.stopProgressAnimation();
            }
        }
    }

    private static final class AnimationTimer {
        private final JLabel jLabel;
        private final Icon findIcon;
        private final Timer animationTimer;

        public AnimationTimer(final JLabel jLabel, Icon icon) {
            this.jLabel = jLabel;
            this.findIcon = icon;
            this.animationTimer = new Timer(100, new ActionListener(){
                ImageIcon[] icons;
                int index = 0;

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (this.icons == null) {
                        this.icons = new ImageIcon[8];
                        for (int i = 0; i < 8; ++i) {
                            this.icons[i] = ImageUtilities.loadImageIcon((String)("org/openide/awt/resources/quicksearch/progress_" + i + ".png"), (boolean)false);
                        }
                    }
                    jLabel.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 6));
                    jLabel.setIcon(this.icons[this.index]);
                    jLabel.repaint();
                    this.index = (this.index + 1) % 8;
                }
            });
        }

        public void startProgressAnimation() {
            if (this.animationTimer != null && !this.animationTimer.isRunning()) {
                this.animationTimer.start();
            }
        }

        public void stopProgressAnimation() {
            if (this.animationTimer != null && this.animationTimer.isRunning()) {
                this.animationTimer.stop();
                this.jLabel.setIcon(this.findIcon);
                this.jLabel.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
            }
        }
    }

    private static enum QS_FIRE {
        UPDATE,
        NEXT,
        MAX;

    }
}

