/*
 * Decompiled with CFR 0.152.
 */
package org.openide.awt;

import java.awt.Dimension;
import java.awt.Image;
import java.awt.Toolkit;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.UIManager;
import org.openide.util.ImageUtilities;

public final class CloseButtonFactory {
    private static Image closeTabImage;
    private static Image closeTabPressedImage;
    private static Image closeTabMouseOverImage;
    private static Image bigCloseTabImage;
    private static Image bigCloseTabPressedImage;
    private static Image bigCloseTabMouseOverImage;

    private CloseButtonFactory() {
    }

    public static JButton createCloseButton() {
        JButton jButton = new JButton();
        int n = 16;
        jButton.setPreferredSize(new Dimension(n, n));
        jButton.setContentAreaFilled(false);
        jButton.setFocusable(false);
        jButton.setBorder(BorderFactory.createEmptyBorder());
        jButton.setBorderPainted(false);
        jButton.setRolloverEnabled(true);
        jButton.setIcon(ImageUtilities.image2Icon((Image)CloseButtonFactory.getCloseTabImage()));
        jButton.setRolloverIcon(ImageUtilities.image2Icon((Image)CloseButtonFactory.getCloseTabRolloverImage()));
        jButton.setPressedIcon(ImageUtilities.image2Icon((Image)CloseButtonFactory.getCloseTabPressedImage()));
        return jButton;
    }

    public static JButton createBigCloseButton() {
        JButton jButton = new JButton();
        int n = 19;
        jButton.setPreferredSize(new Dimension(n, n));
        jButton.setContentAreaFilled(false);
        jButton.setFocusable(false);
        jButton.setBorder(BorderFactory.createEmptyBorder());
        jButton.setBorderPainted(false);
        jButton.setRolloverEnabled(true);
        jButton.setIcon(ImageUtilities.image2Icon((Image)CloseButtonFactory.getBigCloseTabImage()));
        jButton.setRolloverIcon(ImageUtilities.image2Icon((Image)CloseButtonFactory.getBigCloseTabRolloverImage()));
        jButton.setPressedIcon(ImageUtilities.image2Icon((Image)CloseButtonFactory.getBigCloseTabPressedImage()));
        return jButton;
    }

    private static boolean isWindowsVistaLaF() {
        return CloseButtonFactory.isWindowsLaF() && (CloseButtonFactory.isWindowsVista() || CloseButtonFactory.isWindows7()) && CloseButtonFactory.isWindowsXPLaF();
    }

    private static boolean isWindows8LaF() {
        return CloseButtonFactory.isWindowsLaF() && CloseButtonFactory.isWindows8() && CloseButtonFactory.isWindowsXPLaF();
    }

    private static boolean isWindowsVista() {
        String string = System.getProperty("os.name");
        return string.indexOf("Vista") >= 0 || string.equals("Windows NT (unknown)") && "6.0".equals(System.getProperty("os.version"));
    }

    private static boolean isWindows8() {
        String string = System.getProperty("os.name");
        return string.indexOf("Windows 8") >= 0 || string.equals("Windows NT (unknown)") && "6.2".equals(System.getProperty("os.version"));
    }

    private static boolean isWindows7() {
        String string = System.getProperty("os.name");
        return string.indexOf("Windows 7") >= 0 || string.equals("Windows NT (unknown)") && "6.1".equals(System.getProperty("os.version"));
    }

    private static boolean isWindowsXPLaF() {
        Boolean bl = (Boolean)Toolkit.getDefaultToolkit().getDesktopProperty("win.xpstyle.themeActive");
        return CloseButtonFactory.isWindowsLaF() && bl != null && bl != false;
    }

    private static boolean isWindowsLaF() {
        String string = UIManager.getLookAndFeel().getID();
        return string.endsWith("Windows");
    }

    private static boolean isAquaLaF() {
        return "Aqua".equals(UIManager.getLookAndFeel().getID());
    }

    private static boolean isGTKLaF() {
        return "GTK".equals(UIManager.getLookAndFeel().getID());
    }

    private static Image getCloseTabImage() {
        if (null == closeTabImage) {
            closeTabImage = CloseButtonFactory.isWindows8LaF() ? ImageUtilities.loadImage((String)"org/openide/awt/resources/win8_bigclose_enabled.png") : (CloseButtonFactory.isWindowsVistaLaF() ? ImageUtilities.loadImage((String)"org/openide/awt/resources/vista_close_enabled.png") : (CloseButtonFactory.isWindowsXPLaF() ? ImageUtilities.loadImage((String)"org/openide/awt/resources/xp_close_enabled.png") : (CloseButtonFactory.isWindowsLaF() ? ImageUtilities.loadImage((String)"org/openide/awt/resources/win_close_enabled.png") : (CloseButtonFactory.isAquaLaF() ? ImageUtilities.loadImage((String)"org/openide/awt/resources/mac_close_enabled.png") : (CloseButtonFactory.isGTKLaF() ? ImageUtilities.loadImage((String)"org/openide/awt/resources/gtk_close_enabled.png") : ImageUtilities.loadImage((String)"org/openide/awt/resources/metal_close_enabled.png"))))));
        }
        return closeTabImage;
    }

    private static Image getCloseTabPressedImage() {
        if (null == closeTabPressedImage) {
            closeTabPressedImage = CloseButtonFactory.isWindows8LaF() ? ImageUtilities.loadImage((String)"org/openide/awt/resources/win8_bigclose_pressed.png") : (CloseButtonFactory.isWindowsVistaLaF() ? ImageUtilities.loadImage((String)"org/openide/awt/resources/vista_close_pressed.png") : (CloseButtonFactory.isWindowsXPLaF() ? ImageUtilities.loadImage((String)"org/openide/awt/resources/xp_close_pressed.png") : (CloseButtonFactory.isWindowsLaF() ? ImageUtilities.loadImage((String)"org/openide/awt/resources/win_close_pressed.png") : (CloseButtonFactory.isAquaLaF() ? ImageUtilities.loadImage((String)"org/openide/awt/resources/mac_close_pressed.png") : (CloseButtonFactory.isGTKLaF() ? ImageUtilities.loadImage((String)"org/openide/awt/resources/gtk_close_pressed.png") : ImageUtilities.loadImage((String)"org/openide/awt/resources/metal_close_pressed.png"))))));
        }
        return closeTabPressedImage;
    }

    private static Image getCloseTabRolloverImage() {
        if (null == closeTabMouseOverImage) {
            closeTabMouseOverImage = CloseButtonFactory.isWindows8LaF() ? ImageUtilities.loadImage((String)"org/openide/awt/resources/win8_bigclose_rollover.png") : (CloseButtonFactory.isWindowsVistaLaF() ? ImageUtilities.loadImage((String)"org/openide/awt/resources/vista_close_rollover.png") : (CloseButtonFactory.isWindowsXPLaF() ? ImageUtilities.loadImage((String)"org/openide/awt/resources/xp_close_rollover.png") : (CloseButtonFactory.isWindowsLaF() ? ImageUtilities.loadImage((String)"org/openide/awt/resources/win_close_rollover.png") : (CloseButtonFactory.isAquaLaF() ? ImageUtilities.loadImage((String)"org/openide/awt/resources/mac_close_rollover.png") : (CloseButtonFactory.isGTKLaF() ? ImageUtilities.loadImage((String)"org/openide/awt/resources/gtk_close_rollover.png") : ImageUtilities.loadImage((String)"org/openide/awt/resources/metal_close_rollover.png"))))));
        }
        return closeTabMouseOverImage;
    }

    private static Image getBigCloseTabImage() {
        if (null == bigCloseTabImage) {
            bigCloseTabImage = CloseButtonFactory.isWindows8LaF() ? ImageUtilities.loadImage((String)"org/openide/awt/resources/win8_bigclose_enabled.png") : (CloseButtonFactory.isWindowsVistaLaF() ? ImageUtilities.loadImage((String)"org/openide/awt/resources/vista_bigclose_enabled.png") : (CloseButtonFactory.isWindowsXPLaF() ? ImageUtilities.loadImage((String)"org/openide/awt/resources/xp_bigclose_enabled.png") : (CloseButtonFactory.isWindowsLaF() ? ImageUtilities.loadImage((String)"org/openide/awt/resources/win_bigclose_enabled.png") : (CloseButtonFactory.isAquaLaF() ? ImageUtilities.loadImage((String)"org/openide/awt/resources/mac_bigclose_enabled.png") : (CloseButtonFactory.isGTKLaF() ? ImageUtilities.loadImage((String)"org/openide/awt/resources/gtk_bigclose_enabled.png") : ImageUtilities.loadImage((String)"org/openide/awt/resources/metal_bigclose_enabled.png"))))));
        }
        return bigCloseTabImage;
    }

    private static Image getBigCloseTabPressedImage() {
        if (null == bigCloseTabPressedImage) {
            bigCloseTabPressedImage = CloseButtonFactory.isWindows8LaF() ? ImageUtilities.loadImage((String)"org/openide/awt/resources/win8_bigclose_pressed.png") : (CloseButtonFactory.isWindowsVistaLaF() ? ImageUtilities.loadImage((String)"org/openide/awt/resources/vista_bigclose_pressed.png") : (CloseButtonFactory.isWindowsXPLaF() ? ImageUtilities.loadImage((String)"org/openide/awt/resources/xp_bigclose_pressed.png") : (CloseButtonFactory.isWindowsLaF() ? ImageUtilities.loadImage((String)"org/openide/awt/resources/win_bigclose_pressed.png") : (CloseButtonFactory.isAquaLaF() ? ImageUtilities.loadImage((String)"org/openide/awt/resources/mac_bigclose_pressed.png") : (CloseButtonFactory.isGTKLaF() ? ImageUtilities.loadImage((String)"org/openide/awt/resources/gtk_bigclose_pressed.png") : ImageUtilities.loadImage((String)"org/openide/awt/resources/metal_bigclose_pressed.png"))))));
        }
        return bigCloseTabPressedImage;
    }

    private static Image getBigCloseTabRolloverImage() {
        if (null == bigCloseTabMouseOverImage) {
            bigCloseTabMouseOverImage = CloseButtonFactory.isWindows8LaF() ? ImageUtilities.loadImage((String)"org/openide/awt/resources/win8_bigclose_rollover.png") : (CloseButtonFactory.isWindowsVistaLaF() ? ImageUtilities.loadImage((String)"org/openide/awt/resources/vista_bigclose_rollover.png") : (CloseButtonFactory.isWindowsXPLaF() ? ImageUtilities.loadImage((String)"org/openide/awt/resources/xp_bigclose_rollover.png") : (CloseButtonFactory.isWindowsLaF() ? ImageUtilities.loadImage((String)"org/openide/awt/resources/win_bigclose_rollover.png") : (CloseButtonFactory.isAquaLaF() ? ImageUtilities.loadImage((String)"org/openide/awt/resources/mac_bigclose_rollover.png") : (CloseButtonFactory.isGTKLaF() ? ImageUtilities.loadImage((String)"org/openide/awt/resources/gtk_bigclose_rollover.png") : ImageUtilities.loadImage((String)"org/openide/awt/resources/metal_bigclose_rollover.png"))))));
        }
        return bigCloseTabMouseOverImage;
    }
}

