/*
 * Decompiled with CFR 0.152.
 */
package sun.org.mozilla.javascript.internal;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import sun.org.mozilla.javascript.internal.CompilerEnvirons;
import sun.org.mozilla.javascript.internal.Context;
import sun.org.mozilla.javascript.internal.ErrorReporter;
import sun.org.mozilla.javascript.internal.Kit;
import sun.org.mozilla.javascript.internal.Node;
import sun.org.mozilla.javascript.internal.ScriptRuntime;
import sun.org.mozilla.javascript.internal.Token;
import sun.org.mozilla.javascript.internal.TokenStream;
import sun.org.mozilla.javascript.internal.ast.ArrayComprehension;
import sun.org.mozilla.javascript.internal.ast.ArrayComprehensionLoop;
import sun.org.mozilla.javascript.internal.ast.ArrayLiteral;
import sun.org.mozilla.javascript.internal.ast.Assignment;
import sun.org.mozilla.javascript.internal.ast.AstNode;
import sun.org.mozilla.javascript.internal.ast.AstRoot;
import sun.org.mozilla.javascript.internal.ast.Block;
import sun.org.mozilla.javascript.internal.ast.BreakStatement;
import sun.org.mozilla.javascript.internal.ast.CatchClause;
import sun.org.mozilla.javascript.internal.ast.Comment;
import sun.org.mozilla.javascript.internal.ast.ConditionalExpression;
import sun.org.mozilla.javascript.internal.ast.ContinueStatement;
import sun.org.mozilla.javascript.internal.ast.DestructuringForm;
import sun.org.mozilla.javascript.internal.ast.DoLoop;
import sun.org.mozilla.javascript.internal.ast.ElementGet;
import sun.org.mozilla.javascript.internal.ast.EmptyExpression;
import sun.org.mozilla.javascript.internal.ast.ErrorNode;
import sun.org.mozilla.javascript.internal.ast.ExpressionStatement;
import sun.org.mozilla.javascript.internal.ast.ForInLoop;
import sun.org.mozilla.javascript.internal.ast.ForLoop;
import sun.org.mozilla.javascript.internal.ast.FunctionCall;
import sun.org.mozilla.javascript.internal.ast.FunctionNode;
import sun.org.mozilla.javascript.internal.ast.IdeErrorReporter;
import sun.org.mozilla.javascript.internal.ast.IfStatement;
import sun.org.mozilla.javascript.internal.ast.InfixExpression;
import sun.org.mozilla.javascript.internal.ast.Jump;
import sun.org.mozilla.javascript.internal.ast.KeywordLiteral;
import sun.org.mozilla.javascript.internal.ast.Label;
import sun.org.mozilla.javascript.internal.ast.LabeledStatement;
import sun.org.mozilla.javascript.internal.ast.LetNode;
import sun.org.mozilla.javascript.internal.ast.Loop;
import sun.org.mozilla.javascript.internal.ast.Name;
import sun.org.mozilla.javascript.internal.ast.NewExpression;
import sun.org.mozilla.javascript.internal.ast.NumberLiteral;
import sun.org.mozilla.javascript.internal.ast.ObjectLiteral;
import sun.org.mozilla.javascript.internal.ast.ObjectProperty;
import sun.org.mozilla.javascript.internal.ast.ParenthesizedExpression;
import sun.org.mozilla.javascript.internal.ast.PropertyGet;
import sun.org.mozilla.javascript.internal.ast.RegExpLiteral;
import sun.org.mozilla.javascript.internal.ast.ReturnStatement;
import sun.org.mozilla.javascript.internal.ast.Scope;
import sun.org.mozilla.javascript.internal.ast.ScriptNode;
import sun.org.mozilla.javascript.internal.ast.StringLiteral;
import sun.org.mozilla.javascript.internal.ast.SwitchCase;
import sun.org.mozilla.javascript.internal.ast.SwitchStatement;
import sun.org.mozilla.javascript.internal.ast.Symbol;
import sun.org.mozilla.javascript.internal.ast.ThrowStatement;
import sun.org.mozilla.javascript.internal.ast.TryStatement;
import sun.org.mozilla.javascript.internal.ast.UnaryExpression;
import sun.org.mozilla.javascript.internal.ast.VariableDeclaration;
import sun.org.mozilla.javascript.internal.ast.VariableInitializer;
import sun.org.mozilla.javascript.internal.ast.WhileLoop;
import sun.org.mozilla.javascript.internal.ast.WithStatement;
import sun.org.mozilla.javascript.internal.ast.XmlDotQuery;
import sun.org.mozilla.javascript.internal.ast.XmlElemRef;
import sun.org.mozilla.javascript.internal.ast.XmlExpression;
import sun.org.mozilla.javascript.internal.ast.XmlLiteral;
import sun.org.mozilla.javascript.internal.ast.XmlMemberGet;
import sun.org.mozilla.javascript.internal.ast.XmlPropRef;
import sun.org.mozilla.javascript.internal.ast.XmlRef;
import sun.org.mozilla.javascript.internal.ast.XmlString;
import sun.org.mozilla.javascript.internal.ast.Yield;

public class Parser {
    public static final int ARGC_LIMIT = 65536;
    static final int CLEAR_TI_MASK = 65535;
    static final int TI_AFTER_EOL = 65536;
    static final int TI_CHECK_LABEL = 131072;
    CompilerEnvirons compilerEnv;
    private ErrorReporter errorReporter;
    private IdeErrorReporter errorCollector;
    private String sourceURI;
    private char[] sourceChars;
    boolean calledByCompileFunction;
    private boolean parseFinished;
    private TokenStream ts;
    private int currentFlaggedToken = 0;
    private int currentToken;
    private int syntaxErrorCount;
    private List<Comment> scannedComments;
    private String currentJsDocComment;
    protected int nestingOfFunction;
    private LabeledStatement currentLabel;
    private boolean inDestructuringAssignment;
    protected boolean inUseStrictDirective;
    ScriptNode currentScriptOrFn;
    Scope currentScope;
    int nestingOfWith;
    private int endFlags;
    private boolean inForInit;
    private Map<String, LabeledStatement> labelSet;
    private List<Loop> loopSet;
    private List<Jump> loopAndSwitchSet;
    private int prevNameTokenStart;
    private String prevNameTokenString = "";
    private int prevNameTokenLineno;

    public Parser() {
        this(new CompilerEnvirons());
    }

    public Parser(CompilerEnvirons compilerEnvirons) {
        this(compilerEnvirons, compilerEnvirons.getErrorReporter());
    }

    public Parser(CompilerEnvirons compilerEnvirons, ErrorReporter errorReporter) {
        this.compilerEnv = compilerEnvirons;
        this.errorReporter = errorReporter;
        if (errorReporter instanceof IdeErrorReporter) {
            this.errorCollector = (IdeErrorReporter)errorReporter;
        }
    }

    void addStrictWarning(String string, String string2) {
        int n = -1;
        int n2 = -1;
        if (this.ts != null) {
            n = this.ts.tokenBeg;
            n2 = this.ts.tokenEnd - this.ts.tokenBeg;
        }
        this.addStrictWarning(string, string2, n, n2);
    }

    void addStrictWarning(String string, String string2, int n, int n2) {
        if (this.compilerEnv.isStrictMode()) {
            this.addWarning(string, string2, n, n2);
        }
    }

    void addWarning(String string, String string2) {
        int n = -1;
        int n2 = -1;
        if (this.ts != null) {
            n = this.ts.tokenBeg;
            n2 = this.ts.tokenEnd - this.ts.tokenBeg;
        }
        this.addWarning(string, string2, n, n2);
    }

    void addWarning(String string, int n, int n2) {
        this.addWarning(string, null, n, n2);
    }

    void addWarning(String string, String string2, int n, int n2) {
        String string3 = this.lookupMessage(string, string2);
        if (this.compilerEnv.reportWarningAsError()) {
            this.addError(string, string2, n, n2);
        } else if (this.errorCollector != null) {
            this.errorCollector.warning(string3, this.sourceURI, n, n2);
        } else {
            this.errorReporter.warning(string3, this.sourceURI, this.ts.getLineno(), this.ts.getLine(), this.ts.getOffset());
        }
    }

    void addError(String string) {
        this.addError(string, this.ts.tokenBeg, this.ts.tokenEnd - this.ts.tokenBeg);
    }

    void addError(String string, int n, int n2) {
        this.addError(string, null, n, n2);
    }

    void addError(String string, String string2) {
        this.addError(string, string2, this.ts.tokenBeg, this.ts.tokenEnd - this.ts.tokenBeg);
    }

    void addError(String string, String string2, int n, int n2) {
        ++this.syntaxErrorCount;
        String string3 = this.lookupMessage(string, string2);
        if (this.errorCollector != null) {
            this.errorCollector.error(string3, this.sourceURI, n, n2);
        } else {
            int n3 = 1;
            int n4 = 1;
            String string4 = "";
            if (this.ts != null) {
                n3 = this.ts.getLineno();
                string4 = this.ts.getLine();
                n4 = this.ts.getOffset();
            }
            this.errorReporter.error(string3, this.sourceURI, n3, string4, n4);
        }
    }

    String lookupMessage(String string) {
        return this.lookupMessage(string, null);
    }

    String lookupMessage(String string, String string2) {
        return string2 == null ? ScriptRuntime.getMessage0(string) : ScriptRuntime.getMessage1(string, string2);
    }

    void reportError(String string) {
        this.reportError(string, null);
    }

    void reportError(String string, String string2) {
        if (this.ts == null) {
            this.reportError(string, string2, 1, 1);
        } else {
            this.reportError(string, string2, this.ts.tokenBeg, this.ts.tokenEnd - this.ts.tokenBeg);
        }
    }

    void reportError(String string, int n, int n2) {
        this.reportError(string, null, n, n2);
    }

    void reportError(String string, String string2, int n, int n2) {
        this.addError(string, n, n2);
        if (!this.compilerEnv.recoverFromErrors()) {
            throw new ParserException();
        }
    }

    private int getNodeEnd(AstNode astNode) {
        return astNode.getPosition() + astNode.getLength();
    }

    private void recordComment(int n) {
        if (this.scannedComments == null) {
            this.scannedComments = new ArrayList<Comment>();
        }
        String string = this.ts.getAndResetCurrentComment();
        if (this.ts.commentType == Token.CommentType.JSDOC && this.compilerEnv.isRecordingLocalJsDocComments()) {
            this.currentJsDocComment = string;
        }
        Comment comment = new Comment(this.ts.tokenBeg, this.ts.getTokenLength(), this.ts.commentType, string);
        comment.setLineno(n);
        this.scannedComments.add(comment);
    }

    private String getAndResetJsDoc() {
        String string = this.currentJsDocComment;
        this.currentJsDocComment = null;
        return string;
    }

    private int peekToken() throws IOException {
        if (this.currentFlaggedToken != 0) {
            return this.currentToken;
        }
        int n = this.ts.getLineno();
        int n2 = this.ts.getToken();
        boolean bl = false;
        while (n2 == 1 || n2 == 161) {
            if (n2 == 1) {
                ++n;
                bl = true;
            } else {
                bl = false;
                if (this.compilerEnv.isRecordingComments()) {
                    this.recordComment(n);
                }
            }
            n2 = this.ts.getToken();
        }
        this.currentToken = n2;
        this.currentFlaggedToken = n2 | (bl ? 65536 : 0);
        return this.currentToken;
    }

    private int peekFlaggedToken() throws IOException {
        this.peekToken();
        return this.currentFlaggedToken;
    }

    private void consumeToken() {
        this.currentFlaggedToken = 0;
    }

    private int nextToken() throws IOException {
        int n = this.peekToken();
        this.consumeToken();
        return n;
    }

    private int nextFlaggedToken() throws IOException {
        this.peekToken();
        int n = this.currentFlaggedToken;
        this.consumeToken();
        return n;
    }

    private boolean matchToken(int n) throws IOException {
        if (this.peekToken() != n) {
            return false;
        }
        this.consumeToken();
        return true;
    }

    private int peekTokenOrEOL() throws IOException {
        int n = this.peekToken();
        if ((this.currentFlaggedToken & 0x10000) != 0) {
            n = 1;
        }
        return n;
    }

    private boolean mustMatchToken(int n, String string) throws IOException {
        return this.mustMatchToken(n, string, this.ts.tokenBeg, this.ts.tokenEnd - this.ts.tokenBeg);
    }

    private boolean mustMatchToken(int n, String string, int n2, int n3) throws IOException {
        if (this.matchToken(n)) {
            return true;
        }
        this.reportError(string, n2, n3);
        return false;
    }

    private void mustHaveXML() {
        if (!this.compilerEnv.isXmlAvailable()) {
            this.reportError("msg.XML.not.available");
        }
    }

    public boolean eof() {
        return this.ts.eof();
    }

    boolean insideFunction() {
        return this.nestingOfFunction != 0;
    }

    void pushScope(Scope scope) {
        Scope scope2 = scope.getParentScope();
        if (scope2 != null) {
            if (scope2 != this.currentScope) {
                this.codeBug();
            }
        } else {
            this.currentScope.addChildScope(scope);
        }
        this.currentScope = scope;
    }

    void popScope() {
        this.currentScope = this.currentScope.getParentScope();
    }

    private void enterLoop(Loop loop) {
        if (this.loopSet == null) {
            this.loopSet = new ArrayList<Loop>();
        }
        this.loopSet.add(loop);
        if (this.loopAndSwitchSet == null) {
            this.loopAndSwitchSet = new ArrayList<Jump>();
        }
        this.loopAndSwitchSet.add(loop);
        this.pushScope(loop);
        if (this.currentLabel != null) {
            this.currentLabel.setStatement(loop);
            this.currentLabel.getFirstLabel().setLoop(loop);
            loop.setRelative(-this.currentLabel.getPosition());
        }
    }

    private void exitLoop() {
        Loop loop = this.loopSet.remove(this.loopSet.size() - 1);
        this.loopAndSwitchSet.remove(this.loopAndSwitchSet.size() - 1);
        if (loop.getParent() != null) {
            loop.setRelative(loop.getParent().getPosition());
        }
        this.popScope();
    }

    private void enterSwitch(SwitchStatement switchStatement) {
        if (this.loopAndSwitchSet == null) {
            this.loopAndSwitchSet = new ArrayList<Jump>();
        }
        this.loopAndSwitchSet.add(switchStatement);
    }

    private void exitSwitch() {
        this.loopAndSwitchSet.remove(this.loopAndSwitchSet.size() - 1);
    }

    public AstRoot parse(String string, String string2, int n) {
        if (this.parseFinished) {
            throw new IllegalStateException("parser reused");
        }
        this.sourceURI = string2;
        if (this.compilerEnv.isIdeMode()) {
            this.sourceChars = string.toCharArray();
        }
        this.ts = new TokenStream(this, null, string, n);
        try {
            AstRoot astRoot = this.parse();
            return astRoot;
        }
        catch (IOException iOException) {
            throw new IllegalStateException();
        }
        finally {
            this.parseFinished = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AstRoot parse(Reader reader, String string, int n) throws IOException {
        if (this.parseFinished) {
            throw new IllegalStateException("parser reused");
        }
        if (this.compilerEnv.isIdeMode()) {
            return this.parse(this.readFully(reader), string, n);
        }
        try {
            this.sourceURI = string;
            this.ts = new TokenStream(this, reader, null, n);
            AstRoot astRoot = this.parse();
            return astRoot;
        }
        finally {
            this.parseFinished = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AstRoot parse() throws IOException {
        Iterator<Comment> iterator;
        int n;
        int n2 = 0;
        AstRoot astRoot = new AstRoot(n2);
        this.currentScriptOrFn = astRoot;
        this.currentScope = this.currentScriptOrFn;
        int n3 = this.ts.lineno;
        int n4 = n2;
        boolean bl = true;
        boolean bl2 = this.inUseStrictDirective;
        this.inUseStrictDirective = false;
        try {
            while (true) {
                block20: {
                    if ((n = this.peekToken()) <= 0) {
                        break;
                    }
                    if (n == 109) {
                        this.consumeToken();
                        try {
                            iterator = this.function(this.calledByCompileFunction ? 2 : 1);
                            break block20;
                        }
                        catch (ParserException parserException) {
                            break;
                        }
                    }
                    iterator = this.statement();
                    if (bl) {
                        String object = this.getDirective((AstNode)((Object)iterator));
                        if (object == null) {
                            bl = false;
                        } else if (object.equals("use strict")) {
                            this.inUseStrictDirective = true;
                            astRoot.setInStrictMode(true);
                        }
                    }
                }
                n4 = this.getNodeEnd((AstNode)((Object)iterator));
                astRoot.addChildToBack((Node)((Object)iterator));
                ((AstNode)((Object)iterator)).setParent(astRoot);
            }
        }
        catch (StackOverflowError stackOverflowError) {
            iterator = this.lookupMessage("msg.too.deep.parser.recursion");
            if (!this.compilerEnv.isIdeMode()) {
                throw Context.reportRuntimeError((String)((Object)iterator), this.sourceURI, this.ts.lineno, null, 0);
            }
        }
        finally {
            this.inUseStrictDirective = bl2;
        }
        if (this.syntaxErrorCount != 0) {
            String string = String.valueOf(this.syntaxErrorCount);
            string = this.lookupMessage("msg.got.syntax.errors", string);
            if (!this.compilerEnv.isIdeMode()) {
                throw this.errorReporter.runtimeError(string, this.sourceURI, n3, null, 0);
            }
        }
        if (this.scannedComments != null) {
            n = this.scannedComments.size() - 1;
            n4 = Math.max(n4, this.getNodeEnd(this.scannedComments.get(n)));
            for (Comment comment : this.scannedComments) {
                astRoot.addComment(comment);
            }
        }
        astRoot.setLength(n4 - n2);
        astRoot.setSourceName(this.sourceURI);
        astRoot.setBaseLineno(n3);
        astRoot.setEndLineno(this.ts.lineno);
        return astRoot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AstNode parseFunctionBody() throws IOException {
        Block block;
        int n;
        block14: {
            if (!this.matchToken(85)) {
                if (this.compilerEnv.getLanguageVersion() < 180) {
                    this.reportError("msg.no.brace.body");
                }
                return this.parseFunctionBodyExpr();
            }
            ++this.nestingOfFunction;
            n = this.ts.tokenBeg;
            block = new Block(n);
            boolean bl = true;
            boolean bl2 = this.inUseStrictDirective;
            block.setLineno(this.ts.lineno);
            try {
                while (true) {
                    AstNode astNode;
                    int n2 = this.peekToken();
                    switch (n2) {
                        case -1: 
                        case 0: 
                        case 86: {
                            break block14;
                        }
                        case 109: {
                            this.consumeToken();
                            astNode = this.function(1);
                            break;
                        }
                        default: {
                            astNode = this.statement();
                            if (!bl) break;
                            String string = this.getDirective(astNode);
                            if (string == null) {
                                bl = false;
                                break;
                            }
                            if (!string.equals("use strict")) break;
                            this.inUseStrictDirective = true;
                        }
                    }
                    block.addStatement(astNode);
                }
            }
            catch (ParserException parserException) {
            }
            finally {
                --this.nestingOfFunction;
                this.inUseStrictDirective = bl2;
            }
        }
        int n3 = this.ts.tokenEnd;
        this.getAndResetJsDoc();
        if (this.mustMatchToken(86, "msg.no.brace.after.body")) {
            n3 = this.ts.tokenEnd;
        }
        block.setLength(n3 - n);
        return block;
    }

    private String getDirective(AstNode astNode) {
        AstNode astNode2;
        if (astNode instanceof ExpressionStatement && (astNode2 = ((ExpressionStatement)astNode).getExpression()) instanceof StringLiteral) {
            return ((StringLiteral)astNode2).getValue();
        }
        return null;
    }

    private void parseFunctionParams(FunctionNode functionNode) throws IOException {
        if (this.matchToken(88)) {
            functionNode.setRp(this.ts.tokenBeg - functionNode.getPosition());
            return;
        }
        HashMap hashMap = null;
        HashSet hashSet = new HashSet();
        do {
            Iterator iterator;
            int n;
            if ((n = this.peekToken()) == 83 || n == 85) {
                iterator = this.destructuringPrimaryExpr();
                this.markDestructuring((AstNode)((Object)iterator));
                functionNode.addParam((AstNode)((Object)iterator));
                if (hashMap == null) {
                    hashMap = new HashMap();
                }
                String object = this.currentScriptOrFn.getNextTempName();
                this.defineSymbol(87, object, false);
                hashMap.put(object, iterator);
                continue;
            }
            if (this.mustMatchToken(39, "msg.no.parm")) {
                functionNode.addParam(this.createNameNode());
                iterator = this.ts.getString();
                this.defineSymbol(87, (String)((Object)iterator));
                if (!this.inUseStrictDirective) continue;
                if ("eval".equals(iterator) || "arguments".equals(iterator)) {
                    this.reportError("msg.bad.id.strict", (String)((Object)iterator));
                }
                if (hashSet.contains(iterator)) {
                    this.addError("msg.dup.param.strict", (String)((Object)iterator));
                }
                hashSet.add(iterator);
                continue;
            }
            functionNode.addParam(this.makeErrorNode());
        } while (this.matchToken(89));
        if (hashMap != null) {
            Node node = new Node(89);
            for (Map.Entry entry : hashMap.entrySet()) {
                Node node2 = this.createDestructuringAssignment(122, (Node)entry.getValue(), this.createName((String)entry.getKey()));
                node.addChildToBack(node2);
            }
            functionNode.putProp(23, node);
        }
        if (this.mustMatchToken(88, "msg.no.paren.after.parms")) {
            functionNode.setRp(this.ts.tokenBeg - functionNode.getPosition());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AstNode parseFunctionBodyExpr() throws IOException {
        ++this.nestingOfFunction;
        int n = this.ts.getLineno();
        ReturnStatement returnStatement = new ReturnStatement(n);
        returnStatement.putProp(25, Boolean.TRUE);
        try {
            returnStatement.setReturnValue(this.assignExpr());
        }
        finally {
            --this.nestingOfFunction;
        }
        return returnStatement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FunctionNode function(int n) throws IOException {
        int n2;
        int n3 = n;
        int n4 = this.ts.lineno;
        int n5 = this.ts.tokenBeg;
        Name name = null;
        AstNode astNode = null;
        if (this.matchToken(39)) {
            Object object;
            name = this.createNameNode(true, 39);
            if (this.inUseStrictDirective && ("eval".equals(object = name.getIdentifier()) || "arguments".equals(object))) {
                this.reportError("msg.bad.id.strict", (String)object);
            }
            if (!this.matchToken(87)) {
                if (this.compilerEnv.isAllowMemberExprAsFunctionName()) {
                    object = name;
                    name = null;
                    astNode = this.memberExprTail(false, (AstNode)object);
                }
                this.mustMatchToken(87, "msg.no.paren.parms");
            }
        } else if (!this.matchToken(87)) {
            if (this.compilerEnv.isAllowMemberExprAsFunctionName()) {
                astNode = this.memberExpr(false);
            }
            this.mustMatchToken(87, "msg.no.paren.parms");
        }
        int n6 = n2 = this.currentToken == 87 ? this.ts.tokenBeg : -1;
        if (astNode != null) {
            n3 = 2;
        }
        if (n3 != 2 && name != null && name.length() > 0) {
            this.defineSymbol(109, name.getIdentifier());
        }
        FunctionNode functionNode = new FunctionNode(n5, name);
        functionNode.setFunctionType(n);
        if (n2 != -1) {
            functionNode.setLp(n2 - n5);
        }
        if (this.insideFunction() || this.nestingOfWith > 0) {
            functionNode.setIgnoreDynamicScope();
        }
        functionNode.setJsDoc(this.getAndResetJsDoc());
        PerFunctionVariables perFunctionVariables = new PerFunctionVariables(functionNode);
        try {
            this.parseFunctionParams(functionNode);
            functionNode.setBody(this.parseFunctionBody());
            functionNode.setEncodedSourceBounds(n5, this.ts.tokenEnd);
            functionNode.setLength(this.ts.tokenEnd - n5);
            if (this.compilerEnv.isStrictMode() && !functionNode.getBody().hasConsistentReturnUsage()) {
                String string = name != null && name.length() > 0 ? "msg.no.return.value" : "msg.anon.no.return.value";
                this.addStrictWarning(string, name == null ? "" : name.getIdentifier());
            }
        }
        finally {
            perFunctionVariables.restore();
        }
        if (astNode != null) {
            Kit.codeBug();
            functionNode.setMemberExprNode(astNode);
        }
        functionNode.setSourceName(this.sourceURI);
        functionNode.setBaseLineno(n4);
        functionNode.setEndLineno(this.ts.lineno);
        if (this.compilerEnv.isIdeMode()) {
            functionNode.setParentScope(this.currentScope);
        }
        return functionNode;
    }

    private AstNode statements(AstNode astNode) throws IOException {
        int n;
        if (this.currentToken != 85 && !this.compilerEnv.isIdeMode()) {
            this.codeBug();
        }
        int n2 = this.ts.tokenBeg;
        AstNode astNode2 = astNode != null ? astNode : new Block(n2);
        astNode2.setLineno(this.ts.lineno);
        while ((n = this.peekToken()) > 0 && n != 86) {
            astNode2.addChild(this.statement());
        }
        astNode2.setLength(this.ts.tokenBeg - n2);
        return astNode2;
    }

    private AstNode statements() throws IOException {
        return this.statements(null);
    }

    private ConditionData condition() throws IOException {
        ConditionData conditionData = new ConditionData();
        if (this.mustMatchToken(87, "msg.no.paren.cond")) {
            conditionData.lp = this.ts.tokenBeg;
        }
        conditionData.condition = this.expr();
        if (this.mustMatchToken(88, "msg.no.paren.after.cond")) {
            conditionData.rp = this.ts.tokenBeg;
        }
        if (conditionData.condition instanceof Assignment) {
            this.addStrictWarning("msg.equal.as.assign", "", conditionData.condition.getPosition(), conditionData.condition.getLength());
        }
        return conditionData;
    }

    private AstNode statement() throws IOException {
        int n = this.ts.tokenBeg;
        try {
            AstNode astNode = this.statementHelper();
            if (astNode != null) {
                if (this.compilerEnv.isStrictMode() && !astNode.hasSideEffects()) {
                    int n2 = astNode.getPosition();
                    n2 = Math.max(n2, this.lineBeginningFor(n2));
                    this.addStrictWarning(astNode instanceof EmptyExpression ? "msg.extra.trailing.semi" : "msg.no.side.effects", "", n2, this.nodeEnd(astNode) - n2);
                }
                return astNode;
            }
        }
        catch (ParserException parserException) {
            // empty catch block
        }
        block5: while (true) {
            int n3 = this.peekTokenOrEOL();
            this.consumeToken();
            switch (n3) {
                case -1: 
                case 0: 
                case 1: 
                case 82: {
                    break block5;
                }
                default: {
                    continue block5;
                }
            }
            break;
        }
        return new EmptyExpression(n, this.ts.tokenBeg - n);
    }

    private AstNode statementHelper() throws IOException {
        if (this.currentLabel != null && this.currentLabel.getStatement() != null) {
            this.currentLabel = null;
        }
        AstNode astNode = null;
        int n = this.peekToken();
        int n2 = this.ts.tokenBeg;
        switch (n) {
            case 112: {
                return this.ifStatement();
            }
            case 114: {
                return this.switchStatement();
            }
            case 117: {
                return this.whileLoop();
            }
            case 118: {
                return this.doLoop();
            }
            case 119: {
                return this.forLoop();
            }
            case 81: {
                return this.tryStatement();
            }
            case 50: {
                astNode = this.throwStatement();
                break;
            }
            case 120: {
                astNode = this.breakStatement();
                break;
            }
            case 121: {
                astNode = this.continueStatement();
                break;
            }
            case 123: {
                if (this.inUseStrictDirective) {
                    this.reportError("msg.no.with.strict");
                }
                return this.withStatement();
            }
            case 122: 
            case 154: {
                this.consumeToken();
                int n3 = this.ts.lineno;
                astNode = this.variables(this.currentToken, this.ts.tokenBeg);
                astNode.setLineno(n3);
                break;
            }
            case 153: {
                astNode = this.letStatement();
                if (astNode instanceof VariableDeclaration && this.peekToken() == 82) break;
                return astNode;
            }
            case 4: 
            case 72: {
                astNode = this.returnOrYield(n, false);
                break;
            }
            case 160: {
                this.consumeToken();
                astNode = new KeywordLiteral(this.ts.tokenBeg, this.ts.tokenEnd - this.ts.tokenBeg, n);
                astNode.setLineno(this.ts.lineno);
                break;
            }
            case 85: {
                return this.block();
            }
            case -1: {
                this.consumeToken();
                return this.makeErrorNode();
            }
            case 82: {
                this.consumeToken();
                n2 = this.ts.tokenBeg;
                astNode = new EmptyExpression(n2, this.ts.tokenEnd - n2);
                astNode.setLineno(this.ts.lineno);
                return astNode;
            }
            case 109: {
                this.consumeToken();
                return this.function(3);
            }
            case 116: {
                astNode = this.defaultXmlNamespace();
                break;
            }
            case 39: {
                astNode = this.nameOrLabel();
                if (astNode instanceof ExpressionStatement) break;
                return astNode;
            }
            default: {
                int n4 = this.ts.lineno;
                astNode = new ExpressionStatement(this.expr(), !this.insideFunction());
                astNode.setLineno(n4);
            }
        }
        this.autoInsertSemicolon(astNode);
        return astNode;
    }

    private void autoInsertSemicolon(AstNode astNode) throws IOException {
        int n = this.peekFlaggedToken();
        int n2 = astNode.getPosition();
        switch (n & 0xFFFF) {
            case 82: {
                this.consumeToken();
                astNode.setLength(this.ts.tokenEnd - n2);
                break;
            }
            case -1: 
            case 0: 
            case 86: {
                this.warnMissingSemi(n2, this.nodeEnd(astNode));
                break;
            }
            default: {
                if ((n & 0x10000) == 0) {
                    this.reportError("msg.no.semi.stmt");
                    break;
                }
                this.warnMissingSemi(n2, this.nodeEnd(astNode));
            }
        }
    }

    private IfStatement ifStatement() throws IOException {
        if (this.currentToken != 112) {
            this.codeBug();
        }
        this.consumeToken();
        int n = this.ts.tokenBeg;
        int n2 = this.ts.lineno;
        int n3 = -1;
        ConditionData conditionData = this.condition();
        AstNode astNode = this.statement();
        AstNode astNode2 = null;
        if (this.matchToken(113)) {
            n3 = this.ts.tokenBeg - n;
            astNode2 = this.statement();
        }
        int n4 = this.getNodeEnd(astNode2 != null ? astNode2 : astNode);
        IfStatement ifStatement = new IfStatement(n, n4 - n);
        ifStatement.setCondition(conditionData.condition);
        ifStatement.setParens(conditionData.lp - n, conditionData.rp - n);
        ifStatement.setThenPart(astNode);
        ifStatement.setElsePart(astNode2);
        ifStatement.setElsePosition(n3);
        ifStatement.setLineno(n2);
        return ifStatement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SwitchStatement switchStatement() throws IOException {
        SwitchStatement switchStatement;
        block14: {
            if (this.currentToken != 114) {
                this.codeBug();
            }
            this.consumeToken();
            int n = this.ts.tokenBeg;
            switchStatement = new SwitchStatement(n);
            if (this.mustMatchToken(87, "msg.no.paren.switch")) {
                switchStatement.setLp(this.ts.tokenBeg - n);
            }
            switchStatement.setLineno(this.ts.lineno);
            AstNode astNode = this.expr();
            switchStatement.setExpression(astNode);
            this.enterSwitch(switchStatement);
            try {
                if (this.mustMatchToken(88, "msg.no.paren.after.switch")) {
                    switchStatement.setRp(this.ts.tokenBeg - n);
                }
                this.mustMatchToken(85, "msg.no.brace.switch");
                boolean bl = false;
                while (true) {
                    int n2 = this.nextToken();
                    int n3 = this.ts.tokenBeg;
                    int n4 = this.ts.lineno;
                    AstNode astNode2 = null;
                    switch (n2) {
                        case 86: {
                            switchStatement.setLength(this.ts.tokenEnd - n);
                            break block14;
                        }
                        case 115: {
                            astNode2 = this.expr();
                            this.mustMatchToken(103, "msg.no.colon.case");
                            break;
                        }
                        case 116: {
                            if (bl) {
                                this.reportError("msg.double.switch.default");
                            }
                            bl = true;
                            astNode2 = null;
                            this.mustMatchToken(103, "msg.no.colon.case");
                            break;
                        }
                        default: {
                            this.reportError("msg.bad.switch");
                            break block14;
                        }
                    }
                    SwitchCase switchCase = new SwitchCase(n3);
                    switchCase.setExpression(astNode2);
                    switchCase.setLength(this.ts.tokenEnd - n);
                    switchCase.setLineno(n4);
                    while ((n2 = this.peekToken()) != 86 && n2 != 115 && n2 != 116 && n2 != 0) {
                        switchCase.addStatement(this.statement());
                    }
                    switchStatement.addCase(switchCase);
                }
            }
            finally {
                this.exitSwitch();
            }
        }
        return switchStatement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private WhileLoop whileLoop() throws IOException {
        if (this.currentToken != 117) {
            this.codeBug();
        }
        this.consumeToken();
        int n = this.ts.tokenBeg;
        WhileLoop whileLoop = new WhileLoop(n);
        whileLoop.setLineno(this.ts.lineno);
        this.enterLoop(whileLoop);
        try {
            ConditionData conditionData = this.condition();
            whileLoop.setCondition(conditionData.condition);
            whileLoop.setParens(conditionData.lp - n, conditionData.rp - n);
            AstNode astNode = this.statement();
            whileLoop.setLength(this.getNodeEnd(astNode) - n);
            whileLoop.setBody(astNode);
        }
        finally {
            this.exitLoop();
        }
        return whileLoop;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DoLoop doLoop() throws IOException {
        int n;
        if (this.currentToken != 118) {
            this.codeBug();
        }
        this.consumeToken();
        int n2 = this.ts.tokenBeg;
        DoLoop doLoop = new DoLoop(n2);
        doLoop.setLineno(this.ts.lineno);
        this.enterLoop(doLoop);
        try {
            AstNode astNode = this.statement();
            this.mustMatchToken(117, "msg.no.while.do");
            doLoop.setWhilePosition(this.ts.tokenBeg - n2);
            ConditionData conditionData = this.condition();
            doLoop.setCondition(conditionData.condition);
            doLoop.setParens(conditionData.lp - n2, conditionData.rp - n2);
            n = this.getNodeEnd(astNode);
            doLoop.setBody(astNode);
        }
        finally {
            this.exitLoop();
        }
        if (this.matchToken(82)) {
            n = this.ts.tokenEnd;
        }
        doLoop.setLength(n - n2);
        return doLoop;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Loop forLoop() throws IOException {
        if (this.currentToken != 119) {
            this.codeBug();
        }
        this.consumeToken();
        int n = this.ts.tokenBeg;
        int n2 = this.ts.lineno;
        boolean bl = false;
        boolean bl2 = false;
        int n3 = -1;
        int n4 = -1;
        int n5 = -1;
        int n6 = -1;
        AstNode astNode = null;
        AstNode astNode2 = null;
        AstNode astNode3 = null;
        Loop loop = null;
        Scope scope = new Scope();
        this.pushScope(scope);
        try {
            AstNode astNode4;
            if (this.matchToken(39)) {
                if ("each".equals(this.ts.getString())) {
                    bl = true;
                    n3 = this.ts.tokenBeg - n;
                } else {
                    this.reportError("msg.no.paren.for");
                }
            }
            if (this.mustMatchToken(87, "msg.no.paren.for")) {
                n5 = this.ts.tokenBeg - n;
            }
            int n7 = this.peekToken();
            astNode = this.forLoopInit(n7);
            if (this.matchToken(52)) {
                bl2 = true;
                n4 = this.ts.tokenBeg - n;
                astNode2 = this.expr();
            } else {
                this.mustMatchToken(82, "msg.no.semi.for");
                if (this.peekToken() == 82) {
                    astNode2 = new EmptyExpression(this.ts.tokenBeg, 1);
                    astNode2.setLineno(this.ts.lineno);
                } else {
                    astNode2 = this.expr();
                }
                this.mustMatchToken(82, "msg.no.semi.for.cond");
                int n8 = this.ts.tokenEnd;
                if (this.peekToken() == 88) {
                    astNode3 = new EmptyExpression(n8, 1);
                    astNode3.setLineno(this.ts.lineno);
                } else {
                    astNode3 = this.expr();
                }
            }
            if (this.mustMatchToken(88, "msg.no.paren.for.ctrl")) {
                n6 = this.ts.tokenBeg - n;
            }
            if (bl2) {
                astNode4 = new ForInLoop(n);
                if (astNode instanceof VariableDeclaration && ((VariableDeclaration)astNode).getVariables().size() > 1) {
                    this.reportError("msg.mult.index");
                }
                astNode4.setIterator(astNode);
                astNode4.setIteratedObject(astNode2);
                astNode4.setInPosition(n4);
                astNode4.setIsForEach(bl);
                astNode4.setEachPosition(n3);
                loop = astNode4;
            } else {
                astNode4 = new ForLoop(n);
                ((ForLoop)astNode4).setInitializer(astNode);
                ((ForLoop)astNode4).setCondition(astNode2);
                ((ForLoop)astNode4).setIncrement(astNode3);
                loop = astNode4;
            }
            this.currentScope.replaceWith(loop);
            this.popScope();
            this.enterLoop(loop);
            try {
                astNode4 = this.statement();
                loop.setLength(this.getNodeEnd(astNode4) - n);
                loop.setBody(astNode4);
            }
            finally {
                this.exitLoop();
            }
        }
        finally {
            if (this.currentScope == scope) {
                this.popScope();
            }
        }
        loop.setParens(n5, n6);
        loop.setLineno(n2);
        return loop;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AstNode forLoopInit(int n) throws IOException {
        try {
            this.inForInit = true;
            AstNode astNode = null;
            if (n == 82) {
                astNode = new EmptyExpression(this.ts.tokenBeg, 1);
                astNode.setLineno(this.ts.lineno);
            } else if (n == 122 || n == 153) {
                this.consumeToken();
                astNode = this.variables(n, this.ts.tokenBeg);
            } else {
                astNode = this.expr();
                this.markDestructuring(astNode);
            }
            AstNode astNode2 = astNode;
            return astNode2;
        }
        finally {
            this.inForInit = false;
        }
    }

    private TryStatement tryStatement() throws IOException {
        if (this.currentToken != 81) {
            this.codeBug();
        }
        this.consumeToken();
        String string = this.getAndResetJsDoc();
        int n = this.ts.tokenBeg;
        int n2 = this.ts.lineno;
        int n3 = -1;
        if (this.peekToken() != 85) {
            this.reportError("msg.no.brace.try");
        }
        AstNode astNode = this.statement();
        int n4 = this.getNodeEnd(astNode);
        ArrayList<CatchClause> arrayList = null;
        boolean bl = false;
        int n5 = this.peekToken();
        if (n5 == 124) {
            while (this.matchToken(124)) {
                int n6 = this.ts.lineno;
                if (bl) {
                    this.reportError("msg.catch.unreachable");
                }
                int n7 = this.ts.tokenBeg;
                int n8 = -1;
                int n9 = -1;
                int n10 = -1;
                if (this.mustMatchToken(87, "msg.no.paren.catch")) {
                    n8 = this.ts.tokenBeg;
                }
                this.mustMatchToken(39, "msg.bad.catchcond");
                Name name = this.createNameNode();
                String string2 = name.getIdentifier();
                if (this.inUseStrictDirective && ("eval".equals(string2) || "arguments".equals(string2))) {
                    this.reportError("msg.bad.id.strict", string2);
                }
                AstNode astNode2 = null;
                if (this.matchToken(112)) {
                    n10 = this.ts.tokenBeg;
                    astNode2 = this.expr();
                } else {
                    bl = true;
                }
                if (this.mustMatchToken(88, "msg.bad.catchcond")) {
                    n9 = this.ts.tokenBeg;
                }
                this.mustMatchToken(85, "msg.no.brace.catchblock");
                Block block = (Block)this.statements();
                n4 = this.getNodeEnd(block);
                CatchClause catchClause = new CatchClause(n7);
                catchClause.setVarName(name);
                catchClause.setCatchCondition(astNode2);
                catchClause.setBody(block);
                if (n10 != -1) {
                    catchClause.setIfPosition(n10 - n7);
                }
                catchClause.setParens(n8, n9);
                catchClause.setLineno(n6);
                if (this.mustMatchToken(86, "msg.no.brace.after.body")) {
                    n4 = this.ts.tokenEnd;
                }
                catchClause.setLength(n4 - n7);
                if (arrayList == null) {
                    arrayList = new ArrayList<CatchClause>();
                }
                arrayList.add(catchClause);
            }
        } else if (n5 != 125) {
            this.mustMatchToken(125, "msg.try.no.catchfinally");
        }
        AstNode astNode3 = null;
        if (this.matchToken(125)) {
            n3 = this.ts.tokenBeg;
            astNode3 = this.statement();
            n4 = this.getNodeEnd(astNode3);
        }
        TryStatement tryStatement = new TryStatement(n, n4 - n);
        tryStatement.setTryBlock(astNode);
        tryStatement.setCatchClauses(arrayList);
        tryStatement.setFinallyBlock(astNode3);
        if (n3 != -1) {
            tryStatement.setFinallyPosition(n3 - n);
        }
        tryStatement.setLineno(n2);
        if (string != null) {
            tryStatement.setJsDoc(string);
        }
        return tryStatement;
    }

    private ThrowStatement throwStatement() throws IOException {
        if (this.currentToken != 50) {
            this.codeBug();
        }
        this.consumeToken();
        int n = this.ts.tokenBeg;
        int n2 = this.ts.lineno;
        if (this.peekTokenOrEOL() == 1) {
            this.reportError("msg.bad.throw.eol");
        }
        AstNode astNode = this.expr();
        ThrowStatement throwStatement = new ThrowStatement(n, this.getNodeEnd(astNode), astNode);
        throwStatement.setLineno(n2);
        return throwStatement;
    }

    private LabeledStatement matchJumpLabelName() throws IOException {
        LabeledStatement labeledStatement = null;
        if (this.peekTokenOrEOL() == 39) {
            this.consumeToken();
            if (this.labelSet != null) {
                labeledStatement = this.labelSet.get(this.ts.getString());
            }
            if (labeledStatement == null) {
                this.reportError("msg.undef.label");
            }
        }
        return labeledStatement;
    }

    private BreakStatement breakStatement() throws IOException {
        LabeledStatement labeledStatement;
        Jump jump;
        if (this.currentToken != 120) {
            this.codeBug();
        }
        this.consumeToken();
        int n = this.ts.lineno;
        int n2 = this.ts.tokenBeg;
        int n3 = this.ts.tokenEnd;
        Name name = null;
        if (this.peekTokenOrEOL() == 39) {
            name = this.createNameNode();
            n3 = this.getNodeEnd(name);
        }
        Label label = jump = (labeledStatement = this.matchJumpLabelName()) == null ? null : labeledStatement.getFirstLabel();
        if (jump == null && name == null) {
            if (this.loopAndSwitchSet == null || this.loopAndSwitchSet.size() == 0) {
                if (name == null) {
                    this.reportError("msg.bad.break", n2, n3 - n2);
                }
            } else {
                jump = this.loopAndSwitchSet.get(this.loopAndSwitchSet.size() - 1);
            }
        }
        BreakStatement breakStatement = new BreakStatement(n2, n3 - n2);
        breakStatement.setBreakLabel(name);
        if (jump != null) {
            breakStatement.setBreakTarget(jump);
        }
        breakStatement.setLineno(n);
        return breakStatement;
    }

    private ContinueStatement continueStatement() throws IOException {
        if (this.currentToken != 121) {
            this.codeBug();
        }
        this.consumeToken();
        int n = this.ts.lineno;
        int n2 = this.ts.tokenBeg;
        int n3 = this.ts.tokenEnd;
        Name name = null;
        if (this.peekTokenOrEOL() == 39) {
            name = this.createNameNode();
            n3 = this.getNodeEnd(name);
        }
        LabeledStatement labeledStatement = this.matchJumpLabelName();
        Loop loop = null;
        if (labeledStatement == null && name == null) {
            if (this.loopSet == null || this.loopSet.size() == 0) {
                this.reportError("msg.continue.outside");
            } else {
                loop = this.loopSet.get(this.loopSet.size() - 1);
            }
        } else {
            if (labeledStatement == null || !(labeledStatement.getStatement() instanceof Loop)) {
                this.reportError("msg.continue.nonloop", n2, n3 - n2);
            }
            loop = labeledStatement == null ? null : (Loop)labeledStatement.getStatement();
        }
        ContinueStatement continueStatement = new ContinueStatement(n2, n3 - n2);
        if (loop != null) {
            continueStatement.setTarget(loop);
        }
        continueStatement.setLabel(name);
        continueStatement.setLineno(n);
        return continueStatement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private WithStatement withStatement() throws IOException {
        AstNode astNode;
        if (this.currentToken != 123) {
            this.codeBug();
        }
        this.consumeToken();
        int n = this.ts.lineno;
        int n2 = this.ts.tokenBeg;
        int n3 = -1;
        int n4 = -1;
        if (this.mustMatchToken(87, "msg.no.paren.with")) {
            n3 = this.ts.tokenBeg;
        }
        AstNode astNode2 = this.expr();
        if (this.mustMatchToken(88, "msg.no.paren.after.with")) {
            n4 = this.ts.tokenBeg;
        }
        ++this.nestingOfWith;
        try {
            astNode = this.statement();
        }
        finally {
            --this.nestingOfWith;
        }
        WithStatement withStatement = new WithStatement(n2, this.getNodeEnd(astNode) - n2);
        withStatement.setJsDoc(this.getAndResetJsDoc());
        withStatement.setExpression(astNode2);
        withStatement.setStatement(astNode);
        withStatement.setParens(n3, n4);
        withStatement.setLineno(n);
        return withStatement;
    }

    private AstNode letStatement() throws IOException {
        if (this.currentToken != 153) {
            this.codeBug();
        }
        this.consumeToken();
        int n = this.ts.lineno;
        int n2 = this.ts.tokenBeg;
        AstNode astNode = this.peekToken() == 87 ? this.let(true, n2) : this.variables(153, n2);
        astNode.setLineno(n);
        return astNode;
    }

    private static final boolean nowAllSet(int n, int n2, int n3) {
        return (n & n3) != n3 && (n2 & n3) == n3;
    }

    private AstNode returnOrYield(int n, boolean bl) throws IOException {
        AstNode astNode;
        if (!this.insideFunction()) {
            this.reportError(n == 4 ? "msg.bad.return" : "msg.bad.yield");
        }
        this.consumeToken();
        int n2 = this.ts.lineno;
        int n3 = this.ts.tokenBeg;
        int n4 = this.ts.tokenEnd;
        AstNode astNode2 = null;
        switch (this.peekTokenOrEOL()) {
            case -1: 
            case 0: 
            case 1: 
            case 72: 
            case 82: 
            case 84: 
            case 86: 
            case 88: {
                break;
            }
            default: {
                astNode2 = this.expr();
                n4 = this.getNodeEnd(astNode2);
            }
        }
        int n5 = this.endFlags;
        if (n == 4) {
            this.endFlags |= astNode2 == null ? 2 : 4;
            astNode = new ReturnStatement(n3, n4 - n3, astNode2);
            if (Parser.nowAllSet(n5, this.endFlags, 6)) {
                this.addStrictWarning("msg.return.inconsistent", "", n3, n4 - n3);
            }
        } else {
            if (!this.insideFunction()) {
                this.reportError("msg.bad.yield");
            }
            this.endFlags |= 8;
            astNode = new Yield(n3, n4 - n3, astNode2);
            this.setRequiresActivation();
            this.setIsGenerator();
            if (!bl) {
                astNode = new ExpressionStatement(astNode);
            }
        }
        if (this.insideFunction() && Parser.nowAllSet(n5, this.endFlags, 12)) {
            Name name = ((FunctionNode)this.currentScriptOrFn).getFunctionName();
            if (name == null || name.length() == 0) {
                this.addError("msg.anon.generator.returns", "");
            } else {
                this.addError("msg.generator.returns", name.getIdentifier());
            }
        }
        astNode.setLineno(n2);
        return astNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AstNode block() throws IOException {
        if (this.currentToken != 85) {
            this.codeBug();
        }
        this.consumeToken();
        int n = this.ts.tokenBeg;
        Scope scope = new Scope(n);
        scope.setLineno(this.ts.lineno);
        this.pushScope(scope);
        try {
            this.statements(scope);
            this.mustMatchToken(86, "msg.no.brace.block");
            scope.setLength(this.ts.tokenEnd - n);
            Scope scope2 = scope;
            return scope2;
        }
        finally {
            this.popScope();
        }
    }

    private AstNode defaultXmlNamespace() throws IOException {
        if (this.currentToken != 116) {
            this.codeBug();
        }
        this.consumeToken();
        this.mustHaveXML();
        this.setRequiresActivation();
        int n = this.ts.lineno;
        int n2 = this.ts.tokenBeg;
        if (!this.matchToken(39) || !"xml".equals(this.ts.getString())) {
            this.reportError("msg.bad.namespace");
        }
        if (!this.matchToken(39) || !"namespace".equals(this.ts.getString())) {
            this.reportError("msg.bad.namespace");
        }
        if (!this.matchToken(90)) {
            this.reportError("msg.bad.namespace");
        }
        AstNode astNode = this.expr();
        UnaryExpression unaryExpression = new UnaryExpression(n2, this.getNodeEnd(astNode) - n2);
        unaryExpression.setOperator(74);
        unaryExpression.setOperand(astNode);
        unaryExpression.setLineno(n);
        ExpressionStatement expressionStatement = new ExpressionStatement(unaryExpression, true);
        return expressionStatement;
    }

    private void recordLabel(Label label, LabeledStatement labeledStatement) throws IOException {
        if (this.peekToken() != 103) {
            this.codeBug();
        }
        this.consumeToken();
        String string = label.getName();
        if (this.labelSet == null) {
            this.labelSet = new HashMap<String, LabeledStatement>();
        } else {
            LabeledStatement labeledStatement2 = this.labelSet.get(string);
            if (labeledStatement2 != null) {
                if (this.compilerEnv.isIdeMode()) {
                    Label label2 = labeledStatement2.getLabelByName(string);
                    this.reportError("msg.dup.label", label2.getAbsolutePosition(), label2.getLength());
                }
                this.reportError("msg.dup.label", label.getPosition(), label.getLength());
            }
        }
        labeledStatement.addLabel(label);
        this.labelSet.put(string, labeledStatement);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AstNode nameOrLabel() throws IOException {
        if (this.currentToken != 39) {
            throw this.codeBug();
        }
        int n = this.ts.tokenBeg;
        this.currentFlaggedToken |= 0x20000;
        AstNode astNode = this.expr();
        if (astNode.getType() != 130) {
            ExpressionStatement expressionStatement = new ExpressionStatement(astNode, !this.insideFunction());
            expressionStatement.lineno = astNode.lineno;
            return expressionStatement;
        }
        LabeledStatement labeledStatement = new LabeledStatement(n);
        this.recordLabel((Label)astNode, labeledStatement);
        labeledStatement.setLineno(this.ts.lineno);
        AstNode astNode2 = null;
        while (this.peekToken() == 39) {
            this.currentFlaggedToken |= 0x20000;
            astNode = this.expr();
            if (astNode.getType() != 130) {
                astNode2 = new ExpressionStatement(astNode, !this.insideFunction());
                this.autoInsertSemicolon(astNode2);
                break;
            }
            this.recordLabel((Label)astNode, labeledStatement);
        }
        try {
            this.currentLabel = labeledStatement;
            if (astNode2 == null) {
                astNode2 = this.statementHelper();
            }
        }
        finally {
            this.currentLabel = null;
            for (Label label : labeledStatement.getLabels()) {
                this.labelSet.remove(label.getName());
            }
        }
        labeledStatement.setLength(this.getNodeEnd(astNode2) - n);
        labeledStatement.setStatement(astNode2);
        return labeledStatement;
    }

    private VariableDeclaration variables(int n, int n2) throws IOException {
        int n3;
        VariableDeclaration variableDeclaration = new VariableDeclaration(n2);
        variableDeclaration.setType(n);
        variableDeclaration.setLineno(this.ts.lineno);
        String string = this.getAndResetJsDoc();
        if (string != null) {
            variableDeclaration.setJsDoc(string);
        }
        do {
            AstNode astNode = null;
            Name name = null;
            int n4 = this.peekToken();
            int n5 = this.ts.tokenBeg;
            n3 = this.ts.tokenEnd;
            if (n4 == 83 || n4 == 85) {
                astNode = this.destructuringPrimaryExpr();
                n3 = this.getNodeEnd(astNode);
                if (!(astNode instanceof DestructuringForm)) {
                    this.reportError("msg.bad.assign.left", n5, n3 - n5);
                }
                this.markDestructuring(astNode);
            } else {
                String string2;
                this.mustMatchToken(39, "msg.bad.var");
                name = this.createNameNode();
                name.setLineno(this.ts.getLineno());
                if (this.inUseStrictDirective && ("eval".equals(string2 = this.ts.getString()) || "arguments".equals(this.ts.getString()))) {
                    this.reportError("msg.bad.id.strict", string2);
                }
                this.defineSymbol(n, this.ts.getString(), this.inForInit);
            }
            int n6 = this.ts.lineno;
            String string3 = this.getAndResetJsDoc();
            AstNode astNode2 = null;
            if (this.matchToken(90)) {
                astNode2 = this.assignExpr();
                n3 = this.getNodeEnd(astNode2);
            }
            VariableInitializer variableInitializer = new VariableInitializer(n5, n3 - n5);
            if (astNode != null) {
                if (astNode2 == null && !this.inForInit) {
                    this.reportError("msg.destruct.assign.no.init");
                }
                variableInitializer.setTarget(astNode);
            } else {
                variableInitializer.setTarget(name);
            }
            variableInitializer.setInitializer(astNode2);
            variableInitializer.setType(n);
            variableInitializer.setJsDoc(string3);
            variableInitializer.setLineno(n6);
            variableDeclaration.addVariable(variableInitializer);
        } while (this.matchToken(89));
        variableDeclaration.setLength(n3 - n2);
        return variableDeclaration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AstNode let(boolean bl, int n) throws IOException {
        LetNode letNode = new LetNode(n);
        letNode.setLineno(this.ts.lineno);
        if (this.mustMatchToken(87, "msg.no.paren.after.let")) {
            letNode.setLp(this.ts.tokenBeg - n);
        }
        this.pushScope(letNode);
        try {
            VariableDeclaration variableDeclaration = this.variables(153, this.ts.tokenBeg);
            letNode.setVariables(variableDeclaration);
            if (this.mustMatchToken(88, "msg.no.paren.let")) {
                letNode.setRp(this.ts.tokenBeg - n);
            }
            if (bl && this.peekToken() == 85) {
                this.consumeToken();
                int n2 = this.ts.tokenBeg;
                AstNode astNode = this.statements();
                this.mustMatchToken(86, "msg.no.curly.let");
                astNode.setLength(this.ts.tokenEnd - n2);
                letNode.setLength(this.ts.tokenEnd - n);
                letNode.setBody(astNode);
                letNode.setType(153);
            } else {
                AstNode astNode = this.expr();
                letNode.setLength(this.getNodeEnd(astNode) - n);
                letNode.setBody(astNode);
                if (bl) {
                    ExpressionStatement expressionStatement = new ExpressionStatement(letNode, !this.insideFunction());
                    expressionStatement.setLineno(letNode.getLineno());
                    ExpressionStatement expressionStatement2 = expressionStatement;
                    return expressionStatement2;
                }
            }
        }
        finally {
            this.popScope();
        }
        return letNode;
    }

    void defineSymbol(int n, String string) {
        this.defineSymbol(n, string, false);
    }

    void defineSymbol(int n, String string, boolean bl) {
        int n2;
        Scope scope;
        if (string == null) {
            if (this.compilerEnv.isIdeMode()) {
                return;
            }
            this.codeBug();
        }
        Symbol symbol = (scope = this.currentScope.getDefiningScope(string)) != null ? scope.getSymbol(string) : null;
        int n3 = n2 = symbol != null ? symbol.getDeclType() : -1;
        if (symbol != null && (n2 == 154 || n == 154 || scope == this.currentScope && n2 == 153)) {
            this.addError(n2 == 154 ? "msg.const.redecl" : (n2 == 153 ? "msg.let.redecl" : (n2 == 122 ? "msg.var.redecl" : (n2 == 109 ? "msg.fn.redecl" : "msg.parm.redecl"))), string);
            return;
        }
        switch (n) {
            case 153: {
                if (!bl && (this.currentScope.getType() == 112 || this.currentScope instanceof Loop)) {
                    this.addError("msg.let.decl.not.in.block");
                    return;
                }
                this.currentScope.putSymbol(new Symbol(n, string));
                return;
            }
            case 109: 
            case 122: 
            case 154: {
                if (symbol != null) {
                    if (n2 == 122) {
                        this.addStrictWarning("msg.var.redecl", string);
                    } else if (n2 == 87) {
                        this.addStrictWarning("msg.var.hides.arg", string);
                    }
                } else {
                    this.currentScriptOrFn.putSymbol(new Symbol(n, string));
                }
                return;
            }
            case 87: {
                if (symbol != null) {
                    this.addWarning("msg.dup.parms", string);
                }
                this.currentScriptOrFn.putSymbol(new Symbol(n, string));
                return;
            }
        }
        throw this.codeBug();
    }

    private AstNode expr() throws IOException {
        AstNode astNode = this.assignExpr();
        int n = astNode.getPosition();
        while (this.matchToken(89)) {
            int n2 = this.ts.lineno;
            int n3 = this.ts.tokenBeg;
            if (this.compilerEnv.isStrictMode() && !astNode.hasSideEffects()) {
                this.addStrictWarning("msg.no.side.effects", "", n, this.nodeEnd(astNode) - n);
            }
            if (this.peekToken() == 72) {
                this.reportError("msg.yield.parenthesized");
            }
            astNode = new InfixExpression(89, astNode, this.assignExpr(), n3);
            astNode.setLineno(n2);
        }
        return astNode;
    }

    private AstNode assignExpr() throws IOException {
        int n = this.peekToken();
        if (n == 72) {
            return this.returnOrYield(n, true);
        }
        AstNode astNode = this.condExpr();
        n = this.peekToken();
        if (90 <= n && n <= 101) {
            this.consumeToken();
            String string = this.getAndResetJsDoc();
            this.markDestructuring(astNode);
            int n2 = this.ts.tokenBeg;
            int n3 = this.ts.getLineno();
            astNode = new Assignment(n, astNode, this.assignExpr(), n2);
            astNode.setLineno(n3);
            if (string != null) {
                astNode.setJsDoc(string);
            }
        } else if (n == 82 && astNode.getType() == 33 && this.currentJsDocComment != null) {
            astNode.setJsDoc(this.getAndResetJsDoc());
        }
        return astNode;
    }

    private AstNode condExpr() throws IOException {
        AstNode astNode = this.orExpr();
        if (this.matchToken(102)) {
            int n = this.ts.lineno;
            int n2 = this.ts.tokenBeg;
            int n3 = -1;
            AstNode astNode2 = this.assignExpr();
            if (this.mustMatchToken(103, "msg.no.colon.cond")) {
                n3 = this.ts.tokenBeg;
            }
            AstNode astNode3 = this.assignExpr();
            int n4 = astNode.getPosition();
            int n5 = this.getNodeEnd(astNode3) - n4;
            ConditionalExpression conditionalExpression = new ConditionalExpression(n4, n5);
            conditionalExpression.setLineno(n);
            conditionalExpression.setTestExpression(astNode);
            conditionalExpression.setTrueExpression(astNode2);
            conditionalExpression.setFalseExpression(astNode3);
            conditionalExpression.setQuestionMarkPosition(n2 - n4);
            conditionalExpression.setColonPosition(n3 - n4);
            astNode = conditionalExpression;
        }
        return astNode;
    }

    private AstNode orExpr() throws IOException {
        AstNode astNode = this.andExpr();
        if (this.matchToken(104)) {
            int n = this.ts.tokenBeg;
            int n2 = this.ts.lineno;
            astNode = new InfixExpression(104, astNode, this.orExpr(), n);
            astNode.setLineno(n2);
        }
        return astNode;
    }

    private AstNode andExpr() throws IOException {
        AstNode astNode = this.bitOrExpr();
        if (this.matchToken(105)) {
            int n = this.ts.tokenBeg;
            int n2 = this.ts.lineno;
            astNode = new InfixExpression(105, astNode, this.andExpr(), n);
            astNode.setLineno(n2);
        }
        return astNode;
    }

    private AstNode bitOrExpr() throws IOException {
        AstNode astNode = this.bitXorExpr();
        while (this.matchToken(9)) {
            int n = this.ts.tokenBeg;
            int n2 = this.ts.lineno;
            astNode = new InfixExpression(9, astNode, this.bitXorExpr(), n);
            astNode.setLineno(n2);
        }
        return astNode;
    }

    private AstNode bitXorExpr() throws IOException {
        AstNode astNode = this.bitAndExpr();
        while (this.matchToken(10)) {
            int n = this.ts.tokenBeg;
            int n2 = this.ts.lineno;
            astNode = new InfixExpression(10, astNode, this.bitAndExpr(), n);
            astNode.setLineno(n2);
        }
        return astNode;
    }

    private AstNode bitAndExpr() throws IOException {
        AstNode astNode = this.eqExpr();
        while (this.matchToken(11)) {
            int n = this.ts.tokenBeg;
            int n2 = this.ts.lineno;
            astNode = new InfixExpression(11, astNode, this.eqExpr(), n);
            astNode.setLineno(n2);
        }
        return astNode;
    }

    private AstNode eqExpr() throws IOException {
        AstNode astNode = this.relExpr();
        block3: while (true) {
            int n = this.peekToken();
            int n2 = this.ts.tokenBeg;
            int n3 = this.ts.lineno;
            switch (n) {
                case 12: 
                case 13: 
                case 46: 
                case 47: {
                    this.consumeToken();
                    int n4 = n;
                    if (this.compilerEnv.getLanguageVersion() == 120) {
                        if (n == 12) {
                            n4 = 46;
                        } else if (n == 13) {
                            n4 = 47;
                        }
                    }
                    astNode = new InfixExpression(n4, astNode, this.relExpr(), n2);
                    astNode.setLineno(n3);
                    continue block3;
                }
            }
            break;
        }
        return astNode;
    }

    private AstNode relExpr() throws IOException {
        AstNode astNode = this.shiftExpr();
        block4: while (true) {
            int n = this.peekToken();
            int n2 = this.ts.tokenBeg;
            int n3 = this.ts.lineno;
            switch (n) {
                case 52: {
                    if (this.inForInit) break block4;
                }
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 53: {
                    this.consumeToken();
                    astNode = new InfixExpression(n, astNode, this.shiftExpr(), n2);
                    astNode.setLineno(n3);
                    continue block4;
                }
            }
            break;
        }
        return astNode;
    }

    private AstNode shiftExpr() throws IOException {
        AstNode astNode = this.addExpr();
        block3: while (true) {
            int n = this.peekToken();
            int n2 = this.ts.tokenBeg;
            int n3 = this.ts.lineno;
            switch (n) {
                case 18: 
                case 19: 
                case 20: {
                    this.consumeToken();
                    astNode = new InfixExpression(n, astNode, this.addExpr(), n2);
                    astNode.setLineno(n3);
                    continue block3;
                }
            }
            break;
        }
        return astNode;
    }

    private AstNode addExpr() throws IOException {
        AstNode astNode = this.mulExpr();
        while (true) {
            int n = this.peekToken();
            int n2 = this.ts.tokenBeg;
            if (n != 21 && n != 22) break;
            this.consumeToken();
            int n3 = this.ts.lineno;
            astNode = new InfixExpression(n, astNode, this.mulExpr(), n2);
            astNode.setLineno(n3);
        }
        return astNode;
    }

    private AstNode mulExpr() throws IOException {
        AstNode astNode = this.unaryExpr();
        block3: while (true) {
            int n = this.peekToken();
            int n2 = this.ts.tokenBeg;
            switch (n) {
                case 23: 
                case 24: 
                case 25: {
                    this.consumeToken();
                    int n3 = this.ts.lineno;
                    astNode = new InfixExpression(n, astNode, this.unaryExpr(), n2);
                    astNode.setLineno(n3);
                    continue block3;
                }
            }
            break;
        }
        return astNode;
    }

    private AstNode unaryExpr() throws IOException {
        int n = this.peekToken();
        int n2 = this.ts.lineno;
        switch (n) {
            case 26: 
            case 27: 
            case 32: 
            case 126: {
                this.consumeToken();
                UnaryExpression unaryExpression = new UnaryExpression(n, this.ts.tokenBeg, this.unaryExpr());
                unaryExpression.setLineno(n2);
                return unaryExpression;
            }
            case 21: {
                this.consumeToken();
                UnaryExpression unaryExpression = new UnaryExpression(28, this.ts.tokenBeg, this.unaryExpr());
                unaryExpression.setLineno(n2);
                return unaryExpression;
            }
            case 22: {
                this.consumeToken();
                UnaryExpression unaryExpression = new UnaryExpression(29, this.ts.tokenBeg, this.unaryExpr());
                unaryExpression.setLineno(n2);
                return unaryExpression;
            }
            case 106: 
            case 107: {
                this.consumeToken();
                UnaryExpression unaryExpression = new UnaryExpression(n, this.ts.tokenBeg, this.memberExpr(true));
                unaryExpression.setLineno(n2);
                this.checkBadIncDec(unaryExpression);
                return unaryExpression;
            }
            case 31: {
                this.consumeToken();
                UnaryExpression unaryExpression = new UnaryExpression(n, this.ts.tokenBeg, this.unaryExpr());
                unaryExpression.setLineno(n2);
                return unaryExpression;
            }
            case -1: {
                this.consumeToken();
                return this.makeErrorNode();
            }
            case 14: {
                if (!this.compilerEnv.isXmlAvailable()) break;
                this.consumeToken();
                return this.memberExprTail(true, this.xmlInitializer());
            }
        }
        AstNode astNode = this.memberExpr(true);
        n = this.peekTokenOrEOL();
        if (n != 106 && n != 107) {
            return astNode;
        }
        this.consumeToken();
        UnaryExpression unaryExpression = new UnaryExpression(n, this.ts.tokenBeg, astNode, true);
        unaryExpression.setLineno(n2);
        this.checkBadIncDec(unaryExpression);
        return unaryExpression;
    }

    private AstNode xmlInitializer() throws IOException {
        if (this.currentToken != 14) {
            this.codeBug();
        }
        int n = this.ts.tokenBeg;
        int n2 = this.ts.getFirstXMLToken();
        if (n2 != 145 && n2 != 148) {
            this.reportError("msg.syntax");
            return this.makeErrorNode();
        }
        XmlLiteral xmlLiteral = new XmlLiteral(n);
        xmlLiteral.setLineno(this.ts.lineno);
        while (true) {
            switch (n2) {
                case 145: {
                    xmlLiteral.addFragment(new XmlString(this.ts.tokenBeg, this.ts.getString()));
                    this.mustMatchToken(85, "msg.syntax");
                    int n3 = this.ts.tokenBeg;
                    AstNode astNode = this.peekToken() == 86 ? new EmptyExpression(n3, this.ts.tokenEnd - n3) : this.expr();
                    this.mustMatchToken(86, "msg.syntax");
                    XmlExpression xmlExpression = new XmlExpression(n3, astNode);
                    xmlExpression.setIsXmlAttribute(this.ts.isXMLAttribute());
                    xmlExpression.setLength(this.ts.tokenEnd - n3);
                    xmlLiteral.addFragment(xmlExpression);
                    break;
                }
                case 148: {
                    xmlLiteral.addFragment(new XmlString(this.ts.tokenBeg, this.ts.getString()));
                    return xmlLiteral;
                }
                default: {
                    this.reportError("msg.syntax");
                    return this.makeErrorNode();
                }
            }
            n2 = this.ts.getNextXMLToken();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<AstNode> argumentList() throws IOException {
        if (this.matchToken(88)) {
            return null;
        }
        ArrayList<AstNode> arrayList = new ArrayList<AstNode>();
        boolean bl = this.inForInit;
        this.inForInit = false;
        try {
            do {
                if (this.peekToken() == 72) {
                    this.reportError("msg.yield.parenthesized");
                }
                arrayList.add(this.assignExpr());
            } while (this.matchToken(89));
        }
        finally {
            this.inForInit = bl;
        }
        this.mustMatchToken(88, "msg.no.paren.arg");
        return arrayList;
    }

    private AstNode memberExpr(boolean bl) throws IOException {
        AstNode astNode;
        int n = this.peekToken();
        int n2 = this.ts.lineno;
        if (n != 30) {
            astNode = this.primaryExpr();
        } else {
            Iterable<AstNode> iterable;
            this.consumeToken();
            int n3 = this.ts.tokenBeg;
            NewExpression newExpression = new NewExpression(n3);
            AstNode astNode2 = this.memberExpr(false);
            int n4 = this.getNodeEnd(astNode2);
            newExpression.setTarget(astNode2);
            int n5 = -1;
            if (this.matchToken(87)) {
                n5 = this.ts.tokenBeg;
                iterable = this.argumentList();
                if (iterable != null && iterable.size() > 65536) {
                    this.reportError("msg.too.many.constructor.args");
                }
                int n6 = this.ts.tokenBeg;
                n4 = this.ts.tokenEnd;
                if (iterable != null) {
                    newExpression.setArguments((List<AstNode>)iterable);
                }
                newExpression.setParens(n5 - n3, n6 - n3);
            }
            if (this.matchToken(85)) {
                iterable = this.objectLiteral();
                n4 = this.getNodeEnd((AstNode)iterable);
                newExpression.setInitializer((ObjectLiteral)iterable);
            }
            newExpression.setLength(n4 - n3);
            astNode = newExpression;
        }
        astNode.setLineno(n2);
        AstNode astNode3 = this.memberExprTail(bl, astNode);
        return astNode3;
    }

    private AstNode memberExprTail(boolean bl, AstNode astNode) throws IOException {
        if (astNode == null) {
            this.codeBug();
        }
        int n = astNode.getPosition();
        block6: while (true) {
            int n2 = this.peekToken();
            switch (n2) {
                case 108: 
                case 143: {
                    int n3 = this.ts.lineno;
                    astNode = this.propertyAccess(n2, astNode);
                    astNode.setLineno(n3);
                    continue block6;
                }
                case 146: {
                    this.consumeToken();
                    int n4 = this.ts.tokenBeg;
                    int n5 = -1;
                    int n3 = this.ts.lineno;
                    this.mustHaveXML();
                    this.setRequiresActivation();
                    AstNode astNode2 = this.expr();
                    int n6 = this.getNodeEnd(astNode2);
                    if (this.mustMatchToken(88, "msg.no.paren")) {
                        n5 = this.ts.tokenBeg;
                        n6 = this.ts.tokenEnd;
                    }
                    XmlDotQuery xmlDotQuery = new XmlDotQuery(n, n6 - n);
                    xmlDotQuery.setLeft(astNode);
                    xmlDotQuery.setRight(astNode2);
                    xmlDotQuery.setOperatorPosition(n4);
                    xmlDotQuery.setRp(n5 - n);
                    xmlDotQuery.setLineno(n3);
                    astNode = xmlDotQuery;
                    continue block6;
                }
                case 83: {
                    this.consumeToken();
                    int n7 = this.ts.tokenBeg;
                    int n8 = -1;
                    int n3 = this.ts.lineno;
                    AstNode astNode3 = this.expr();
                    int n6 = this.getNodeEnd(astNode3);
                    if (this.mustMatchToken(84, "msg.no.bracket.index")) {
                        n8 = this.ts.tokenBeg;
                        n6 = this.ts.tokenEnd;
                    }
                    ElementGet elementGet = new ElementGet(n, n6 - n);
                    elementGet.setTarget(astNode);
                    elementGet.setElement(astNode3);
                    elementGet.setParens(n7, n8);
                    elementGet.setLineno(n3);
                    astNode = elementGet;
                    continue block6;
                }
                case 87: {
                    if (!bl) break block6;
                    int n3 = this.ts.lineno;
                    this.consumeToken();
                    this.checkCallRequiresActivation(astNode);
                    FunctionCall functionCall = new FunctionCall(n);
                    functionCall.setTarget(astNode);
                    functionCall.setLineno(n3);
                    functionCall.setLp(this.ts.tokenBeg - n);
                    List<AstNode> list = this.argumentList();
                    if (list != null && list.size() > 65536) {
                        this.reportError("msg.too.many.function.args");
                    }
                    functionCall.setArguments(list);
                    functionCall.setRp(this.ts.tokenBeg - n);
                    functionCall.setLength(this.ts.tokenEnd - n);
                    astNode = functionCall;
                    continue block6;
                }
            }
            break;
        }
        return astNode;
    }

    private AstNode propertyAccess(int n, AstNode astNode) throws IOException {
        InfixExpression infixExpression;
        if (astNode == null) {
            this.codeBug();
        }
        int n2 = 0;
        int n3 = this.ts.lineno;
        int n4 = this.ts.tokenBeg;
        this.consumeToken();
        if (n == 143) {
            this.mustHaveXML();
            n2 = 4;
        }
        if (!this.compilerEnv.isXmlAvailable()) {
            this.mustMatchToken(39, "msg.no.name.after.dot");
            Name name = this.createNameNode(true, 33);
            PropertyGet propertyGet = new PropertyGet(astNode, name, n4);
            propertyGet.setLineno(n3);
            return propertyGet;
        }
        AstNode astNode2 = null;
        switch (this.nextToken()) {
            case 50: {
                this.saveNameTokenData(this.ts.tokenBeg, "throw", this.ts.lineno);
                astNode2 = this.propertyName(-1, "throw", n2);
                break;
            }
            case 39: {
                astNode2 = this.propertyName(-1, this.ts.getString(), n2);
                break;
            }
            case 23: {
                this.saveNameTokenData(this.ts.tokenBeg, "*", this.ts.lineno);
                astNode2 = this.propertyName(-1, "*", n2);
                break;
            }
            case 147: {
                astNode2 = this.attributeAccess();
                break;
            }
            default: {
                this.reportError("msg.no.name.after.dot");
                return this.makeErrorNode();
            }
        }
        boolean bl = astNode2 instanceof XmlRef;
        InfixExpression infixExpression2 = infixExpression = bl ? new XmlMemberGet() : new PropertyGet();
        if (bl && n == 108) {
            infixExpression.setType(108);
        }
        int n5 = astNode.getPosition();
        infixExpression.setPosition(n5);
        infixExpression.setLength(this.getNodeEnd(astNode2) - n5);
        infixExpression.setOperatorPosition(n4 - n5);
        infixExpression.setLineno(n3);
        infixExpression.setLeft(astNode);
        infixExpression.setRight(astNode2);
        return infixExpression;
    }

    private AstNode attributeAccess() throws IOException {
        int n = this.nextToken();
        int n2 = this.ts.tokenBeg;
        switch (n) {
            case 39: {
                return this.propertyName(n2, this.ts.getString(), 0);
            }
            case 23: {
                this.saveNameTokenData(this.ts.tokenBeg, "*", this.ts.lineno);
                return this.propertyName(n2, "*", 0);
            }
            case 83: {
                return this.xmlElemRef(n2, null, -1);
            }
        }
        this.reportError("msg.no.name.after.xmlAttr");
        return this.makeErrorNode();
    }

    private AstNode propertyName(int n, String string, int n2) throws IOException {
        int n3 = n != -1 ? n : this.ts.tokenBeg;
        int n4 = this.ts.lineno;
        int n5 = -1;
        Name name = this.createNameNode(true, this.currentToken);
        Name name2 = null;
        if (this.matchToken(144)) {
            name2 = name;
            n5 = this.ts.tokenBeg;
            switch (this.nextToken()) {
                case 39: {
                    name = this.createNameNode();
                    break;
                }
                case 23: {
                    this.saveNameTokenData(this.ts.tokenBeg, "*", this.ts.lineno);
                    name = this.createNameNode(false, -1);
                    break;
                }
                case 83: {
                    return this.xmlElemRef(n, name2, n5);
                }
                default: {
                    this.reportError("msg.no.name.after.coloncolon");
                    return this.makeErrorNode();
                }
            }
        }
        if (name2 == null && n2 == 0 && n == -1) {
            return name;
        }
        XmlPropRef xmlPropRef = new XmlPropRef(n3, this.getNodeEnd(name) - n3);
        xmlPropRef.setAtPos(n);
        xmlPropRef.setNamespace(name2);
        xmlPropRef.setColonPos(n5);
        xmlPropRef.setPropName(name);
        xmlPropRef.setLineno(n4);
        return xmlPropRef;
    }

    private XmlElemRef xmlElemRef(int n, Name name, int n2) throws IOException {
        int n3 = this.ts.tokenBeg;
        int n4 = -1;
        int n5 = n != -1 ? n : n3;
        AstNode astNode = this.expr();
        int n6 = this.getNodeEnd(astNode);
        if (this.mustMatchToken(84, "msg.no.bracket.index")) {
            n4 = this.ts.tokenBeg;
            n6 = this.ts.tokenEnd;
        }
        XmlElemRef xmlElemRef = new XmlElemRef(n5, n6 - n5);
        xmlElemRef.setNamespace(name);
        xmlElemRef.setColonPos(n2);
        xmlElemRef.setAtPos(n);
        xmlElemRef.setExpression(astNode);
        xmlElemRef.setBrackets(n3, n4);
        return xmlElemRef;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AstNode destructuringPrimaryExpr() throws IOException, ParserException {
        try {
            this.inDestructuringAssignment = true;
            AstNode astNode = this.primaryExpr();
            return astNode;
        }
        finally {
            this.inDestructuringAssignment = false;
        }
    }

    private AstNode primaryExpr() throws IOException {
        int n = this.nextFlaggedToken();
        int n2 = n & 0xFFFF;
        switch (n2) {
            case 109: {
                return this.function(2);
            }
            case 83: {
                return this.arrayLiteral();
            }
            case 85: {
                return this.objectLiteral();
            }
            case 153: {
                return this.let(false, this.ts.tokenBeg);
            }
            case 87: {
                return this.parenExpr();
            }
            case 147: {
                this.mustHaveXML();
                return this.attributeAccess();
            }
            case 39: {
                return this.name(n, n2);
            }
            case 40: {
                String string = this.ts.getString();
                if (this.inUseStrictDirective && this.ts.isNumberOctal()) {
                    this.reportError("msg.no.octal.strict");
                }
                return new NumberLiteral(this.ts.tokenBeg, string, this.ts.getNumber());
            }
            case 41: {
                return this.createStringLiteral();
            }
            case 24: 
            case 100: {
                this.ts.readRegExp(n2);
                int n3 = this.ts.tokenBeg;
                int n4 = this.ts.tokenEnd;
                RegExpLiteral regExpLiteral = new RegExpLiteral(n3, n4 - n3);
                regExpLiteral.setValue(this.ts.getString());
                regExpLiteral.setFlags(this.ts.readAndClearRegExpFlags());
                return regExpLiteral;
            }
            case 42: 
            case 43: 
            case 44: 
            case 45: {
                int n5 = this.ts.tokenBeg;
                int n6 = this.ts.tokenEnd;
                return new KeywordLiteral(n5, n6 - n5, n2);
            }
            case 127: {
                this.reportError("msg.reserved.id");
                break;
            }
            case -1: {
                break;
            }
            case 0: {
                this.reportError("msg.unexpected.eof");
                break;
            }
            default: {
                this.reportError("msg.syntax");
            }
        }
        return this.makeErrorNode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AstNode parenExpr() throws IOException {
        boolean bl = this.inForInit;
        this.inForInit = false;
        try {
            String string = this.getAndResetJsDoc();
            int n = this.ts.lineno;
            AstNode astNode = this.expr();
            ParenthesizedExpression parenthesizedExpression = new ParenthesizedExpression(astNode);
            if (string == null) {
                string = this.getAndResetJsDoc();
            }
            if (string != null) {
                parenthesizedExpression.setJsDoc(string);
            }
            this.mustMatchToken(88, "msg.no.paren");
            parenthesizedExpression.setLength(this.ts.tokenEnd - parenthesizedExpression.getPosition());
            parenthesizedExpression.setLineno(n);
            ParenthesizedExpression parenthesizedExpression2 = parenthesizedExpression;
            return parenthesizedExpression2;
        }
        finally {
            this.inForInit = bl;
        }
    }

    private AstNode name(int n, int n2) throws IOException {
        String string = this.ts.getString();
        int n3 = this.ts.tokenBeg;
        int n4 = this.ts.lineno;
        if (0 != (n & 0x20000) && this.peekToken() == 103) {
            Label label = new Label(n3, this.ts.tokenEnd - n3);
            label.setName(string);
            label.setLineno(this.ts.lineno);
            return label;
        }
        this.saveNameTokenData(n3, string, n4);
        if (this.compilerEnv.isXmlAvailable()) {
            return this.propertyName(-1, string, 0);
        }
        return this.createNameNode(true, 39);
    }

    private AstNode arrayLiteral() throws IOException {
        if (this.currentToken != 83) {
            this.codeBug();
        }
        int n = this.ts.tokenBeg;
        int n2 = this.ts.tokenEnd;
        ArrayList<AstNode> arrayList = new ArrayList<AstNode>();
        ArrayLiteral arrayLiteral = new ArrayLiteral(n);
        boolean bl = true;
        int n3 = -1;
        int n4 = 0;
        while (true) {
            int n5;
            if ((n5 = this.peekToken()) == 89) {
                this.consumeToken();
                n3 = this.ts.tokenEnd;
                if (!bl) {
                    bl = true;
                    continue;
                }
                arrayList.add(new EmptyExpression(this.ts.tokenBeg, 1));
                ++n4;
                continue;
            }
            if (n5 == 84) {
                this.consumeToken();
                n2 = this.ts.tokenEnd;
                arrayLiteral.setDestructuringLength(arrayList.size() + (bl ? 1 : 0));
                arrayLiteral.setSkipCount(n4);
                if (n3 == -1) break;
                this.warnTrailingComma("msg.array.trailing.comma", n, arrayList, n3);
                break;
            }
            if (n5 == 119 && !bl && arrayList.size() == 1) {
                return this.arrayComprehension((AstNode)arrayList.get(0), n);
            }
            if (n5 == 0) {
                this.reportError("msg.no.bracket.arg");
                continue;
            }
            if (!bl) {
                this.reportError("msg.no.bracket.arg");
            }
            arrayList.add(this.assignExpr());
            bl = false;
            n3 = -1;
        }
        for (AstNode astNode : arrayList) {
            arrayLiteral.addElement(astNode);
        }
        arrayLiteral.setLength(n2 - n);
        return arrayLiteral;
    }

    private AstNode arrayComprehension(AstNode astNode, int n) throws IOException {
        ArrayList<ArrayComprehensionLoop> arrayList = new ArrayList<ArrayComprehensionLoop>();
        while (this.peekToken() == 119) {
            arrayList.add(this.arrayComprehensionLoop());
        }
        int n2 = -1;
        ConditionData conditionData = null;
        if (this.peekToken() == 112) {
            this.consumeToken();
            n2 = this.ts.tokenBeg - n;
            conditionData = this.condition();
        }
        this.mustMatchToken(84, "msg.no.bracket.arg");
        ArrayComprehension arrayComprehension = new ArrayComprehension(n, this.ts.tokenEnd - n);
        arrayComprehension.setResult(astNode);
        arrayComprehension.setLoops(arrayList);
        if (conditionData != null) {
            arrayComprehension.setIfPosition(n2);
            arrayComprehension.setFilter(conditionData.condition);
            arrayComprehension.setFilterLp(conditionData.lp - n);
            arrayComprehension.setFilterRp(conditionData.rp - n);
        }
        return arrayComprehension;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayComprehensionLoop arrayComprehensionLoop() throws IOException {
        if (this.nextToken() != 119) {
            this.codeBug();
        }
        int n = this.ts.tokenBeg;
        int n2 = -1;
        int n3 = -1;
        int n4 = -1;
        int n5 = -1;
        ArrayComprehensionLoop arrayComprehensionLoop = new ArrayComprehensionLoop(n);
        this.pushScope(arrayComprehensionLoop);
        try {
            if (this.matchToken(39)) {
                if (this.ts.getString().equals("each")) {
                    n2 = this.ts.tokenBeg - n;
                } else {
                    this.reportError("msg.no.paren.for");
                }
            }
            if (this.mustMatchToken(87, "msg.no.paren.for")) {
                n3 = this.ts.tokenBeg - n;
            }
            AstNode astNode = null;
            switch (this.peekToken()) {
                case 83: 
                case 85: {
                    astNode = this.destructuringPrimaryExpr();
                    this.markDestructuring(astNode);
                    break;
                }
                case 39: {
                    this.consumeToken();
                    astNode = this.createNameNode();
                    break;
                }
                default: {
                    this.reportError("msg.bad.var");
                }
            }
            if (astNode.getType() == 39) {
                this.defineSymbol(153, this.ts.getString(), true);
            }
            if (this.mustMatchToken(52, "msg.in.after.for.name")) {
                n5 = this.ts.tokenBeg - n;
            }
            AstNode astNode2 = this.expr();
            if (this.mustMatchToken(88, "msg.no.paren.for.ctrl")) {
                n4 = this.ts.tokenBeg - n;
            }
            arrayComprehensionLoop.setLength(this.ts.tokenEnd - n);
            arrayComprehensionLoop.setIterator(astNode);
            arrayComprehensionLoop.setIteratedObject(astNode2);
            arrayComprehensionLoop.setInPosition(n5);
            arrayComprehensionLoop.setEachPosition(n2);
            arrayComprehensionLoop.setIsForEach(n2 != -1);
            arrayComprehensionLoop.setParens(n3, n4);
            ArrayComprehensionLoop arrayComprehensionLoop2 = arrayComprehensionLoop;
            return arrayComprehensionLoop2;
        }
        finally {
            this.popScope();
        }
    }

    private ObjectLiteral objectLiteral() throws IOException {
        Object object;
        int n = this.ts.tokenBeg;
        int n2 = this.ts.lineno;
        int n3 = -1;
        ArrayList<ObjectProperty> arrayList = new ArrayList<ObjectProperty>();
        HashSet<ObjectLiteral> hashSet = new HashSet<ObjectLiteral>();
        block5: while (true) {
            object = null;
            int n4 = this.peekToken();
            String string = this.getAndResetJsDoc();
            switch (n4) {
                case 39: 
                case 41: {
                    AstNode astNode;
                    n3 = -1;
                    this.saveNameTokenData(this.ts.tokenBeg, this.ts.getString(), this.ts.lineno);
                    this.consumeToken();
                    StringLiteral stringLiteral = null;
                    if (n4 == 41) {
                        stringLiteral = this.createStringLiteral();
                    }
                    Name name = this.createNameNode();
                    object = this.ts.getString();
                    int n5 = this.ts.tokenBeg;
                    if (n4 == 39 && this.peekToken() == 39 && ("get".equals(object) || "set".equals(object))) {
                        this.consumeToken();
                        name = this.createNameNode();
                        name.setJsDoc(string);
                        astNode = this.getterSetterProperty(n5, name, "get".equals(object));
                        arrayList.add((ObjectProperty)astNode);
                        object = ((InfixExpression)astNode).getLeft().getString();
                        break;
                    }
                    astNode = stringLiteral != null ? stringLiteral : name;
                    astNode.setJsDoc(string);
                    arrayList.add(this.plainProperty(astNode, n4));
                    break;
                }
                case 40: {
                    this.consumeToken();
                    n3 = -1;
                    AstNode astNode = new NumberLiteral(this.ts.tokenBeg, this.ts.getString(), this.ts.getNumber());
                    astNode.setJsDoc(string);
                    object = this.ts.getString();
                    arrayList.add(this.plainProperty(astNode, n4));
                    break;
                }
                case 86: {
                    if (n3 == -1 || !this.compilerEnv.getWarnTrailingComma()) break block5;
                    this.warnTrailingComma("msg.extra.trailing.comma", n, arrayList, n3);
                    break block5;
                }
                default: {
                    this.reportError("msg.bad.prop");
                }
            }
            if (this.inUseStrictDirective) {
                if (hashSet.contains(object)) {
                    this.addError("msg.dup.obj.lit.prop.strict", (String)object);
                }
                hashSet.add((ObjectLiteral)object);
            }
            this.getAndResetJsDoc();
            string = null;
            if (!this.matchToken(89)) break;
            n3 = this.ts.tokenEnd;
        }
        this.mustMatchToken(86, "msg.no.brace.prop");
        object = new ObjectLiteral(n, this.ts.tokenEnd - n);
        ((ObjectLiteral)object).setElements(arrayList);
        ((Node)object).setLineno(n2);
        return object;
    }

    private ObjectProperty plainProperty(AstNode astNode, int n) throws IOException {
        int n2 = this.peekToken();
        if ((n2 == 89 || n2 == 86) && n == 39 && this.compilerEnv.getLanguageVersion() >= 180) {
            if (!this.inDestructuringAssignment) {
                this.reportError("msg.bad.object.init");
            }
            Name name = new Name(astNode.getPosition(), astNode.getString());
            ObjectProperty objectProperty = new ObjectProperty();
            objectProperty.putProp(26, Boolean.TRUE);
            objectProperty.setLeftAndRight(astNode, name);
            return objectProperty;
        }
        this.mustMatchToken(103, "msg.no.colon.prop");
        ObjectProperty objectProperty = new ObjectProperty();
        objectProperty.setOperatorPosition(this.ts.tokenBeg);
        objectProperty.setLeftAndRight(astNode, this.assignExpr());
        return objectProperty;
    }

    private ObjectProperty getterSetterProperty(int n, AstNode astNode, boolean bl) throws IOException {
        FunctionNode functionNode = this.function(2);
        Name name = functionNode.getFunctionName();
        if (name != null && name.length() != 0) {
            this.reportError("msg.bad.prop");
        }
        ObjectProperty objectProperty = new ObjectProperty(n);
        if (bl) {
            objectProperty.setIsGetter();
        } else {
            objectProperty.setIsSetter();
        }
        int n2 = this.getNodeEnd(functionNode);
        objectProperty.setLeft(astNode);
        objectProperty.setRight(functionNode);
        objectProperty.setLength(n2 - n);
        return objectProperty;
    }

    private Name createNameNode() {
        return this.createNameNode(false, 39);
    }

    private Name createNameNode(boolean bl, int n) {
        int n2 = this.ts.tokenBeg;
        String string = this.ts.getString();
        int n3 = this.ts.lineno;
        if (!"".equals(this.prevNameTokenString)) {
            n2 = this.prevNameTokenStart;
            string = this.prevNameTokenString;
            n3 = this.prevNameTokenLineno;
            this.prevNameTokenStart = 0;
            this.prevNameTokenString = "";
            this.prevNameTokenLineno = 0;
        }
        if (string == null) {
            if (this.compilerEnv.isIdeMode()) {
                string = "";
            } else {
                this.codeBug();
            }
        }
        Name name = new Name(n2, string);
        name.setLineno(n3);
        if (bl) {
            this.checkActivationName(string, n);
        }
        return name;
    }

    private StringLiteral createStringLiteral() {
        int n = this.ts.tokenBeg;
        int n2 = this.ts.tokenEnd;
        StringLiteral stringLiteral = new StringLiteral(n, n2 - n);
        stringLiteral.setLineno(this.ts.lineno);
        stringLiteral.setValue(this.ts.getString());
        stringLiteral.setQuoteCharacter(this.ts.getQuoteChar());
        return stringLiteral;
    }

    protected void checkActivationName(String string, int n) {
        if (!this.insideFunction()) {
            return;
        }
        boolean bl = false;
        if ("arguments".equals(string) || this.compilerEnv.getActivationNames() != null && this.compilerEnv.getActivationNames().contains(string)) {
            bl = true;
        } else if ("length".equals(string) && n == 33 && this.compilerEnv.getLanguageVersion() == 120) {
            bl = true;
        }
        if (bl) {
            this.setRequiresActivation();
        }
    }

    protected void setRequiresActivation() {
        if (this.insideFunction()) {
            ((FunctionNode)this.currentScriptOrFn).setRequiresActivation();
        }
    }

    private void checkCallRequiresActivation(AstNode astNode) {
        if (astNode.getType() == 39 && "eval".equals(((Name)astNode).getIdentifier()) || astNode.getType() == 33 && "eval".equals(((PropertyGet)astNode).getProperty().getIdentifier())) {
            this.setRequiresActivation();
        }
    }

    protected void setIsGenerator() {
        if (this.insideFunction()) {
            ((FunctionNode)this.currentScriptOrFn).setIsGenerator();
        }
    }

    private void checkBadIncDec(UnaryExpression unaryExpression) {
        AstNode astNode = this.removeParens(unaryExpression.getOperand());
        int n = astNode.getType();
        if (n != 39 && n != 33 && n != 36 && n != 67 && n != 38) {
            this.reportError(unaryExpression.getType() == 106 ? "msg.bad.incr" : "msg.bad.decr");
        }
    }

    private ErrorNode makeErrorNode() {
        ErrorNode errorNode = new ErrorNode(this.ts.tokenBeg, this.ts.tokenEnd - this.ts.tokenBeg);
        errorNode.setLineno(this.ts.lineno);
        return errorNode;
    }

    private int nodeEnd(AstNode astNode) {
        return astNode.getPosition() + astNode.getLength();
    }

    private void saveNameTokenData(int n, String string, int n2) {
        this.prevNameTokenStart = n;
        this.prevNameTokenString = string;
        this.prevNameTokenLineno = n2;
    }

    private int lineBeginningFor(int n) {
        if (this.sourceChars == null) {
            return -1;
        }
        if (n <= 0) {
            return 0;
        }
        char[] cArray = this.sourceChars;
        if (n >= cArray.length) {
            n = cArray.length - 1;
        }
        while (--n >= 0) {
            char c = cArray[n];
            if (c != '\n' && c != '\r') continue;
            return n + 1;
        }
        return 0;
    }

    private void warnMissingSemi(int n, int n2) {
        if (this.compilerEnv.isStrictMode()) {
            int n3 = Math.max(n, this.lineBeginningFor(n2));
            if (n2 == -1) {
                n2 = this.ts.cursor;
            }
            this.addStrictWarning("msg.missing.semi", "", n3, n2 - n3);
        }
    }

    private void warnTrailingComma(String string, int n, List<?> list, int n2) {
        if (this.compilerEnv.getWarnTrailingComma()) {
            if (!list.isEmpty()) {
                n = ((AstNode)list.get(0)).getPosition();
            }
            n = Math.max(n, this.lineBeginningFor(n2));
            this.addWarning("msg.extra.trailing.comma", n, n2 - n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readFully(Reader reader) throws IOException {
        try (BufferedReader bufferedReader = new BufferedReader(reader);){
            int n;
            char[] cArray = new char[1024];
            StringBuilder stringBuilder = new StringBuilder(1024);
            while ((n = bufferedReader.read(cArray, 0, 1024)) != -1) {
                stringBuilder.append(cArray, 0, n);
            }
            String string = stringBuilder.toString();
            return string;
        }
    }

    Node createDestructuringAssignment(int n, Node node, Node node2) {
        String string = this.currentScriptOrFn.getNextTempName();
        Node node3 = this.destructuringAssignmentHelper(n, node, node2, string);
        Node node4 = node3.getLastChild();
        node4.addChildToBack(this.createName(string));
        return node3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Node destructuringAssignmentHelper(int n, Node node, Node node2, String string) {
        Scope scope = this.createScopeNode(158, node.getLineno());
        scope.addChildToFront(new Node(153, this.createName(39, string, node2)));
        try {
            this.pushScope(scope);
            this.defineSymbol(153, string, true);
        }
        finally {
            this.popScope();
        }
        Node node3 = new Node(89);
        scope.addChildToBack(node3);
        ArrayList<String> arrayList = new ArrayList<String>();
        boolean bl = true;
        switch (node.getType()) {
            case 65: {
                bl = this.destructuringArray((ArrayLiteral)node, n, string, node3, arrayList);
                break;
            }
            case 66: {
                bl = this.destructuringObject((ObjectLiteral)node, n, string, node3, arrayList);
                break;
            }
            case 33: 
            case 36: {
                node3.addChildToBack(this.simpleAssignment(node, this.createName(string)));
                break;
            }
            default: {
                this.reportError("msg.bad.assign.left");
            }
        }
        if (bl) {
            node3.addChildToBack(this.createNumber(0.0));
        }
        scope.putProp(22, arrayList);
        return scope;
    }

    boolean destructuringArray(ArrayLiteral arrayLiteral, int n, String string, Node node, List<String> list) {
        boolean bl = true;
        int n2 = n == 154 ? 155 : 8;
        int n3 = 0;
        for (AstNode astNode : arrayLiteral.getElements()) {
            if (astNode.getType() == 128) {
                ++n3;
                continue;
            }
            Node node2 = new Node(36, this.createName(string), this.createNumber(n3));
            if (astNode.getType() == 39) {
                String string2 = astNode.getString();
                node.addChildToBack(new Node(n2, this.createName(49, string2, null), node2));
                if (n != -1) {
                    this.defineSymbol(n, string2, true);
                    list.add(string2);
                }
            } else {
                node.addChildToBack(this.destructuringAssignmentHelper(n, astNode, node2, this.currentScriptOrFn.getNextTempName()));
            }
            ++n3;
            bl = false;
        }
        return bl;
    }

    boolean destructuringObject(ObjectLiteral objectLiteral, int n, String string, Node node, List<String> list) {
        boolean bl = true;
        int n2 = n == 154 ? 155 : 8;
        for (ObjectProperty objectProperty : objectLiteral.getElements()) {
            Node node2;
            int n3 = 0;
            if (this.ts != null) {
                n3 = this.ts.lineno;
            }
            AstNode astNode = objectProperty.getLeft();
            Node node3 = null;
            if (astNode instanceof Name) {
                node2 = Node.newString(((Name)astNode).getIdentifier());
                node3 = new Node(33, this.createName(string), node2);
            } else if (astNode instanceof StringLiteral) {
                node2 = Node.newString(((StringLiteral)astNode).getValue());
                node3 = new Node(33, this.createName(string), node2);
            } else if (astNode instanceof NumberLiteral) {
                node2 = this.createNumber((int)((NumberLiteral)astNode).getNumber());
                node3 = new Node(36, this.createName(string), node2);
            } else {
                throw this.codeBug();
            }
            node3.setLineno(n3);
            node2 = objectProperty.getRight();
            if (node2.getType() == 39) {
                String string2 = ((Name)node2).getIdentifier();
                node.addChildToBack(new Node(n2, this.createName(49, string2, null), node3));
                if (n != -1) {
                    this.defineSymbol(n, string2, true);
                    list.add(string2);
                }
            } else {
                node.addChildToBack(this.destructuringAssignmentHelper(n, node2, node3, this.currentScriptOrFn.getNextTempName()));
            }
            bl = false;
        }
        return bl;
    }

    protected Node createName(String string) {
        this.checkActivationName(string, 39);
        return Node.newString(39, string);
    }

    protected Node createName(int n, String string, Node node) {
        Node node2 = this.createName(string);
        node2.setType(n);
        if (node != null) {
            node2.addChildToBack(node);
        }
        return node2;
    }

    protected Node createNumber(double d) {
        return Node.newNumber(d);
    }

    protected Scope createScopeNode(int n, int n2) {
        Scope scope = new Scope();
        scope.setType(n);
        scope.setLineno(n2);
        return scope;
    }

    protected Node simpleAssignment(Node node, Node node2) {
        int n = node.getType();
        switch (n) {
            case 39: {
                if (this.inUseStrictDirective && "eval".equals(((Name)node).getIdentifier())) {
                    this.reportError("msg.bad.id.strict", ((Name)node).getIdentifier());
                }
                node.setType(49);
                return new Node(8, node, node2);
            }
            case 33: 
            case 36: {
                int n2;
                Node node3;
                Node node4;
                if (node instanceof PropertyGet) {
                    node4 = ((PropertyGet)node).getTarget();
                    node3 = ((PropertyGet)node).getProperty();
                } else if (node instanceof ElementGet) {
                    node4 = ((ElementGet)node).getTarget();
                    node3 = ((ElementGet)node).getElement();
                } else {
                    node4 = node.getFirstChild();
                    node3 = node.getLastChild();
                }
                if (n == 33) {
                    n2 = 35;
                    node3.setType(41);
                } else {
                    n2 = 37;
                }
                return new Node(n2, node4, node3, node2);
            }
            case 67: {
                Node node5 = node.getFirstChild();
                this.checkMutableReference(node5);
                return new Node(68, node5, node2);
            }
        }
        throw this.codeBug();
    }

    protected void checkMutableReference(Node node) {
        int n = node.getIntProp(16, 0);
        if ((n & 4) != 0) {
            this.reportError("msg.bad.assign.left");
        }
    }

    protected AstNode removeParens(AstNode astNode) {
        while (astNode instanceof ParenthesizedExpression) {
            astNode = ((ParenthesizedExpression)astNode).getExpression();
        }
        return astNode;
    }

    void markDestructuring(AstNode astNode) {
        if (astNode instanceof DestructuringForm) {
            ((DestructuringForm)((Object)astNode)).setIsDestructuring(true);
        } else if (astNode instanceof ParenthesizedExpression) {
            this.markDestructuring(((ParenthesizedExpression)astNode).getExpression());
        }
    }

    private RuntimeException codeBug() throws RuntimeException {
        throw Kit.codeBug("ts.cursor=" + this.ts.cursor + ", ts.tokenBeg=" + this.ts.tokenBeg + ", currentToken=" + this.currentToken);
    }

    protected class PerFunctionVariables {
        private ScriptNode savedCurrentScriptOrFn;
        private Scope savedCurrentScope;
        private int savedNestingOfWith;
        private int savedEndFlags;
        private boolean savedInForInit;
        private Map<String, LabeledStatement> savedLabelSet;
        private List<Loop> savedLoopSet;
        private List<Jump> savedLoopAndSwitchSet;

        PerFunctionVariables(FunctionNode functionNode) {
            this.savedCurrentScriptOrFn = Parser.this.currentScriptOrFn;
            Parser.this.currentScriptOrFn = functionNode;
            this.savedCurrentScope = Parser.this.currentScope;
            Parser.this.currentScope = functionNode;
            this.savedNestingOfWith = Parser.this.nestingOfWith;
            Parser.this.nestingOfWith = 0;
            this.savedLabelSet = Parser.this.labelSet;
            Parser.this.labelSet = null;
            this.savedLoopSet = Parser.this.loopSet;
            Parser.this.loopSet = null;
            this.savedLoopAndSwitchSet = Parser.this.loopAndSwitchSet;
            Parser.this.loopAndSwitchSet = null;
            this.savedEndFlags = Parser.this.endFlags;
            Parser.this.endFlags = 0;
            this.savedInForInit = Parser.this.inForInit;
            Parser.this.inForInit = false;
        }

        void restore() {
            Parser.this.currentScriptOrFn = this.savedCurrentScriptOrFn;
            Parser.this.currentScope = this.savedCurrentScope;
            Parser.this.nestingOfWith = this.savedNestingOfWith;
            Parser.this.labelSet = this.savedLabelSet;
            Parser.this.loopSet = this.savedLoopSet;
            Parser.this.loopAndSwitchSet = this.savedLoopAndSwitchSet;
            Parser.this.endFlags = this.savedEndFlags;
            Parser.this.inForInit = this.savedInForInit;
        }
    }

    private static class ConditionData {
        AstNode condition;
        int lp = -1;
        int rp = -1;

        private ConditionData() {
        }
    }

    private static class ParserException
    extends RuntimeException {
        static final long serialVersionUID = 5882582646773765630L;

        private ParserException() {
        }
    }
}

