/*
 * Decompiled with CFR 0.152.
 */
package sun.lwawt;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.ItemSelectable;
import java.awt.List;
import java.awt.Point;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.peer.ListPeer;
import java.util.Arrays;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import sun.lwawt.LWComponentPeer;
import sun.lwawt.PlatformComponent;

final class LWListPeer
extends LWComponentPeer<List, ScrollableJList>
implements ListPeer {
    LWListPeer(List list, PlatformComponent platformComponent) {
        super(list, platformComponent);
        if (!((List)this.getTarget()).isBackgroundSet()) {
            ((List)this.getTarget()).setBackground(SystemColor.text);
        }
    }

    @Override
    protected ScrollableJList createDelegate() {
        return new ScrollableJList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void initializeImpl() {
        super.initializeImpl();
        this.setMultipleMode(((List)this.getTarget()).isMultipleMode());
        int[] nArray = ((List)this.getTarget()).getSelectedIndexes();
        Object object = this.getDelegateLock();
        synchronized (object) {
            ((ScrollableJList)this.getDelegate()).setSkipStateChangedEvent(true);
            ((ScrollableJList)this.getDelegate()).getView().setSelectedIndices(nArray);
            ((ScrollableJList)this.getDelegate()).setSkipStateChangedEvent(false);
        }
    }

    @Override
    public boolean isFocusable() {
        return true;
    }

    @Override
    protected Component getDelegateFocusOwner() {
        return ((ScrollableJList)this.getDelegate()).getView();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[] getSelectedIndexes() {
        Object object = this.getDelegateLock();
        synchronized (object) {
            return ((ScrollableJList)this.getDelegate()).getView().getSelectedIndices();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(String string, int n) {
        Object object = this.getDelegateLock();
        synchronized (object) {
            ((ScrollableJList)this.getDelegate()).getModel().add(n, string);
            this.revalidate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delItems(int n, int n2) {
        Object object = this.getDelegateLock();
        synchronized (object) {
            ((ScrollableJList)this.getDelegate()).getModel().removeRange(n, n2);
            this.revalidate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAll() {
        Object object = this.getDelegateLock();
        synchronized (object) {
            ((ScrollableJList)this.getDelegate()).getModel().removeAllElements();
            this.revalidate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void select(int n) {
        Object object = this.getDelegateLock();
        synchronized (object) {
            ((ScrollableJList)this.getDelegate()).setSkipStateChangedEvent(true);
            ((ScrollableJList)this.getDelegate()).getView().setSelectedIndex(n);
            ((ScrollableJList)this.getDelegate()).setSkipStateChangedEvent(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deselect(int n) {
        Object object = this.getDelegateLock();
        synchronized (object) {
            ((ScrollableJList)this.getDelegate()).getView().getSelectionModel().removeSelectionInterval(n, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void makeVisible(int n) {
        Object object = this.getDelegateLock();
        synchronized (object) {
            ((ScrollableJList)this.getDelegate()).getView().ensureIndexIsVisible(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMultipleMode(boolean bl) {
        Object object = this.getDelegateLock();
        synchronized (object) {
            ((ScrollableJList)this.getDelegate()).getView().setSelectionMode(bl ? 2 : 0);
        }
    }

    @Override
    public Dimension getPreferredSize(int n) {
        return this.getMinimumSize(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension getMinimumSize(int n) {
        Object object = this.getDelegateLock();
        synchronized (object) {
            FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
            int n2 = fontMetrics.getHeight() - fontMetrics.getLeading() + 2;
            return new Dimension(20 + (fontMetrics == null ? 150 : fontMetrics.stringWidth("0123456789abcde")), (fontMetrics == null ? 10 : n2) * n + 4);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void revalidate() {
        Object object = this.getDelegateLock();
        synchronized (object) {
            ((ScrollableJList)this.getDelegate()).getView().invalidate();
            ((ScrollableJList)this.getDelegate()).validate();
        }
    }

    final class ScrollableJList
    extends JScrollPane
    implements ListSelectionListener {
        private boolean skipStateChangedEvent;
        private DefaultListModel<Object> model = new DefaultListModel<Object>(){

            @Override
            public void add(int n, Object object) {
                if (n == -1) {
                    this.addElement(object);
                } else {
                    super.add(n, object);
                }
            }
        };
        private int[] oldSelectedIndices = new int[0];

        ScrollableJList() {
            this.getViewport().setScrollMode(0);
            JListDelegate jListDelegate = new JListDelegate();
            jListDelegate.addListSelectionListener(this);
            this.getViewport().setView(jListDelegate);
            String[] stringArray = ((List)LWListPeer.this.getTarget()).getItems();
            for (int i = 0; i < stringArray.length; ++i) {
                this.model.add(i, stringArray[i]);
            }
        }

        public boolean isSkipStateChangedEvent() {
            return this.skipStateChangedEvent;
        }

        public void setSkipStateChangedEvent(boolean bl) {
            this.skipStateChangedEvent = bl;
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (!listSelectionEvent.getValueIsAdjusting() && !this.isSkipStateChangedEvent()) {
                JList jList = (JList)listSelectionEvent.getSource();
                for (int i = 0; i < jList.getModel().getSize(); ++i) {
                    boolean bl;
                    boolean bl2 = Arrays.binarySearch(this.oldSelectedIndices, i) >= 0;
                    if (bl2 == (bl = jList.isSelectedIndex(i))) continue;
                    int n = !bl2 && bl ? 1 : 2;
                    LWListPeer.this.postEvent(new ItemEvent((ItemSelectable)LWListPeer.this.getTarget(), 701, i, n));
                }
                this.oldSelectedIndices = jList.getSelectedIndices();
            }
        }

        public JList getView() {
            return (JList)this.getViewport().getView();
        }

        public DefaultListModel<Object> getModel() {
            return this.model;
        }

        @Override
        public void setEnabled(boolean bl) {
            this.getView().setEnabled(bl);
            super.setEnabled(bl);
        }

        @Override
        public void setOpaque(boolean bl) {
            super.setOpaque(bl);
            if (this.getView() != null) {
                this.getView().setOpaque(bl);
            }
        }

        @Override
        public void setFont(Font font) {
            super.setFont(font);
            if (this.getView() != null) {
                this.getView().setFont(font);
                LWListPeer.this.revalidate();
            }
        }

        private final class JListDelegate
        extends JList<Object> {
            JListDelegate() {
                super(ScrollableJList.this.model);
            }

            @Override
            public boolean hasFocus() {
                return ((List)LWListPeer.this.getTarget()).hasFocus();
            }

            @Override
            protected void processMouseEvent(MouseEvent mouseEvent) {
                int n;
                super.processMouseEvent(mouseEvent);
                if (mouseEvent.getID() == 500 && mouseEvent.getClickCount() == 2 && 0 <= (n = this.locationToIndex(mouseEvent.getPoint())) && n < this.getModel().getSize()) {
                    LWListPeer.this.postEvent(new ActionEvent(LWListPeer.this.getTarget(), 1001, this.getModel().getElementAt(n).toString(), mouseEvent.getWhen(), mouseEvent.getModifiers()));
                }
            }

            @Override
            protected void processKeyEvent(KeyEvent keyEvent) {
                Object e;
                super.processKeyEvent(keyEvent);
                if (keyEvent.getID() == 401 && keyEvent.getKeyCode() == 10 && (e = this.getSelectedValue()) != null) {
                    LWListPeer.this.postEvent(new ActionEvent(LWListPeer.this.getTarget(), 1001, e.toString(), keyEvent.getWhen(), keyEvent.getModifiers()));
                }
            }

            @Override
            public Point getLocationOnScreen() {
                return LWListPeer.this.getLocationOnScreen();
            }
        }
    }
}

