/*
 * Decompiled with CFR 0.152.
 */
package com.javafx.tools.doclets.internal.toolkit.builders;

import com.javafx.tools.doclets.internal.toolkit.Configuration;
import com.javafx.tools.doclets.internal.toolkit.Content;
import com.javafx.tools.doclets.internal.toolkit.FieldWriter;
import com.javafx.tools.doclets.internal.toolkit.builders.AbstractMemberBuilder;
import com.javafx.tools.doclets.internal.toolkit.builders.XMLNode;
import com.javafx.tools.doclets.internal.toolkit.util.VisibleMemberMap;
import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.FieldDoc;
import com.sun.javadoc.ProgramElementDoc;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FieldBuilder
extends AbstractMemberBuilder {
    private ClassDoc classDoc;
    private VisibleMemberMap visibleMemberMap;
    private FieldWriter writer;
    private List<ProgramElementDoc> fields;
    private int currentFieldIndex;

    private FieldBuilder(Configuration configuration) {
        super(configuration);
    }

    public static FieldBuilder getInstance(Configuration configuration, ClassDoc classDoc, FieldWriter writer) {
        FieldBuilder builder = new FieldBuilder(configuration);
        builder.classDoc = classDoc;
        builder.writer = writer;
        builder.visibleMemberMap = new VisibleMemberMap(classDoc, 2, configuration.nodeprecated);
        builder.fields = new ArrayList<ProgramElementDoc>(builder.visibleMemberMap.getLeafClassMembers(configuration));
        if (configuration.getMemberComparator() != null) {
            Collections.sort(builder.fields, configuration.getMemberComparator());
        }
        return builder;
    }

    @Override
    public String getName() {
        return "FieldDetails";
    }

    public List<ProgramElementDoc> members(ClassDoc classDoc) {
        return this.visibleMemberMap.getMembersFor(classDoc);
    }

    public VisibleMemberMap getVisibleMemberMap() {
        return this.visibleMemberMap;
    }

    @Override
    public boolean hasMembersToDocument() {
        return this.fields.size() > 0;
    }

    public void buildFieldDoc(XMLNode node, Content memberDetailsTree) {
        if (this.writer == null) {
            return;
        }
        int size = this.fields.size();
        if (size > 0) {
            Content fieldDetailsTree = this.writer.getFieldDetailsTreeHeader(this.classDoc, memberDetailsTree);
            this.currentFieldIndex = 0;
            while (this.currentFieldIndex < size) {
                Content fieldDocTree = this.writer.getFieldDocTreeHeader((FieldDoc)this.fields.get(this.currentFieldIndex), fieldDetailsTree);
                this.buildChildren(node, fieldDocTree);
                fieldDetailsTree.addContent(this.writer.getFieldDoc(fieldDocTree, this.currentFieldIndex == size - 1));
                ++this.currentFieldIndex;
            }
            memberDetailsTree.addContent(this.writer.getFieldDetails(fieldDetailsTree));
        }
    }

    public void buildSignature(XMLNode node, Content fieldDocTree) {
        fieldDocTree.addContent(this.writer.getSignature((FieldDoc)this.fields.get(this.currentFieldIndex)));
    }

    public void buildDeprecationInfo(XMLNode node, Content fieldDocTree) {
        this.writer.addDeprecated((FieldDoc)this.fields.get(this.currentFieldIndex), fieldDocTree);
    }

    public void buildFieldComments(XMLNode node, Content fieldDocTree) {
        if (!this.configuration.nocomment) {
            this.writer.addComments((FieldDoc)this.fields.get(this.currentFieldIndex), fieldDocTree);
        }
    }

    public void buildTagInfo(XMLNode node, Content fieldDocTree) {
        this.writer.addTags((FieldDoc)this.fields.get(this.currentFieldIndex), fieldDocTree);
    }

    public FieldWriter getWriter() {
        return this.writer;
    }
}

