/*
 * Decompiled with CFR 0.152.
 */
package com.javafx.tools.doclets.formats.html;

import com.javafx.tools.doclets.formats.html.AbstractMemberWriter;
import com.javafx.tools.doclets.formats.html.ConfigurationImpl;
import com.javafx.tools.doclets.formats.html.LinkInfoImpl;
import com.javafx.tools.doclets.formats.html.SubWriterHolderWriter;
import com.javafx.tools.doclets.formats.html.markup.HtmlConstants;
import com.javafx.tools.doclets.formats.html.markup.HtmlStyle;
import com.javafx.tools.doclets.formats.html.markup.HtmlTag;
import com.javafx.tools.doclets.formats.html.markup.HtmlTree;
import com.javafx.tools.doclets.formats.html.markup.RawHtml;
import com.javafx.tools.doclets.formats.html.markup.StringContent;
import com.javafx.tools.doclets.internal.toolkit.AnnotationTypeWriter;
import com.javafx.tools.doclets.internal.toolkit.Content;
import com.javafx.tools.doclets.internal.toolkit.builders.MemberSummaryBuilder;
import com.javafx.tools.doclets.internal.toolkit.util.DirectoryManager;
import com.javafx.tools.doclets.internal.toolkit.util.DocletAbortException;
import com.javafx.tools.doclets.internal.toolkit.util.Util;
import com.sun.javadoc.AnnotationTypeDoc;
import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.Doc;
import com.sun.javadoc.ProgramElementDoc;
import com.sun.javadoc.Tag;
import com.sun.javadoc.Type;

public class AnnotationTypeWriterImpl
extends SubWriterHolderWriter
implements AnnotationTypeWriter {
    protected AnnotationTypeDoc annotationType;
    protected Type prev;
    protected Type next;

    public AnnotationTypeWriterImpl(AnnotationTypeDoc annotationType, Type prevType, Type nextType) throws Exception {
        super(ConfigurationImpl.getInstance(), DirectoryManager.getDirectoryPath(annotationType.containingPackage()), annotationType.name() + ".html", DirectoryManager.getRelativePath(annotationType.containingPackage().name()));
        this.annotationType = annotationType;
        this.configuration.currentcd = annotationType.asClassDoc();
        this.prev = prevType;
        this.next = nextType;
    }

    protected Content getNavLinkPackage() {
        Content linkContent = this.getHyperLink("package-summary.html", "", this.packageLabel);
        HtmlTree li = HtmlTree.LI(linkContent);
        return li;
    }

    protected Content getNavLinkClass() {
        HtmlTree li = HtmlTree.LI(HtmlStyle.navBarCell1Rev, this.classLabel);
        return li;
    }

    protected Content getNavLinkClassUse() {
        Content linkContent = this.getHyperLink("class-use/" + this.filename, "", this.useLabel);
        HtmlTree li = HtmlTree.LI(linkContent);
        return li;
    }

    public Content getNavLinkPrevious() {
        HtmlTree li;
        if (this.prev != null) {
            RawHtml prevLink = new RawHtml(this.getLink(new LinkInfoImpl(2, this.prev.asClassDoc(), "", this.configuration.getText("doclet.Prev_Class"), true)));
            li = HtmlTree.LI(prevLink);
        } else {
            li = HtmlTree.LI(this.prevclassLabel);
        }
        return li;
    }

    public Content getNavLinkNext() {
        HtmlTree li;
        if (this.next != null) {
            RawHtml nextLink = new RawHtml(this.getLink(new LinkInfoImpl(2, this.next.asClassDoc(), "", this.configuration.getText("doclet.Next_Class"), true)));
            li = HtmlTree.LI(nextLink);
        } else {
            li = HtmlTree.LI(this.nextclassLabel);
        }
        return li;
    }

    public Content getHeader(String header) {
        String pkgname = this.annotationType.containingPackage() != null ? this.annotationType.containingPackage().name() : "";
        String clname = this.annotationType.name();
        HtmlTree bodyTree = this.getBody(true, this.getWindowTitle(clname));
        this.addTop(bodyTree);
        this.addNavLinks(true, bodyTree);
        ((Content)bodyTree).addContent(HtmlConstants.START_OF_CLASS_DATA);
        HtmlTree div = new HtmlTree(HtmlTag.DIV);
        div.addStyle(HtmlStyle.header);
        if (pkgname.length() > 0) {
            StringContent pkgNameContent = new StringContent(pkgname);
            HtmlTree pkgNameDiv = HtmlTree.DIV(HtmlStyle.subTitle, pkgNameContent);
            div.addContent(pkgNameDiv);
        }
        LinkInfoImpl linkInfo = new LinkInfoImpl(14, (ClassDoc)this.annotationType, false);
        StringContent headerContent = new StringContent(header);
        HtmlTree heading = HtmlTree.HEADING(HtmlConstants.CLASS_PAGE_HEADING, true, HtmlStyle.title, headerContent);
        ((Content)heading).addContent(new RawHtml(this.getTypeParameterLinks(linkInfo)));
        div.addContent(heading);
        ((Content)bodyTree).addContent(div);
        return bodyTree;
    }

    public Content getAnnotationContentHeader() {
        return this.getContentHeader();
    }

    public void addFooter(Content contentTree) {
        contentTree.addContent(HtmlConstants.END_OF_CLASS_DATA);
        this.addNavLinks(false, contentTree);
        this.addBottom(contentTree);
    }

    public void printDocument(Content contentTree) {
        this.printHtmlDocument(this.configuration.metakeywords.getMetaKeywords((ClassDoc)this.annotationType), true, contentTree);
    }

    public Content getAnnotationInfoTreeHeader() {
        return this.getMemberTreeHeader();
    }

    public Content getAnnotationInfo(Content annotationInfoTree) {
        return this.getMemberTree(HtmlStyle.description, annotationInfoTree);
    }

    public void addAnnotationTypeSignature(String modifiers, Content annotationInfoTree) {
        annotationInfoTree.addContent(new HtmlTree(HtmlTag.BR));
        HtmlTree pre = new HtmlTree(HtmlTag.PRE);
        this.addAnnotationInfo((ProgramElementDoc)this.annotationType, (Content)pre);
        ((Content)pre).addContent(modifiers);
        LinkInfoImpl linkInfo = new LinkInfoImpl(15, (ClassDoc)this.annotationType, false);
        StringContent annotationName = new StringContent(this.annotationType.name());
        RawHtml parameterLinks = new RawHtml(this.getTypeParameterLinks(linkInfo));
        if (this.configuration().linksource) {
            this.addSrcLink((ProgramElementDoc)this.annotationType, annotationName, pre);
            ((Content)pre).addContent(parameterLinks);
        } else {
            HtmlTree span = HtmlTree.SPAN(HtmlStyle.strong, annotationName);
            ((Content)span).addContent(parameterLinks);
            ((Content)pre).addContent(span);
        }
        annotationInfoTree.addContent(pre);
    }

    public void addAnnotationTypeDescription(Content annotationInfoTree) {
        if (!this.configuration.nocomment && this.annotationType.inlineTags().length > 0) {
            this.addInlineComment((Doc)this.annotationType, annotationInfoTree);
        }
    }

    public void addAnnotationTypeTagInfo(Content annotationInfoTree) {
        if (!this.configuration.nocomment) {
            this.addTagsInfo((Doc)this.annotationType, annotationInfoTree);
        }
    }

    public void addAnnotationTypeDeprecationInfo(Content annotationInfoTree) {
        HtmlTree hr = new HtmlTree(HtmlTag.HR);
        annotationInfoTree.addContent(hr);
        Tag[] deprs = this.annotationType.tags("deprecated");
        if (Util.isDeprecated((Doc)this.annotationType)) {
            Tag[] commentTags;
            HtmlTree strong = HtmlTree.STRONG(this.deprecatedPhrase);
            HtmlTree div = HtmlTree.DIV(HtmlStyle.block, strong);
            if (deprs.length > 0 && (commentTags = deprs[0].inlineTags()).length > 0) {
                ((Content)div).addContent(this.getSpace());
                this.addInlineDeprecatedComment((Doc)this.annotationType, deprs[0], div);
            }
            annotationInfoTree.addContent(div);
        }
    }

    public void addAnnotationDetailsMarker(Content memberDetails) {
        memberDetails.addContent(HtmlConstants.START_OF_ANNOTATION_TYPE_DETAILS);
    }

    protected Content getNavLinkTree() {
        Content treeLinkContent = this.getHyperLink("package-tree.html", "", this.treeLabel, "", "");
        HtmlTree li = HtmlTree.LI(treeLinkContent);
        return li;
    }

    protected void addSummaryDetailLinks(Content subDiv) {
        try {
            HtmlTree div = HtmlTree.DIV(this.getNavSummaryLinks());
            ((Content)div).addContent(this.getNavDetailLinks());
            subDiv.addContent(div);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new DocletAbortException();
        }
    }

    protected Content getNavSummaryLinks() throws Exception {
        HtmlTree li = HtmlTree.LI(this.summaryLabel);
        ((Content)li).addContent(this.getSpace());
        HtmlTree ulNav = HtmlTree.UL(HtmlStyle.subNavList, li);
        MemberSummaryBuilder memberSummaryBuilder = (MemberSummaryBuilder)this.configuration.getBuilderFactory().getMemberSummaryBuilder(this);
        HtmlTree liNavReq = new HtmlTree(HtmlTag.LI);
        this.addNavSummaryLink(memberSummaryBuilder, "doclet.navAnnotationTypeRequiredMember", 6, liNavReq);
        this.addNavGap(liNavReq);
        ((Content)ulNav).addContent(liNavReq);
        HtmlTree liNavOpt = new HtmlTree(HtmlTag.LI);
        this.addNavSummaryLink(memberSummaryBuilder, "doclet.navAnnotationTypeOptionalMember", 5, liNavOpt);
        ((Content)ulNav).addContent(liNavOpt);
        return ulNav;
    }

    protected void addNavSummaryLink(MemberSummaryBuilder builder, String label, int type, Content liNav) {
        AbstractMemberWriter writer = (AbstractMemberWriter)((Object)builder.getMemberSummaryWriter(type));
        if (writer == null) {
            liNav.addContent(this.getResource(label));
        } else {
            liNav.addContent(writer.getNavSummaryLink(null, !builder.getVisibleMemberMap(type).noVisibleMembers()));
        }
    }

    protected Content getNavDetailLinks() throws Exception {
        HtmlTree li = HtmlTree.LI(this.detailLabel);
        ((Content)li).addContent(this.getSpace());
        HtmlTree ulNav = HtmlTree.UL(HtmlStyle.subNavList, li);
        MemberSummaryBuilder memberSummaryBuilder = (MemberSummaryBuilder)this.configuration.getBuilderFactory().getMemberSummaryBuilder(this);
        AbstractMemberWriter writerOptional = (AbstractMemberWriter)((Object)memberSummaryBuilder.getMemberSummaryWriter(5));
        AbstractMemberWriter writerRequired = (AbstractMemberWriter)((Object)memberSummaryBuilder.getMemberSummaryWriter(6));
        if (writerOptional != null) {
            HtmlTree liNavOpt = new HtmlTree(HtmlTag.LI);
            writerOptional.addNavDetailLink(this.annotationType.elements().length > 0, (Content)liNavOpt);
            ((Content)ulNav).addContent(liNavOpt);
        } else if (writerRequired != null) {
            HtmlTree liNavReq = new HtmlTree(HtmlTag.LI);
            writerRequired.addNavDetailLink(this.annotationType.elements().length > 0, (Content)liNavReq);
            ((Content)ulNav).addContent(liNavReq);
        } else {
            HtmlTree liNav = HtmlTree.LI(this.getResource("doclet.navAnnotationTypeMember"));
            ((Content)ulNav).addContent(liNav);
        }
        return ulNav;
    }

    protected void addNavGap(Content liNav) {
        liNav.addContent(this.getSpace());
        liNav.addContent("|");
        liNav.addContent(this.getSpace());
    }

    public AnnotationTypeDoc getAnnotationTypeDoc() {
        return this.annotationType;
    }
}

