/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.asm.ia64;

import sun.jvm.hotspot.asm.Register;
import sun.jvm.hotspot.asm.ia64.IA64Registers;

public class IA64Register
extends Register {
    private static final int STACKED_BASE = 32;
    private static final int STACKED_END = 127;
    private static final int APPL_BASE = 128;
    private static final int nofRegisters = 129;

    public IA64Register(int number) {
        super(number);
    }

    @Override
    public int getNumberOfRegisters() {
        return 129;
    }

    public boolean isStacked() {
        return 32 <= this.getNumber();
    }

    public long spOffsetInSavedWindow() {
        return 0L;
    }

    public String toString() {
        return IA64Registers.getRegisterName(this.number);
    }

    @Override
    public boolean isFramePointer() {
        return this.number == 128;
    }

    @Override
    public boolean isStackPointer() {
        return this.number == 12;
    }

    @Override
    public boolean isFloat() {
        return false;
    }
}

