/*
 * Decompiled with CFR 0.152.
 */
package bluej.editor.moe;

import bluej.Config;
import bluej.editor.Editor;
import bluej.editor.EditorManager;
import bluej.editor.EditorWatcher;
import bluej.editor.moe.MoeEditor;
import bluej.editor.moe.MoeEditorParameters;
import bluej.parser.entity.EntityResolver;
import bluej.pkgmgr.JavadocResolver;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public final class MoeEditorManager
extends EditorManager {
    protected static MoeEditorManager editorManager;
    private Properties resources;
    private List<MoeEditor> editors = new ArrayList<MoeEditor>(4);
    private boolean showLineNum = false;
    private boolean showToolBar = true;

    public MoeEditorManager() {
        this.resources = Config.moeUserProps;
        editorManager = this;
    }

    @Override
    public Editor openClass(String filename, String docFilename, Charset charset, String windowTitle, EditorWatcher watcher, boolean compiled, Rectangle bounds, EntityResolver projectResolver, JavadocResolver javadocResolver) {
        return this.openEditor(filename, docFilename, charset, true, windowTitle, watcher, compiled, bounds, projectResolver, javadocResolver);
    }

    @Override
    public Editor openText(String filename, Charset charset, String windowTitle, Rectangle bounds) {
        return this.openEditor(filename, null, charset, false, windowTitle, null, false, bounds, null, null);
    }

    @Override
    public void refreshAll() {
        for (Editor editor : this.editors) {
            if (!editor.isShowing()) continue;
            editor.refresh();
        }
    }

    public static void beep() {
        Toolkit.getDefaultToolkit().beep();
    }

    @Override
    public void discardEditor(Editor ed) {
        ed.close();
        this.editors.remove(ed);
    }

    private Editor openEditor(String filename, String docFilename, Charset charset, boolean isCode, String windowTitle, EditorWatcher watcher, boolean compiled, Rectangle bounds, EntityResolver projectResolver, JavadocResolver javadocResolver) {
        MoeEditorParameters mep = new MoeEditorParameters(windowTitle, watcher, this.resources, projectResolver, javadocResolver);
        mep.setCode(isCode);
        mep.setShowToolbar(this.showToolBar);
        mep.setShowLineNum(this.showLineNum);
        MoeEditor editor = new MoeEditor(mep);
        this.editors.add(editor);
        if (editor.showFile(filename, charset, compiled, docFilename, bounds)) {
            return editor;
        }
        editor.doClose();
        return null;
    }
}

