/*
 * Decompiled with CFR 0.152.
 */
package bluej.editor.moe;

import bluej.Config;
import bluej.editor.moe.MoeActions;
import bluej.editor.moe.MoeEditor;
import bluej.prefmgr.PrefPanelListener;
import bluej.utility.Debug;
import bluej.utility.DialogManager;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.util.Properties;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.FocusManager;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class KeyBindingsPanel
extends JPanel
implements ActionListener,
ListSelectionListener,
ItemListener,
PrefPanelListener {
    static final String title = Config.getString((String)"editor.functions.title");
    static final String close = Config.getString((String)"close");
    static final String defaultsLabel = Config.getString((String)"editor.functions.defaults");
    static final String categoriesLabel = Config.getString((String)"editor.functions.categories");
    static final String keyLabel = Config.getString((String)"editor.functions.keys");
    static final String addKeyLabel = Config.getString((String)"editor.functions.addkey");
    static final String delKeyLabel = Config.getString((String)"editor.functions.delkey");
    private FocusManager focusMgr;
    private JButton defaultsButton;
    private JButton addKeyButton;
    private JButton delKeyButton;
    private JComboBox categoryMenu;
    private JList functionList;
    private JList keyList;
    private JTextArea helpLabel;
    private MoeActions actions = MoeActions.getActions(new JEditorPane());
    private Action currentAction;
    private KeyStroke[] currentKeys;
    private int firstDisplayedFunc;
    private Properties help;
    private Action[] functions;
    private String[] categories;
    private int[] categoryIndex;

    @Override
    public void actionPerformed(ActionEvent event) {
        Object src = event.getSource();
        if (src == this.defaultsButton) {
            this.handleDefaults();
        } else if (src == this.addKeyButton) {
            this.handleAddKey();
        } else if (src == this.delKeyButton) {
            this.handleDelKey();
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent event) {
        if (event.getValueIsAdjusting()) {
            return;
        }
        Object src = event.getSource();
        if (src == this.functionList) {
            this.handleFuncListSelect();
        } else if (src == this.keyList) {
            this.handleKeyListSelect();
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        int selected = this.categoryMenu.getSelectedIndex();
        this.firstDisplayedFunc = this.categoryIndex[selected];
        int lastFunc = this.categoryIndex[selected + 1];
        String[] names = new String[lastFunc - this.firstDisplayedFunc];
        for (int i = this.firstDisplayedFunc; i < lastFunc; ++i) {
            names[i - this.firstDisplayedFunc] = (String)this.functions[i].getValue("Name");
        }
        this.functionList.setListData(names);
        this.clearKeyList();
        this.clearHelpText();
        this.addKeyButton.setEnabled(false);
        this.delKeyButton.setEnabled(false);
        this.currentAction = null;
        this.currentKeys = null;
    }

    public JPanel makePanel() {
        GridLayout gridL = new GridLayout(1, 2);
        JPanel mainPanel = new JPanel(gridL);
        mainPanel.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
        JPanel funcPanel = new JPanel(new BorderLayout());
        funcPanel.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
        this.functionList = new JList();
        this.functionList.setSelectionMode(0);
        this.functionList.addListSelectionListener(this);
        this.functionList.setVisibleRowCount(12);
        JScrollPane scrollPane = new JScrollPane(this.functionList);
        funcPanel.add(scrollPane);
        JPanel categoryPanel = new JPanel();
        JLabel label = new JLabel(categoriesLabel);
        categoryPanel.add(label);
        this.categoryMenu = new JComboBox();
        categoryPanel.add(this.categoryMenu);
        funcPanel.add((Component)categoryPanel, "North");
        JPanel controlPanel = new JPanel(new BorderLayout());
        controlPanel.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
        JPanel keyPanel = new JPanel(new BorderLayout());
        JLabel kLabel = new JLabel(keyLabel);
        kLabel.setPreferredSize(this.categoryMenu.getPreferredSize());
        keyPanel.add((Component)kLabel, "North");
        this.keyList = new JList();
        this.keyList.setSelectionMode(0);
        this.keyList.setPrototypeCellValue("shift-ctrl-delete");
        this.keyList.setVisibleRowCount(4);
        scrollPane = new JScrollPane(this.keyList);
        keyPanel.add((Component)scrollPane, "Center");
        JPanel keyButtonPanel = new JPanel();
        this.addKeyButton = new JButton(addKeyLabel);
        this.addKeyButton.setMargin(new Insets(2, 2, 2, 2));
        keyButtonPanel.add(this.addKeyButton);
        this.delKeyButton = new JButton(delKeyLabel);
        this.delKeyButton.setMargin(new Insets(2, 2, 2, 2));
        keyButtonPanel.add(this.delKeyButton);
        this.defaultsButton = new JButton(defaultsLabel);
        keyButtonPanel.add(this.defaultsButton);
        keyPanel.add((Component)keyButtonPanel, "South");
        controlPanel.add(keyPanel);
        JPanel helpPanel = new JPanel(new GridLayout());
        helpPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(10, 0, 0, 0), BorderFactory.createLineBorder(Color.black)));
        this.helpLabel = new JTextArea();
        this.helpLabel.setRows(6);
        this.helpLabel.setLineWrap(true);
        this.helpLabel.setWrapStyleWord(true);
        this.helpLabel.setBackground(MoeEditor.infoColor);
        helpPanel.add(this.helpLabel);
        controlPanel.add((Component)helpPanel, "South");
        mainPanel.add(funcPanel);
        mainPanel.add(controlPanel);
        this.updateDispay();
        return mainPanel;
    }

    public void beginEditing() {
    }

    public void commitEditing() {
        this.handleClose();
    }

    public void revertEditing() {
    }

    public void setActionValues(Action[] actiontable, String[] categories, int[] categoryIndex) {
        this.categories = categories;
        this.functions = actiontable;
        this.categoryIndex = categoryIndex;
    }

    public void updateDispay() {
        this.categoryMenu.addItemListener(this);
        this.delKeyButton.addActionListener(this);
        this.addKeyButton.addActionListener(this);
        this.keyList.addListSelectionListener(this);
        this.defaultsButton.addActionListener(this);
        this.focusMgr = FocusManager.getCurrentManager();
        this.openHelpFile();
        for (int i = 0; i < this.categories.length; ++i) {
            this.categoryMenu.addItem(this.categories[i]);
        }
    }

    private void handleDefaults() {
        int answer = DialogManager.askQuestion((Component)this, (String)"default-keys");
        if (answer == 0) {
            this.actions.setDefaultKeyBindings();
            this.handleFuncListSelect();
        }
    }

    private void handleFuncListSelect() {
        int index = this.functionList.getSelectedIndex();
        if (index == -1) {
            return;
        }
        this.currentAction = this.functions[this.firstDisplayedFunc + index];
        this.updateKeyList(this.currentAction);
        String helpText = this.getHelpText((String)this.currentAction.getValue("Name"));
        this.helpLabel.setText(helpText);
    }

    private void handleKeyListSelect() {
        this.delKeyButton.setEnabled(true);
    }

    private void handleClose() {
        this.removeKeyListener();
        if (!this.actions.save()) {
            DialogManager.showError((Component)this, (String)"cannot-save-keys");
        }
        this.setVisible(false);
    }

    private void handleAddKey() {
        this.helpLabel.setText(this.getHelpText("press-key"));
        this.addKeyListener();
    }

    private void handleDelKey() {
        if (this.currentKeys == null) {
            return;
        }
        int index = this.keyList.getSelectedIndex();
        if (index == -1) {
            return;
        }
        this.actions.removeKeyStrokeBinding(this.currentKeys[index]);
        this.updateKeyList(this.currentAction);
    }

    private void updateKeyList(Action action) {
        this.currentKeys = this.actions.getKeyStrokesForAction(action);
        if (this.currentKeys == null) {
            this.clearKeyList();
        } else {
            String[] keyStrings = this.getKeyStrings(this.currentKeys);
            this.keyList.setListData(keyStrings);
            this.delKeyButton.setEnabled(false);
        }
        this.addKeyButton.setEnabled(true);
    }

    private String[] getKeyStrings(KeyStroke[] keys) {
        String[] keyStrings = new String[keys.length];
        for (int i = 0; i < keys.length; ++i) {
            int modifiers = keys[i].getModifiers();
            keyStrings[i] = KeyEvent.getKeyModifiersText(modifiers);
            if (keyStrings[i].length() > 0) {
                int n = i;
                keyStrings[n] = keyStrings[n] + "+";
            }
            int n = i;
            keyStrings[n] = keyStrings[n] + KeyEvent.getKeyText(keys[i].getKeyCode());
        }
        return keyStrings;
    }

    private void clearKeyList() {
        this.keyList.setListData(new String[0]);
    }

    private void clearHelpText() {
        this.helpLabel.setText(null);
    }

    private void openHelpFile() {
        this.help = Config.getMoeHelp();
    }

    private String getHelpText(String function) {
        if (this.help == null) {
            return null;
        }
        String helpText = this.help.getProperty(function);
        if (helpText != null && helpText.length() > 0) {
            helpText = helpText.replaceAll("\n", "");
            helpText = helpText.trim();
        }
        return helpText;
    }

    private void addKeyListener() {
        FocusManager.setCurrentManager(new KeyCatcher());
    }

    private void removeKeyListener() {
        FocusManager.setCurrentManager(this.focusMgr);
    }

    public KeyBindingsPanel() {
        this.setActionValues(this.actions.getActionTable(), this.actions.getCategories(), this.actions.getCategoryIndex());
    }

    class KeyCatcher
    extends FocusManager {
        KeyCatcher() {
        }

        @Override
        public void processKeyEvent(Component focusedComponent, KeyEvent e) {
            if (e.getID() != 401) {
                return;
            }
            int keyCode = e.getKeyCode();
            if (keyCode == 20 || keyCode == 16 || keyCode == 17 || keyCode == 157 || keyCode == 18 || keyCode == 65406 || keyCode == 65312 || keyCode == 144 || keyCode == 145 || keyCode == 0) {
                return;
            }
            if (KeyBindingsPanel.this.currentAction == null) {
                Debug.message((String)"FunctionDialog: currentAction is null...");
            } else {
                KeyStroke key = KeyStroke.getKeyStrokeForEvent(e);
                if (this.isPrintable(key, e)) {
                    KeyBindingsPanel.this.helpLabel.setText(KeyBindingsPanel.this.getHelpText("cannot-redefine"));
                } else {
                    KeyBindingsPanel.this.actions.addActionForKeyStroke(key, KeyBindingsPanel.this.currentAction);
                    KeyBindingsPanel.this.handleFuncListSelect();
                }
            }
            e.consume();
            KeyBindingsPanel.this.removeKeyListener();
        }

        private boolean isPrintable(KeyStroke key, KeyEvent e) {
            int modifiers = key.getModifiers();
            if (modifiers != 0 && modifiers != 1) {
                return false;
            }
            if (e.isActionKey()) {
                return false;
            }
            int keyCode = e.getKeyCode();
            return keyCode != 8 && keyCode != 127 && keyCode != 10 && keyCode != 9 && keyCode != 27;
        }

        @Override
        public void focusNextComponent(Component c) {
        }

        @Override
        public void focusPreviousComponent(Component c) {
        }
    }
}

