/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rjmx.ui.internal;

import com.jrockit.mc.common.unit.ContentType;
import com.jrockit.mc.common.unit.UnitLookup;
import com.jrockit.mc.core.ITreeNode;
import com.jrockit.mc.rjmx.subscription.IMRIMetaData;
import com.jrockit.mc.rjmx.subscription.IMRIMetaDataProvider;
import com.jrockit.mc.rjmx.subscription.MRIMetaDataToolkit;
import com.jrockit.mc.rjmx.ui.RJMXUIPlugin;
import com.jrockit.mc.rjmx.ui.internal.MBeanPropertiesOrderer;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;

public class MBeanTreeLabelProvider
extends ColumnLabelProvider {
    private final ContentType<?> allowedContentType;

    public MBeanTreeLabelProvider(ContentType<?> allowedContentType) {
        this.allowedContentType = allowedContentType;
    }

    private Image getConsoleImage(String imageKey) {
        return RJMXUIPlugin.getDefault().getImage(imageKey);
    }

    public Image getImage(Object element) {
        Object data = ((ITreeNode)element).getUserData();
        if (data instanceof MBeanPropertiesOrderer.PropertyWithMBean) {
            return this.getConsoleImage("mbean-16.png");
        }
        if (data instanceof String || data instanceof MBeanPropertiesOrderer.Property) {
            return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER");
        }
        if (data instanceof IMRIMetaData) {
            IMRIMetaData info = (IMRIMetaData)data;
            String unitString = info.getUnitString();
            if (this.allowedContentType != null && unitString != null && !this.allowedContentType.equals((Object)UnitLookup.getContentType((String)unitString))) {
                return null;
            }
            if (MRIMetaDataToolkit.isComposite((IMRIMetaDataProvider)info)) {
                return this.getConsoleImage("composite-attribute-closed-16.png");
            }
            if (MRIMetaDataToolkit.isNumerical((IMRIMetaData)info)) {
                return this.getConsoleImage("numerical-attribute-16.png");
            }
            return this.getConsoleImage("non-numerical-attribute-16.png");
        }
        throw new IllegalArgumentException("This label provider only supports the ObjectName and AttributeInfo types.");
    }

    public String getText(Object element) {
        Object data = ((ITreeNode)element).getUserData();
        if (data instanceof String) {
            return (String)data;
        }
        if (data instanceof MBeanPropertiesOrderer.Property) {
            return this.formatProperty((MBeanPropertiesOrderer.Property)data);
        }
        if (data instanceof IMRIMetaData) {
            String dataPath = ((IMRIMetaData)data).getMRI().getDataPath();
            return dataPath.substring(dataPath.lastIndexOf(47) + 1);
        }
        throw new IllegalArgumentException("This label provider only supports the ObjectName and AttributeInfo types: " + data);
    }

    public Font getFont(Object element) {
        Object data = ((ITreeNode)element).getUserData();
        if (data instanceof IMRIMetaData && this.allowedContentType != null && ((IMRIMetaData)data).getUnitString() == null) {
            return JFaceResources.getFontRegistry().getItalic("org.eclipse.jface.defaultfont");
        }
        return super.getFont(element);
    }

    public Color getForeground(Object element) {
        String unitString;
        Object data = ((ITreeNode)element).getUserData();
        if (data instanceof IMRIMetaData && this.allowedContentType != null && (unitString = ((IMRIMetaData)data).getUnitString()) != null && !this.allowedContentType.equals((Object)UnitLookup.getContentType((String)unitString))) {
            return JFaceResources.getColorRegistry().get("QUALIFIER_COLOR");
        }
        return super.getForeground(element);
    }

    public String getToolTipText(Object element) {
        Object data = ((ITreeNode)element).getUserData();
        if (data instanceof MBeanPropertiesOrderer.PropertyWithMBean) {
            return MBeanPropertiesOrderer.getMBeanPath(((MBeanPropertiesOrderer.PropertyWithMBean)data).getBean());
        }
        if (data instanceof String) {
            return (String)data;
        }
        if (data instanceof MBeanPropertiesOrderer.Property) {
            return ((MBeanPropertiesOrderer.Property)data).getStringRepresentation();
        }
        if (data instanceof IMRIMetaData) {
            return ((IMRIMetaData)data).getDescription();
        }
        return null;
    }

    private String formatProperty(MBeanPropertiesOrderer.Property data) {
        String value = data.getValue();
        if (value != null && "class".equals(data.getKey())) {
            return value.substring(value.lastIndexOf(46) + 1);
        }
        return value;
    }
}

