/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rjmx.ui.internal;

import com.jrockit.mc.common.unit.IUnit;
import com.jrockit.mc.common.unit.UnitLookup;
import com.jrockit.mc.rjmx.IConnectionHandle;
import com.jrockit.mc.rjmx.subscription.IMRIMetaDataService;
import com.jrockit.mc.rjmx.subscription.IMRIService;
import com.jrockit.mc.rjmx.subscription.IMRIValueListener;
import com.jrockit.mc.rjmx.subscription.ISubscriptionService;
import com.jrockit.mc.rjmx.subscription.MRI;
import com.jrockit.mc.rjmx.subscription.MRIValueEvent;
import com.jrockit.mc.rjmx.ui.column.TableColumnComposite;
import com.jrockit.mc.rjmx.ui.internal.AccessibleControlAction;
import com.jrockit.mc.rjmx.ui.internal.AddAttibutesAction;
import com.jrockit.mc.rjmx.ui.internal.AttributeLabelProvider;
import com.jrockit.mc.rjmx.ui.internal.FreezeModel;
import com.jrockit.mc.rjmx.ui.internal.IAttributeSet;
import com.jrockit.mc.rjmx.ui.internal.MBeanPropertiesOrderer;
import com.jrockit.mc.rjmx.ui.internal.Messages;
import com.jrockit.mc.rjmx.ui.internal.StatisticsCalculator;
import com.jrockit.mc.rjmx.ui.internal.StatisticsTable;
import com.jrockit.mc.rjmx.ui.internal.ToggleFreezeAction;
import com.jrockit.mc.ui.dial.Dial;
import com.jrockit.mc.ui.dial.DialConfiguration;
import com.jrockit.mc.ui.dial.RefreshController;
import com.jrockit.mc.ui.misc.DisplayToolkit;
import com.jrockit.mc.ui.misc.IRefreshable;
import com.jrockit.mc.ui.misc.MoveControlAction;
import com.jrockit.mc.ui.sections.MCClientSectionPart;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.commands.ICommandImageService;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class CombinedDialsSectionPart
extends MCClientSectionPart
implements IAttributeSet {
    private static final String ATTRIBUTE_DIAL_TAG = "attribute";
    public static final String TAG_COMBINED_DIALS_SECTION_PART = "CombinedDialsSectionPart";
    private TableColumnComposite m_statisticsTable;
    private Composite m_dialsHolder;
    private GridLayout m_dialsHolderLayout;
    private final RefreshController m_refreshController;
    private final IConnectionHandle m_connection;
    private final IMRIMetaDataService m_mds;
    private final IMRIService m_mriService;
    private final FreezeModel m_freezeModel = new FreezeModel();
    private final ISubscriptionService m_subscriptionService;
    private final Map<MRI, StatisticsCalculator> m_model = new HashMap<MRI, StatisticsCalculator>();
    private Control[] m_orderedDials;
    private AccessibleControlAction accessibleControlAction;
    private final Observer metadataObserver = new Observer(){

        @Override
        public void update(Observable o, Object arg) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (!CombinedDialsSectionPart.this.getSection().isDisposed()) {
                        CombinedDialsSectionPart.this.m_statisticsTable.getViewer().refresh();
                        Control[] controlArray = CombinedDialsSectionPart.this.m_dialsHolder.getChildren();
                        int n = controlArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Control child = controlArray[n2];
                            ((AttributeDial)child).updateUnit();
                            ++n2;
                        }
                    }
                }
            });
        }
    };

    public CombinedDialsSectionPart(Composite parent, FormToolkit toolkit, int style, String sectionIdentifier, IConnectionHandle ch) {
        super(parent, toolkit, style, sectionIdentifier);
        this.m_refreshController = new RefreshController(parent.getDisplay());
        this.m_connection = ch;
        this.m_subscriptionService = (ISubscriptionService)this.m_connection.getServiceOrNull(ISubscriptionService.class);
        this.m_mds = (IMRIMetaDataService)this.m_connection.getServiceOrNull(IMRIMetaDataService.class);
        this.m_mriService = (IMRIService)this.m_connection.getServiceOrNull(IMRIService.class);
    }

    public void dispose() {
        if (this.accessibleControlAction != null) {
            this.accessibleControlAction.dispose();
        }
        this.m_refreshController.stop();
        this.m_mds.deleteObserver(this.metadataObserver);
        super.dispose();
    }

    protected Composite createClient(IManagedForm form, FormToolkit formToolkit, Composite section) throws Exception {
        Composite stackContainer = formToolkit.createComposite(section);
        final StackLayout stackLayout = new StackLayout();
        stackContainer.setLayout((Layout)stackLayout);
        this.m_dialsHolder = formToolkit.createComposite(stackContainer);
        this.m_dialsHolder.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                CombinedDialsSectionPart.this.m_orderedDials = CombinedDialsSectionPart.this.m_dialsHolder.getChildren();
            }
        });
        this.m_dialsHolderLayout = new GridLayout(0, true);
        this.m_dialsHolderLayout.horizontalSpacing = 0;
        this.m_dialsHolder.setLayout((Layout)this.m_dialsHolderLayout);
        this.m_statisticsTable = StatisticsTable.create(stackContainer, new AttributeLabelProvider(this.m_mds, this.m_mriService), this, true);
        this.m_statisticsTable.getViewer().setInput(this.m_model.values());
        this.getMCToolBarManager().add((IAction)new AddAttibutesAction(this.m_mds, this.m_mriService, this), 0);
        this.getMCToolBarManager().add((IAction)new ToggleFreezeAction(this.getMCToolBarManager(), this.m_freezeModel));
        this.accessibleControlAction = new AccessibleControlAction(){

            public void run() {
                stackLayout.topControl = this.isChecked() ? CombinedDialsSectionPart.this.m_statisticsTable : CombinedDialsSectionPart.this.m_dialsHolder;
                CombinedDialsSectionPart.this.m_statisticsTable.setVisible(this.isChecked());
                CombinedDialsSectionPart.this.m_dialsHolder.setVisible(!this.isChecked());
                CombinedDialsSectionPart.this.updateStructure();
            }
        };
        this.getMCToolBarManager().add((IAction)this.accessibleControlAction);
        this.m_mds.addObserver(this.metadataObserver);
        return stackContainer;
    }

    @Override
    public void remove(MRI ... mris) {
        MRI[] mRIArray = mris;
        int n = mris.length;
        int n2 = 0;
        while (n2 < n) {
            MRI mri = mRIArray[n2];
            this.m_model.remove(mri);
            ++n2;
        }
        if (this.m_model.size() == 0) {
            this.m_refreshController.stop();
        }
        HashSet<MRI> removeMris = new HashSet<MRI>(Arrays.asList(mris));
        Control[] controlArray = this.m_dialsHolder.getChildren();
        int n3 = controlArray.length;
        n = 0;
        while (n < n3) {
            Control child = controlArray[n];
            AttributeDial dial = (AttributeDial)child;
            if (removeMris.contains(dial.mri)) {
                dial.dispose();
            }
            ++n;
        }
        this.updateStructure();
    }

    @Override
    public void add(MRI ... mris) {
        MRI[] mRIArray = mris;
        int n = mris.length;
        int n2 = 0;
        while (n2 < n) {
            MRI mri = mRIArray[n2];
            this.add(mri, new DialConfiguration(this.m_mds.getMetaData(mri).getDisplayName()));
            ++n2;
        }
        this.updateStructure();
    }

    public boolean isEmpty() {
        return this.m_model.isEmpty();
    }

    public MRI[] elements() {
        Set<MRI> attributes = this.m_model.keySet();
        return attributes.toArray(new MRI[attributes.size()]);
    }

    private boolean add(final MRI mri, DialConfiguration dialConfiguration) {
        if (!this.m_model.containsKey(mri)) {
            final AttributeDial newDial = new AttributeDial(mri, dialConfiguration);
            newDial.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    CombinedDialsSectionPart.this.m_subscriptionService.removeMRIValueListener((IMRIValueListener)newDial);
                    CombinedDialsSectionPart.this.m_refreshController.remove((IRefreshable)newDial.getDialViewer());
                }
            });
            this.m_model.put(mri, newDial.statistics);
            this.m_refreshController.add((IRefreshable)newDial.getDialViewer());
            this.m_refreshController.start();
            this.m_subscriptionService.addMRIValueListener(mri, (IMRIValueListener)newDial);
            MenuManager menuManager = new MenuManager();
            menuManager.add((IAction)new Action(Messages.AttributeDialSectionPart_CLEAR_STATISTICS_MENU_TEXT){

                public void run() {
                    newDial.reset();
                }
            });
            menuManager.add((IAction)new MoveControlAction((Control)newDial, false));
            menuManager.add((IAction)new MoveControlAction((Control)newDial, true));
            menuManager.add((IAction)new Action(Messages.DELETE_COMMAND_TEXT){
                {
                    super($anonymous0);
                    this.setImageDescriptor(((ICommandImageService)PlatformUI.getWorkbench().getService(ICommandImageService.class)).getImageDescriptor(ActionFactory.DELETE.getCommandId()));
                }

                public void run() {
                    CombinedDialsSectionPart.this.remove(mri);
                }
            });
            menuManager.add((IContributionItem)new Separator());
            menuManager.add(newDial.getPropertiesAction());
            newDial.getDialViewer().setMenu(menuManager.createContextMenu((Control)newDial.getDialViewer()));
            newDial.setLayoutData(new GridData(4, 4, true, true));
            return true;
        }
        return false;
    }

    private static int calculateNumberOfColumns(int elementCount) {
        int rowCount = Math.max(1, CombinedDialsSectionPart.ceilDivision(elementCount, 5));
        return CombinedDialsSectionPart.ceilDivision(elementCount, rowCount);
    }

    private static int ceilDivision(int nominator, int denominator) {
        return (nominator + denominator - 1) / denominator;
    }

    public void saveState(IMemento state) {
        Control[] controlArray = this.m_dialsHolder.isDisposed() ? this.m_orderedDials : this.m_dialsHolder.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            AttributeDial dial = (AttributeDial)child;
            IMemento dialState = state.createChild(ATTRIBUTE_DIAL_TAG);
            dialState.putTextData(dial.mri.getQualifiedName());
            dial.getDialConfiguration().saveState(dialState);
            ++n2;
        }
    }

    public void restoreState(IMemento state) {
        IMRIMetaDataService mds = (IMRIMetaDataService)this.m_connection.getServiceOrDummy(IMRIMetaDataService.class);
        IMemento[] iMementoArray = state.getChildren(ATTRIBUTE_DIAL_TAG);
        int n = iMementoArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMemento dialState = iMementoArray[n2];
            MRI attribute = MRI.createFromQualifiedName((String)dialState.getTextData().trim());
            DialConfiguration dc = new DialConfiguration(mds.getMetaData(attribute).getDisplayName());
            dc.restoreState(dialState);
            this.add(attribute, dc);
            ++n2;
        }
        this.updateStructure();
    }

    private void updateStructure() {
        this.m_dialsHolderLayout.numColumns = CombinedDialsSectionPart.calculateNumberOfColumns(this.m_model.size());
        this.getManagedForm().reflow(true);
        this.m_dialsHolder.layout(true, true);
        this.m_statisticsTable.getViewer().refresh();
    }

    protected void initializeSection(Section section) {
    }

    private class AttributeDial
    extends Dial
    implements IMRIValueListener {
        final StatisticsCalculator statistics;
        final MRI mri;

        AttributeDial(MRI mri, DialConfiguration dialConfiguration) {
            super(CombinedDialsSectionPart.this.m_dialsHolder, CombinedDialsSectionPart.this.getFormToolkit(), dialConfiguration);
            this.mri = mri;
            this.statistics = new StatisticsCalculator(mri);
            this.updateUnit();
            String desc = CombinedDialsSectionPart.this.m_mds.getMetaData(mri).getDescription();
            String path = MBeanPropertiesOrderer.getAttributePath(mri);
            this.getDialViewer().setToolTipText(desc != null && desc.length() > 0 ? String.valueOf(path) + "\n" + desc : path);
        }

        public void valueChanged(MRIValueEvent event) {
            if (event.getValue() instanceof Number) {
                final double value = ((Number)event.getValue()).doubleValue();
                DisplayToolkit.safeAsyncExec((Widget)CombinedDialsSectionPart.this.getSection(), (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        AttributeDial.this.statistics.addValue(value);
                        if (!AttributeDial.this.isDisposed() && !CombinedDialsSectionPart.this.m_freezeModel.isFreezed()) {
                            AttributeDial.this.setInput(AttributeDial.this.statistics.getLast(), AttributeDial.this.statistics.getMax());
                            CombinedDialsSectionPart.this.m_statisticsTable.getViewer().refresh();
                        }
                    }
                });
            }
        }

        void updateUnit() {
            IUnit unit = UnitLookup.getUnitOrDefault((String)CombinedDialsSectionPart.this.m_mds.getMetaData(this.mri).getUnitString());
            if (!unit.equals(this.statistics.getUnit())) {
                this.statistics.setUnit(unit);
                this.setUnit(unit);
            }
        }

        public boolean reset() {
            if (this.statistics.reset()) {
                this.setInput(this.statistics.getLast(), this.statistics.getMax());
                return true;
            }
            return false;
        }
    }
}

