/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rjmx.ui.column;

import com.jrockit.mc.rjmx.ui.column.ColumnCompositeComparator;
import com.jrockit.mc.rjmx.ui.column.CopyColumnsHandler;
import com.jrockit.mc.rjmx.ui.column.IColumn;
import com.jrockit.mc.rjmx.ui.column.Messages;
import com.jrockit.mc.ui.handlers.MCCommandItem;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.ContributionManager;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.DialogSettings;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.layout.AbstractColumnLayout;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.ViewerColumn;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.menus.IMenuService;

public abstract class ColumnComposite
extends Composite {
    public static final String SORT_COLUMN_ITEM = "sort_column";
    public static final String SORT_DESCENDING_ITEM = "sort_descending";
    private static final String VISIBILITY_SECTION = "hidden_columns";
    private static final String WIDTH_SECTION = "column_widths";
    private static final int DEFAULT_WIDTH = 50;
    private final MenuManager menuManager = new MenuManager();
    private final LinkedHashMap<IColumn, ColumnData> allColumns = new LinkedHashMap();
    private final List<IColumn> visibleColumns = new ArrayList<IColumn>();
    private final MenuManager visibilityMenu = new MenuManager(Messages.VISIBILE_COLUMNS_MENU_HEADER);
    private final MenuManager sortMenu = new MenuManager(Messages.SORT_COLUMNS_MENU_HEADER);
    private final IDialogSettings dialogSettings;
    private final IDialogSettings columnWidths;
    private final IDialogSettings hiddenColumnsSettings;
    private final AbstractColumnLayout layout;
    private ColumnCompositeComparator comparator;

    public ColumnComposite(Composite parent, IDialogSettings settings, AbstractColumnLayout layout) {
        super(parent, 0);
        this.dialogSettings = settings;
        this.columnWidths = DialogSettings.getOrCreateSection((IDialogSettings)settings, (String)WIDTH_SECTION);
        this.hiddenColumnsSettings = DialogSettings.getOrCreateSection((IDialogSettings)settings, (String)VISIBILITY_SECTION);
        this.layout = layout;
        this.setLayout((Layout)layout);
    }

    protected void initColumnViewer() {
        Menu menu = this.menuManager.createContextMenu(this.getViewer().getControl());
        this.getViewer().getControl().setMenu(menu);
        this.menuManager.add((IContributionItem)this.sortMenu);
        this.sortMenu.add((IAction)this.createNoSortAction());
        this.menuManager.add((IContributionItem)this.visibilityMenu);
        this.menuManager.add((IContributionItem)new Separator());
        this.menuManager.add((IContributionItem)new MCCommandItem(ActionFactory.COPY));
        this.menuManager.add((IContributionItem)new MenuManager(Messages.COPY_SETTINGS_MENU_TEXT, "com.jrockit.mc.ui.copysettings"));
        this.menuManager.add((IContributionItem)new Separator());
        IMenuService ms = (IMenuService)PlatformUI.getWorkbench().getService(IMenuService.class);
        if (ms != null) {
            ms.populateContributionManager((ContributionManager)this.menuManager, "popup:org.eclipse.ui.popup.any");
        }
        this.enableColumnManagement(false);
        CopyColumnsHandler.enableFor(this);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.getViewer());
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        Point p = super.computeSize(wHint, hHint, changed);
        return new Point(wHint == -1 ? 100 : p.x, hHint == -1 ? 100 : p.y);
    }

    public void setBounds(int x, int y, int width, int height) {
        boolean extraLayout = this.getViewer().getControl().getSize().y != height;
        super.setBounds(x, y, width, height);
        if (extraLayout) {
            this.layout();
        }
    }

    public void addColumns(IColumn ... cols) {
        IColumn[] iColumnArray = cols;
        int n = cols.length;
        int n2 = 0;
        while (n2 < n) {
            IColumn column = iColumnArray[n2];
            this.allColumns.put(column, null);
            if (this.allColumns.size() == 2) {
                this.enableColumnManagement(true);
            }
            MenuManager sortColumnMenu = new MenuManager(column.getName(), column.getId());
            sortColumnMenu.add((IAction)this.createSortAction(true, column));
            sortColumnMenu.add((IAction)this.createSortAction(false, column));
            sortColumnMenu.setVisible(false);
            this.sortMenu.add((IContributionItem)sortColumnMenu);
            this.sortMenu.find(column.getId()).setVisible(false);
            Action visibilityAction = this.createVisibilityAction(column);
            if (!this.hiddenColumnsSettings.getBoolean(column.getId())) {
                this.showColumn(column);
                visibilityAction.setChecked(true);
            }
            this.visibilityMenu.add((IAction)visibilityAction);
            ++n2;
        }
        String initialSortColumnName = this.dialogSettings.get(SORT_COLUMN_ITEM);
        if (initialSortColumnName != null) {
            for (IColumn column : this.getVisibleColumns()) {
                if (!column.getId().equals(initialSortColumnName)) continue;
                this.sortColumn(column, Boolean.valueOf(this.dialogSettings.get(SORT_DESCENDING_ITEM)) == false);
                break;
            }
        }
    }

    public void updateColumn(IColumn column) {
        ColumnData colData = this.allColumns.get(column);
        if (colData != null) {
            colData.viewerColumn.setEditingSupport(column.getEditingSupport());
            colData.viewerColumn.setLabelProvider((CellLabelProvider)column.getLabelProvider());
            colData.columnItem.setText(column.getName());
            this.setColumnDescription(colData.columnItem, column.getDescription());
            this.getViewer().refresh();
        }
    }

    public void showColumn(final IColumn column) {
        ColumnData colData = this.allColumns.get(column);
        if (colData == null) {
            int index = this.countVisibleColumnsBefore(column);
            colData = new ColumnData();
            colData.columnItem = this.createColumnWidget(column.getId(), index, column.getStyle());
            colData.columnItem.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    if (ColumnComposite.this.comparator == null) {
                        ColumnComposite.this.sortColumn(column, true);
                    } else {
                        ColumnComposite.this.sortColumn(column, !ColumnComposite.this.comparator.isSortAscending());
                    }
                }
            });
            colData.viewerColumn = new ViewerColumn(this.getViewer(), (Widget)colData.columnItem){};
            this.visibleColumns.add(index, column);
            this.allColumns.put(column, colData);
            this.layout.setColumnData((Widget)colData.columnItem, (ColumnLayoutData)new ColumnWeightData(this.loadColumnWidth(column.getId())));
        }
        this.updateColumn(column);
        this.hiddenColumnsSettings.put(column.getId(), false);
        this.updateActionEnablement(column, true);
    }

    public void hideColumn(IColumn column) {
        this.allColumns.get((Object)column).columnItem.dispose();
        this.allColumns.put(column, null);
        this.visibleColumns.remove(column);
        this.hiddenColumnsSettings.put(column.getId(), true);
        this.updateActionEnablement(column, false);
        this.layout();
    }

    private void sortColumn(IColumn column, boolean sortAscending) {
        int sortOrder = sortAscending ? 128 : 1024;
        this.setSortColumn(this.allColumns.get((Object)column).columnItem, sortOrder);
        this.comparator = new ColumnCompositeComparator(column, sortAscending);
        this.getViewer().setComparator((ViewerComparator)this.comparator);
        this.dialogSettings.put(SORT_COLUMN_ITEM, column.getId());
        this.dialogSettings.put(SORT_DESCENDING_ITEM, sortAscending);
    }

    protected void columnRemoved(String columnId, int columnWidth) {
        this.columnWidths.put(columnId, columnWidth);
    }

    public MenuManager getMenuManager() {
        return this.menuManager;
    }

    public abstract ColumnViewer getViewer();

    protected abstract Item createColumnWidget(String var1, int var2, int var3);

    protected abstract void setSortColumn(Item var1, int var2);

    protected abstract void setColumnDescription(Item var1, String var2);

    protected abstract void setHeaderVisible(boolean var1);

    private void enableColumnManagement(boolean visible) {
        this.setHeaderVisible(visible);
        this.visibilityMenu.setVisible(visible);
        this.visibilityMenu.markDirty();
        this.sortMenu.setVisible(visible);
        this.sortMenu.markDirty();
    }

    private int loadColumnWidth(String columnId) {
        return this.columnWidths.get(columnId) != null ? Math.max(50, this.columnWidths.getInt(columnId)) : 50;
    }

    private int countVisibleColumnsBefore(IColumn column) {
        int i = 0;
        for (Map.Entry<IColumn, ColumnData> e : this.allColumns.entrySet()) {
            if (e.getKey().equals(column)) break;
            if (e.getValue() == null) continue;
            ++i;
        }
        return i;
    }

    private void updateActionEnablement(IColumn column, boolean shown) {
        int visibleCount;
        IMenuManager sortingMenu = this.sortMenu.findMenuUsingPath(column.getId());
        if (sortingMenu != null) {
            sortingMenu.setVisible(shown);
            sortingMenu.markDirty();
        }
        if ((visibleCount = this.visibleColumns.size()) > 2) {
            return;
        }
        boolean enableAllChecked = visibleCount == 2;
        IContributionItem[] iContributionItemArray = this.visibilityMenu.getItems();
        int n = iContributionItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            IAction action;
            IContributionItem i = iContributionItemArray[n2];
            action.setEnabled(!(action = ((ActionContributionItem)i).getAction()).isChecked() || enableAllChecked);
            ++n2;
        }
    }

    private Action createSortAction(final boolean sortAscending, final IColumn column) {
        String text = sortAscending ? Messages.SORT_COLUMN_ASCENDING_MENU_ITEM : Messages.SORT_COLUMN_DESCENDING_MENU_ITEM;
        return new Action(text){

            public void run() {
                ColumnComposite.this.sortColumn(column, sortAscending);
            }
        };
    }

    private Action createNoSortAction() {
        return new Action(Messages.SORT_COLUMN_NONE_MENU_ITEM){

            public void run() {
                ColumnComposite.this.setSortColumn(null, 0);
                ColumnComposite.this.comparator = null;
                ColumnComposite.this.getViewer().setComparator(null);
                ColumnComposite.this.dialogSettings.put(ColumnComposite.SORT_COLUMN_ITEM, null);
                ColumnComposite.this.dialogSettings.put(ColumnComposite.SORT_DESCENDING_ITEM, null);
                ColumnComposite.this.getViewer().refresh();
            }
        };
    }

    private Action createVisibilityAction(final IColumn column) {
        return new Action(column.getName(), 2){

            public void run() {
                if (this.isChecked()) {
                    ColumnComposite.this.showColumn(column);
                } else {
                    ColumnComposite.this.hideColumn(column);
                }
                ColumnComposite.this.layout();
                ColumnComposite.this.layout();
            }
        };
    }

    public Iterable<IColumn> getColumns() {
        return this.allColumns.keySet();
    }

    public List<IColumn> getVisibleColumns() {
        return this.visibleColumns;
    }

    private static class ColumnData {
        Item columnItem;
        ViewerColumn viewerColumn;

        private ColumnData() {
        }
    }
}

