/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rjmx.ui.attributes;

import com.jrockit.mc.rjmx.IConnectionHandle;
import com.jrockit.mc.rjmx.subscription.IMRIMetaData;
import com.jrockit.mc.rjmx.subscription.IMRIMetaDataService;
import com.jrockit.mc.rjmx.subscription.MRI;
import com.jrockit.mc.rjmx.subscription.MRIMetaDataToolkit;
import com.jrockit.mc.rjmx.ui.RJMXUIPlugin;
import com.jrockit.mc.rjmx.ui.attributes.Messages;
import com.jrockit.mc.rjmx.ui.attributes.ReadOnlyMRIAttribute;
import com.jrockit.mc.rjmx.ui.attributes.VisualizeWizardPage;
import com.jrockit.mc.rjmx.ui.internal.SectionPartManager;
import com.jrockit.mc.ui.wizards.OnePageWizardDialog;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.actions.SelectionProviderAction;

public class VisualizeAction
extends SelectionProviderAction {
    private final IConnectionHandle connection;
    private List<MRI> numericals = Collections.emptyList();
    private final SectionPartManager sectionPartManager;

    public VisualizeAction(SectionPartManager sectionPartManager, IConnectionHandle connection, ISelectionProvider selectionProvider) {
        super(selectionProvider, Messages.VisualizeAction_VISUALIZE_ATTRIBUTE_TEXT);
        this.sectionPartManager = sectionPartManager;
        this.connection = connection;
        this.setEnabled(false);
    }

    public void selectionChanged(IStructuredSelection selection) {
        this.numericals = this.filterForNumericalAttributeDescriptors(selection.toList());
        this.setEnabled(!this.numericals.isEmpty());
    }

    private List<MRI> filterForNumericalAttributeDescriptors(List<?> descriptors) {
        ArrayList<MRI> numericals = new ArrayList<MRI>();
        IMRIMetaDataService mriMetaDataService = (IMRIMetaDataService)this.connection.getServiceOrNull(IMRIMetaDataService.class);
        if (mriMetaDataService == null) {
            return numericals;
        }
        for (Object object : descriptors) {
            if (!(object instanceof ReadOnlyMRIAttribute) || !MRIMetaDataToolkit.isNumerical((IMRIMetaData)mriMetaDataService.getMetaData(((ReadOnlyMRIAttribute)object).getMRI()))) continue;
            numericals.add(((ReadOnlyMRIAttribute)object).getMRI());
        }
        return numericals;
    }

    public void run() {
        VisualizeWizardPage wizardPage = new VisualizeWizardPage(this.sectionPartManager, this.numericals, this.connection);
        OnePageWizardDialog dialog = new OnePageWizardDialog(Display.getCurrent().getActiveShell(), (IWizardPage)wizardPage);
        dialog.setImage(RJMXUIPlugin.getDefault().getImage("add-graph-16.png"));
        dialog.setTitle(Messages.VisualizeAction_VISUALIZE_WIZARD_TITLE_TEXT);
        dialog.open();
    }
}

