/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import org.netbeans.modules.profiler.Bundle;
import org.netbeans.modules.profiler.CPUSnapshotPanel;
import org.netbeans.modules.profiler.FragmentSnapshotPanel;
import org.netbeans.modules.profiler.LoadedSnapshot;
import org.netbeans.modules.profiler.MemorySnapshotPanel;
import org.netbeans.modules.profiler.ProfilerTopComponent;
import org.netbeans.modules.profiler.ResultsManager;
import org.netbeans.modules.profiler.SnapshotPanel;
import org.netbeans.modules.profiler.SnapshotsListener;
import org.netbeans.modules.profiler.api.ProfilerDialogs;
import org.netbeans.modules.profiler.api.icons.Icons;
import org.netbeans.modules.profiler.utilities.Delegate;
import org.netbeans.spi.actions.AbstractSavable;
import org.openide.actions.FindAction;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.actions.CallbackSystemAction;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;

public final class SnapshotResultsWindow
extends ProfilerTopComponent {
    private static final String HELP_CTX_KEY_CPU = "CpuSnapshot.HelpCtx";
    private static final String HELP_CTX_KEY_MEM = "MemorySnapshot.HelpCtx";
    private static final Image WINDOW_ICON_CPU = Icons.getImage((String)"ProfilerIcons.Cpu");
    private static final Image WINDOWS_ICON_FRAGMENT = Icons.getImage((String)"ProfilerIcons.Fragment");
    private static final Image WINDOWS_ICON_MEMORY = Icons.getImage((String)"ProfilerIcons.Memory");
    private static final HashMap windowsList = new HashMap();
    private LoadedSnapshot snapshot;
    private InstanceContent ic = new InstanceContent();
    private SavePerformer savePerformer = new SavePerformer();
    private SnapshotPanel displayedPanel;
    private String tabName = "";
    private SnapshotListener listener;
    private boolean forcedClose = false;
    private HelpCtx helpCtx = HelpCtx.DEFAULT_HELP;

    public SnapshotResultsWindow() {
        throw new InternalError("This constructor should never be called");
    }

    public SnapshotResultsWindow(LoadedSnapshot loadedSnapshot, int n, boolean bl) {
        this.associateLookup((Lookup)new AbstractLookup((AbstractLookup.Content)this.ic));
        this.ic.add((Object)this.getActionMap());
        this.snapshot = loadedSnapshot;
        this.updateSaveState();
        this.setLayout(new BorderLayout());
        this.setFocusable(true);
        this.setRequestFocusEnabled(true);
        this.refreshTabName();
        switch (this.snapshot.getType()) {
            case 1: {
                this.getAccessibleContext().setAccessibleDescription(Bundle.SnapshotResultsWindow_CpuSnapshotAccessDescr());
                this.displayCPUResults(loadedSnapshot, n, bl);
                break;
            }
            case 2: {
                this.getAccessibleContext().setAccessibleDescription(Bundle.SnapshotResultsWindow_FragmentSnapshotAccessDescr());
                this.displayCodeRegionResults(loadedSnapshot);
                break;
            }
            case 4: 
            case 8: 
            case 16: {
                this.getAccessibleContext().setAccessibleDescription(Bundle.SnapshotResultsWindow_MemorySnapshotAccessDescr());
                this.displayMemoryResults(loadedSnapshot, n, bl);
            }
        }
        this.listener = (SnapshotListener)Lookup.getDefault().lookup(SnapshotListener.class);
        this.listener.setDelegate((Object)this);
    }

    public static synchronized void closeAllWindows() {
        Collection collection = windowsList.values();
        if (!collection.isEmpty()) {
            SnapshotResultsWindow[] snapshotResultsWindowArray = new SnapshotResultsWindow[collection.size()];
            collection.toArray(snapshotResultsWindowArray);
            for (int i = 0; i < snapshotResultsWindowArray.length; ++i) {
                SnapshotResultsWindow snapshotResultsWindow = snapshotResultsWindowArray[i];
                snapshotResultsWindow.forcedClose();
            }
        }
    }

    public static synchronized void closeWindow(LoadedSnapshot loadedSnapshot) {
        SnapshotResultsWindow snapshotResultsWindow = (SnapshotResultsWindow)((Object)windowsList.get(loadedSnapshot));
        if (snapshotResultsWindow != null) {
            snapshotResultsWindow.forcedClose();
        }
    }

    public static synchronized SnapshotResultsWindow get(LoadedSnapshot loadedSnapshot) {
        return SnapshotResultsWindow.get(loadedSnapshot, -1, false);
    }

    public static synchronized SnapshotResultsWindow get(LoadedSnapshot loadedSnapshot, int n, boolean bl) {
        SnapshotResultsWindow snapshotResultsWindow = (SnapshotResultsWindow)((Object)windowsList.get(loadedSnapshot));
        if (snapshotResultsWindow == null) {
            snapshotResultsWindow = new SnapshotResultsWindow(loadedSnapshot, n, bl);
            windowsList.put(loadedSnapshot, snapshotResultsWindow);
        }
        return snapshotResultsWindow;
    }

    public static synchronized boolean hasSnapshotWindow(LoadedSnapshot loadedSnapshot) {
        return windowsList.get(loadedSnapshot) != null;
    }

    public int getPersistenceType() {
        return 2;
    }

    public HelpCtx getHelpCtx() {
        return this.helpCtx;
    }

    public boolean canClose() {
        File file = this.snapshot.getFile();
        if (file != null) {
            this.putClientProperty("nb.recent.file.path", file);
        }
        if (this.forcedClose) {
            this.savePerformer.remove();
            return true;
        }
        if (this.snapshot.isSaved()) {
            return true;
        }
        Boolean bl = ProfilerDialogs.displayCancellableConfirmationDNSA((String)Bundle.SnapshotResultsWindow_SaveSnapshotDialogMsg(), null, null, (String)"org.netbeans.modules.profiler.SnapshotResultsWindow.canClose", (boolean)false);
        if (Boolean.TRUE.equals(bl)) {
            try {
                this.savePerformer.save();
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
            return true;
        }
        if (Boolean.FALSE.equals(bl)) {
            this.savePerformer.remove();
            return true;
        }
        return false;
    }

    @Override
    protected Component defaultFocusOwner() {
        return this.displayedPanel;
    }

    public void displayStacksForClass(int n, int n2, boolean bl) {
        if (this.displayedPanel instanceof MemorySnapshotPanel) {
            ((MemorySnapshotPanel)this.displayedPanel).displayStacksForClass(n, n2, bl);
        }
    }

    public void refreshTabName() {
        this.tabName = ResultsManager.getDefault().getSnapshotDisplayName(this.snapshot);
        File file = this.snapshot.getFile();
        if (file != null) {
            this.setToolTipText(file.getAbsolutePath());
        }
        this.updateTitle();
    }

    public void updateTitle() {
        if (this.snapshot.isSaved()) {
            this.setName(this.tabName);
        } else {
            this.setName(this.tabName + " *");
        }
        if (this.snapshot.getFile() != null) {
            this.setToolTipText(this.snapshot.getFile().getAbsolutePath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void componentClosed() {
        Class<SnapshotResultsWindow> clazz = SnapshotResultsWindow.class;
        synchronized (SnapshotResultsWindow.class) {
            windowsList.remove(this.snapshot);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            ResultsManager.getDefault().closeSnapshot(this.snapshot);
            this.snapshot = null;
            return;
        }
    }

    protected String preferredID() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public void setState(SnapshotPanel.State state) {
        this.displayedPanel.setState(state);
    }

    public SnapshotPanel.State getState() {
        return this.displayedPanel.getState();
    }

    private void displayCPUResults(LoadedSnapshot loadedSnapshot, int n, boolean bl) {
        CPUSnapshotPanel cPUSnapshotPanel = new CPUSnapshotPanel(this.getLookup(), loadedSnapshot, n, bl);
        this.displayedPanel = cPUSnapshotPanel;
        this.updateFind(true, cPUSnapshotPanel);
        this.add((Component)((Object)cPUSnapshotPanel), "Center");
        this.setIcon(WINDOW_ICON_CPU);
        this.helpCtx = new HelpCtx(HELP_CTX_KEY_CPU);
    }

    private void displayCodeRegionResults(LoadedSnapshot loadedSnapshot) {
        this.updateFind(false, null);
        FragmentSnapshotPanel fragmentSnapshotPanel = new FragmentSnapshotPanel(loadedSnapshot);
        this.displayedPanel = fragmentSnapshotPanel;
        this.add((Component)((Object)fragmentSnapshotPanel), "Center");
        this.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        this.setIcon(WINDOWS_ICON_FRAGMENT);
    }

    private void displayMemoryResults(LoadedSnapshot loadedSnapshot, int n, boolean bl) {
        MemorySnapshotPanel memorySnapshotPanel = new MemorySnapshotPanel(this.getLookup(), loadedSnapshot, n, bl);
        this.displayedPanel = memorySnapshotPanel;
        this.updateFind(true, memorySnapshotPanel);
        this.add((Component)((Object)memorySnapshotPanel), "Center");
        this.setIcon(WINDOWS_ICON_MEMORY);
        this.helpCtx = new HelpCtx(HELP_CTX_KEY_MEM);
    }

    private void forcedClose() {
        this.forcedClose = true;
        this.close();
    }

    private void updateFind(boolean bl, final FindPerformer findPerformer) {
        CallbackSystemAction callbackSystemAction = (CallbackSystemAction)SystemAction.get(FindAction.class);
        Object object = callbackSystemAction.getActionMapKey();
        if (bl) {
            this.getActionMap().put(object, new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    findPerformer.performFind();
                }
            });
        } else {
            this.getActionMap().remove(object);
        }
    }

    private void updateSaveState() {
        if (this.snapshot != null) {
            if (this.snapshot.isSaved()) {
                this.savePerformer.remove();
            } else {
                this.savePerformer.add();
            }
            if (this.displayedPanel != null) {
                this.displayedPanel.updateSavedState();
            }
        } else {
            this.savePerformer.remove();
        }
    }

    private class SavePerformer
    extends AbstractSavable {
        private SavePerformer() {
        }

        private void add() {
            this.register();
            SnapshotResultsWindow.this.ic.add((Object)this);
        }

        private void remove() {
            this.unregister();
            SnapshotResultsWindow.this.ic.remove((Object)this);
        }

        protected String findDisplayName() {
            return SnapshotResultsWindow.this.tabName;
        }

        protected void handleSave() {
            LoadedSnapshot loadedSnapshot = SnapshotResultsWindow.this.snapshot;
            if (loadedSnapshot == null) {
                return;
            }
            ResultsManager.getDefault().saveSnapshot(SnapshotResultsWindow.this.snapshot);
            SnapshotResultsWindow.this.ic.remove((Object)this);
        }

        public boolean equals(Object object) {
            return this == object;
        }

        public int hashCode() {
            return System.identityHashCode((Object)this);
        }
    }

    public static interface FindPerformer {
        public void performFind();

        public void performFindNext();

        public void performFindPrevious();
    }

    public static class SnapshotListener
    extends Delegate<SnapshotResultsWindow>
    implements SnapshotsListener {
        @Override
        public void snapshotLoaded(LoadedSnapshot loadedSnapshot) {
        }

        @Override
        public void snapshotRemoved(LoadedSnapshot loadedSnapshot) {
        }

        @Override
        public void snapshotSaved(LoadedSnapshot loadedSnapshot) {
            if (this.getDelegate() != null) {
                ((SnapshotResultsWindow)((Object)this.getDelegate())).updateSaveState();
            }
        }

        @Override
        public void snapshotTaken(LoadedSnapshot loadedSnapshot) {
        }
    }
}

