/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.heapwalk;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import javax.swing.AbstractButton;
import javax.swing.BoundedRangeModel;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.lib.profiler.heap.HeapProgress;
import org.netbeans.lib.profiler.heap.Instance;
import org.netbeans.lib.profiler.heap.JavaClass;
import org.netbeans.modules.profiler.api.ProfilerDialogs;
import org.netbeans.modules.profiler.heapwalk.AbstractController;
import org.netbeans.modules.profiler.heapwalk.Bundle;
import org.netbeans.modules.profiler.heapwalk.HeapFragmentWalker;
import org.netbeans.modules.profiler.heapwalk.model.AbstractHeapWalkerNode;
import org.netbeans.modules.profiler.heapwalk.model.BrowserUtils;
import org.netbeans.modules.profiler.heapwalk.model.HeapWalkerNode;
import org.netbeans.modules.profiler.heapwalk.model.HeapWalkerNodeFactory;
import org.netbeans.modules.profiler.heapwalk.model.InstanceNode;
import org.netbeans.modules.profiler.heapwalk.ui.ReferencesBrowserControllerUI;
import org.netbeans.modules.profiler.ui.NBSwingWorker;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;

public class ReferencesBrowserController
extends AbstractController {
    public static final AbstractHeapWalkerNode EMPTY_INSTANCE_NODE = new AbstractHeapWalkerNode(null){

        @Override
        protected String computeName() {
            return Bundle.ReferencesBrowserController_NoInstanceSelectedString();
        }

        @Override
        protected String computeType() {
            return Bundle.ReferencesBrowserController_NoneString();
        }

        @Override
        protected String computeValue() {
            return Bundle.ReferencesBrowserController_NoneString();
        }

        @Override
        protected String computeSize() {
            return "";
        }

        @Override
        protected String computeRetainedSize() {
            return "";
        }

        @Override
        protected Icon computeIcon() {
            return null;
        }

        @Override
        public boolean isLeaf() {
            return true;
        }
    };
    private static final int DEFAULT_WIDTH = 350;
    private static final int DEFAULT_HEIGHT = 100;
    private Handler referencesControllerHandler;
    private Instance instance;

    public ReferencesBrowserController(Handler handler) {
        this.referencesControllerHandler = handler;
    }

    public Handler getReferencesControllerHandler() {
        return this.referencesControllerHandler;
    }

    public HeapWalkerNode getFilteredSortedReferences(String string, int n, boolean bl) {
        if (this.instance == null) {
            return EMPTY_INSTANCE_NODE;
        }
        return this.getSortedReferences(this.getFilteredReferences(this.getReferences(this.instance), string), n, bl);
    }

    public void setInstance(Instance instance) {
        this.instance = instance;
        this.update();
    }

    public void createNavigationHistoryPoint() {
        this.referencesControllerHandler.getHeapFragmentWalker().createNavigationHistoryPoint();
    }

    public void navigateToClass(JavaClass javaClass) {
        this.referencesControllerHandler.showClass(javaClass);
    }

    public void navigateToInstance(Instance instance) {
        this.referencesControllerHandler.showInstance(instance);
    }

    public void navigateToRootNearestGCRoot() {
        ((ReferencesBrowserControllerUI)((Object)this.getPanel())).showRootGCRoot();
    }

    public void navigateToNearestGCRoot(final InstanceNode instanceNode) {
        new NBSwingWorker(true){
            private ProgressHandle progress;
            private HeapWalkerNode gcRootNode;
            private BoundedRangeModel progressModel;
            private ChangeListener cl;
            private boolean done;
            {
                super(bl);
                this.progress = null;
                this.gcRootNode = null;
                this.progressModel = null;
                this.cl = null;
                this.done = false;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void doInBackground() {
                this.progressModel = HeapProgress.getProgress();
                this.cl = new ChangeListener(){

                    @Override
                    public void stateChanged(ChangeEvent changeEvent) {
                        if (progress != null) {
                            progress.progress(progressModel.getValue());
                        }
                    }
                };
                this.progressModel.addChangeListener(this.cl);
                try {
                    this.gcRootNode = BrowserUtils.computeChildrenToNearestGCRoot(instanceNode);
                }
                finally {
                    HeapProgress.getProgress().removeChangeListener(this.cl);
                }
            }

            public void nonResponding() {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (!done) {
                            progress = ProgressHandleFactory.createHandle((String)Bundle.ReferencesBrowserController_ProgressMsg());
                            progress.start(1000);
                        }
                    }
                });
            }

            public void done() {
                ReferencesBrowserControllerUI referencesBrowserControllerUI;
                this.done = false;
                if (this.progress != null) {
                    this.progress.finish();
                }
                if (instanceNode.equals((referencesBrowserControllerUI = (ReferencesBrowserControllerUI)((Object)ReferencesBrowserController.this.getPanel())).getSelectedNode(0))) {
                    if (this.gcRootNode != null) {
                        if (instanceNode == this.gcRootNode) {
                            ProfilerDialogs.displayInfo((String)Bundle.ReferencesBrowserController_SelfGcRootMsg());
                        } else {
                            referencesBrowserControllerUI.selectNode(this.gcRootNode);
                        }
                    } else {
                        ProfilerDialogs.displayInfo((String)Bundle.ReferencesBrowserController_NoGcRootMsg());
                    }
                }
            }
        }.execute();
    }

    public void showInstance(Instance instance) {
        if (this.instance != instance) {
            this.setInstance(instance);
        }
    }

    public void showInThreads(Instance instance) {
        HeapFragmentWalker heapFragmentWalker = this.referencesControllerHandler.getHeapFragmentWalker();
        heapFragmentWalker.switchToSummaryView();
        heapFragmentWalker.getSummaryController().getOverViewController().showInThreads(instance);
    }

    public void update() {
        ((ReferencesBrowserControllerUI)((Object)this.getPanel())).update();
    }

    @Override
    protected AbstractButton createControllerPresenter() {
        return ((ReferencesBrowserControllerUI)((Object)this.getPanel())).getPresenter();
    }

    @Override
    protected JPanel createControllerUI() {
        return new ReferencesBrowserControllerUI(this);
    }

    Dialog createProgressPanel(String string, BoundedRangeModel boundedRangeModel) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(10, 10));
        jPanel.setBorder(new EmptyBorder(15, 15, 15, 15));
        jPanel.add((Component)new JLabel(string), "North");
        Dimension dimension = jPanel.getPreferredSize();
        dimension.setSize(Math.max(dimension.getWidth(), 350.0), Math.max(dimension.getHeight(), 100.0));
        jPanel.setPreferredSize(dimension);
        JProgressBar jProgressBar = new JProgressBar();
        if (boundedRangeModel == null) {
            jProgressBar.setIndeterminate(true);
        } else {
            jProgressBar.setStringPainted(true);
            jProgressBar.setModel(boundedRangeModel);
        }
        jPanel.add((Component)jProgressBar, "South");
        Dialog dialog = DialogDisplayer.getDefault().createDialog(new DialogDescriptor((Object)jPanel, Bundle.ReferencesBrowserController_ProgressDialogCaption(), true, new Object[0], DialogDescriptor.CANCEL_OPTION, 1, null, null));
        return dialog;
    }

    private HeapWalkerNode getReferences(Instance instance) {
        return HeapWalkerNodeFactory.createRootInstanceNode(instance, "this", new Runnable(){

            @Override
            public void run() {
                ((ReferencesBrowserControllerUI)((Object)ReferencesBrowserController.this.getPanel())).refreshView();
            }
        }, 2, this.referencesControllerHandler.getHeapFragmentWalker().getHeapFragment());
    }

    private HeapWalkerNode getFilteredReferences(HeapWalkerNode heapWalkerNode, String string) {
        return heapWalkerNode;
    }

    private HeapWalkerNode getSortedReferences(HeapWalkerNode heapWalkerNode, int n, boolean bl) {
        return heapWalkerNode;
    }

    public static interface Handler {
        public HeapFragmentWalker getHeapFragmentWalker();

        public void showClass(JavaClass var1);

        public void showInstance(Instance var1);
    }
}

