/*
 * Decompiled with CFR 0.152.
 */
package de.mbenning.weather.wunderground.impl.services;

import de.mbenning.weather.wunderground.api.domain.HttpProxy;
import de.mbenning.weather.wunderground.api.domain.WeatherStation;
import de.mbenning.weather.wunderground.api.services.IWeatherStationService;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Scanner;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
@Scope(value="prototype")
@Qualifier(value="weatherStationService")
public class WeatherStationService
implements IWeatherStationService {
    private String url = ResourceBundle.getBundle("wunderground-core").getString("wunderground.core.http.stations.url");
    @Autowired
    @Qualifier(value="httpProxy")
    private HttpProxy httpProxy;

    @Override
    public List<WeatherStation> findAllWeatherStationsByCountry(String country) {
        List<WeatherStation> stations = this.parseStations(this.loadSource(country), country);
        return stations;
    }

    protected Scanner loadSource(String country) {
        if (this.httpProxy != null && this.httpProxy.isEnabled()) {
            System.setProperty("proxySet", "true");
            System.setProperty("http.proxyHost", this.httpProxy.getUrl());
            System.setProperty("http.proxyPort", Integer.toString(this.httpProxy.getPort()));
        }
        try {
            URL url = new URL(this.url + country);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            connection.setUseCaches(false);
            return new Scanner(connection.getInputStream());
        }
        catch (MalformedURLException e) {
            return null;
        }
        catch (ProtocolException e) {
            return null;
        }
        catch (IOException e) {
            return null;
        }
    }

    protected List<WeatherStation> parseStations(Scanner sourceScanner, String country) {
        ArrayList<WeatherStation> stations = new ArrayList<WeatherStation>();
        if (sourceScanner != null) {
            boolean isAdding = false;
            while (sourceScanner.hasNextLine()) {
                String line = sourceScanner.nextLine();
                if (line == null) continue;
                WeatherStation weatherStation = null;
                if (line.contains("/weatherstation/WXDailyHistory.asp?ID=")) {
                    String[] siteParts1;
                    String[] siteParts2;
                    String siteLine;
                    String stationTypeLine;
                    String[] stationTypeParts1;
                    String[] stationTypeParts2;
                    String cityLine;
                    String[] cityParts1;
                    String[] cityParts2;
                    String neighLine;
                    String[] neighParts1;
                    String[] neighParts2;
                    String[] lineParts1 = line.split("<td><a href=");
                    String[] lineParts2 = lineParts1[1].split("\">");
                    String[] idParts = lineParts2[1].split("</a></td>");
                    if (idParts[0] != null) {
                        weatherStation = new WeatherStation(idParts[0]);
                        weatherStation.setCountry(country);
                        isAdding = true;
                    }
                    if (isAdding && (neighParts2 = (neighParts1 = (neighLine = sourceScanner.nextLine()).split("<td>"))[1].split("&nbsp;</td>")) != null && neighParts2.length > 0 && neighParts2[0] != null && weatherStation != null) {
                        weatherStation.setNeighborhood(neighParts2[0].trim());
                    }
                    if (isAdding && (cityParts2 = (cityParts1 = (cityLine = sourceScanner.nextLine()).split("<td>"))[1].split("&nbsp;</td>")) != null && cityParts2.length > 0 && cityParts2[0] != null && weatherStation != null) {
                        weatherStation.setCity(cityParts2[0].trim());
                    }
                    if (isAdding && (stationTypeParts2 = (stationTypeParts1 = (stationTypeLine = sourceScanner.nextLine()).split("<td>"))[1].split("&nbsp;</td>")) != null && stationTypeParts2.length > 0 && stationTypeParts2[0] != null && weatherStation != null) {
                        weatherStation.setStationType(stationTypeParts2[0].trim());
                    }
                    if (isAdding && !(siteLine = sourceScanner.nextLine()).contains("<td>&nbsp;</td>") && (siteParts2 = (siteParts1 = siteLine.split("<a href=\""))[1].split("\"></a></td>")) != null && siteParts2.length > 0 && siteParts2[0] != null && weatherStation != null) {
                        weatherStation.setSite(siteParts2[0].trim());
                    }
                }
                if (weatherStation != null) {
                    stations.add(weatherStation);
                }
                isAdding = false;
            }
        }
        return stations;
    }

    @Override
    public WeatherStation getWeatherStation(String country, String id) {
        if (country != null && id != null) {
            List<WeatherStation> stations = this.findAllWeatherStationsByCountry(country);
            for (WeatherStation weatherStation : stations) {
                if (!weatherStation.getStationId().equals(id)) continue;
                return weatherStation;
            }
        }
        return null;
    }

    public HttpProxy getHttpProxy() {
        return this.httpProxy;
    }

    public void setHttpProxy(HttpProxy httpProxy) {
        this.httpProxy = httpProxy;
    }
}

