/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.options.keymap;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.AbstractListModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import org.netbeans.core.options.keymap.api.KeyStrokeUtils;
import org.netbeans.core.options.keymap.api.ShortcutAction;
import org.netbeans.modules.options.keymap.KeymapPanel;
import org.netbeans.modules.options.keymap.MutableShortcutsModel;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.xml.EntityCatalog;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ProfilesPanel
extends JPanel {
    private static final Logger LOG = Logger.getLogger(ProfilesPanel.class.getName());
    private ProfileListModel model;
    private KeymapPanel keymapPanel;
    private static final String PUBLIC_ID = "-//NetBeans//DTD Keymap Preferences 1.0//EN";
    private static final String SYSTEM_ID = "http://www.netbeans.org/dtds/KeymapPreferences-1_0.dtd";
    private static final String ATTR_ACTION_ID = "id";
    private static final String ELEM_SHORTCUT = "shortcut";
    private static final String ELEM_XML_ROOT = "keymap-preferences";
    private static final String ATTR_SHORTCUT_STRING = "shortcut_string";
    private static final String ELEM_ACTION = "action";
    private JButton deleteButton;
    private JButton duplicateButton;
    private JButton exportButton;
    private JButton importButton;
    private JScrollPane jScrollPane1;
    private JList profilesList;
    private JButton restoreButton;

    public ProfilesPanel(KeymapPanel keymapPanel) {
        this.keymapPanel = keymapPanel;
        this.model = new ProfileListModel();
        this.initComponents();
        this.model.setData(this.getKeymapPanel().getMutableModel().getProfiles());
        this.profilesList.setSelectedValue(this.getKeymapPanel().getMutableModel().getCurrentProfile(), true);
    }

    private KeymapPanel getKeymapPanel() {
        return this.keymapPanel;
    }

    ProfileListModel getModel() {
        return this.model;
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.profilesList = new JList();
        this.duplicateButton = new JButton();
        this.restoreButton = new JButton();
        this.deleteButton = new JButton();
        this.exportButton = new JButton();
        this.importButton = new JButton();
        this.profilesList.setModel(this.model);
        this.profilesList.setSelectionMode(0);
        this.profilesList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                ProfilesPanel.this.profilesListValueChanged(listSelectionEvent);
            }
        });
        this.jScrollPane1.setViewportView(this.profilesList);
        this.profilesList.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ProfilesPanel.class, (String)"ProfilesPanel.profilesList.AccessibleContext.accessibleName"));
        this.profilesList.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ProfilesPanel.class, (String)"ProfilesPanel.profilesList.AccessibleContext.accessibleDescription"));
        Mnemonics.setLocalizedText((AbstractButton)this.duplicateButton, (String)NbBundle.getMessage(ProfilesPanel.class, (String)"ProfilesPanel.duplicateButton.text"));
        this.duplicateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ProfilesPanel.this.duplicateButtonActionPerformed(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.restoreButton, (String)NbBundle.getMessage(ProfilesPanel.class, (String)"ProfilesPanel.restoreButton.text"));
        this.restoreButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ProfilesPanel.this.restoreButtonActionPerformed(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.deleteButton, (String)NbBundle.getMessage(ProfilesPanel.class, (String)"ProfilesPanel.deleteButton.text"));
        this.deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ProfilesPanel.this.deleteButtonActionPerformed(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.exportButton, (String)NbBundle.getMessage(ProfilesPanel.class, (String)"ProfilesPanel.exportButton.text"));
        this.exportButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ProfilesPanel.this.exportButtonActionPerformed(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.importButton, (String)NbBundle.getMessage(ProfilesPanel.class, (String)"ProfilesPanel.importButton.text"));
        this.importButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ProfilesPanel.this.importButtonActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 234, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.duplicateButton, GroupLayout.Alignment.TRAILING).addComponent(this.restoreButton, GroupLayout.Alignment.TRAILING).addComponent(this.deleteButton, GroupLayout.Alignment.TRAILING).addComponent(this.exportButton, GroupLayout.Alignment.TRAILING).addComponent(this.importButton, GroupLayout.Alignment.TRAILING)).addContainerGap()));
        groupLayout.linkSize(0, this.deleteButton, this.duplicateButton, this.exportButton, this.importButton, this.restoreButton);
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jScrollPane1, GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.LEADING, groupLayout.createSequentialGroup().addComponent(this.duplicateButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.restoreButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.deleteButton).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.exportButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.importButton))).addContainerGap(-1, Short.MAX_VALUE)));
        this.jScrollPane1.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ProfilesPanel.class, (String)"ProfilesPanel.jScrollPane1.AccessibleContext.accessibleName"));
        this.jScrollPane1.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ProfilesPanel.class, (String)"ProfilesPanel.jScrollPane1.AccessibleContext.accessibleDescription"));
        this.duplicateButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ProfilesPanel.class, (String)"ProfilesPanel.duplicateButton.AccessibleContext.accessibleDescription"));
        this.restoreButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ProfilesPanel.class, (String)"ProfilesPanel.restoreButton.AccessibleContext.accessibleDescription"));
        this.deleteButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ProfilesPanel.class, (String)"ProfilesPanel.deleteButton.AccessibleContext.accessibleDescription"));
        this.exportButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ProfilesPanel.class, (String)"ProfilesPanel.exportButton.AccessibleContext.accessibleDescription"));
        this.importButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ProfilesPanel.class, (String)"ProfilesPanel.importButton.AccessibleContext.accessibleDescription"));
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ProfilesPanel.class, (String)"ProfilesPanel.AccessibleContext.accessibleName"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ProfilesPanel.class, (String)"ProfilesPanel.AccessibleContext.accessibleDescription"));
    }

    private void restoreButtonActionPerformed(ActionEvent actionEvent) {
        this.deleteOrRestoreSelectedProfile();
    }

    private void deleteButtonActionPerformed(ActionEvent actionEvent) {
        this.deleteOrRestoreSelectedProfile();
    }

    private void profilesListValueChanged(ListSelectionEvent listSelectionEvent) {
        String string = (String)this.profilesList.getSelectedValue();
        if (string == null) {
            this.deleteButton.setEnabled(false);
            this.duplicateButton.setEnabled(false);
            this.exportButton.setEnabled(false);
            this.restoreButton.setEnabled(false);
            return;
        }
        this.duplicateButton.setEnabled(true);
        this.exportButton.setEnabled(true);
        MutableShortcutsModel mutableShortcutsModel = this.getKeymapPanel().getMutableModel();
        if (mutableShortcutsModel.isCustomProfile(string)) {
            this.deleteButton.setEnabled(true);
            this.restoreButton.setEnabled(false);
        } else {
            boolean bl = mutableShortcutsModel.isChangedProfile(string);
            if (!bl) {
                bl |= mutableShortcutsModel.differsFromDefault(string);
            }
            this.deleteButton.setEnabled(false);
            this.restoreButton.setEnabled(bl);
        }
    }

    private void duplicateButtonActionPerformed(ActionEvent actionEvent) {
        this.duplicateProfile();
    }

    private String duplicateProfile() {
        String string = null;
        NotifyDescriptor.InputLine inputLine = new NotifyDescriptor.InputLine(KeymapPanel.loc("CTL_Create_New_Profile_Message"), KeymapPanel.loc("CTL_Create_New_Profile_Title"));
        String string2 = (String)this.profilesList.getSelectedValue();
        inputLine.setInputText(string2);
        DialogDisplayer.getDefault().notify((NotifyDescriptor)inputLine);
        if (inputLine.getValue() == NotifyDescriptor.OK_OPTION) {
            String string32;
            string = inputLine.getInputText();
            for (String string32 : this.getKeymapPanel().getMutableModel().getProfiles()) {
                if (!string.equals(string32)) continue;
                NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)KeymapPanel.loc("CTL_Duplicate_Profile_Name"), 0);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
                return null;
            }
            MutableShortcutsModel mutableShortcutsModel = this.getKeymapPanel().getMutableModel();
            string32 = mutableShortcutsModel.getCurrentProfile();
            this.getKeymapPanel().getMutableModel().setCurrentProfile(string2);
            this.getKeymapPanel().getMutableModel().cloneProfile(string);
            mutableShortcutsModel.setCurrentProfile(string32);
            this.model.addItem(inputLine.getInputText());
            this.profilesList.setSelectedValue(inputLine.getInputText(), true);
        }
        return string;
    }

    private void exportButtonActionPerformed(ActionEvent actionEvent) {
        JFileChooser jFileChooser = ProfilesPanel.getFileChooser();
        jFileChooser.setSelectedFile(new File("exported-" + this.profilesList.getSelectedValue() + "-profile.xml"));
        int n = jFileChooser.showSaveDialog(this);
        if (n == 0) {
            Document document = XMLUtil.createDocument((String)ELEM_XML_ROOT, null, (String)PUBLIC_ID, (String)SYSTEM_ID);
            Node node = document.getElementsByTagName(ELEM_XML_ROOT).item(0);
            MutableShortcutsModel mutableShortcutsModel = this.getKeymapPanel().getMutableModel();
            for (Object object : mutableShortcutsModel.getItems("")) {
                ShortcutAction shortcutAction = (ShortcutAction)object;
                String[] stringArray = mutableShortcutsModel.getShortcuts(shortcutAction);
                if (stringArray.length <= 0) continue;
                String string = shortcutAction.getId();
                Element element = document.createElement(ELEM_ACTION);
                element.setAttribute(ATTR_ACTION_ID, string);
                for (int i = 0; i < stringArray.length; ++i) {
                    Element element2 = document.createElement(ELEM_SHORTCUT);
                    String string2 = ProfilesPanel.shortcutToPortableRepresentation(stringArray[i]);
                    element2.setAttribute(ATTR_SHORTCUT_STRING, string2);
                    element.appendChild(element2);
                }
                node.appendChild(element);
            }
            File file = jFileChooser.getSelectedFile();
            try {
                Object object;
                object = new FileOutputStream(file);
                XMLUtil.write((Document)document, (OutputStream)object, (String)"UTF-8");
                ((FileOutputStream)object).close();
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
    }

    private static String shortcutToPortableRepresentation(String string) {
        assert (string != null) : "The parameter key must not be null";
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = " ";
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken().trim();
            KeyStroke keyStroke = KeyStrokeUtils.getKeyStroke(string3);
            if (keyStroke != null) {
                stringBuilder.append(Utilities.keyToString((KeyStroke)keyStroke, (boolean)true));
                if (!stringTokenizer.hasMoreTokens()) continue;
                stringBuilder.append(' ');
                continue;
            }
            return null;
        }
        return stringBuilder.toString();
    }

    private static String portableRepresentationToShortcut(String string) {
        assert (string != null) : "The parameter must not be null";
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = " ";
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken().trim();
            KeyStroke keyStroke = Utilities.stringToKey((String)string3);
            if (keyStroke != null) {
                stringBuilder.append(KeyStrokeUtils.getKeyStrokeAsText(keyStroke));
                if (!stringTokenizer.hasMoreTokens()) continue;
                stringBuilder.append(' ');
                continue;
            }
            return null;
        }
        return stringBuilder.toString();
    }

    private static JFileChooser getFileChooser() {
        JFileChooser jFileChooser = new JFileChooser();
        XMLFileFilter xMLFileFilter = new XMLFileFilter();
        jFileChooser.setAcceptAllFileFilterUsed(false);
        jFileChooser.addChoosableFileFilter(xMLFileFilter);
        jFileChooser.setFileFilter(xMLFileFilter);
        return jFileChooser;
    }

    private void importButtonActionPerformed(ActionEvent actionEvent) {
        InputSource inputSource;
        JFileChooser jFileChooser = ProfilesPanel.getFileChooser();
        int n = jFileChooser.showOpenDialog(this);
        boolean[] blArray = new boolean[1];
        if (n == 0) {
            try {
                inputSource = new InputSource(new FileInputStream(jFileChooser.getSelectedFile()));
                MutableShortcutsModel mutableShortcutsModel = this.getKeymapPanel().getMutableModel();
                String string = this.duplicateProfile();
                if (string == null) {
                    return;
                }
                mutableShortcutsModel.setCurrentProfile(string);
                Document document = XMLUtil.parse((InputSource)inputSource, (boolean)false, (boolean)true, null, (EntityResolver)EntityCatalog.getDefault());
                Node node = document.getElementsByTagName(ELEM_XML_ROOT).item(0);
                NodeList nodeList = node.getChildNodes();
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Node node2 = nodeList.item(i);
                    NamedNodeMap namedNodeMap = node2.getAttributes();
                    if (namedNodeMap == null) continue;
                    String string2 = namedNodeMap.item(0).getNodeValue();
                    ShortcutAction shortcutAction = mutableShortcutsModel.findActionForId(string2);
                    NodeList nodeList2 = node2.getChildNodes();
                    int n2 = nodeList2.getLength();
                    LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>(n2);
                    for (int j = 0; j < n2; ++j) {
                        NamedNodeMap namedNodeMap2 = nodeList2.item(j).getAttributes();
                        if (namedNodeMap2 == null) continue;
                        String string3 = namedNodeMap2.item(0).getNodeValue();
                        linkedHashSet.add(ProfilesPanel.portableRepresentationToShortcut(string3));
                    }
                    if (shortcutAction == null) {
                        blArray[0] = true;
                        LOG.log(Level.WARNING, "Failed to import binding for: {0}, keys: {1}", new Object[]{string2, linkedHashSet});
                        continue;
                    }
                    mutableShortcutsModel.setShortcuts(shortcutAction, linkedHashSet);
                }
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
            catch (SAXException sAXException) {
                Exceptions.printStackTrace((Throwable)sAXException);
            }
        }
        if (blArray[0]) {
            inputSource = new NotifyDescriptor((Object)NbBundle.getMessage(ProfilesPanel.class, (String)"Import.failed.unknown.id"), NbBundle.getMessage(ProfilesPanel.class, (String)"Import.failed.title"), -1, 1, new Object[]{NotifyDescriptor.OK_OPTION}, NotifyDescriptor.OK_OPTION);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)inputSource);
        }
    }

    private void deleteOrRestoreSelectedProfile() {
        String string = (String)this.profilesList.getSelectedValue();
        MutableShortcutsModel mutableShortcutsModel = this.getKeymapPanel().getMutableModel();
        if (mutableShortcutsModel.deleteOrRestoreProfile(string)) {
            this.model.removeItem(this.profilesList.getSelectedIndex());
            this.profilesList.setSelectedIndex(0);
        } else {
            this.profilesListValueChanged(null);
        }
    }

    public String getSelectedProfile() {
        return (String)this.profilesList.getSelectedValue();
    }

    private class ProfileListModel
    extends AbstractListModel {
        private ArrayList<String> delegate = new ArrayList();

        private ProfileListModel() {
        }

        @Override
        public int getSize() {
            return this.delegate.size();
        }

        @Override
        public Object getElementAt(int n) {
            return this.delegate.get(n);
        }

        public void setData(Collection<String> collection) {
            this.delegate.clear();
            this.delegate.addAll(collection);
            this.fireContentsChanged(this, 0, collection.size());
        }

        private void addItem(String string) {
            this.delegate.add(string);
            int n = this.delegate.size();
            this.fireContentsChanged(this, n, n);
        }

        private void removeItem(int n) {
            this.delegate.remove(n);
            this.fireContentsChanged(this, n, n);
        }
    }

    private static class XMLFileFilter
    extends FileFilter {
        private XMLFileFilter() {
        }

        @Override
        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            return file.getAbsolutePath().endsWith(".xml");
        }

        @Override
        public String getDescription() {
            return "XML " + NbBundle.getMessage(ProfilesPanel.class, (String)"CTL_Files") + "(*.xml)";
        }
    }
}

