/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.options.keymap;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JFileChooser;
import org.netbeans.core.options.keymap.api.ShortcutAction;
import org.netbeans.core.options.keymap.spi.KeymapManager;
import org.netbeans.modules.options.keymap.KeymapModel;
import org.netbeans.modules.options.keymap.LayersBridge;
import org.netbeans.modules.options.keymap.XMLStorage;
import org.openide.ErrorManager;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.util.NbBundle;
import org.openide.windows.WindowManager;

public class ExportShortcutsAction {
    private static Action exportIDEActionsAction = new AbstractAction(){
        {
            this.putValue("Name", ExportShortcutsAction.loc("CTL_Export_IDE_Actions_Action"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            LayersBridge layersBridge = new LayersBridge();
            Map<String, Set<ShortcutAction>> map = layersBridge.getActions();
            Map map2 = ExportShortcutsAction.resolveNames(map);
            ExportShortcutsAction.generateLayersXML(layersBridge, map2);
        }
    };
    private static Action exportIDEShortcutsAction = new AbstractAction(){
        {
            this.putValue("Name", ExportShortcutsAction.loc("CTL_Export_IDE_Shortcuts_Action"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            HashMap<String, Map<String, ShortcutAction>> hashMap = new HashMap<String, Map<String, ShortcutAction>>();
            LayersBridge layersBridge = new LayersBridge();
            layersBridge.getActions();
            List<String> list = layersBridge.getProfiles();
            for (String string : list) {
                Map<ShortcutAction, Set<String>> map = layersBridge.getKeymap(string);
                Map<String, ShortcutAction> map2 = LayersBridge.shortcutToAction(map);
                hashMap.put(string, map2);
            }
            ExportShortcutsAction.generateLayersXML(layersBridge, hashMap);
        }
    };
    private static Action exportEditorShortcutsAction = new AbstractAction(){
        {
            this.putValue("Name", ExportShortcutsAction.loc("CTL_Export_Editor_Shortcuts_Action"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            KeymapManager keymapManager = null;
            for (KeymapManager keymapManager2 : KeymapModel.getKeymapManagerInstances()) {
                if (!"EditorBridge".equals(keymapManager2.getName())) continue;
                keymapManager = keymapManager2;
                break;
            }
            if (keymapManager != null) {
                Map<ShortcutAction, Set<String>> map = keymapManager.getKeymap(keymapManager.getCurrentProfile());
                ExportShortcutsAction.generateEditorXML(map);
            }
        }
    };
    private static Action exportShortcutsToHTMLAction = new AbstractAction(){
        {
            this.putValue("Name", ExportShortcutsAction.loc("CTL_Export_Shortcuts_to_HTML_Action"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ExportShortcutsAction.exportShortcutsToHTML();
        }
    };

    private ExportShortcutsAction() {
    }

    public static Action getExportIDEActionsAction() {
        return exportIDEActionsAction;
    }

    public static Action getExportIDEShortcutsAction() {
        return exportIDEShortcutsAction;
    }

    public static Action getExportEditorShortcutsAction() {
        return exportEditorShortcutsAction;
    }

    public static Action getExportShortcutsToHTMLAction() {
        return exportShortcutsToHTMLAction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void exportShortcutsToHTML() {
        KeymapModel keymapModel = new KeymapModel();
        TreeMap<String, Map<ShortcutAction, Set<String>>> treeMap = new TreeMap<String, Map<ShortcutAction, Set<String>>>();
        for (String object : keymapModel.getProfiles()) {
            treeMap.put(object, keymapModel.getKeymap(object));
        }
        try {
            String string2;
            StringBuffer stringBuffer = new StringBuffer();
            XMLStorage.Attribs attribs = new XMLStorage.Attribs(true);
            XMLStorage.generateFolderStart(stringBuffer, "html", attribs, "");
            XMLStorage.generateFolderStart(stringBuffer, "body", attribs, "  ");
            attribs.add("border", "1");
            attribs.add("cellpadding", "1");
            attribs.add("cellspacing", "0");
            XMLStorage.generateFolderStart(stringBuffer, "table", attribs, "    ");
            XMLStorage.Attribs attribs2 = new XMLStorage.Attribs(true);
            XMLStorage.generateFolderStart(stringBuffer, "tr", attribs2, "      ");
            XMLStorage.generateFolderStart(stringBuffer, "td", attribs2, "        ");
            XMLStorage.generateFolderStart(stringBuffer, "h2", attribs2, "        ");
            stringBuffer.append("Action Name");
            XMLStorage.generateFolderEnd(stringBuffer, "h2", "        ");
            XMLStorage.generateFolderEnd(stringBuffer, "td", "        ");
            for (String string2 : treeMap.keySet()) {
                XMLStorage.generateFolderStart(stringBuffer, "td", attribs2, "        ");
                XMLStorage.generateFolderStart(stringBuffer, "h2", attribs2, "        ");
                stringBuffer.append(string2);
                XMLStorage.generateFolderEnd(stringBuffer, "h2", "        ");
                XMLStorage.generateFolderEnd(stringBuffer, "td", "        ");
            }
            ExportShortcutsAction.exportShortcutsToHTML2(keymapModel, stringBuffer, treeMap);
            XMLStorage.generateFolderEnd(stringBuffer, "table", "    ");
            XMLStorage.generateFolderEnd(stringBuffer, "body", "  ");
            XMLStorage.generateFolderEnd(stringBuffer, "html", "");
            FileObject fileObject = FileUtil.createData((FileObject)FileUtil.getConfigRoot(), (String)"shortcuts.html");
            string2 = fileObject.lock();
            try {
                OutputStream outputStream = fileObject.getOutputStream((FileLock)string2);
                OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream);
                outputStreamWriter.write(stringBuffer.toString());
                outputStreamWriter.close();
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify((Throwable)iOException);
            }
            finally {
                string2.releaseLock();
            }
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify((Throwable)iOException);
        }
    }

    private static void exportShortcutsToHTML2(KeymapModel keymapModel, StringBuffer stringBuffer, Map<String, Map<ShortcutAction, Set<String>>> map) {
        ArrayList<String> arrayList = new ArrayList<String>(keymapModel.getActionCategories());
        Collections.sort(arrayList);
        XMLStorage.Attribs attribs = new XMLStorage.Attribs(true);
        for (String string : arrayList) {
            XMLStorage.generateFolderStart(stringBuffer, "tr", attribs, "      ");
            attribs.add("colspan", Integer.toString(map.size() + 1));
            attribs.add("rowspan", "1");
            XMLStorage.generateFolderStart(stringBuffer, "td", attribs, "        ");
            attribs = new XMLStorage.Attribs(true);
            XMLStorage.generateFolderStart(stringBuffer, "h3", attribs, "        ");
            stringBuffer.append(string);
            XMLStorage.generateFolderEnd(stringBuffer, "h3", "        ");
            XMLStorage.generateFolderEnd(stringBuffer, "td", "        ");
            XMLStorage.generateFolderEnd(stringBuffer, "tr", "      ");
            ExportShortcutsAction.exportShortcutsToHTML3(stringBuffer, keymapModel, string, map);
        }
    }

    private static void exportShortcutsToHTML3(StringBuffer stringBuffer, KeymapModel keymapModel, String string, Map<String, Map<ShortcutAction, Set<String>>> map) {
        Set<ShortcutAction> set = keymapModel.getActions(string);
        TreeMap<String, ShortcutAction> treeMap = new TreeMap<String, ShortcutAction>();
        for (ShortcutAction object : set) {
            treeMap.put(object.getDisplayName(), object);
        }
        XMLStorage.Attribs attribs = new XMLStorage.Attribs(true);
        for (Map.Entry entry : treeMap.entrySet()) {
            String string2 = (String)entry.getKey();
            ShortcutAction shortcutAction = (ShortcutAction)entry.getValue();
            XMLStorage.generateFolderStart(stringBuffer, "tr", attribs, "      ");
            XMLStorage.generateFolderStart(stringBuffer, "td", attribs, "        ");
            stringBuffer.append(string2);
            XMLStorage.generateFolderEnd(stringBuffer, "td", "        ");
            for (String string3 : map.keySet()) {
                Map<ShortcutAction, Set<String>> map2 = map.get(string3);
                Set<String> set2 = map2.get(shortcutAction);
                XMLStorage.generateFolderStart(stringBuffer, "td", attribs, "        ");
                ExportShortcutsAction.printShortcuts(set2, stringBuffer);
                XMLStorage.generateFolderEnd(stringBuffer, "td", "        ");
            }
            XMLStorage.generateFolderEnd(stringBuffer, "tr", "      ");
        }
    }

    private static void printShortcuts(Set<String> set, StringBuffer stringBuffer) {
        if (set == null) {
            stringBuffer.append('-');
            return;
        }
        Iterator<String> iterator = set.iterator();
        while (iterator.hasNext()) {
            String string = iterator.next();
            stringBuffer.append(string);
            if (!iterator.hasNext()) continue;
            stringBuffer.append(", ");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void generateLayersXML(LayersBridge layersBridge, Map<String, Map<String, ShortcutAction>> map) {
        Writer writer = null;
        try {
            writer = ExportShortcutsAction.openWriter();
            if (writer == null) {
                return;
            }
            StringBuffer stringBuffer = XMLStorage.generateHeader();
            XMLStorage.Attribs attribs = new XMLStorage.Attribs(true);
            XMLStorage.generateFolderStart(stringBuffer, "filesystem", attribs, "");
            attribs.add("name", "Keymaps");
            XMLStorage.generateFolderStart(stringBuffer, "folder", attribs, "    ");
            ExportShortcutsAction.generateShadowsToXML(layersBridge, stringBuffer, map, "        ");
            XMLStorage.generateFolderEnd(stringBuffer, "folder", "    ");
            XMLStorage.generateFolderEnd(stringBuffer, "filesystem", "");
            writer.write(stringBuffer.toString());
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify((Throwable)iOException);
        }
        finally {
            try {
                if (writer != null) {
                    writer.flush();
                    writer.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void generateEditorXML(Map<ShortcutAction, Set<String>> map) {
        Writer writer = null;
        try {
            writer = ExportShortcutsAction.openWriter();
            if (writer == null) {
                return;
            }
            StringBuffer stringBuffer = XMLStorage.generateHeader();
            XMLStorage.Attribs attribs = new XMLStorage.Attribs(true);
            XMLStorage.generateFolderStart(stringBuffer, "bindings", attribs, "");
            TreeMap<String, Set<String>> treeMap = new TreeMap<String, Set<String>>();
            for (ShortcutAction object : map.keySet()) {
                treeMap.put(object.getDisplayName(), map.get(object));
            }
            for (String string : treeMap.keySet()) {
                Set set = (Set)treeMap.get(string);
                for (String string2 : set) {
                    attribs = new XMLStorage.Attribs(true);
                    attribs.add("actionName", string);
                    attribs.add("key", string2);
                    XMLStorage.generateLeaf(stringBuffer, "bind", attribs, "  ");
                }
            }
            XMLStorage.generateFolderEnd(stringBuffer, "bindings", "");
            writer.write(stringBuffer.toString());
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify((Throwable)iOException);
        }
        finally {
            try {
                if (writer != null) {
                    writer.flush();
                    writer.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private static Map<String, Map<String, ShortcutAction>> resolveNames(Map<String, Set<ShortcutAction>> map) {
        HashMap<String, Map<String, ShortcutAction>> hashMap = new HashMap<String, Map<String, ShortcutAction>>();
        for (Map.Entry<String, Set<ShortcutAction>> entry : map.entrySet()) {
            String string = entry.getKey();
            Set<ShortcutAction> set = entry.getValue();
            HashMap<String, ShortcutAction> hashMap2 = new HashMap<String, ShortcutAction>();
            for (ShortcutAction shortcutAction : set) {
                hashMap2.put(shortcutAction.getDisplayName(), shortcutAction);
            }
            hashMap.put(string, hashMap2);
        }
        return hashMap;
    }

    private static void generateShadowsToXML(LayersBridge layersBridge, StringBuffer stringBuffer, Map<String, Map<String, ShortcutAction>> map, String string) {
        for (String string2 : map.keySet()) {
            Map<String, ShortcutAction> map2 = map.get(string2);
            XMLStorage.Attribs attribs = new XMLStorage.Attribs(true);
            attribs.add("name", string2);
            XMLStorage.generateFolderStart(stringBuffer, "folder", attribs, string);
            ExportShortcutsAction.generateShadowsToXML2(layersBridge, stringBuffer, map2, "    " + string);
            XMLStorage.generateFolderEnd(stringBuffer, "folder", string);
        }
    }

    private static void generateShadowsToXML2(LayersBridge layersBridge, StringBuffer stringBuffer, Map<String, ShortcutAction> map, String string) {
        for (String string2 : map.keySet()) {
            ShortcutAction shortcutAction = map.get(string2);
            DataObject dataObject = layersBridge.getDataObject(shortcutAction);
            if (dataObject == null) {
                System.out.println("no Dataobject " + shortcutAction);
                continue;
            }
            FileObject fileObject = dataObject.getPrimaryFile();
            XMLStorage.Attribs attribs = new XMLStorage.Attribs(true);
            attribs.add("name", string2 + ".shadow");
            XMLStorage.generateFolderStart(stringBuffer, "file", attribs, string);
            XMLStorage.Attribs attribs2 = new XMLStorage.Attribs(true);
            attribs2.add("name", "originalFile");
            attribs2.add("stringvalue", fileObject.getPath());
            XMLStorage.generateLeaf(stringBuffer, "attr", attribs2, string + "    ");
            XMLStorage.generateFolderEnd(stringBuffer, "file", string);
        }
    }

    private static Writer openWriter() throws IOException {
        JFileChooser jFileChooser = new JFileChooser();
        int n = jFileChooser.showSaveDialog(WindowManager.getDefault().getMainWindow());
        if (n != 0) {
            return null;
        }
        File file = jFileChooser.getSelectedFile();
        return new FileWriter(file);
    }

    private static String loc(String string) {
        return NbBundle.getMessage(ExportShortcutsAction.class, (String)string);
    }
}

