/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.options.keymap;

import java.awt.Color;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.Set;
import javax.swing.DefaultCellEditor;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import org.netbeans.core.options.keymap.api.ShortcutAction;
import org.netbeans.modules.options.keymap.ActionHolder;
import org.netbeans.modules.options.keymap.KeymapViewModel;
import org.netbeans.modules.options.keymap.ShortcutCellPanel;
import org.netbeans.modules.options.keymap.ShortcutTextField;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;

class ButtonCellEditor
extends DefaultCellEditor {
    private Object action;
    private KeymapViewModel model;
    private String orig;
    private KeyAdapter escapeAdapter = new KeyAdapter(){

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 27) {
                JTable jTable = (JTable)cell.getParent();
                jTable.getCellEditor().cancelCellEditing();
                ButtonCellEditor.this.model.update();
            }
        }
    };
    private static final ShortcutCellPanel cell = new ShortcutCellPanel();

    public ButtonCellEditor(KeymapViewModel keymapViewModel) {
        super(new ShortcutTextField());
        this.model = keymapViewModel;
    }

    @Override
    public boolean shouldSelectCell(EventObject eventObject) {
        return true;
    }

    private void removeConflictingShortcut(ShortcutAction shortcutAction, String string) {
        if (string.contains(" ")) {
            string = string.substring(0, string.indexOf(32));
        }
        String[] stringArray = this.model.getMutableModel().getShortcuts(shortcutAction);
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].startsWith(string)) continue;
            this.model.getMutableModel().removeShortcut(shortcutAction, stringArray[i]);
        }
    }

    @Override
    public boolean stopCellEditing() {
        String string = cell.toString();
        Window window = (Window)SwingUtilities.getRoot(cell);
        if (window == null) {
            return true;
        }
        JTable jTable = (JTable)cell.getParent();
        ShortcutAction shortcutAction = (ShortcutAction)this.action;
        Set<ShortcutAction> set = this.model.getMutableModel().findActionForShortcutPrefix(string);
        set.remove(shortcutAction);
        Collection<ShortcutAction> collection = this.model.getMutableModel().filterSameScope(set, shortcutAction);
        if (!set.isEmpty()) {
            Object object = this.overrride(set, collection);
            window.toFront();
            jTable.requestFocus();
            if (object.equals(DialogDescriptor.YES_OPTION)) {
                for (ShortcutAction shortcutAction2 : set) {
                    this.removeConflictingShortcut(shortcutAction2, string);
                }
            } else if (object == DialogDescriptor.CANCEL_OPTION) {
                cell.getTextField().setText(this.orig);
                this.fireEditingCanceled();
                this.setBorderEmpty();
                return true;
            }
        }
        cell.getTextField().removeActionListener(this.delegate);
        cell.getTextField().removeKeyListener(this.escapeAdapter);
        this.model.getMutableModel().removeShortcut((ShortcutAction)this.action, this.orig);
        if (string.length() != 0) {
            this.model.getMutableModel().addShortcut((ShortcutAction)this.action, string);
        }
        this.fireEditingStopped();
        this.setBorderEmpty();
        this.model.update();
        return true;
    }

    @Override
    public void cancelCellEditing() {
        cell.getTextField().setText(this.orig);
        this.fireEditingCanceled();
        this.setBorderEmpty();
    }

    @Override
    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        cell.setText((String)object);
        this.orig = cell.getTextField().getText();
        this.action = ((ActionHolder)jTable.getValueAt(n, 0)).getAction();
        final JTextField jTextField = cell.getTextField();
        jTextField.addActionListener(this.delegate);
        jTextField.setBorder(new LineBorder(Color.BLACK));
        if (!Arrays.asList(jTextField.getKeyListeners()).contains(this.escapeAdapter)) {
            jTextField.addKeyListener(this.escapeAdapter);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                jTextField.requestFocus();
            }
        });
        return cell;
    }

    @Override
    public Object getCellEditorValue() {
        return cell.getTextField().getText();
    }

    @Override
    public Component getComponent() {
        return cell.getTextField();
    }

    private Object overrride(Set<ShortcutAction> set, Collection<ShortcutAction> collection) {
        ShortcutAction shortcutAction2;
        StringBuffer stringBuffer = new StringBuffer();
        for (ShortcutAction shortcutAction2 : set) {
            stringBuffer.append("<li>'").append(shortcutAction2.getDisplayName()).append("'</li>");
        }
        JPanel jPanel = new JPanel();
        jPanel.add(new JLabel(NbBundle.getMessage(ButtonCellEditor.class, (String)(collection.isEmpty() ? "Override_Shortcut2" : "Override_Shortcut"), (Object)stringBuffer)));
        shortcutAction2 = new DialogDescriptor((Object)jPanel, NbBundle.getMessage(ButtonCellEditor.class, (String)"Conflicting_Shortcut_Dialog"), true, collection.isEmpty() ? 1 : 0, null, null);
        DialogDisplayer.getDefault().notify((NotifyDescriptor)shortcutAction2);
        Object object = shortcutAction2.getValue();
        if (!collection.isEmpty() && object == DialogDescriptor.NO_OPTION) {
            return DialogDescriptor.CANCEL_OPTION;
        }
        return object;
    }

    private void setBorderEmpty() {
        ((JComponent)this.getComponent()).setBorder(new EmptyBorder(0, 0, 0, 0));
    }
}

