/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.oql.engine.api.impl;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.lib.profiler.heap.Field;
import org.netbeans.lib.profiler.heap.GCRoot;
import org.netbeans.lib.profiler.heap.Heap;
import org.netbeans.lib.profiler.heap.Instance;
import org.netbeans.lib.profiler.heap.JavaClass;
import org.netbeans.lib.profiler.heap.ObjectArrayInstance;
import org.netbeans.lib.profiler.heap.ObjectFieldValue;
import org.netbeans.lib.profiler.heap.PrimitiveArrayInstance;
import org.netbeans.lib.profiler.heap.Value;
import org.netbeans.modules.profiler.oql.engine.api.OQLEngine;
import org.netbeans.modules.profiler.oql.engine.api.ReferenceChain;
import org.netbeans.modules.profiler.oql.engine.api.impl.ReachableExcludes;
import org.netbeans.modules.profiler.oql.engine.api.impl.TreeIterator;

public class Snapshot {
    private final Heap delegate;
    private JavaClass weakReferenceClass;
    private int referentFieldIndex;
    private ReachableExcludes reachableExcludes;
    private final OQLEngine engine;

    public Snapshot(Heap heap, OQLEngine oQLEngine) {
        this.delegate = heap;
        this.engine = oQLEngine;
        this.init();
    }

    private void init() {
        this.weakReferenceClass = this.findClass("java.lang.ref.Reference");
        if (this.weakReferenceClass == null) {
            this.weakReferenceClass = this.findClass("sun.misc.Ref");
            this.referentFieldIndex = 0;
        } else {
            List list = this.weakReferenceClass.getFields();
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                if (!"referent".equals(((Field)list.get(i)).getName())) continue;
                this.referentFieldIndex = i;
                break;
            }
        }
    }

    public JavaClass findClass(String string) {
        try {
            long l = string.startsWith("0x") ? Long.parseLong(string.substring(2), 16) : Long.parseLong(string);
            return this.delegate.getJavaClassByID(l);
        }
        catch (NumberFormatException numberFormatException) {
            return this.delegate.getJavaClassByName(this.preprocessClassName(string));
        }
    }

    private String preprocessClassName(String string) {
        int n = 0;
        if (string.startsWith("[")) {
            n = string.lastIndexOf(91) + 1;
            string = string.substring(n);
        }
        if (string.length() == 1) {
            if (string.equals("I")) {
                string = "int";
            } else if (string.equals("J")) {
                string = "long";
            } else if (string.equals("D")) {
                string = "double";
            } else if (string.equals("F")) {
                string = "float";
            } else if (string.equals("B")) {
                string = "byte";
            } else if (string.equals("S")) {
                string = "short";
            } else if (string.equals("C")) {
                string = "char";
            } else if (string.equals("Z")) {
                string = "boolean";
            }
        }
        if (n > 0 && string.startsWith("L")) {
            string = string.substring(1);
        }
        StringBuilder stringBuilder = new StringBuilder(string);
        for (int i = 0; i < n; ++i) {
            stringBuilder.append("[]");
        }
        return stringBuilder.toString();
    }

    public Instance findThing(long l) {
        return this.delegate.getInstanceByID(l);
    }

    public GCRoot findRoot(Instance instance) {
        Instance instance2 = instance;
        while (!(instance2 = instance2.getNearestGCRootPointer()).isGCRoot()) {
        }
        if (instance2 != null) {
            return this.delegate.getGCRoot(instance2);
        }
        return null;
    }

    public Iterator getClasses() {
        return this.delegate.getAllClasses().iterator();
    }

    public Iterator getClassNames(String string) {
        final Iterator iterator = this.delegate.getJavaClassesByRegExp(string).iterator();
        return new Iterator(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            public Object next() {
                return ((JavaClass)iterator.next()).getName();
            }

            @Override
            public void remove() {
                iterator.remove();
            }
        };
    }

    public Iterator getInstances(JavaClass javaClass, final boolean bl) {
        return new TreeIterator<Instance, JavaClass>(javaClass){

            @Override
            protected Iterator<Instance> getSameLevelIterator(JavaClass javaClass) {
                return javaClass.getInstances().iterator();
            }

            @Override
            protected Iterator<JavaClass> getTraversingIterator(JavaClass javaClass) {
                return bl ? javaClass.getSubClasses().iterator() : Collections.EMPTY_LIST.iterator();
            }
        };
    }

    public Iterator getReferrers(Object object, boolean bl) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        ArrayList<Instance> arrayList2 = new ArrayList<Instance>();
        if (object instanceof Instance) {
            arrayList2.addAll(((Instance)object).getReferences());
        } else if (object instanceof JavaClass) {
            arrayList2.addAll(((JavaClass)object).getInstances());
            arrayList2.add(((JavaClass)object).getClassLoader());
        }
        if (!arrayList2.isEmpty()) {
            for (Object e : arrayList2) {
                if (e instanceof Value) {
                    Value value = (Value)e;
                    Instance instance = value.getDefiningInstance();
                    if (!bl && this.isWeakRef(instance)) continue;
                    arrayList.add(instance);
                    continue;
                }
                if (!(e instanceof Instance) || !bl && this.isWeakRef((Instance)e)) continue;
                arrayList.add(e);
            }
        }
        return arrayList.iterator();
    }

    public Iterator getReferees(Object object, boolean bl) {
        Object object2;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        ArrayList arrayList2 = new ArrayList();
        if (object instanceof Instance) {
            object2 = (Instance)object;
            arrayList2.addAll(object2.getFieldValues());
        }
        if (object instanceof JavaClass) {
            arrayList2.addAll(((JavaClass)object).getStaticFieldValues());
        }
        if (object instanceof ObjectArrayInstance) {
            object2 = (ObjectArrayInstance)object;
            arrayList2.addAll(object2.getValues());
        }
        if (!arrayList2.isEmpty()) {
            for (Object e : arrayList2) {
                if (e instanceof ObjectFieldValue && ((ObjectFieldValue)e).getInstance() != null) {
                    Instance instance = ((ObjectFieldValue)e).getInstance();
                    if (!bl && this.isWeakRef(instance)) continue;
                    if (instance.getJavaClass().getName().equals("java.lang.Class")) {
                        JavaClass javaClass = this.delegate.getJavaClassByID(instance.getInstanceId());
                        if (javaClass != null) {
                            arrayList.add(javaClass);
                            continue;
                        }
                        arrayList.add(instance);
                        continue;
                    }
                    arrayList.add(instance);
                    continue;
                }
                if (!(e instanceof Instance) || !bl && this.isWeakRef((Instance)e)) continue;
                arrayList.add(e);
            }
        }
        return arrayList.iterator();
    }

    public Iterator getFinalizerObjects() {
        JavaClass javaClass = this.findClass("java.lang.ref.Finalizer");
        Instance instance = ((ObjectFieldValue)javaClass.getValueOfStaticField("queue")).getInstance();
        ObjectFieldValue objectFieldValue = (ObjectFieldValue)instance.getValueOfField("head");
        ArrayList<Instance> arrayList = new ArrayList<Instance>();
        if (objectFieldValue != null) {
            Instance instance2 = objectFieldValue.getInstance();
            while (true) {
                ObjectFieldValue objectFieldValue2 = (ObjectFieldValue)instance2.getValueOfField("referent");
                ObjectFieldValue objectFieldValue3 = (ObjectFieldValue)instance2.getValueOfField("next");
                if (objectFieldValue3 == null || objectFieldValue3.getInstance().equals(instance2)) break;
                instance2 = objectFieldValue3.getInstance();
                arrayList.add(objectFieldValue2.getInstance());
            }
        }
        return arrayList.iterator();
    }

    public Iterator getRoots() {
        return this.getRootsList().iterator();
    }

    public List getRootsList() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (Object e : this.delegate.getGCRoots()) {
            GCRoot gCRoot = (GCRoot)e;
            Instance instance = gCRoot.getInstance();
            if (instance.getJavaClass().getName().equals("java.lang.Class")) {
                JavaClass javaClass = this.delegate.getJavaClassByID(instance.getInstanceId());
                if (javaClass != null) {
                    arrayList.add(javaClass);
                    continue;
                }
                arrayList.add(instance);
                continue;
            }
            arrayList.add(instance);
        }
        return arrayList;
    }

    public GCRoot[] getRootsArray() {
        List list = this.getRootsList();
        return list.toArray(new GCRoot[list.size()]);
    }

    public ReferenceChain[] rootsetReferencesTo(Instance instance, boolean bl) {
        LinkedList<State> linkedList = new LinkedList<State>();
        HashSet<Object> hashSet = new HashSet<Object>();
        ArrayList<ReferenceChain> arrayList = new ArrayList<ReferenceChain>();
        Iterator iterator = this.getRoots();
        ReferenceChain referenceChain = null;
        class State {
            private Iterator<Instance> iterator;
            private ReferenceChain path;
            private AtomicLong hits = new AtomicLong(0L);

            public State(ReferenceChain referenceChain, Iterator<Instance> iterator) {
                this.iterator = iterator;
                this.path = referenceChain;
            }
        }
        State state = new State(referenceChain, iterator);
        do {
            Object object;
            if (referenceChain != null && referenceChain.getObj().equals(instance)) {
                arrayList.add(referenceChain);
                state.hits.incrementAndGet();
            } else {
                while (!this.engine.isCancelled() && iterator.hasNext()) {
                    object = iterator.next();
                    if (referenceChain != null && referenceChain.contains(object) || hashSet.contains(object)) continue;
                    linkedList.push(state);
                    referenceChain = new ReferenceChain(this.delegate, object, referenceChain);
                    iterator = this.getReferees(object, bl);
                    state = new State(referenceChain, iterator);
                }
                if (referenceChain != null && referenceChain.getObj().equals(instance)) {
                    arrayList.add(referenceChain);
                    state.hits.incrementAndGet();
                }
            }
            object = (State)linkedList.poll();
            if (object == null) break;
            ((State)object).hits.addAndGet(state.hits.get());
            if (state.hits.get() == 0L) {
                hashSet.add(referenceChain.getObj());
            }
            state = object;
            referenceChain = state.path;
            iterator = state.iterator;
        } while (!this.engine.isCancelled());
        return arrayList.toArray(new ReferenceChain[arrayList.size()]);
    }

    private boolean isAssignable(JavaClass javaClass, JavaClass javaClass2) {
        if (javaClass == javaClass2) {
            return true;
        }
        if (javaClass == null) {
            return false;
        }
        return this.isAssignable(javaClass.getSuperClass(), javaClass2);
    }

    private boolean isWeakRef(Instance instance) {
        return this.weakReferenceClass != null && this.isAssignable(instance.getJavaClass(), this.weakReferenceClass);
    }

    public JavaClass getWeakReferenceClass() {
        return this.weakReferenceClass;
    }

    public int getReferentFieldIndex() {
        return this.referentFieldIndex;
    }

    public void setReachableExcludes(ReachableExcludes reachableExcludes) {
        this.reachableExcludes = reachableExcludes;
    }

    public ReachableExcludes getReachableExcludes() {
        return this.reachableExcludes;
    }

    public String valueString(Instance instance) {
        if (instance == null) {
            return null;
        }
        try {
            if (instance.getJavaClass().getName().equals(String.class.getName())) {
                Class<?> clazz = Class.forName("org.netbeans.lib.profiler.heap.HprofProxy");
                Method method = clazz.getDeclaredMethod("getString", Instance.class);
                method.setAccessible(true);
                return (String)method.invoke(clazz, instance);
            }
            if (instance.getJavaClass().getName().equals("char[]")) {
                Method method = instance.getClass().getDeclaredMethod("getChars", Integer.TYPE, Integer.TYPE);
                method.setAccessible(true);
                char[] cArray = (char[])method.invoke((Object)instance, 0, ((PrimitiveArrayInstance)instance).getLength());
                if (cArray != null) {
                    return new String(cArray);
                }
                return "*null*";
            }
        }
        catch (Exception exception) {
            Logger.getLogger(Snapshot.class.getName()).log(Level.WARNING, "Error getting toString() value of an instance dump", exception);
        }
        return instance.toString();
    }
}

