/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.quicksearch;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.lang.ref.WeakReference;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DocumentFilter;
import javax.swing.text.JTextComponent;
import org.netbeans.modules.quicksearch.Bundle;
import org.netbeans.modules.quicksearch.CategoryResult;
import org.netbeans.modules.quicksearch.CommandEvaluator;
import org.netbeans.modules.quicksearch.ProviderModel;
import org.netbeans.modules.quicksearch.QuickSearchPopup;
import org.netbeans.modules.quicksearch.ResultsModel;
import org.netbeans.modules.quicksearch.SearchResultRender;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.windows.TopComponent;

public abstract class AbstractQuickSearchComboBar
extends JPanel
implements ActionListener {
    private static final String CATEGORY = "cat";
    QuickSearchPopup displayer = new QuickSearchPopup(this);
    WeakReference<TopComponent> caller;
    Color origForeground;
    protected final KeyStroke keyStroke;
    protected JTextComponent command;

    public AbstractQuickSearchComboBar(KeyStroke keyStroke) {
        this.keyStroke = keyStroke;
        this.initComponents();
        this.setShowHint(true);
        this.command.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                this.textChanged();
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                this.textChanged();
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                this.textChanged();
            }

            private void textChanged() {
                if (AbstractQuickSearchComboBar.this.command.isFocusOwner()) {
                    AbstractQuickSearchComboBar.this.displayer.maybeEvaluate(AbstractQuickSearchComboBar.this.command.getText());
                }
            }
        });
        if (this.command.getDocument() instanceof AbstractDocument) {
            AbstractDocument abstractDocument = (AbstractDocument)this.command.getDocument();
            abstractDocument.setDocumentFilter(new InvalidSearchTextDocumentFilter());
        }
    }

    public KeyStroke getKeyStroke() {
        return this.keyStroke;
    }

    protected abstract JTextComponent createCommandField();

    protected abstract JComponent getInnerComponent();

    private void initComponents() {
        this.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.setMaximumSize(new Dimension(200, Integer.MAX_VALUE));
        this.setName("Form");
        this.setOpaque(false);
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                AbstractQuickSearchComboBar.this.formFocusLost(focusEvent);
            }
        });
        this.command = this.createCommandField();
        String string = "";
        if (!SearchResultRender.getKeyStrokeAsText(this.keyStroke).isEmpty()) {
            string = "(" + SearchResultRender.getKeyStrokeAsText(this.keyStroke) + ")";
        }
        this.command.setToolTipText(NbBundle.getMessage(AbstractQuickSearchComboBar.class, (String)"AbstractQuickSearchComboBar.command.toolTipText", (Object[])new Object[]{string}));
        this.command.setName("command");
        this.command.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                AbstractQuickSearchComboBar.this.commandFocusGained(focusEvent);
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                AbstractQuickSearchComboBar.this.commandFocusLost(focusEvent);
            }
        });
        this.command.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                AbstractQuickSearchComboBar.this.commandKeyPressed(keyEvent);
            }
        });
        this.command.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                AbstractQuickSearchComboBar.this.displayer.explicitlyInvoked();
            }
        });
    }

    private void formFocusLost(FocusEvent focusEvent) {
        this.displayer.setVisible(false);
    }

    private void commandKeyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 40) {
            this.displayer.selectNext();
            keyEvent.consume();
        } else if (keyEvent.getKeyCode() == 38) {
            this.displayer.selectPrev();
            keyEvent.consume();
        } else if (keyEvent.getKeyCode() == 10) {
            keyEvent.consume();
            this.invokeSelectedItem();
        } else if (keyEvent.getKeyCode() == 27) {
            this.returnFocus(true);
            this.displayer.clearModel();
        } else if (keyEvent.getKeyCode() == 121 && keyEvent.isShiftDown()) {
            keyEvent.consume();
            this.maybeShowPopup(null);
        }
    }

    public void invokeSelectedItem() {
        Runnable runnable;
        JList jList = this.displayer.getList();
        ResultsModel.ItemResult itemResult = (ResultsModel.ItemResult)jList.getSelectedValue();
        if (itemResult != null && (runnable = itemResult.getAction()) instanceof CategoryResult) {
            CategoryResult categoryResult = (CategoryResult)runnable;
            this.evaluateCategory(categoryResult.getCategory(), true);
            return;
        }
        if (jList.getModel().getSize() > 0) {
            this.returnFocus(false);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    AbstractQuickSearchComboBar.this.displayer.invoke();
                }
            });
        }
    }

    private void returnFocus(boolean bl) {
        TopComponent topComponent;
        this.displayer.setVisible(false);
        if (this.caller != null && (topComponent = (TopComponent)this.caller.get()) != null) {
            topComponent.requestActive();
            topComponent.requestFocus();
            return;
        }
        if (bl) {
            KeyboardFocusManager.getCurrentKeyboardFocusManager().clearGlobalFocusOwner();
        }
    }

    private void commandFocusLost(FocusEvent focusEvent) {
        this.displayer.setVisible(false);
        this.setShowHint(true);
    }

    private void commandFocusGained(FocusEvent focusEvent) {
        this.caller = new WeakReference<TopComponent>(TopComponent.getRegistry().getActivated());
        this.setShowHint(false);
        if (CommandEvaluator.isCatTemporary()) {
            CommandEvaluator.setCatTemporary(false);
            CommandEvaluator.setEvalCat(null);
        }
    }

    protected void maybeShowPopup(MouseEvent mouseEvent) {
        if (mouseEvent != null && !SwingUtilities.isLeftMouseButton(mouseEvent)) {
            return;
        }
        JPopupMenu jPopupMenu = new JPopupMenu();
        ProviderModel.Category category = null;
        if (!CommandEvaluator.isCatTemporary()) {
            category = CommandEvaluator.getEvalCat();
        }
        JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(NbBundle.getMessage(this.getClass(), (String)"LBL_AllCategories"), category == null);
        jRadioButtonMenuItem.addActionListener(this);
        jPopupMenu.add(jRadioButtonMenuItem);
        for (ProviderModel.Category category2 : ProviderModel.getInstance().getCategories()) {
            if ("Recent".equals(category2.getName())) continue;
            JRadioButtonMenuItem jRadioButtonMenuItem2 = new JRadioButtonMenuItem(category2.getDisplayName(), category2 == category);
            jRadioButtonMenuItem2.putClientProperty(CATEGORY, category2);
            jRadioButtonMenuItem2.addActionListener(this);
            jPopupMenu.add(jRadioButtonMenuItem2);
        }
        jPopupMenu.show(this.getInnerComponent(), 0, this.getInnerComponent().getHeight() - 1);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        JRadioButtonMenuItem jRadioButtonMenuItem = (JRadioButtonMenuItem)actionEvent.getSource();
        CommandEvaluator.setEvalCat((ProviderModel.Category)jRadioButtonMenuItem.getClientProperty(CATEGORY));
        CommandEvaluator.setCatTemporary(false);
        this.setShowHint(!this.command.isFocusOwner());
    }

    public void evaluateCategory(ProviderModel.Category category, boolean bl) {
        CommandEvaluator.setEvalCat(category);
        CommandEvaluator.setCatTemporary(bl);
        this.displayer.maybeEvaluate(this.command.getText());
    }

    public void setNoResults(boolean bl) {
        if (this.command == null || this.origForeground == null) {
            return;
        }
        if (this.command.getForeground().equals(this.command.getDisabledTextColor())) {
            return;
        }
        this.command.setForeground(bl ? Color.RED : this.origForeground);
    }

    private void setShowHint(boolean bl) {
        if (this.origForeground == null) {
            this.origForeground = this.command.getForeground();
        }
        if (bl) {
            this.command.setForeground(this.command.getDisabledTextColor());
            ProviderModel.Category category = CommandEvaluator.getEvalCat();
            if (category != null && !CommandEvaluator.isCatTemporary()) {
                this.command.setText(this.getHintText(category));
            } else {
                this.command.setText(this.getHintText(null));
            }
        } else {
            this.command.setForeground(this.origForeground);
            this.command.setText("");
        }
    }

    private String getHintText(ProviderModel.Category category) {
        StringBuilder stringBuilder = new StringBuilder();
        if (category != null) {
            stringBuilder.append(NbBundle.getMessage(AbstractQuickSearchComboBar.class, (String)"MSG_DiscoverabilityHint2", (Object)category.getDisplayName()));
        } else {
            stringBuilder.append(NbBundle.getMessage(AbstractQuickSearchComboBar.class, (String)"MSG_DiscoverabilityHint"));
        }
        String string = SearchResultRender.getKeyStrokeAsText(this.keyStroke);
        if (!string.isEmpty()) {
            stringBuilder.append(" (");
            stringBuilder.append(string);
            stringBuilder.append(")");
        }
        return stringBuilder.toString();
    }

    @Override
    public void requestFocus() {
        super.requestFocus();
        this.command.requestFocus();
    }

    public JTextComponent getCommand() {
        return this.command;
    }

    public int getBottomLineY() {
        return this.getInnerComponent().getY() + this.getInnerComponent().getHeight();
    }

    static Color getComboBorderColor() {
        Color color = UIManager.getColor(Utilities.isWindows() ? "Nb.ScrollPane.Border.color" : "TextField.shadow");
        return color != null ? color : AbstractQuickSearchComboBar.getPopupBorderColor();
    }

    static Color getPopupBorderColor() {
        Color color = UIManager.getColor("controlShadow");
        return color != null ? color : Color.GRAY;
    }

    static Color getTextBackground() {
        Color color = UIManager.getColor("TextPane.background");
        if ("Aqua".equals(UIManager.getLookAndFeel().getID())) {
            color = UIManager.getColor("NbExplorerView.background");
        }
        return color != null ? color : Color.WHITE;
    }

    static Color getResultBackground() {
        return AbstractQuickSearchComboBar.getTextBackground();
    }

    static Color getCategoryTextColor() {
        Color color = UIManager.getColor("textInactiveText");
        if ("Aqua".equals(UIManager.getLookAndFeel().getID())) {
            color = UIManager.getColor("Table.foreground");
        }
        return color != null ? color : Color.DARK_GRAY;
    }

    protected int computePrefWidth() {
        FontMetrics fontMetrics = this.command.getFontMetrics(this.command.getFont());
        ProviderModel providerModel = ProviderModel.getInstance();
        int n = 0;
        for (ProviderModel.Category category : providerModel.getCategories()) {
            if ("Recent".equals(category.getName())) continue;
            n = Math.max(n, fontMetrics.stringWidth(this.getHintText(category)));
        }
        return Math.min(350, n);
    }

    static class InvalidSearchTextDocumentFilter
    extends DocumentFilter {
        private static final int SEARCH_TEXT_LENGTH_LIMIT = 256;
        private static final int SEARCH_NUM_WORDS_LIMIT = 20;

        InvalidSearchTextDocumentFilter() {
        }

        @Override
        public void insertString(DocumentFilter.FilterBypass filterBypass, int n, String string, AttributeSet attributeSet) throws BadLocationException {
            String string2 = this.normalizeWhiteSpaces(string);
            if (this.isLengthInLimit(string2, filterBypass, 0)) {
                super.insertString(filterBypass, n, string2, attributeSet);
            } else {
                this.warnAboutInvalidText();
            }
        }

        @Override
        public void replace(DocumentFilter.FilterBypass filterBypass, int n, int n2, String string, AttributeSet attributeSet) throws BadLocationException {
            String string2;
            String string3 = string2 = string == null ? null : this.normalizeWhiteSpaces(string);
            if (string2 == null || this.isLengthInLimit(string2, filterBypass, n2)) {
                super.replace(filterBypass, n, n2, string2, attributeSet);
            } else {
                this.warnAboutInvalidText();
            }
        }

        private boolean isLengthInLimit(String string, DocumentFilter.FilterBypass filterBypass, int n) {
            return this.isLengthInLimit(string, 256 - filterBypass.getDocument().getLength() + n);
        }

        boolean isLengthInLimit(String string, int n) {
            return string.length() <= n && string.split(" ").length <= 20;
        }

        String normalizeWhiteSpaces(String string) {
            String string2 = string.replaceAll("\\s+", " ");
            return string2.length() > 1 ? string2.trim() : string2;
        }

        private void warnAboutInvalidText() {
            NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)Bundle.MSG_INVALID_SEARCH_TEST(), 0);
            DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)message);
        }
    }
}

